/////////////////////////////////////////////////////////////////////////
///@author ̩֤ȯɷ޹˾
///@file xtp_quote_api.h
///@brief 鶩Ŀͻ˽ӿ
/////////////////////////////////////////////////////////////////////////

#ifndef _XTP_QUOTE_API_H_
#define _XTP_QUOTE_API_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "xtp_api_struct.h"

#if defined(ISLIB) && defined(WIN32)
#ifdef LIB_MD_API_EXPORT
#define MD_API_EXPORT __declspec(dllexport)
#else
#define MD_API_EXPORT __declspec(dllimport)
#endif
#else
#define MD_API_EXPORT 
#endif

/*!
* \class XTP::API::QuoteSpi
*
* \brief ص
*
* \author ̩֤ȯɷ޹˾
* \date ʮ 2015
*/
namespace XTP {
	namespace API {
		class QuoteSpi
		{
		public:

			///ͻ̨ͨӶϿʱ÷á
			///@param reason ԭӦ
			///@remark apiԶ߷ʱûѡڴ˺еLoginµ¼עûµ¼Ҫ¶
			virtual void OnDisconnected(int reason) {};


			///Ӧ
			///@param error_info ӦʱľĴʹϢerror_infoΪգerror_info.error_idΪ0ʱûд
			///@remark ˺ֻڷʱŻãһû
			virtual void OnError(XTPRI *error_info) {};

			///Ӧ
			///@param ticker ϸĺԼ
			///@param error_info ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
			///@param is_last Ƿ˴ζĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
			///@remark ÿĵĺԼӦһӦҪٷأϢʱᴥ
			virtual void OnSubMarketData(XTPST *ticker, XTPRI *error_info, bool is_last) {};

			///ȡӦ
			///@param ticker ϸĺԼȡ
			///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
			///@param is_last Ƿ˴ȡĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
			///@remark ÿȡĵĺԼӦһȡӦҪٷأϢʱᴥ
			virtual void OnUnSubMarketData(XTPST *ticker, XTPRI *error_info, bool is_last) {};

			///֪ͨ
			///@param market_data ݣҪٷأϢʱᴥ
			virtual void OnMarketData(XTPMD *market_data) {};

			///鶩Ӧ𣨴˺ӿΪӿڣݲ֧֣
			///@param ticker ϸĺԼ
			///@param error_info ĺԼʱĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
			///@param is_last Ƿ˴ζĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
			///@remark ÿĵĺԼӦһӦҪٷأϢʱᴥ
			virtual void OnSubOrderBook(XTPST *ticker, XTPRI *error_info, bool is_last) {};

			///ȡ鶩Ӧ𣨴˺ӿΪӿڣݲ֧֣
			///@param ticker ϸĺԼȡ
			///@param error_info ȡĺԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
			///@param is_last Ƿ˴ȡĵһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
			///@remark ÿȡĵĺԼӦһȡӦҪٷأϢʱᴥ
			virtual void OnUnSubOrderBook(XTPST *ticker, XTPRI *error_info, bool is_last) {};

			///鶩֪ͨ˺ӿΪӿڣݲ֧֣
			///@param order_book 鶩ݣҪٷأϢʱᴥ
			virtual void OnOrderBook(XTPOB *order_book) {};


			///ѯɽ׺ԼӦ
			///@param ticker_info ɽ׺ԼϢ
			///@param error_info ѯɽ׺ԼʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
			///@param is_last Ƿ˴βѯɽ׺ԼһӦ𣬵ΪһʱΪtrueΪfalseʾϢӦ
			virtual void OnQueryAllTickers(XTPQSI* ticker_info, XTPRI *error_info, bool is_last) {};
		};
	}
}

#ifndef WINDOWS
#if __GNUC__ >= 4
#pragma GCC visibility push(default)
#endif
#endif

/*!
* \class XTP::API::QuoteApi
*
* \brief 鶩Ľӿ
*
* \author ̩֤ȯɷ޹˾
* \date ʮ 2015
*/
namespace XTP {
	namespace API {
		class MD_API_EXPORT QuoteApi
		{
		public:
			///QuoteApi
			///@param client_id 룩ͬһûĲͬͻˣûԶ
			///@param save_file_path 룩ϢļĿ¼趨һпдȨ޵ʵڵ·
			///@param log_level ־
			///@return UserApi
			///@remark һ˻Ҫڶͻ˵¼ʹòͬclient_idϵͳһ˻ͬʱ¼ͻˣǶͬһ˻ͬclient_idֻܱһsessionӣĵ¼ǰһsessionڼ䣬޷
			static QuoteApi *CreateQuoteApi(uint8_t client_id, const char *save_file_path, XTP_LOG_LEVEL log_level=XTP_LOG_LEVEL_DEBUG);

			///ɾӿڶ
			///@remark ʹñӿڶʱ,øúɾӿڶ
			virtual void Release() = 0;


			///ȡǰ
			///@return ȡĽ
			///@remark ֻе¼ɹ,ܵõȷĽ
			virtual const char *GetTradingDay() = 0;

			///ȡAPIķа汾
			///@return apiа汾
			virtual const char* GetApiVersion() = 0;

			///ȡAPIϵͳ
			///@return صĴϢLoginLogoutġȡʧʱãȡʧܵԭ
			///@remark ڵapiӿʧʱãloginʧʱ
			virtual XTPRI *GetApiLastError() = 0;


			///עصӿ
			///@param spi Իصӿʵڵ¼֮ǰ趨
			virtual void RegisterSpi(QuoteSpi *spi) = 0;

			///顣
			///@return ĽӿڵǷɹ0ʾӿڵóɹǡ0ʾӿڵó
			///@param ticker ԼID飬עԼ'\0'βո 
			///@param count Ҫ/˶ĺԼ
			///@param exchage_id 
			///@remark һԶͬһ֤ȯĶԼûΪҪµ¼Ҫ¶
			virtual int SubscribeMarketData(char *ticker[], int count, XTP_EXCHANGE_TYPE exchage_id) = 0;

			///˶顣
			///@return ȡĽӿڵǷɹ0ʾӿڵóɹǡ0ʾӿڵó
			///@param ticker ԼID飬עԼ'\0'βո  
			///@param count Ҫ/˶ĺԼ
			///@param exchage_id 
			///@remark һȡͬһ֤ȯĶԼ
			virtual int UnSubscribeMarketData(char *ticker[], int count, XTP_EXCHANGE_TYPE exchage_id) = 0;

			///鶩(˺ӿΪӿڣݲ֧)
			///@return 鶩ӿڵǷɹ0ʾӿڵóɹǡ0ʾӿڵó
			///@param ticker ԼID飬עԼ'\0'βո 
			///@param count Ҫ/˶鶩ĺԼ
			///@param exchage_id 
			///@remark һԶͬһ֤ȯĶԼûΪҪµ¼Ҫ¶(ݲ֧)
			virtual int SubscribeOrderBook(char *ticker[], int count, XTP_EXCHANGE_TYPE exchage_id) = 0;

			///˶鶩(˺ӿΪӿڣݲ֧)
			///@return ȡ鶩ӿڵǷɹ0ʾӿڵóɹǡ0ʾӿڵó
			///@param ticker ԼID飬עԼ'\0'βո  
			///@param count Ҫ/˶鶩ĺԼ
			///@param exchage_id 
			///@remark һȡͬһ֤ȯĶԼ(ݲ֧)
			virtual int UnSubscribeOrderBook(char *ticker[], int count, XTP_EXCHANGE_TYPE exchage_id) = 0;

			///û¼
			///@return ¼Ƿɹ0ʾ¼ɹ-1ʾӷʱûԵGetApiLastError()ȡ룬-2ʾѴӣظ¼Ҫlogout-3ʾд
			///@param ip ipַơ127.0.0.1
			///@param port ˿ں
			///@param user ½û
			///@param password ½
			///@param sock_type 1TCP2UDPĿǰʱֻ֧TCP
			///@remark ˺ΪͬʽҪ첽ȴ¼ɹؼɽкapiֻһ
			virtual int Login(const char* ip, int port, const char* user, const char* password, XTP_PROTOCOL_TYPE sock_type) = 0;


			///ǳ
			///@return ǳǷɹ0ʾǳɹǡ0ʾǳʱûԵGetApiLastError()ȡ
			///@remark ˺ΪͬʽҪ첽ȴǳؼɽк
			virtual int Logout() = 0;

			///ȡǰտɽ׺Լ
			///@return ѯǷɹ0ʾѯɹǡ0ʾѯɹ
			///@param exchage_id 
			virtual int QueryAllTickers(XTP_EXCHANGE_TYPE exchage_id) = 0;


		protected:
			~QuoteApi() {};
		};
	}
}

#ifndef WINDOWS
#if __GNUC__ >= 4
#pragma GCC visibility pop
#endif
#endif


#endif
