/////////////////////////////////////////////////////////////////////////
///@author ̩֤ȯɷ޹˾
///@file xtp_trader_api.h
///@brief ͻ˽׽ӿ
/////////////////////////////////////////////////////////////////////////

#ifndef _XTP_TRADER_API_H_
#define _XTP_TRADER_API_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "xtp_api_struct.h"

#if defined(ISLIB) && defined(WIN32)
#ifdef LIB_TRADER_API_EXPORT
#define TRADER_API_EXPORT __declspec(dllexport)
#else
#define TRADER_API_EXPORT __declspec(dllimport)
#endif
#else
#define TRADER_API_EXPORT 
#endif

/*!
* \class XTP::API::TraderSpi
*
* \brief ׽ӿӦ
*
* \author ̩֤ȯɷ޹˾
* \date ʮ 2015
*/
namespace XTP {
	namespace API {

		class TraderSpi
		{
		public:

			///ͻ˵ĳ뽻׺̨ͨӶϿʱ÷á
			///@param reason ԭӦ
			///@param session_id ʽ˻Ӧsession_id¼ʱõ
			///@remark ûlogoutµĶߣᴥ˺apiԶ߷ʱûѡڴ˺еLoginµ¼session_idʱûյݸ֮ǰ
			virtual void OnDisconnected(uint64_t session_id, int reason) {};

			///Ӧ
			///@param error_info ӦʱľĴʹϢ,error_infoΪգerror_info.error_idΪ0ʱûд
			///@remark ˺ֻڷʱŻãһû
			virtual void OnError(XTPRI *error_info) {};

			///֪ͨ
			///@param order_info ӦϢûͨorder_info.order_xtp_idͨGetClientIDByXTPID() == client_idԼĶorder_info.qty_leftֶڶΪδɽɡȫɡϵ״̬ʱʾ˶ûгɽڲȫ״̬ʱʾ˶order_info.order_cancel_xtp_idΪӦĳIDΪ0ʱʾ˵ɹ
			///@param error_info ܾ߷ʱʹϢerror_infoΪգerror_info.error_idΪ0ʱûд
			///@remark ÿζ״̬ʱᱻãҪٷأϢʱᴥߣڶδɽȫɽȫֳѾܾЩ״̬ʱӦڲֳɽɶĳɽرȷϡе¼˴ûĿͻ˶յûĶӦ
			virtual void OnOrderEvent(XTPOrderInfo *order_info, XTPRI *error_info) {};

			///ɽ֪ͨ
			///@param trade_info ɽرľϢûͨtrade_info.order_xtp_idͨGetClientIDByXTPID() == client_idԼĶϽexec_idΨһʶһʳɽ2ʳɽرӵͬexec_idΪ˱ʽԳɽˡexec_idΨһģʱ޴жϻơreport_index+marketֶοΨһʶʾɽر
			///@remark гɽʱ򣬻ᱻãҪٷأϢʱᴥߡе¼˴ûĿͻ˶յûĳɽرضΪ״̬ҪûͨɽرĳɽȷOnOrderEvent()Ͳ״̬
			virtual void OnTradeEvent(XTPTradeReport *trade_info) {};

			///Ӧ
			///@param cancel_info Ϣorder_cancel_xtp_idʹorder_xtp_id
			///@param error_info ܾ߷ʱʹϢҪٷأϢʱᴥߣerror_infoΪգerror_info.error_idΪ0ʱûд
			///@remark Ӧֻڳʱص
			virtual void OnCancelOrderError(XTPOrderCancelInfo *cancel_info, XTPRI *error_info) {};

			///ѯӦ
			///@param order_info ѯһ
			///@param error_info ѯʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
			///@param request_id ϢӦӦID
			///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
			///@remark ַ֧ʱβѯһѯܶӦӦҪٷأϢʱᴥ
			virtual void OnQueryOrder(XTPQueryOrderRsp *order_info, XTPRI *error_info, int request_id, bool is_last) {};

			///ѯɽӦ
			///@param trade_info ѯһɽر
			///@param error_info ѯɽرʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
			///@param request_id ϢӦӦID
			///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
			///@remark ַ֧ʱβѯһѯܶӦӦҪٷأϢʱᴥ
			virtual void OnQueryTrade(XTPQueryTradeRsp *trade_info, XTPRI *error_info, int request_id, bool is_last) {};

			///ѯͶֲ߳Ӧ
			///@param position ѯһֻƱĳֲ
			///@param error_info ѯ˻ֲַʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
			///@param request_id ϢӦӦID
			///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
			///@remark ûܳжƱһѯܶӦӦҪٷأϢʱᴥ
			virtual void OnQueryPosition(XTPQueryStkPositionRsp *position, XTPRI *error_info, int request_id, bool is_last) {};

			///ѯʽ˻ӦҪٷأϢʱᴥ
			///@param asset ѯʽ˻
			///@param error_info ѯʽ˻ʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
			///@param request_id ϢӦӦID
			///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
			///@remark ҪٷأϢʱᴥ
			virtual void OnQueryAsset(XTPQueryAssetRsp *asset, XTPRI *error_info, int request_id, bool is_last) {};


		};
	}
}

#ifndef WINDOWS
#if __GNUC__ >= 4
#pragma GCC visibility push(default)
#endif
#endif

/*!
* \class XTP::API::TraderApi
*
* \brief ׽ӿ
*
* \author ̩֤ȯɷ޹˾
* \date ʮ 2015
*/
namespace XTP {
	namespace API {

		class TRADER_API_EXPORT TraderApi
		{
		public:
			///TraderApi
			///@param client_id 룩ͻidͬһûĲͬͻˣûԶ
			///@param save_file_path 룩ϢļĿ¼趨һʵڵпдȨ޵·
			///@param log_level ־
			///@return UserApi
			///@remark һ˻Ҫڶͻ˵¼ʹòͬclient_idϵͳһ˻ͬʱ¼ͻˣǶͬһ˻ͬclient_idֻܱһsessionӣĵ¼ǰһsessionڼ䣬޷ӡϵͳֹ֧ҹȷÿ쿪ǰ
			static TraderApi *CreateTraderApi(uint8_t client_id, const char *save_file_path, XTP_LOG_LEVEL log_level = XTP_LOG_LEVEL_DEBUG);

			///ɾӿڶ
			///@remark ʹñӿڶʱ,øúɾӿڶ
			virtual void Release() = 0;

			///ȡǰ
			///@return ȡĽ
			///@remark ֻе¼ɹ,ܵõȷĽ
			virtual const char *GetTradingDay() = 0;

			///עصӿ
			///@param spi Իصӿʵڵ¼֮ǰ趨
			virtual void RegisterSpi(TraderSpi *spi) = 0;

			///ȡAPIϵͳ
			///@return صĴϢLoginInsertOrderCancelOrderֵΪ0ʱãȡʧܵԭ
			///@remark ڵapiӿʧʱãloginʧʱ
			virtual XTPRI *GetApiLastError() = 0;

			///ȡAPIķа汾
			///@return apiа汾
			virtual const char* GetApiVersion() = 0;

			///ͨxtpϵͳеIDȡµĿͻid
			///@return ؿͻidô˷ԼµĶ
			///@param order_xtp_id xtpϵͳеID
			///@remark ϵͳͬһûڲͬͻϵ¼ÿͻͨͬclient_id
			virtual uint8_t GetClientIDByXTPID(uint64_t order_xtp_id) = 0;

			///ͨxtpϵͳеIDȡʽ˻
			///@return ʽ˻
			///@param order_xtp_id xtpϵͳеID
			///@remark ֻʽ˻¼ɹ,ܵõȷϢ
			virtual const char* GetAccountByXTPID(uint64_t order_xtp_id) = 0;

			///Ĺ
			///@param resume_type Ӧɽرشʽ  
			///        XTP_TERT_RESTART:ӱտʼش
			///        XTP_TERT_RESUME:(ֶΣ˷ʽδ֧)ϴյ
			///        XTP_TERT_QUICK:ֻ͵¼󹫹
			///@remark ÷ҪLoginǰá򲻻յݡעûߺǳlogin()ķʽáûֻյߺϢlogout()login()ôķʽãûյݻûѡʽ
			virtual void SubscribePublicTopic(XTP_TE_RESUME_TYPE resume_type) = 0;

			///汾
			///@param version û汾ţapiа汾ţȲ15λ'\0'β
			///@remark ˺Login֮ǰãʶǿͻ˰汾ţAPIİ汾ţûԶ
			virtual void SetSoftwareVersion(const char* version) = 0;

			///Key
			///@param key ûKeyû뿪ʱ裬'\0'β
			///@remark ˺Login֮ǰ
			virtual void SetSoftwareKey(const char* key) = 0;

			///û¼
			///@return session_idʽ˺ŵ¼Ƿɹ0ʾ¼ʧܣԵGetApiLastError()ȡ룬ǡ0ʾ¼ɹʱҪ¼ֵsession_id¼ʽ˻Ӧ
			///@param ip ַơ127.0.0.1
			///@param port ˿ں
			///@param user ¼û
			///@param password ¼
			///@param sock_type 1TCP2UDPĿǰʱֻ֧TCP
			///@remark ˺ΪͬʽҪ첽ȴ¼ɹؼɽкapiֶ֧˻ӣͬһ˻ͬһclient_idֻһsessionӣĵ¼ǰһsessionڼ䣬޷
			virtual uint64_t Login(const char* ip, int port, const char* user, const char* password, XTP_PROTOCOL_TYPE sock_type) = 0;


			///ǳ
			///@return ǳǷɹ0ʾǳɹ-1ʾǳʧ
			///@param session_id ʽ˻Ӧsession_id,¼ʱõ
			virtual int Logout(uint64_t session_id) = 0;

			///¼
			///@return XTPϵͳеID,Ϊ0ʾʧܣʱûԵGetApiLastError()ȡ룬ǡ0ʾͳɹûҪ¼·صorder_xtp_id֤һΨһͬĽղ֤Ψһ
			///@param order ¼Ϣorder.order_client_idֶûԶֶΣûʲôֵӦOnOrderEvent()ʱͻʲôֵڱעûԼλȻʲôҲǿԵġorder.order_xtp_idֶûдorder.ticker벻ո'\0'β
			///@param session_id ʽ˻Ӧsession_id,¼ʱõ
			///@remark ն󣬻ڱӦOnOrderEvent()зرδɽ״̬֮еĶ״̬ı䣨˲״̬ͨӦ
			virtual uint64_t InsertOrder(XTPOrderInsertInfo *order, uint64_t session_id) = 0;

			///
			///@return XTPϵͳеID,Ϊ0ʾʧܣʱûԵGetApiLastError()ȡ룬ǡ0ʾͳɹûҪ¼·صorder_cancel_xtp_id֤һΨһͬĽղ֤Ψһ
			///@param order_xtp_id ҪίеXTPϵͳеID
			///@param session_id ʽ˻Ӧsession_id,¼ʱõ
			///@remark ɹڱӦOnOrderEvent()ﷵԭȫϢɹOnCancelOrderError()Ӧзشԭ
			virtual uint64_t CancelOrder(const uint64_t order_xtp_id, uint64_t session_id) = 0;

			///ݱIDѯ
			///@return ѯǷɹ0ʾɹǡ0ʾʱûԵGetApiLastError()ȡ
			///@param order_xtp_id ҪѯıxtpϵͳеIDInsertOrder()ɹʱصorder_xtp_id
			///@param session_id ʽ˻Ӧsession_id¼ʱõ
			///@param request_id ûλѯӦIDûԶ
			virtual int QueryOrderByXTPID(const uint64_t order_xtp_id, uint64_t session_id, int request_id) = 0;

			///ѯ
			///@return ѯǷɹ0ʾɹǡ0ʾʱûԵGetApiLastError()ȡ
			///@param query_param ҪѯĶɸѡкԼΪգĬдڵĺԼ룬Ϊգ벻ո񣬲'\0'βʼʱʽΪYYYYMMDDHHMMSSsssΪ0Ĭϵǰ0㣬ʱʽΪYYYYMMDDHHMMSSsssΪ0Ĭϵǰʱ
			///@param session_id ʽ˻Ӧsession_id¼ʱõ
			///@param request_id ûλѯӦIDûԶ
			///@remark ÷ַ֧ʱβѯƱΪգĬϲѯʱڵбѯʱиƱصı˺ѯĽܶӦѯӦ
			virtual int QueryOrders(const XTPQueryOrderReq *query_param, uint64_t session_id, int request_id) = 0;

			///ίбѯسɽ
			///@return ѯǷɹ0ʾɹǡ0ʾʱûԵGetApiLastError()ȡ
			///@param order_xtp_id ҪѯίбţInsertOrder()ɹʱصorder_xtp_id
			///@param session_id ʽ˻Ӧsession_id¼ʱõ
			///@param request_id ûλѯӦIDûԶ
			///@remark ˺ѯĽܶӦѯӦ
			virtual int QueryTradesByXTPID(const uint64_t order_xtp_id, uint64_t session_id, int request_id) = 0;

			///ѯѳɽ
			///@return ѯǷɹ0ʾɹǡ0ʾʱûԵGetApiLastError()ȡ
			///@param query_param ҪѯĳɽرɸѡкԼΪգĬдڵĺԼ룬Ϊգ벻ո񣬲'\0'βʼʱʽΪYYYYMMDDHHMMSSsssΪ0Ĭϵǰ0㣬ʱʽΪYYYYMMDDHHMMSSsssΪ0Ĭϵǰʱ
			///@param session_id ʽ˻Ӧsession_id,¼ʱõ
			///@param request_id ûλѯӦIDûԶ
			///@remark ÷ַ֧ʱβѯƱΪգĬϲѯʱڵгɽرѯʱиƱصĳɽر˺ѯĽܶӦѯӦ
			virtual int QueryTrades(XTPQueryTraderReq *query_param, uint64_t session_id, int request_id) = 0;

			///ѯͶֲ߳
			///@return ѯǷɹ0ʾɹǡ0ʾʱûԵGetApiLastError()ȡ
			///@param ticker ҪѯĳֲֺԼ룬ΪգΪգ벻ո񣬲'\0'β
			///@param session_id ʽ˻Ӧsession_id,¼ʱõ
			///@param request_id ûλѯӦIDûԶ
			///@remark ÷ûṩ˺Լ룬ѯ˺ԼĳֲϢԼΪգĬϲѯгֲϢ
			virtual int QueryPosition(const char *ticker, uint64_t session_id, int request_id) = 0;

			///ѯʲ
			///@return ѯǷɹ0ʾɹǡ0ʾʱûԵGetApiLastError()ȡ
			///@param session_id ʽ˻Ӧsession_id,¼ʱõ
			///@param request_id ûλѯӦIDûԶ
			virtual int QueryAsset(uint64_t session_id, int request_id) = 0;

		protected:
			~TraderApi() {};
		};

			}
}

#ifndef WINDOWS
#if __GNUC__ >= 4
#pragma GCC visibility pop
#endif
#endif


#endif
