/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob;

import com.hbm.entity.mob.EntityBurrowingBase;
import com.hbm.entity.mob.ai.EntityAINearestAttackableTargetNT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public abstract class EntityBurrowingSwingingBase
extends EntityBurrowingBase {
    protected Entity targetedEntity = null;
    protected boolean wasNearGround = false;
    public int courseChangeCooldown = 0;
    public int aggroCooldown = 0;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    protected ChunkCoordinates spawnPoint = new ChunkCoordinates();
    public boolean lastInGround = false;

    public EntityBurrowingSwingingBase(World world) {
        super(world);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTargetNT(this, EntityPlayer.class, 0, false, false, null, 128.0));
    }

    public void func_70071_h_() {
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        super.func_70071_h_();
        double dx = this.field_70159_w;
        double dy = this.field_70181_x;
        double dz = this.field_70179_y;
        float f3 = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
        this.field_70177_z = (float)(Math.atan2(dx, dz) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(dy, f3) * 180.0 / Math.PI);
        boolean inGround = this.func_70094_T();
        if (this.lastInGround != inGround) {
            this.field_70170_p.func_72956_a((Entity)this, "hbm:block.debris", 1.0f, 1.0f);
            double mod = 0.25;
            if (inGround) {
                mod *= -1.0;
            }
            for (int i = 0; i < 10; ++i) {
                double dev = 0.05;
                this.field_70170_p.func_72869_a("cloud", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w * mod + this.field_70146_Z.nextGaussian() * dev, this.field_70181_x * mod + this.field_70146_Z.nextGaussian() * dev, this.field_70179_y * mod + this.field_70146_Z.nextGaussian() * dev);
            }
        }
        this.lastInGround = inGround;
    }

    protected void func_70619_bc() {
        this.func_70626_be();
        super.func_70619_bc();
        this.updateSwingingMovement();
    }

    @Override
    protected void func_70626_be() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if (this.targetedEntity != null && this.targetedEntity.field_70128_L) {
            this.targetedEntity = null;
        }
        if (this.field_70163_u < -10.0) {
            this.field_70181_x = 1.0;
        } else if (this.field_70163_u < 3.0) {
            this.field_70181_x = 0.3;
        }
        if (this.field_70173_aa % 2 == 0) {
            this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.5, 0.5, 0.5)));
        }
    }

    protected void attackEntitiesInList(List<Entity> targets) {
        for (Entity target : targets) {
            if (!(target instanceof EntityLivingBase) || !this.func_70686_a(target.getClass())) continue;
            this.func_70652_k(target);
        }
    }

    public boolean func_70652_k(Entity target) {
        boolean hit = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        if (hit) {
            this.field_70708_bq = 0;
            double tx = (this.field_70121_D.field_72340_a + this.field_70121_D.field_72336_d) / 2.0;
            double tz = (this.field_70121_D.field_72339_c + this.field_70121_D.field_72334_f) / 2.0;
            double ty = (this.field_70121_D.field_72338_b + this.field_70121_D.field_72337_e) / 2.0;
            double deltaX = target.field_70165_t - tx;
            double deltaZ = target.field_70161_v - tz;
            double deltaY = target.field_70163_u - ty;
            double knockback = 0.5 * (deltaX * deltaX + deltaZ * deltaZ + deltaY * deltaY + 0.1);
            target.func_70024_g(deltaX / knockback, deltaY / knockback, deltaZ / knockback);
        }
        return hit;
    }

    protected void updateSwingingMovement() {
        double deltaX = this.waypointX - this.field_70165_t;
        double deltaY = this.waypointY - this.field_70163_u;
        double deltaZ = this.waypointZ - this.field_70161_v;
        double delta = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.func_70681_au().nextInt(5) + 5;
            double speed = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
            if (!this.canSupportMovement()) {
                speed /= 4.0;
            }
            this.field_70159_w += deltaX / delta * speed;
            this.field_70181_x += deltaY / delta * speed;
            this.field_70179_y += deltaZ / delta * speed;
        }
        if (!this.canSupportMovement() && !this.wasNearGround) {
            this.field_70181_x -= this.getGravity();
        }
        --this.aggroCooldown;
        if (this.func_70638_az() != null) {
            if (this.aggroCooldown <= 0) {
                this.targetedEntity = this.func_70638_az();
                this.aggroCooldown = this.getAggroCooldown();
            }
        } else if (this.targetedEntity == null) {
            this.waypointX = this.spawnPoint.field_71574_a - 50 + this.func_70681_au().nextInt(100);
            this.waypointY = this.spawnPoint.field_71572_b - 30 + this.func_70681_au().nextInt(60);
            this.waypointZ = this.spawnPoint.field_71573_c - 50 + this.func_70681_au().nextInt(100);
        }
        this.field_70177_z = -((float)(-(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI)));
        this.field_70125_A = (float)(-(Math.atan2(this.field_70181_x, MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) * 180.0 / Math.PI));
        double range = 100.0;
        if (this.targetedEntity != null && this.targetedEntity.func_70068_e((Entity)this) < range * range) {
            if (this.canSupportMovement() || this.wasNearGround) {
                this.waypointX = this.targetedEntity.field_70165_t;
                this.waypointY = this.targetedEntity.field_70163_u + (double)this.targetedEntity.field_70131_O * 0.5;
                this.waypointZ = this.targetedEntity.field_70161_v;
                int surface = this.field_70170_p.func_72976_f(MathHelper.func_76128_c((double)this.waypointX), MathHelper.func_76128_c((double)this.waypointZ));
                if (this.func_70681_au().nextInt(80) == 0 && this.field_70163_u > (double)surface && !this.canSupportMovement()) {
                    this.wasNearGround = false;
                }
            } else {
                this.waypointX = this.targetedEntity.field_70165_t;
                this.waypointY = 10.0;
                this.waypointZ = this.targetedEntity.field_70161_v;
                if (this.field_70163_u < 15.0) {
                    this.wasNearGround = true;
                }
            }
        } else {
            this.waypointX = this.spawnPoint.field_71574_a - 20 + this.func_70681_au().nextInt(40);
            this.waypointY = this.spawnPoint.field_71572_b - 5 + this.func_70681_au().nextInt(100);
            this.waypointZ = this.spawnPoint.field_71573_c - 20 + this.func_70681_au().nextInt(40);
        }
    }

    protected double getGravity() {
        return 0.01;
    }

    protected int getAggroCooldown() {
        return 20;
    }

    public void func_70024_g(double x, double y, double z) {
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("spawnX", this.spawnPoint.field_71574_a);
        nbt.func_74768_a("spawnY", this.spawnPoint.field_71572_b);
        nbt.func_74768_a("spawnZ", this.spawnPoint.field_71573_c);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.spawnPoint.func_71571_b(nbt.func_74762_e("spawnX"), nbt.func_74762_e("spawnY"), nbt.func_74762_e("spawnZ"));
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        this.spawnPoint.func_71571_b(x, y, z);
        return super.func_110161_a(data);
    }
}

