/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna.mags;

import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemAmmoBag;
import com.hbm.items.weapon.sedna.BulletConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.mags.IMagazine;
import com.hbm.particle.SpentCasing;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class MagazineBelt
implements IMagazine<BulletConfig> {
    public List<BulletConfig> acceptedBullets = new ArrayList<BulletConfig>();
    public static final String KEY_MAG_TYPE = "magtype";

    public MagazineBelt addConfigs(BulletConfig ... cfgs) {
        for (BulletConfig cfg : cfgs) {
            this.acceptedBullets.add(cfg);
        }
        return this;
    }

    @Override
    public BulletConfig getType(ItemStack stack, IInventory inventory) {
        BulletConfig config = this.getFirstConfig(stack, inventory);
        if (MagazineBelt.getMagType(stack) != config.id) {
            MagazineBelt.setMagType(stack, config.id);
        }
        return config;
    }

    @Override
    public void useUpAmmo(ItemStack stack, IInventory inventory, int amount) {
        if (inventory == null) {
            return;
        }
        if (!IMagazine.shouldUseUpTrenchie(inventory)) {
            return;
        }
        BulletConfig first = this.getFirstConfig(stack, inventory);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            boolean infBag;
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null) continue;
            if (first.ammo.matchesRecipe(slot, true)) {
                int toRemove = Math.min(slot.field_77994_a, amount);
                inventory.func_70298_a(i, toRemove);
                IMagazine.handleAmmoBag(inventory, first, toRemove);
                if ((amount -= toRemove) <= 0) {
                    return;
                }
            }
            boolean bl = infBag = slot.func_77973_b() == ModItems.ammo_bag_infinite;
            if (slot.func_77973_b() != ModItems.ammo_bag && !infBag) continue;
            ItemAmmoBag.InventoryAmmoBag bag = new ItemAmmoBag.InventoryAmmoBag(slot);
            for (int j = 0; j < bag.func_70302_i_(); ++j) {
                ItemStack bagslot = bag.func_70301_a(j);
                if (bagslot == null || !first.ammo.matchesRecipe(bagslot, true)) continue;
                int toRemove = Math.min(bagslot.field_77994_a, amount);
                amount -= toRemove;
                if (!infBag) {
                    bag.func_70298_a(j, toRemove);
                }
                IMagazine.handleAmmoBag(inventory, first, toRemove);
                if (amount > 0) continue;
                return;
            }
        }
    }

    @Override
    public void setType(ItemStack stack, BulletConfig type) {
    }

    @Override
    public int getCapacity(ItemStack stack) {
        return 0;
    }

    @Override
    public void setAmount(ItemStack stack, int amount) {
    }

    @Override
    public boolean canReload(ItemStack stack, IInventory inventory) {
        return false;
    }

    @Override
    public void initNewType(ItemStack stack, IInventory inventory) {
    }

    @Override
    public void reloadAction(ItemStack stack, IInventory inventory) {
    }

    @Override
    public void setAmountBeforeReload(ItemStack stack, int amount) {
    }

    @Override
    public int getAmountBeforeReload(ItemStack stack) {
        return 0;
    }

    @Override
    public void setAmountAfterReload(ItemStack stack, int amount) {
    }

    @Override
    public int getAmountAfterReload(ItemStack stack) {
        return 0;
    }

    @Override
    public int getAmount(ItemStack stack, IInventory inventory) {
        if (inventory == null) {
            return 1;
        }
        BulletConfig first = this.getFirstConfig(stack, inventory);
        int count = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            boolean infBag;
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null) continue;
            if (first.ammo.matchesRecipe(slot, true)) {
                count += slot.field_77994_a;
            }
            boolean bl = infBag = slot.func_77973_b() == ModItems.ammo_bag_infinite;
            if (slot.func_77973_b() != ModItems.ammo_bag && !infBag) continue;
            ItemAmmoBag.InventoryAmmoBag bag = new ItemAmmoBag.InventoryAmmoBag(slot);
            for (int j = 0; j < bag.func_70302_i_(); ++j) {
                ItemStack bagslot = bag.func_70301_a(j);
                if (bagslot == null || !first.ammo.matchesRecipe(bagslot, true)) continue;
                if (infBag) {
                    return 9999;
                }
                count += bagslot.field_77994_a;
            }
        }
        return count;
    }

    @Override
    public ItemStack getIconForHUD(ItemStack stack, EntityPlayer player) {
        BulletConfig first = this.getFirstConfig(stack, (IInventory)player.field_71071_by);
        return first.ammo.toStack();
    }

    @Override
    public String reportAmmoStateForHUD(ItemStack stack, EntityPlayer player) {
        return "x" + this.getAmount(stack, (IInventory)player.field_71071_by);
    }

    @Override
    public SpentCasing getCasing(ItemStack stack, IInventory invnetory) {
        return this.getFirstConfig((ItemStack)stack, (IInventory)invnetory).casing;
    }

    public BulletConfig getFirstConfig(ItemStack stack, IInventory inventory) {
        if (inventory == null) {
            return this.acceptedBullets.get(0);
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null) continue;
            for (BulletConfig config : this.acceptedBullets) {
                if (!config.ammo.matchesRecipe(slot, true)) continue;
                return config;
            }
            if (slot.func_77973_b() != ModItems.ammo_bag && slot.func_77973_b() != ModItems.ammo_bag_infinite) continue;
            ItemAmmoBag.InventoryAmmoBag bag = new ItemAmmoBag.InventoryAmmoBag(slot);
            for (int j = 0; j < bag.func_70302_i_(); ++j) {
                ItemStack bagslot = bag.func_70301_a(j);
                if (bagslot == null) continue;
                for (BulletConfig config : this.acceptedBullets) {
                    if (!config.ammo.matchesRecipe(bagslot, true)) continue;
                    return config;
                }
            }
        }
        BulletConfig cached = BulletConfig.configs.get(MagazineBelt.getMagType(stack));
        return this.acceptedBullets.contains(cached) ? cached : this.acceptedBullets.get(0);
    }

    public static int getMagType(ItemStack stack) {
        return ItemGunBaseNT.getValueInt(stack, KEY_MAG_TYPE);
    }

    public static void setMagType(ItemStack stack, int value) {
        ItemGunBaseNT.setValueInt(stack, KEY_MAG_TYPE, value);
    }
}

