/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item.weapon.sedna;

import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.mags.IMagazine;
import com.hbm.main.MainRegistry;
import com.hbm.main.ResourceManager;
import com.hbm.particle.SpentCasing;
import com.hbm.render.anim.AnimationEnums;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.item.weapon.sedna.ItemRenderWeaponBase;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderCongoLake
extends ItemRenderWeaponBase {
    @Override
    protected float getTurnMagnitude(ItemStack stack) {
        return ItemGunBaseNT.getIsAiming(stack) ? 2.5f : -0.25f;
    }

    @Override
    public float getViewFOV(ItemStack stack, float fov) {
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        return fov * (1.0f - aimingProgress * 0.33f);
    }

    @Override
    public void setupFirstPerson(ItemStack stack) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.875);
        float offset = 0.8f;
        ItemRenderCongoLake.standardAimingTransform(stack, -1.5f * offset, -2.0f * offset, 1.25f * offset, 0.0, -1.25, 0.25);
    }

    @Override
    public void renderFirstPerson(ItemStack stack) {
        ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.congolake_tex);
        double scale = 0.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        HbmAnimations.applyRelevantTransformation("Gun");
        ResourceManager.congolake.renderPart("Gun");
        GL11.glPushMatrix();
        HbmAnimations.applyRelevantTransformation("Pump");
        ResourceManager.congolake.renderPart("Pump");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        HbmAnimations.applyRelevantTransformation("Sight");
        GL11.glTranslated((double)0.0, (double)2.125, (double)3.0);
        GL11.glRotated((double)(aimingProgress * -90.0f), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-2.125, (double)-3.0);
        ResourceManager.congolake.renderPart("Sight");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        HbmAnimations.applyRelevantTransformation("Loop");
        ResourceManager.congolake.renderPart("Loop");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        HbmAnimations.applyRelevantTransformation("GuardOuter");
        ResourceManager.congolake.renderPart("GuardOuter");
        GL11.glPushMatrix();
        HbmAnimations.applyRelevantTransformation("GuardInner");
        ResourceManager.congolake.renderPart("GuardInner");
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        IMagazine mag = gun.getConfig(stack, 0).getReceivers(stack)[0].getMagazine(stack);
        if (ItemGunBaseNT.getLastAnim(stack, 0) != AnimationEnums.GunAnimation.INSPECT || mag.getAmount(stack, (IInventory)MainRegistry.proxy.me().field_71071_by) > 0) {
            int[] nArray;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.casings_tex);
            HbmAnimations.applyRelevantTransformation("Shell");
            SpentCasing casing = mag.getCasing(stack, (IInventory)MainRegistry.proxy.me().field_71071_by);
            if (casing != null) {
                nArray = casing.getColors();
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0x515151;
            }
            int[] colors = nArray;
            Color shellColor = new Color(colors[0]);
            GL11.glColor3f((float)((float)shellColor.getRed() / 255.0f), (float)((float)shellColor.getGreen() / 255.0f), (float)((float)shellColor.getBlue() / 255.0f));
            ResourceManager.congolake.renderPart("Shell");
            Color shellForeColor = new Color(colors.length > 1 ? colors[1] : colors[0]);
            GL11.glColor3f((float)((float)shellForeColor.getRed() / 255.0f), (float)((float)shellForeColor.getGreen() / 255.0f), (float)((float)shellForeColor.getBlue() / 255.0f));
            ResourceManager.congolake.renderPart("ShellFore");
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
        double smokeScale = 0.25;
        GL11.glShadeModel((int)7425);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)1.75, (double)4.25);
        double[] transform = HbmAnimations.getRelevantTransformation("Gun");
        GL11.glRotated((double)(-transform[5]), (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)(-transform[4]), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(-transform[3]), (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glScaled((double)smokeScale, (double)smokeScale, (double)smokeScale);
        ItemRenderCongoLake.renderSmokeNodes(gun.getConfig((ItemStack)stack, (int)0).smokeNodes, 1.0);
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)1.75, (double)4.25);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(90.0 * gun.shotRand), (double)1.0, (double)0.0, (double)0.0);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        ItemRenderCongoLake.renderMuzzleFlash(gun.lastShot[0], 150, 7.5);
        GL11.glPopMatrix();
    }

    @Override
    public void setupThirdPerson(ItemStack stack) {
        super.setupThirdPerson(stack);
        GL11.glTranslated((double)0.0, (double)-2.5, (double)4.0);
        double scale = 2.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
    }

    @Override
    public void setupInv(ItemStack stack) {
        super.setupInv(stack);
        double scale = 2.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-1.25, (double)0.0);
    }

    @Override
    public void setupModTable(ItemStack stack) {
        double scale = -15.0;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-1.25, (double)0.0);
    }

    @Override
    public void renderOther(ItemStack stack, IItemRenderer.ItemRenderType type, Object ... data) {
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7425);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.congolake_tex);
        ResourceManager.congolake.renderAll();
        GL11.glShadeModel((int)7424);
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            long shot;
            EntityLivingBase ent = (EntityLivingBase)data[1];
            double shotRand = 0.0;
            if (ent == Minecraft.func_71410_x().field_71439_g) {
                ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
                shot = gun.lastShot[0];
                shotRand = gun.shotRand;
            } else {
                shot = ItemRenderWeaponBase.flashMap.getOrDefault(ent, -1L);
                if (shot < 0L) {
                    return;
                }
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)1.75, (double)4.25);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(90.0 * shotRand), (double)1.0, (double)0.0, (double)0.0);
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            ItemRenderCongoLake.renderMuzzleFlash(shot, 150, 7.5);
            GL11.glPopMatrix();
        }
    }
}

