/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.saveddata;

import com.hbm.interfaces.NotableComments;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.AnnihilatorRecipes;
import com.hbm.util.ItemStackUtil;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

@NotableComments
public class AnnihilatorSavedData
extends WorldSavedData {
    public static final String KEY = "annihilator";
    public HashMap<String, AnnihilatorPool> pools = new HashMap();

    public AnnihilatorSavedData() {
        super(KEY);
        this.func_76185_a();
    }

    public AnnihilatorSavedData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList pools = nbt.func_150295_c("pools", 10);
        for (int i = 0; i < pools.func_74745_c(); ++i) {
            NBTTagCompound poolCompound = pools.func_150305_b(i);
            String poolName = poolCompound.func_74779_i("poolname");
            AnnihilatorPool pool = new AnnihilatorPool();
            pool.deserialize(poolCompound.func_150295_c("pool", 10));
            this.pools.put(poolName, pool);
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        NBTTagList pools = new NBTTagList();
        for (Map.Entry<String, AnnihilatorPool> entry : this.pools.entrySet()) {
            NBTTagCompound pool = new NBTTagCompound();
            NBTTagList poolList = new NBTTagList();
            entry.getValue().serialize(poolList);
            pool.func_74778_a("poolname", entry.getKey());
            pool.func_74782_a("pool", (NBTBase)poolList);
            pools.func_74742_a((NBTBase)pool);
        }
        nbt.func_74782_a("pools", (NBTBase)pools);
    }

    public static AnnihilatorSavedData getData(World worldObj) {
        AnnihilatorSavedData data = (AnnihilatorSavedData)worldObj.perWorldStorage.func_75742_a(AnnihilatorSavedData.class, KEY);
        if (data == null) {
            worldObj.perWorldStorage.func_75745_a(KEY, (WorldSavedData)new AnnihilatorSavedData());
            data = (AnnihilatorSavedData)worldObj.perWorldStorage.func_75742_a(AnnihilatorSavedData.class, KEY);
        }
        return data;
    }

    public AnnihilatorPool grabPool(String pool) {
        AnnihilatorPool poolInstance = this.pools.get(pool);
        if (poolInstance == null) {
            poolInstance = new AnnihilatorPool();
            this.pools.put(pool, poolInstance);
        }
        return poolInstance;
    }

    public ItemStack pushToPool(String pool, FluidType type, long amount, boolean alwaysPayOut) {
        AnnihilatorPool poolInstance = this.grabPool(pool);
        ItemStack payout = poolInstance.increment(type, amount, alwaysPayOut);
        this.func_76185_a();
        return payout;
    }

    public ItemStack pushToPool(String pool, ItemStack stack, boolean alwaysPayOut) {
        AnnihilatorPool poolInstance = this.grabPool(pool);
        ItemStack itemPayout = poolInstance.increment(stack.func_77973_b(), stack.field_77994_a, alwaysPayOut);
        ItemStack compPayout = poolInstance.increment(new RecipesCommon.ComparableStack(stack).makeSingular(), stack.field_77994_a, alwaysPayOut);
        ItemStack dictPayout = null;
        List<String> oreDict = ItemStackUtil.getOreDictNames(stack);
        for (String name : oreDict) {
            ItemStack payout;
            if (name == null || name.isEmpty() || (payout = poolInstance.increment(name, stack.field_77994_a, alwaysPayOut)) == null) continue;
            dictPayout = payout;
        }
        this.func_76185_a();
        return dictPayout != null ? dictPayout : (compPayout != null ? compPayout : itemPayout);
    }

    public static class AnnihilatorPool {
        public HashMap<Object, BigInteger> items = new HashMap();

        public ItemStack increment(Object type, long amount, boolean alwaysPayOut) {
            ItemStack payout = null;
            BigInteger counter = this.items.get(type);
            if (counter == null) {
                counter = BigInteger.valueOf(amount);
                payout = AnnihilatorRecipes.getHighestPayoutFromKey(type, BigInteger.ZERO, counter);
            } else {
                BigInteger prev = counter;
                counter = counter.add(BigInteger.valueOf(amount));
                payout = AnnihilatorRecipes.getHighestPayoutFromKey(type, alwaysPayOut ? null : prev, counter);
            }
            this.items.put(type, counter);
            return payout;
        }

        public void serialize(NBTTagList nbt) {
            for (Map.Entry<Object, BigInteger> entry : this.items.entrySet()) {
                NBTTagCompound compound = new NBTTagCompound();
                this.serializeKey(compound, entry.getKey());
                compound.func_74773_a("amount", entry.getValue().toByteArray());
                nbt.func_74742_a((NBTBase)compound);
            }
        }

        public void deserialize(NBTTagList nbt) {
            try {
                for (int i = 0; i < nbt.func_74745_c(); ++i) {
                    NBTTagCompound compound = (NBTTagCompound)nbt.field_74747_a.get(i);
                    Object key = this.deserializeKey(compound);
                    if (key == null) continue;
                    this.items.put(key, new BigInteger(compound.func_74770_j("amount")));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void serializeKey(NBTTagCompound nbt, Object key) {
            if (key instanceof Item) {
                Item item = (Item)key;
                nbt.func_74774_a("key", (byte)0);
                nbt.func_74778_a("item", Item.field_150901_e.func_148750_c((Object)item));
            }
            if (key instanceof RecipesCommon.ComparableStack) {
                RecipesCommon.ComparableStack comp = (RecipesCommon.ComparableStack)key;
                nbt.func_74774_a("key", (byte)1);
                nbt.func_74778_a("item", Item.field_150901_e.func_148750_c((Object)comp.item));
                nbt.func_74777_a("meta", (short)comp.meta);
            }
            if (key instanceof FluidType) {
                FluidType type = (FluidType)key;
                nbt.func_74774_a("key", (byte)2);
                nbt.func_74778_a("fluid", type.getName());
            }
            if (key instanceof String) {
                nbt.func_74774_a("key", (byte)3);
                nbt.func_74778_a("dict", (String)key);
            }
        }

        public Object deserializeKey(NBTTagCompound nbt) {
            try {
                byte key = nbt.func_74771_c("key");
                if (key == 0) {
                    return Item.field_150901_e.func_82594_a(nbt.func_74779_i("item"));
                }
                if (key == 1) {
                    return new RecipesCommon.ComparableStack((Item)Item.field_150901_e.func_82594_a(nbt.func_74779_i("item")), 1, (int)nbt.func_74765_d("meta"));
                }
                if (key == 2) {
                    return Fluids.fromName(nbt.func_74779_i("fluid"));
                }
                if (key == 3) {
                    return nbt.func_74779_i("dict");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }
}

