/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.container.ContainerAshpit;
import com.hbm.inventory.gui.GUIAshpit;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TileEntityAshpit
extends TileEntityMachineBase
implements IGUIProvider,
IConfigurableMachine {
    private int playersUsing = 0;
    public float doorAngle = 0.0f;
    public float prevDoorAngle = 0.0f;
    public boolean isFull;
    public int ashLevelWood;
    public int ashLevelCoal;
    public int ashLevelMisc;
    public int ashLevelFly;
    public int ashLevelSoot;
    public static int thresholdWood = 2000;
    public static int thresholdCoal = 2000;
    public static int thresholdMisc = 2000;
    public static int thresholdFly = 2000;
    public static int thresholdSoot = 8000;
    AxisAlignedBB bb = null;

    public TileEntityAshpit() {
        super(5);
    }

    @Override
    public String getConfigName() {
        return "ashpit";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        thresholdWood = IConfigurableMachine.grab(obj, "I:thresholdWood", thresholdWood);
        thresholdCoal = IConfigurableMachine.grab(obj, "I:thresholdCoal", thresholdCoal);
        thresholdMisc = IConfigurableMachine.grab(obj, "I:thresholdMisc", thresholdMisc);
        thresholdFly = IConfigurableMachine.grab(obj, "I:thresholdFly", thresholdFly);
        thresholdSoot = IConfigurableMachine.grab(obj, "I:thresholdSoot", thresholdSoot);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("I:thresholdWood").value((long)thresholdWood);
        writer.name("I:thresholdCoal").value((long)thresholdCoal);
        writer.name("I:thresholdMisc").value((long)thresholdMisc);
        writer.name("I:thresholdFly").value((long)thresholdFly);
        writer.name("I:thresholdSoot").value((long)thresholdSoot);
    }

    @Override
    public void func_70295_k_() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.playersUsing;
        }
    }

    @Override
    public void func_70305_f() {
        if (!this.field_145850_b.field_72995_K) {
            --this.playersUsing;
        }
    }

    @Override
    public String getName() {
        return "container.ashpit";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.processAsh(this.ashLevelWood, ItemEnums.EnumAshType.WOOD, thresholdWood)) {
                this.ashLevelWood -= thresholdWood;
            }
            if (this.processAsh(this.ashLevelCoal, ItemEnums.EnumAshType.COAL, thresholdCoal)) {
                this.ashLevelCoal -= thresholdCoal;
            }
            if (this.processAsh(this.ashLevelMisc, ItemEnums.EnumAshType.MISC, thresholdMisc)) {
                this.ashLevelMisc -= thresholdMisc;
            }
            if (this.processAsh(this.ashLevelFly, ItemEnums.EnumAshType.FLY, thresholdFly)) {
                this.ashLevelFly -= thresholdFly;
            }
            if (this.processAsh(this.ashLevelSoot, ItemEnums.EnumAshType.SOOT, thresholdSoot)) {
                this.ashLevelSoot -= thresholdSoot;
            }
            this.isFull = false;
            for (int i = 0; i < 5; ++i) {
                if (this.slots[i] == null) continue;
                this.isFull = true;
            }
            this.networkPackNT(50);
        } else {
            this.prevDoorAngle = this.doorAngle;
            float swingSpeed = this.doorAngle / 10.0f + 3.0f;
            this.doorAngle = this.playersUsing > 0 ? (this.doorAngle += swingSpeed) : (this.doorAngle -= swingSpeed);
            this.doorAngle = MathHelper.func_76131_a((float)this.doorAngle, (float)0.0f, (float)135.0f);
        }
    }

    protected boolean processAsh(int level, ItemEnums.EnumAshType type, int threshold) {
        if (level >= threshold) {
            for (int i = 0; i < 5; ++i) {
                if (this.slots[i] == null) {
                    this.slots[i] = OreDictManager.DictFrame.fromOne(ModItems.powder_ash, (Enum)type);
                    this.ashLevelWood -= threshold;
                    return true;
                }
                if (this.slots[i].field_77994_a >= this.slots[i].func_77976_d() || this.slots[i].func_77973_b() != ModItems.powder_ash || this.slots[i].func_77960_j() != type.ordinal()) continue;
                ++this.slots[i].field_77994_a;
                return true;
            }
        }
        return false;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.playersUsing);
        buf.writeBoolean(this.isFull);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.playersUsing = buf.readInt();
        this.isFull = buf.readBoolean();
    }

    @Override
    public int[] func_94128_d(int meta) {
        return new int[]{0, 1, 2, 3, 4};
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.ashLevelWood = nbt.func_74762_e("ashLevelWood");
        this.ashLevelCoal = nbt.func_74762_e("ashLevelCoal");
        this.ashLevelMisc = nbt.func_74762_e("ashLevelMisc");
        this.ashLevelFly = nbt.func_74762_e("ashLevelFly");
        this.ashLevelSoot = nbt.func_74762_e("ashLevelSoot");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("ashLevelWood", this.ashLevelWood);
        nbt.func_74768_a("ashLevelCoal", this.ashLevelCoal);
        nbt.func_74768_a("ashLevelMisc", this.ashLevelMisc);
        nbt.func_74768_a("ashLevelFly", this.ashLevelFly);
        nbt.func_74768_a("ashLevelSoot", this.ashLevelSoot);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerAshpit(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIAshpit(player.field_71071_by, this);
    }
}

