/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.fusion;

import api.hbm.energymk2.IEnergyProviderMK2;
import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.handler.CompatHandler;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.tileentity.machine.fusion.IFusionPowerReceiver;
import com.hbm.uninos.GenNode;
import com.hbm.uninos.NodeNet;
import com.hbm.uninos.UniNodespace;
import com.hbm.uninos.networkproviders.PlasmaNetwork;
import com.hbm.uninos.networkproviders.PlasmaNetworkProvider;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityFusionMHDT
extends TileEntityLoadedBase
implements IEnergyProviderMK2,
IFluidStandardTransceiverMK2,
IFusionPowerReceiver,
IConfigurableMachine,
SimpleComponent,
CompatHandler.OCComponent {
    protected GenNode plasmaNode;
    public long plasmaEnergy;
    public long plasmaEnergySync;
    public long power;
    public float rotor;
    public float prevRotor;
    public float rotorSpeed;
    public static final float ROTOR_ACCELERATION = 0.125f;
    public static final double PLASMA_EFFICIENCY = 1.35;
    public static final int COOLANT_USE = 50;
    public static long MINIMUM_PLASMA = 5000000L;
    public FluidTank[] tanks = new FluidTank[2];
    private AudioWrapper audio;
    AxisAlignedBB bb = null;

    @Override
    public String getConfigName() {
        return "mhd-turbine";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        MINIMUM_PLASMA = IConfigurableMachine.grab(obj, "L:minimumPlasma", MINIMUM_PLASMA);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("L:minimumPlasma").value(MINIMUM_PLASMA);
    }

    public TileEntityFusionMHDT() {
        this.tanks[0] = new FluidTank(Fluids.PERFLUOROMETHYL_COLD, 4000);
        this.tanks[1] = new FluidTank(Fluids.PERFLUOROMETHYL, 4000);
    }

    public boolean hasMinimumPlasma() {
        return this.plasmaEnergy >= MINIMUM_PLASMA;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.plasmaEnergySync = this.plasmaEnergy;
            if (this.isCool()) {
                this.power = (long)Math.floor((double)this.plasmaEnergy * 1.35);
                if (!this.hasMinimumPlasma()) {
                    this.power /= 2L;
                }
                this.tanks[0].setFill(this.tanks[0].getFill() - 50);
                this.tanks[1].setFill(this.tanks[1].getFill() + 50);
            }
            for (DirPos pos : this.getConPos()) {
                this.tryProvide(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                if (this.tanks[0].getTankType() != Fluids.NONE) {
                    this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos);
                }
                if (this.tanks[1].getFill() <= 0) continue;
                this.tryProvide(this.tanks[1], this.field_145850_b, pos);
            }
            if (this.plasmaNode == null || this.plasmaNode.expired) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
                this.plasmaNode = UniNodespace.getNode(this.field_145850_b, this.field_145851_c + dir.offsetX * 6, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 6, PlasmaNetworkProvider.THE_PROVIDER);
                if (this.plasmaNode == null) {
                    this.plasmaNode = new GenNode<PlasmaNetwork>(PlasmaNetworkProvider.THE_PROVIDER, new BlockPos(this.field_145851_c + dir.offsetX * 6, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 6)).setConnections(new DirPos(this.field_145851_c + dir.offsetX * 7, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 7, dir));
                    UniNodespace.createNode(this.field_145850_b, this.plasmaNode);
                }
            }
            if (this.plasmaNode != null && this.plasmaNode.hasValidNet()) {
                ((NodeNet)this.plasmaNode.net).addReceiver((TileEntityFusionMHDT)this);
            }
            this.networkPackNT(150);
            this.plasmaEnergy = 0L;
        } else {
            this.rotorSpeed = this.plasmaEnergy > 0L && this.isCool() ? (this.rotorSpeed += 0.125f) : (this.rotorSpeed -= 0.125f);
            this.rotorSpeed = MathHelper.func_76131_a((float)this.rotorSpeed, (float)0.0f, (float)(this.hasMinimumPlasma() ? 15.0f : 10.0f));
            this.prevRotor = this.rotor;
            this.rotor += this.rotorSpeed;
            if (this.rotor >= 360.0f) {
                this.rotor -= 360.0f;
                this.prevRotor -= 360.0f;
            }
            if (this.rotorSpeed > 0.0f && MainRegistry.proxy.me().func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 2.5, (double)this.field_145849_e + 0.5) < 900.0) {
                float speed = this.rotorSpeed / 15.0f;
                if (this.audio == null) {
                    this.audio = MainRegistry.proxy.getLoopedSound("hbm:block.largeTurbineRunning", (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 1.5f, (float)this.field_145849_e + 0.5f, this.getVolume(speed), 20.0f, speed, 20);
                    this.audio.startSound();
                } else {
                    this.audio.updateVolume(this.getVolume(speed));
                    this.audio.updatePitch(speed);
                    this.audio.keepAlive();
                }
            } else if (this.audio != null) {
                if (this.audio.isPlaying()) {
                    this.audio.stopSound();
                }
                this.audio = null;
            }
        }
    }

    public boolean isCool() {
        return this.tanks[0].getFill() >= 50 && this.tanks[1].getFill() + 50 <= this.tanks[1].getMaxFill();
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 4 + rot.offsetX * 4, this.field_145848_d, this.field_145849_e + dir.offsetZ * 4 + rot.offsetZ * 4, rot), new DirPos(this.field_145851_c + dir.offsetX * 4 - rot.offsetX * 4, this.field_145848_d, this.field_145849_e + dir.offsetZ * 4 - rot.offsetZ * 4, rot.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 8, this.field_145848_d + 1, this.field_145849_e + dir.offsetZ * 8, dir)};
    }

    @Override
    public boolean receivesFusionPower() {
        return true;
    }

    @Override
    public void receiveFusionPower(long fusionPower, double neutronPower) {
        this.plasmaEnergy = fusionPower;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.plasmaEnergySync);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.plasmaEnergy = buf.readLong();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "t0");
        this.tanks[1].readFromNBT(nbt, "t1");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "t0");
        this.tanks[1].writeToNBT(nbt, "t1");
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
        if (!this.field_145850_b.field_72995_K && this.plasmaNode != null) {
            UniNodespace.destroyNode(this.field_145850_b, this.plasmaNode);
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return this.power;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 7), (double)this.field_145848_d, (double)(this.field_145849_e - 7), (double)(this.field_145851_c + 8), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 8));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_fusion_mhdt";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyInfo(Context context, Arguments args) {
        return new Object[]{this.power};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getPlasmaEnergy(Context context, Arguments args) {
        return new Object[]{this.plasmaEnergySync};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCoolant(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getFill(), this.tanks[0].getMaxFill(), this.tanks[1].getFill(), this.tanks[1].getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.power, this.plasmaEnergySync, this.tanks[0].getFill(), this.tanks[0].getMaxFill(), this.tanks[1].getFill(), this.tanks[1].getMaxFill()};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getEnergyInfo", "getPlasmaEnergy", "getCoolant", "getInfo"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getEnergyInfo": {
                return this.getEnergyInfo(context, args);
            }
            case "getPlasmaEnergy": {
                return this.getPlasmaEnergy(context, args);
            }
            case "getCoolant": {
                return this.getCoolant(context, args);
            }
            case "getInfo": {
                return this.getInfo(context, args);
            }
        }
        throw new NoSuchMethodException();
    }
}

