/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.BlockEnumMulti;
import com.hbm.blocks.IBlockMulti;
import com.hbm.handler.radiation.ChunkRadiationManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BlockAbsorber
extends BlockEnumMulti
implements IBlockMulti {
    public BlockAbsorber(Material mat) {
        super(mat, EnumAbsorberTier.class, true, true);
        this.func_149675_a(true);
        this.func_149663_c("rad_absorber");
    }

    public EnumAbsorberTier getTier(int meta) {
        return EnumAbsorberTier.values()[this.rectify(meta)];
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        EnumAbsorberTier tier = this.getTier(stack.func_77960_j());
        String tierName = StatCollector.func_74838_a((String)("tile.rad_absorber." + tier.name().toLowerCase()));
        return tierName;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons = new IIcon[EnumAbsorberTier.values().length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = reg.func_94245_a("hbm:" + EnumAbsorberTier.values()[i].textureName);
        }
    }

    public int func_149738_a(World world) {
        return 10;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        EnumAbsorberTier tier = this.getTier(world.func_72805_g(x, y, z));
        ChunkRadiationManager.proxy.decrementRad(world, x, y, z, tier.absorbAmount);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    public static enum EnumAbsorberTier {
        BASE(2.5f, "absorber"),
        RED(10.0f, "absorber_red"),
        GREEN(100.0f, "absorber_green"),
        PINK(10000.0f, "absorber_pink");

        public final float absorbAmount;
        public final String textureName;

        private EnumAbsorberTier(float absorb, String texture) {
            this.absorbAmount = absorb;
            this.textureName = texture;
        }
    }
}

