/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import api.hbm.fluidmk2.IFillableItem;
import com.hbm.blocks.IBlockMultiPass;
import com.hbm.blocks.ILookOverlay;
import com.hbm.inventory.FluidContainerRegistry;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemDrillbit;
import com.hbm.main.MainRegistry;
import com.hbm.render.block.RenderBlockMultipass;
import com.hbm.util.EnumUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class BlockBedrockOreTE
extends BlockContainer
implements ILookOverlay,
IBlockMultiPass {
    private IIcon[] overlays = new IIcon[10];

    public BlockBedrockOreTE() {
        super(Material.field_151576_e);
        this.func_149658_d("bedrock");
        this.func_149722_s();
        this.func_149752_b(1000000.0f);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityBedrockOre();
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return null;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.func_149689_a(world, x, y, z, entity, stack);
        world.func_147471_g(x, y, z);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int i, float fx, float fy, float fz) {
        ItemStack stack = player.func_70694_bm();
        if (stack == null) {
            return false;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityBedrockOre) {
            TileEntityBedrockOre ore = (TileEntityBedrockOre)te;
            if (stack.func_77973_b() == ModItems.drillbit) {
                ItemDrillbit.EnumDrillType type = (ItemDrillbit.EnumDrillType)((Object)EnumUtil.grabEnumSafely(ItemDrillbit.EnumDrillType.class, stack.func_77960_j()));
                ore.tier = type.tier;
            } else if (FluidContainerRegistry.getFluidType(stack) != Fluids.NONE) {
                FluidType type = FluidContainerRegistry.getFluidType(stack);
                int amount = FluidContainerRegistry.getFluidContent(stack, type);
                ore.acidRequirement = new FluidStack(type, amount);
            } else if (stack.func_77973_b() instanceof IFillableItem) {
                IFillableItem item = (IFillableItem)stack.func_77973_b();
                FluidType type = item.getFirstFluidType(stack);
                if (type != null) {
                    ore.acidRequirement = new FluidStack(type, item.getFill(stack));
                }
            } else {
                ore.resource = stack.func_77946_l();
                ore.shape = world.field_73012_v.nextInt(10);
            }
            ore.func_70296_d();
        }
        world.func_147471_g(x, y, z);
        return true;
    }

    public int func_149645_b() {
        return IBlockMultiPass.getRenderType();
    }

    @Override
    public int getPasses() {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a("bedrock");
        for (int i = 0; i < this.overlays.length; ++i) {
            this.overlays[i] = reg.func_94245_a("hbm:ore_random_" + (i + 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (RenderBlockMultipass.currentPass == 0) {
            return Blocks.field_150357_h.func_149691_a(0, 0);
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityBedrockOre) {
            TileEntityBedrockOre ore = (TileEntityBedrockOre)te;
            int index = ore.shape % this.overlays.length;
            return this.overlays[index];
        }
        return Blocks.field_150357_h.func_149691_a(0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (RenderBlockMultipass.currentPass == 0) {
            return Blocks.field_150357_h.func_149691_a(0, 0);
        }
        int index = meta % this.overlays.length;
        return this.overlays[index];
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        if (RenderBlockMultipass.currentPass == 0) {
            return 0xFFFFFF;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityBedrockOre) {
            TileEntityBedrockOre ore = (TileEntityBedrockOre)te;
            return ore.color;
        }
        return super.func_149720_d(world, x, y, z);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityBedrockOre)) {
            return;
        }
        TileEntityBedrockOre ore = (TileEntityBedrockOre)te;
        ArrayList<String> text = new ArrayList<String>();
        if (ore.resource != null) {
            text.add(ore.resource.func_82833_r());
        }
        text.add("Tier: " + ore.tier);
        if (ore.acidRequirement != null) {
            text.add("Requires: " + ore.acidRequirement.fill + "mB " + ore.acidRequirement.type.getLocalizedName());
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    public static class TileEntityBedrockOre
    extends TileEntity {
        public ItemStack resource;
        public FluidStack acidRequirement;
        public int tier;
        public int color;
        public int shape;

        public TileEntityBedrockOre setStyle(int color, int shape) {
            this.color = color;
            this.shape = shape;
            return this;
        }

        public boolean canUpdate() {
            return false;
        }

        public void func_145839_a(NBTTagCompound nbt) {
            FluidType type;
            super.func_145839_a(nbt);
            this.resource = new ItemStack(Item.func_150899_d((int)nbt.func_74762_e("0id")), (int)nbt.func_74771_c("size"), (int)nbt.func_74765_d("meta"));
            if (this.resource.func_77973_b() == null) {
                this.resource = new ItemStack(ModItems.powder_iron);
            }
            if ((type = Fluids.fromID(nbt.func_74762_e("fluid"))) != Fluids.NONE) {
                this.acidRequirement = new FluidStack(type, nbt.func_74762_e("amount"));
            }
            this.tier = nbt.func_74762_e("tier");
            this.color = nbt.func_74762_e("color");
            this.shape = nbt.func_74762_e("shape");
        }

        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            if (this.resource != null) {
                nbt.func_74768_a("0id", Item.func_150891_b((Item)this.resource.func_77973_b()));
                nbt.func_74774_a("size", (byte)this.resource.field_77994_a);
                nbt.func_74777_a("meta", (short)this.resource.func_77960_j());
            }
            if (this.acidRequirement != null) {
                nbt.func_74768_a("fluid", this.acidRequirement.type.getID());
                nbt.func_74768_a("amount", this.acidRequirement.fill);
            }
            nbt.func_74768_a("tier", this.tier);
            nbt.func_74768_a("color", this.color);
            nbt.func_74768_a("shape", this.shape);
        }

        public Packet func_145844_m() {
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_145841_b(nbt);
            return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
            this.func_145839_a(pkt.func_148857_g());
            if (this.color == 0) {
                this.color = MainRegistry.proxy.getStackColor(this.resource, true);
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }
}

