/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.trait.FT_Gaseous;
import com.hbm.inventory.fluid.trait.FluidTraitSimple;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityAtmosphericEmitter;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineAtmosphericEmitter
extends BlockDummyable
implements ILookOverlay {
    public MachineAtmosphericEmitter() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityAtmosphericEmitter();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo().power().fluid();
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{2, 0, 1, 0, 1, 0};
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.makeExtra(world, (x -= dir.offsetX * o) - dir.offsetX + rot.offsetX, y, (z -= dir.offsetZ * o) - dir.offsetZ + rot.offsetZ);
        this.makeExtra(world, x, y, z - dir.offsetZ + rot.offsetZ);
        this.makeExtra(world, x - dir.offsetX + rot.offsetX, y, z);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IItemFluidIdentifier) {
                int[] pos = this.findCore(world, x, y, z);
                if (pos == null) {
                    return false;
                }
                TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
                if (!(te instanceof TileEntityAtmosphericEmitter)) {
                    return false;
                }
                TileEntityAtmosphericEmitter drain = (TileEntityAtmosphericEmitter)te;
                FluidType type = ((IItemFluidIdentifier)player.func_70694_bm().func_77973_b()).getType(world, pos[0], pos[1], pos[2], player.func_70694_bm());
                if (type.hasTrait(FT_Gaseous.class) || type.hasTrait(FluidTraitSimple.FT_Gaseous_ART.class)) {
                    drain.tank.setTankType(type);
                    drain.func_70296_d();
                    player.func_146105_b(new ChatComponentText("Changed type to ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)).func_150257_a((IChatComponent)new ChatComponentTranslation(type.getConditionalName(), new Object[0])).func_150257_a((IChatComponent)new ChatComponentText("!")));
                }
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityAtmosphericEmitter)) {
            return;
        }
        TileEntityAtmosphericEmitter drain = (TileEntityAtmosphericEmitter)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add((drain.power < (long)(Math.max(drain.tank.getFill() / 2, 1) * 10) ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + "Power: " + BobMathUtil.getShortNumber(drain.power) + "HE");
        text.add(EnumChatFormatting.GREEN + "-> " + EnumChatFormatting.RESET + drain.tank.getTankType().getLocalizedName() + ": " + drain.tank.getFill() + "/" + drain.tank.getMaxFill() + "mB");
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }
}

