/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.mapgen;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class MapGenPlateau
extends MapGenBase {
    public Block stoneBlock;
    public Block surfrock;
    public Block fillblock;
    public NoiseGeneratorPerlin plateauNoise;
    public double noiseScale = 0.05;
    public int maxPlateauAddition = 12;
    public int stepHeight = 6;
    public int topsoilThickness = 2;
    public BiomeGenBase applyToBiome;

    public MapGenPlateau(World world) {
        this.plateauNoise = new NoiseGeneratorPerlin(world.field_73012_v, 4);
    }

    public void func_151539_a(IChunkProvider provider, World world, int chunkX, int chunkZ, Block[] blocks) {
        int localZ;
        int localX;
        int[][] plateauTops = new int[16][16];
        int[][] baseHeights = new int[16][16];
        for (localX = 0; localX < 16; ++localX) {
            for (localZ = 0; localZ < 16; ++localZ) {
                int baseHeight;
                baseHeights[localX][localZ] = baseHeight = this.getSurfaceHeight(blocks, localX, localZ);
                double noiseVal = this.plateauNoise.func_151601_a((double)(chunkX * 16 + localX) * this.noiseScale, (double)(chunkZ * 16 + localZ) * this.noiseScale);
                int plateauAddition = (int)((noiseVal + 1.0) / 2.0 * (double)this.maxPlateauAddition);
                plateauAddition = plateauAddition / this.stepHeight * this.stepHeight;
                plateauTops[localX][localZ] = baseHeight + plateauAddition;
            }
        }
        for (localX = 0; localX < 16; ++localX) {
            for (localZ = 0; localZ < 16; ++localZ) {
                BiomeGenBase biome;
                if (this.applyToBiome != null && (biome = world.func_72807_a(localX + chunkX * 16, localZ + chunkZ * 16)) != this.applyToBiome) continue;
                int baseHeight = baseHeights[localX][localZ];
                int plateauTop = plateauTops[localX][localZ];
                for (int y = baseHeight + 1; y < 256; ++y) {
                    int index = (localX * 16 + localZ) * 256 + y;
                    if (y < plateauTop - this.topsoilThickness) {
                        blocks[index] = this.stoneBlock;
                        continue;
                    }
                    if (y < plateauTop) {
                        boolean sameBack;
                        boolean sameLeft = localX - 1 < 0 || plateauTops[localX - 1][localZ] == plateauTop;
                        boolean sameRight = localX + 1 >= 16 || plateauTops[localX + 1][localZ] == plateauTop;
                        boolean sameFront = localZ - 1 < 0 || plateauTops[localX][localZ - 1] == plateauTop;
                        boolean bl = sameBack = localZ + 1 >= 16 || plateauTops[localX][localZ + 1] == plateauTop;
                        if (y == plateauTop - 1 && sameLeft && sameRight && sameFront && sameBack) {
                            blocks[index] = this.fillblock;
                            continue;
                        }
                        blocks[index] = this.surfrock;
                        continue;
                    }
                    blocks[index] = Blocks.field_150350_a;
                }
            }
        }
    }

    private int getSurfaceHeight(Block[] blocks, int localX, int localZ) {
        int baseHeight = 0;
        for (int y = 255; y >= 0; --y) {
            int index = (localX * 16 + localZ) * 256 + y;
            if (blocks[index] == Blocks.field_150350_a) continue;
            baseHeight = y;
            break;
        }
        return baseHeight;
    }
}

