/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import com.hbm.dim.CelestialBody;
import com.hbm.handler.nei.NEIUniversalHandler;
import com.hbm.items.ModItems;
import com.hbm.util.Clock;
import com.hbm.util.InventoryUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class NEICelestialHandler
extends NEIUniversalHandler {
    protected HashMap<Integer, CelestialBody> recipeInputCache = new HashMap();

    public NEICelestialHandler(String display, ItemStack[] machine, HashMap recipes) {
        super(display, machine, recipes);
    }

    public NEICelestialHandler(String display, HashMap recipes, HashMap machines) {
        super(display, recipes, machines);
    }

    public NEICelestialHandler(String display, ItemStack machine, HashMap recipes) {
        super(display, machine, recipes);
    }

    public NEICelestialHandler(String display, Item machine, HashMap recipes) {
        super(display, machine, recipes);
    }

    public NEICelestialHandler(String display, Block machine, HashMap recipes) {
        super(display, machine, recipes);
    }

    @Override
    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
        CelestialBody body = this.recipeInputCache.get(recipe);
        GuiDraw.changeTexture((ResourceLocation)body.texture);
        double uvOffset = (double)(Clock.get_ms() % 4000L) / 4000.0;
        double minX = 32.0;
        double minY = 12.0;
        double maxX = minX + 32.0;
        double maxY = minY + 32.0;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(minX, maxY, 0.0, 0.0 + uvOffset, 1.0);
        tessellator.func_78374_a(maxX, maxY, 0.0, 1.0 + uvOffset, 1.0);
        tessellator.func_78374_a(maxX, minY, 0.0, 1.0 + uvOffset, 0.0);
        tessellator.func_78374_a(minX, minY, 0.0, 0.0 + uvOffset, 0.0);
        tessellator.func_78381_a();
        GuiDraw.drawStringC((String)I18nUtil.resolveKey("body." + body.name, new Object[0]), (int)16, (int)48, (int)64, (int)12, (int)0, (boolean)false);
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getKey())) {
            block0: for (Map.Entry recipe : this.recipes.entrySet()) {
                ItemStack[][] outs;
                ItemStack[][] ins = new ItemStack[0][0];
                ItemStack[][] itemStackArray = outs = InventoryUtil.extractObject(recipe.getValue());
                int n = itemStackArray.length;
                for (int i = 0; i < n; ++i) {
                    ItemStack[] array;
                    for (ItemStack stack : array = itemStackArray[i]) {
                        if (stack.func_77973_b() == ModItems.item_secret) continue block0;
                    }
                }
                this.recipeInputCache.put(this.arecipes.size(), (CelestialBody)recipe.getKey());
                this.arecipes.add(new NEIUniversalHandler.RecipeSet(this, ins, outs, recipe.getKey()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        block0: for (Map.Entry recipe : this.recipes.entrySet()) {
            ItemStack[] array;
            int n;
            ItemStack[][] outs;
            ItemStack[][] ins = new ItemStack[0][0];
            ItemStack[][] itemStackArray = outs = InventoryUtil.extractObject(recipe.getValue());
            int n2 = itemStackArray.length;
            for (n = 0; n < n2; ++n) {
                for (ItemStack stack : array = itemStackArray[n]) {
                    if (stack.func_77973_b() == ModItems.item_secret) continue block0;
                }
            }
            itemStackArray = outs;
            n2 = itemStackArray.length;
            for (n = 0; n < n2; ++n) {
                for (ItemStack stack : array = itemStackArray[n]) {
                    if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)result)) continue;
                    this.recipeInputCache.put(this.arecipes.size(), (CelestialBody)recipe.getKey());
                    this.arecipes.add(new NEIUniversalHandler.RecipeSet(this, ins, outs, recipe.getKey()));
                    continue block0;
                }
            }
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
    }
}

