/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.fluid.trait;

import com.google.common.collect.HashBiMap;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Combustible;
import com.hbm.inventory.fluid.trait.FT_Coolable;
import com.hbm.inventory.fluid.trait.FT_Corrosive;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.inventory.fluid.trait.FT_Gaseous;
import com.hbm.inventory.fluid.trait.FT_Heatable;
import com.hbm.inventory.fluid.trait.FT_PWRModerator;
import com.hbm.inventory.fluid.trait.FT_Pheromone;
import com.hbm.inventory.fluid.trait.FT_Poison;
import com.hbm.inventory.fluid.trait.FT_Polluting;
import com.hbm.inventory.fluid.trait.FT_Rocket;
import com.hbm.inventory.fluid.trait.FT_Terraformer;
import com.hbm.inventory.fluid.trait.FT_Toxin;
import com.hbm.inventory.fluid.trait.FT_VentRadiation;
import com.hbm.inventory.fluid.trait.FluidTraitSimple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.World;

public abstract class FluidTrait {
    public static List<Class<? extends FluidTrait>> traitList = new ArrayList<Class<? extends FluidTrait>>();
    public static HashBiMap<String, Class<? extends FluidTrait>> traitNameMap = HashBiMap.create();

    private static void registerTrait(String name, Class<? extends FluidTrait> clazz) {
        traitNameMap.put((Object)name, clazz);
        traitList.add(clazz);
    }

    public void addInfo(List<String> info) {
    }

    public void addInfoHidden(List<String> info) {
    }

    public void onFluidRelease(World world, int x, int y, int z, FluidTank tank, int overflowAmount, FluidReleaseType type) {
    }

    public void serializeJSON(JsonWriter writer) throws IOException {
    }

    public void deserializeJSON(JsonObject obj) {
    }

    static {
        FluidTrait.registerTrait("corrosive", FT_Corrosive.class);
        FluidTrait.registerTrait("flammable", FT_Flammable.class);
        FluidTrait.registerTrait("combustible", FT_Combustible.class);
        FluidTrait.registerTrait("polluting", FT_Polluting.class);
        FluidTrait.registerTrait("heatable", FT_Heatable.class);
        FluidTrait.registerTrait("coolable", FT_Coolable.class);
        FluidTrait.registerTrait("pwrmoderator", FT_PWRModerator.class);
        FluidTrait.registerTrait("poison", FT_Poison.class);
        FluidTrait.registerTrait("toxin", FT_Toxin.class);
        FluidTrait.registerTrait("ventradiation", FT_VentRadiation.class);
        FluidTrait.registerTrait("pheromone", FT_Pheromone.class);
        FluidTrait.registerTrait("rocket", FT_Rocket.class);
        FluidTrait.registerTrait("terraformer", FT_Terraformer.class);
        FluidTrait.registerTrait("gaseous", FT_Gaseous.class);
        FluidTrait.registerTrait("gaseous_art", FluidTraitSimple.FT_Gaseous_ART.class);
        FluidTrait.registerTrait("liquid", FluidTraitSimple.FT_Liquid.class);
        FluidTrait.registerTrait("viscous", FluidTraitSimple.FT_Viscous.class);
        FluidTrait.registerTrait("plasma", FluidTraitSimple.FT_Plasma.class);
        FluidTrait.registerTrait("amat", FluidTraitSimple.FT_Amat.class);
        FluidTrait.registerTrait("leadcontainer", FluidTraitSimple.FT_LeadContainer.class);
        FluidTrait.registerTrait("delicious", FluidTraitSimple.FT_Delicious.class);
        FluidTrait.registerTrait("noid", FluidTraitSimple.FT_NoID.class);
        FluidTrait.registerTrait("nocontainer", FluidTraitSimple.FT_NoContainer.class);
        FluidTrait.registerTrait("unsiphonable", FluidTraitSimple.FT_Unsiphonable.class);
        FluidTrait.registerTrait("uk", FluidTraitSimple.FT_ULTRAKILL.class);
        FluidTrait.registerTrait("explosive", FluidTraitSimple.FT_EXPLOSIVE.class);
    }

    public static enum FluidReleaseType {
        VOID,
        BURN,
        SPILL;

    }
}

