/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.config.SpaceConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.trait.CBT_War;
import com.hbm.inventory.container.ContainerStardar;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.items.ItemVOTVdrive;
import com.hbm.items.ModItems;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.saveddata.SatelliteSavedData;
import com.hbm.tileentity.machine.TileEntityMachineStardar;
import com.hbm.util.Clock;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GUIMachineStardar
extends GuiInfoContainer {
    public static ResourceLocation texture = new ResourceLocation("hbm:textures/gui/machine/gui_stardar.png");
    private static final ResourceLocation nightTexture = new ResourceLocation("hbm", "textures/misc/space/night.png");
    private TileEntityMachineStardar star;
    private CelestialBody currentBody;
    private int mX;
    private int mY;
    private int lX;
    private int lY;
    private int sX;
    private int sY;
    private boolean dragging = false;
    private float starX = 0.0f;
    private float starY = 0.0f;
    private float velocityX = 0.0f;
    private float velocityY = 0.0f;
    private List<POI> pList = new ArrayList<POI>();
    Random rnd = new Random();
    private final DynamicTexture groundTexture;
    private final ResourceLocation groundMap;
    private final int[] groundColors;

    public void init() {
        this.currentBody = CelestialBody.getBody(this.star.func_145831_w());
        boolean inOrbit = CelestialBody.inOrbit(this.star.func_145831_w());
        for (CelestialBody landable : CelestialBody.getLandableBodies()) {
            if (landable == this.currentBody && !inOrbit) continue;
            int posX = this.rnd.nextInt(400) - 200;
            int posY = this.rnd.nextInt(400) - 200;
            this.pList.add(new POI(posX, posY, landable));
        }
    }

    public GUIMachineStardar(InventoryPlayer iplayer, TileEntityMachineStardar restard) {
        super(new ContainerStardar(iplayer, restard));
        this.star = restard;
        this.field_146999_f = 176;
        this.field_147000_g = 256;
        this.init();
        this.groundTexture = new DynamicTexture(256, 256);
        this.groundMap = Minecraft.func_71410_x().func_110434_K().func_110578_a("groundMap", this.groundTexture);
        this.groundColors = this.groundTexture.func_110565_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        super.func_73863_a(mouseX, mouseY, f);
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 129, this.field_147009_r + 124, 18, 18, mouseX, mouseY, "Toggle radar mode");
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 129, this.field_147009_r + 143, 18, 18, mouseX, mouseY, "Program new orbital station into drive");
        this.drawCustomInfoStat(mouseX, mouseY, this.field_147003_i + 149, this.field_147009_r + 143, 18, 18, mouseX, mouseY, "Program current body into drive");
    }

    /*
     * WARNING - void declaration
     */
    protected void func_146976_a(float interp, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.pushScissor(9, 9, 158, 108);
        if (!Mouse.isButtonDown((int)0)) {
            this.velocityX = (float)((double)this.velocityX * 0.85);
            this.velocityY = (float)((double)this.velocityY * 0.85);
            this.starX += this.velocityX;
            this.starY += this.velocityY;
            this.starX = MathHelper.func_76131_a((float)this.starX, (float)-98.0f, (float)256.0f);
            this.starY = MathHelper.func_76131_a((float)this.starY, (float)-148.0f, (float)256.0f);
        }
        if (!this.star.radarMode) {
            if (Keyboard.isKeyDown((int)200)) {
                this.starY += 1.0f;
            }
            if (Keyboard.isKeyDown((int)208)) {
                this.starY -= 1.0f;
            }
            if (Keyboard.isKeyDown((int)203)) {
                this.starX += 1.0f;
            }
            if (Keyboard.isKeyDown((int)205)) {
                this.starX -= 1.0f;
            }
            if (this.star.heightmap == null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(nightTexture);
                this.func_73729_b(this.field_147003_i, this.field_147009_r, (int)this.starX * -1, (int)this.starY * -1, 256, 256);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
                for (POI pOI : this.pList) {
                    int px = (int)((float)this.field_147003_i + this.starX + (float)pOI.offsetX);
                    int py = (int)((float)this.field_147009_r + this.starY + (float)pOI.offsetY);
                    this.func_73729_b(px, py, this.field_146999_f + pOI.body.getProcessingLevel(this.currentBody) * 8, 0, 8, 8);
                }
            } else {
                if (this.star.updateHeightmap) {
                    for (int i = 0; i < this.star.heightmap.length; ++i) {
                        int n = this.star.heightmap[i] % 16 * 16;
                        int r = 0;
                        int g = n;
                        int b = 0;
                        int a = 255;
                        this.groundColors[i] = a << 24 | r << 16 | g << 8 | b;
                    }
                    this.groundTexture.func_110564_a();
                    this.star.updateHeightmap = false;
                }
                this.field_146297_k.func_110434_K().func_110577_a(this.groundMap);
                GUIMachineStardar.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)((int)this.starX * -1 - 256 - 9), (float)((int)this.starY * -1 - 256 - 9), (int)256, (int)256, (float)512.0f, (float)512.0f);
            }
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(nightTexture);
            this.func_73729_b(this.field_147003_i, this.field_147009_r, (int)this.starX * -1, (int)this.starY * -1, 256, 256);
            if (CelestialBody.getBody(this.star.func_145831_w()).hasTrait(CBT_War.class)) {
                void var5_10;
                CBT_War wardat = CelestialBody.getTrait(this.star.func_145831_w(), CBT_War.class);
                boolean bl = false;
                while (var5_10 < wardat.getProjectiles().size()) {
                    CBT_War.Projectile projectile = wardat.getProjectiles().get((int)var5_10);
                    int projvel = (int)projectile.getTravel();
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
                    float randomAngle = projectile.GUIangle;
                    float offsetX = (float)Math.cos(Math.toRadians(randomAngle)) * (float)projvel;
                    float offsetY = (float)Math.sin(Math.toRadians(randomAngle)) * (float)projvel;
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
                    if (Clock.get_ms() % 300L < 120L) {
                        this.func_73729_b((int)((float)this.field_147003_i + this.starX + offsetX + 85.0f), (int)((float)this.field_147009_r + this.starY + offsetY + 60.0f), this.field_146999_f + 44, 0, 8, 8);
                    }
                    ++var5_10;
                }
            }
            for (Map.Entry entry : SatelliteSavedData.getClientSats().entrySet()) {
                float radius = 20 + (Integer)entry.getKey() / 1000;
                float initialAngle = (float)((Integer)entry.getKey() / 1000) * 10.0f;
                double currentTime = Clock.get_ms();
                double angle = (currentTime / (double)radius % 360.0 + (double)initialAngle) % 360.0;
                float offsetX = (float)Math.cos(Math.toRadians(angle)) * radius;
                float offsetY = (float)Math.sin(Math.toRadians(angle)) * radius;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
                this.func_73729_b((int)((float)this.field_147003_i + this.starX + offsetX + 85.0f), (int)((float)this.field_147009_r + this.starY + offsetY + 60.0f), this.field_146999_f + 8, 0, 8, 8);
            }
            GL11.glPushMatrix();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(CelestialBody.getBody((World)this.star.func_145831_w()).texture);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            int n = 85;
            int offsetY = 60;
            tessellator.func_78374_a((double)((float)this.field_147003_i + this.starX + (float)n - 5.0f), (double)((float)this.field_147009_r + this.starY + (float)offsetY + 11.0f), 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)((float)this.field_147003_i + this.starX + (float)n + 11.0f), (double)((float)this.field_147009_r + this.starY + (float)offsetY + 11.0f), 0.0, 1.0, 1.0);
            tessellator.func_78374_a((double)((float)this.field_147003_i + this.starX + (float)n + 11.0f), (double)((float)this.field_147009_r + this.starY + (float)offsetY - 5.0f), 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)((float)this.field_147003_i + this.starX + (float)n - 5.0f), (double)((float)this.field_147009_r + this.starY + (float)offsetY - 5.0f), 0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            GL11.glPopMatrix();
        }
        this.popScissor();
    }

    protected void func_146979_b(int mx, int my) {
        ItemStack slotStack = this.field_147002_h.func_75139_a(0).func_75211_c();
        if (!this.star.radarMode) {
            if (this.checkClick(mx, my, 9, 9, 158, 108)) {
                if (this.star.heightmap == null) {
                    for (POI poi : this.pList) {
                        int px = (int)(this.starX + (float)poi.offsetX);
                        int py = (int)(this.starY + (float)poi.offsetY);
                        this.drawCustomInfoStat(mx - this.field_147003_i, my - this.field_147009_r, px - 2, py - 2, 12, 12, px + 8, py + 10, I18nUtil.resolveKey("body." + poi.body.name, new Object[0]), "Processing Tier: " + poi.body.getProcessingLevel(this.currentBody));
                    }
                } else {
                    this.pushScissor(9, 9, 158, 108);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
                    int hx = (mx - (int)this.starX - this.field_147003_i - 9 + 256) / 2;
                    int hz = (my - (int)this.starY - this.field_147009_r - 9 + 256) / 2;
                    String info = this.landingInfo(hx, hz);
                    int altitude = this.altitude(hx, hz);
                    boolean canLand = info == null;
                    int sx = mx - (mx + (int)this.starX) % 2;
                    int sy = my - (my + (int)this.starY) % 2;
                    this.func_73729_b(sx - 6 - this.field_147003_i, sy - 6 - this.field_147009_r, this.field_146999_f + (canLand ? 14 : 0), 28, 14, 14);
                    this.popScissor();
                    this.field_146289_q.func_78276_b(canLand ? "Valid location" : info, 10, 128, canLand ? 65280 : 0xFF0000);
                    if (altitude > 0) {
                        this.field_146289_q.func_78276_b("Target altitude: " + altitude, 10, 148, 65280);
                    }
                }
            } else if (this.star.heightmap != null) {
                this.field_146289_q.func_78276_b("Select landing zone", 10, 128, 65280);
            }
            if (this.star.heightmap == null) {
                if (slotStack == null) {
                    this.field_146289_q.func_78276_b("Insert drive", 10, 128, 65280);
                } else if (slotStack.func_77973_b() == ModItems.full_drive) {
                    if (ItemVOTVdrive.getDestination((ItemStack)slotStack).body == SolarSystem.Body.ORBIT) {
                        this.field_146289_q.func_78276_b("Orbital station ready", 10, 128, 65280);
                    } else {
                        this.field_146289_q.func_78276_b("Loading heightmap...", 10, 128, 65280);
                        this.field_146289_q.func_78276_b("Please wait", 10, 148, 65280);
                    }
                } else if (slotStack.func_77973_b() == ModItems.hard_drive) {
                    this.field_146289_q.func_78276_b("Select body", 10, 128, 65280);
                    this.field_146289_q.func_78276_b("Drag map to pan", 10, 148, 65280);
                }
            }
        }
    }

    private String landingInfo(int x, int z) {
        if (this.star.heightmap == null) {
            return "No heightmap";
        }
        if (x < 3 || x > 252 || z < 3 || z > 252) {
            return "Outside bounds";
        }
        for (int ox = x - 2; ox <= x + 2; ++ox) {
            for (int oz = z - 2; oz <= z + 2; ++oz) {
                if (this.star.heightmap[256 * oz + ox] == this.star.heightmap[256 * z + x]) continue;
                return "Area not flat";
            }
        }
        return null;
    }

    private int altitude(int x, int z) {
        if (this.star.heightmap == null) {
            return -1;
        }
        if (x < 0 || x > 255 || z < 0 || z > 255) {
            return -1;
        }
        return this.star.heightmap[256 * z + x];
    }

    public void func_146274_d() {
        super.func_146274_d();
        int button = Mouse.getEventButton();
        if (this.starX > 256.0f) {
            this.velocityX = 0.0f;
            this.starX = 256.0f;
        }
        if (this.starX < -98.0f) {
            this.velocityX = 0.0f;
            this.starX = -98.0f;
        }
        if (this.starY < -148.0f) {
            this.velocityY = 0.0f;
            this.starY = -148.0f;
        }
        if (this.starY > 256.0f) {
            this.velocityY = 0.0f;
            this.starY = 256.0f;
        }
        if (this.dragging && button == 0 && !Mouse.getEventButtonState()) {
            this.velocityX = (float)(this.mX - this.lX) * 0.8f;
            this.velocityY = (float)(this.mY - this.lY) * 0.8f;
            this.dragging = false;
        }
    }

    protected void func_146273_a(int x, int y, int p_146273_3_, long p_146273_4_) {
        super.func_146273_a(x, y, p_146273_3_, p_146273_4_);
        if (!this.dragging) {
            return;
        }
        int deltaX = x - this.mX;
        int deltaY = y - this.mY;
        this.starX += (float)deltaX;
        this.starY += (float)deltaY;
        this.lX = this.mX;
        this.lY = this.mY;
        this.mX = x;
        this.mY = y;
    }

    protected void func_73864_a(int x, int y, int i) {
        NBTTagCompound data;
        super.func_73864_a(x, y, i);
        if (this.checkClick(x, y, 9, 9, 158, 108)) {
            this.dragging = true;
            this.mX = this.lX = x;
            this.sX = this.lX;
            this.mY = this.lY = y;
            this.sY = this.lY;
        } else {
            this.dragging = false;
        }
        if (this.checkClick(x, y, 129, 143, 18, 18)) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            data = new NBTTagCompound();
            data.func_74768_a("pid", SpaceConfig.orbitDimension);
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.star.field_145851_c, this.star.field_145848_d, this.star.field_145849_e));
        }
        if (this.checkClick(x, y, 129, 123, 18, 18)) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            data = new NBTTagCompound();
            data.func_74757_a("radarmode", true);
            if (this.star.radarMode) {
                data.func_74757_a("radarmode", false);
            }
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.star.field_145851_c, this.star.field_145848_d, this.star.field_145849_e));
        }
        if (this.checkClick(x, y, 149, 143, 18, 18)) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            data = new NBTTagCompound();
            data.func_74768_a("pid", this.star.func_145831_w().field_73011_w.field_76574_g);
            data.func_74768_a("ix", this.star.field_145851_c);
            data.func_74768_a("iz", this.star.field_145849_e);
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.star.field_145851_c, this.star.field_145848_d, this.star.field_145849_e));
        }
    }

    protected void func_146286_b(int x, int y, int which) {
        super.func_146286_b(x, y, which);
        if (which == -1 || which == 1) {
            return;
        }
        if (Math.abs(this.sX - x) > 2 || Math.abs(this.sY - y) > 2) {
            return;
        }
        if (this.checkClick(x, y, 9, 9, 158, 108)) {
            if (this.star.heightmap == null) {
                for (POI poi : this.pList) {
                    int poiX = (int)(this.starX + (float)poi.offsetX);
                    int poiY = (int)(this.starY + (float)poi.offsetY);
                    if (!this.checkClick(x, y, poiX - 2, poiY - 2, 12, 12)) continue;
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74768_a("pid", poi.body.dimensionId);
                    PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.star.field_145851_c, this.star.field_145848_d, this.star.field_145849_e));
                    break;
                }
            } else {
                boolean canLand;
                int hx = (x - (int)this.starX - this.field_147003_i - 9 + 256) / 2;
                int hz = (y - (int)this.starY - this.field_147009_r - 9 + 256) / 2;
                boolean bl = canLand = this.landingInfo(hx, hz) == null;
                if (canLand) {
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74768_a("px", hx);
                    data.func_74768_a("pz", hz);
                    PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.star.field_145851_c, this.star.field_145848_d, this.star.field_145849_e));
                }
            }
        }
    }

    public static class POI {
        int offsetX;
        int offsetY;
        CelestialBody body;

        public POI(int offsetX, int offsetY, CelestialBody body) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.body = body;
        }
    }
}

