/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import com.hbm.dim.CelestialBody;
import com.hbm.inventory.gui.GUITransporterLinker;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TransporterLinkerPacket;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.machine.TileEntityTransporterBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.CompatExternal;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ItemTransporterLinker
extends Item
implements IGUIProvider {
    @SideOnly(value=Side.CLIENT)
    public static List<TransporterInfo> currentTransporters;
    private TransporterInfo lastTransporter;

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean bool) {
        list.add("Sneak-click to save transporter");
        list.add("Use on transporter to link to a saved transporter");
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float fx, float fy, float fz) {
        TileEntity tile = CompatExternal.getCoreFromPos(world, x, y, z);
        if (!(tile instanceof TileEntityTransporterBase)) {
            return false;
        }
        TileEntityTransporterBase transporter = (TileEntityTransporterBase)tile;
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                this.addTransporter(stack, world, transporter);
                player.func_145747_a((IChatComponent)new ChatComponentText("Added transporter to linker"));
            }
        } else if (world.field_72995_K) {
            this.lastTransporter = TransporterInfo.from(world.field_73011_w.field_76574_g, transporter);
            player.openGui((Object)MainRegistry.instance, 0, world, 0, 0, 0);
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int i, boolean b) {
        if (world.field_72995_K || !(entity instanceof EntityPlayerMP)) {
            return;
        }
        if (((EntityPlayerMP)entity).func_70694_bm() != stack) {
            return;
        }
        List<TransporterInfo> transporters = this.getTransporters(stack);
        if (entity.field_70173_aa % 2 == 0) {
            PacketDispatcher.wrapper.sendTo(new TransporterLinkerPacket(transporters), (EntityPlayerMP)entity);
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        return stack;
    }

    @Override
    public Container provideContainer(int i, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int i, EntityPlayer player, World world, int x, int y, int z) {
        return new GUITransporterLinker(player, currentTransporters, this.lastTransporter);
    }

    private void addTransporter(ItemStack stack, World world, TileEntityTransporterBase transporter) {
        int dimensionId = world.field_73011_w.field_76574_g;
        Set<TransporterInfo> transporters = ItemTransporterLinker.loadTransporters(stack);
        transporters.add(TransporterInfo.from(dimensionId, transporter));
        ItemTransporterLinker.saveTransporters(stack, transporters);
    }

    private List<TransporterInfo> getTransporters(ItemStack stack) {
        ArrayList<TransporterInfo> transporters = new ArrayList<TransporterInfo>();
        Set<TransporterInfo> transporterData = ItemTransporterLinker.loadTransporters(stack);
        transporters.addAll(transporterData);
        return transporters;
    }

    private static Set<TransporterInfo> loadTransporters(ItemStack stack) {
        int[] dimensionsToLoad;
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        HashSet<TransporterInfo> transporterCoordinates = new HashSet<TransporterInfo>();
        for (int dimensionId : dimensionsToLoad = stack.field_77990_d.func_74759_k("dimensions")) {
            NBTTagCompound dimensionTag = stack.field_77990_d.func_74775_l("d" + dimensionId);
            int[] coordinateList = dimensionTag.func_74759_k("coords");
            WorldServer world = DimensionManager.getWorld((int)dimensionId);
            if (world == null) continue;
            for (int i = 0; i < coordinateList.length; i += 3) {
                TileEntity te = world.func_147438_o(coordinateList[i], coordinateList[i + 1], coordinateList[i + 2]);
                if (!(te instanceof TileEntityTransporterBase)) continue;
                transporterCoordinates.add(TransporterInfo.from(dimensionId, (TileEntityTransporterBase)te));
            }
        }
        return transporterCoordinates;
    }

    private static void saveTransporters(ItemStack stack, Set<TransporterInfo> transporters) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        HashMap data = new HashMap();
        for (TransporterInfo transporterInfo : transporters) {
            if (!data.containsKey(transporterInfo.dimensionId)) {
                data.put(transporterInfo.dimensionId, new ArrayList());
            }
            ((List)data.get(transporterInfo.dimensionId)).addAll(Arrays.asList(transporterInfo.x, transporterInfo.y, transporterInfo.z));
        }
        stack.field_77990_d.func_74783_a("dimensions", BobMathUtil.intCollectionToArray(data.keySet()));
        for (Map.Entry entry : data.entrySet()) {
            NBTTagCompound dimensionTag = new NBTTagCompound();
            dimensionTag.func_74783_a("coords", BobMathUtil.intCollectionToArray((Collection)entry.getValue()));
            stack.field_77990_d.func_74782_a("d" + entry.getKey(), (NBTBase)dimensionTag);
        }
    }

    public static class TransporterInfo {
        public String name;
        public ResourceLocation planet;
        public TransporterInfo linkedTo;
        public int dimensionId;
        public int x;
        public int y;
        public int z;

        public TransporterInfo(String name, int dimensionId, int x, int y, int z) {
            this.name = name;
            this.dimensionId = dimensionId;
            this.x = x;
            this.y = y;
            this.z = z;
            this.planet = CelestialBody.getBody((int)dimensionId).texture;
        }

        public static TransporterInfo from(int dimensionId, TileEntityTransporterBase transporter) {
            TransporterInfo info = new TransporterInfo(transporter.getTransporterName(), dimensionId, transporter.field_145851_c, transporter.field_145848_d, transporter.field_145849_e);
            info.linkedTo = transporter.getLinkedTransporter();
            return info;
        }

        public void writeToNBT(NBTTagCompound nbt) {
            this.writeToNBT(nbt, true);
        }

        private void writeToNBT(NBTTagCompound nbt, boolean recurse) {
            nbt.func_74778_a("name", this.name);
            nbt.func_74768_a("dimensionId", this.dimensionId);
            nbt.func_74768_a("x", this.x);
            nbt.func_74768_a("y", this.y);
            nbt.func_74768_a("z", this.z);
            if (recurse && this.linkedTo != null) {
                NBTTagCompound linked = new NBTTagCompound();
                this.linkedTo.writeToNBT(linked, false);
                nbt.func_74782_a("linked", (NBTBase)linked);
            }
        }

        public static TransporterInfo readFromNBT(NBTTagCompound nbt) {
            TransporterInfo info = new TransporterInfo(nbt.func_74779_i("name"), nbt.func_74762_e("dimensionId"), nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
            if (nbt.func_74764_b("linked")) {
                info.linkedTo = TransporterInfo.readFromNBT(nbt.func_74775_l("linked"));
            }
            return info;
        }

        public int hashCode() {
            return Objects.hash(this.dimensionId, this.x, this.y, this.z);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            TransporterInfo info = (TransporterInfo)other;
            return this.dimensionId == info.dimensionId && this.x == info.x && this.y == info.y && this.z == info.z;
        }
    }
}

