/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.entity.missile.EntityMissileCustom;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemLootCrate;
import com.hbm.main.MainRegistry;
import com.hbm.util.i18n.I18nUtil;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class ItemCustomMissilePart
extends Item {
    public PartType type;
    public PartSize top;
    public PartSize bottom;
    public Rarity rarity;
    public float health;
    public int mass = 0;
    private String title;
    private String author;
    private String witty;
    public static HashMap<Integer, ItemCustomMissilePart> parts = new HashMap();
    public Object[] attributes;

    public ItemCustomMissilePart() {
        this.func_77637_a(MainRegistry.missileTab);
    }

    public ItemCustomMissilePart makeChip(float inaccuracy) {
        this.type = PartType.CHIP;
        this.top = PartSize.ANY;
        this.bottom = PartSize.ANY;
        this.attributes = new Object[]{Float.valueOf(inaccuracy)};
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemCustomMissilePart makeWarhead(WarheadType type, float punch, int mass, PartSize size) {
        this.type = PartType.WARHEAD;
        this.top = PartSize.NONE;
        this.bottom = size;
        this.mass = mass;
        this.attributes = new Object[]{type, Float.valueOf(punch)};
        this.func_111206_d("hbm:mp_warhead");
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemCustomMissilePart makeFuselage(FuelType type, int fuel, int mass, PartSize top, PartSize bottom) {
        this.type = PartType.FUSELAGE;
        this.top = top;
        this.bottom = bottom;
        this.mass = mass;
        this.attributes = new Object[]{type, fuel};
        this.func_111206_d("hbm:mp_fuselage");
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemCustomMissilePart makeStability(float inaccuracy, PartSize size) {
        this.type = PartType.FINS;
        this.top = size;
        this.bottom = size;
        this.attributes = new Object[]{Float.valueOf(inaccuracy)};
        this.func_111206_d("hbm:mp_stability");
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemCustomMissilePart makeThruster(FuelType type, float consumption, float lift, PartSize size, int thrust, int mass, int isp) {
        this.type = PartType.THRUSTER;
        this.top = size;
        this.bottom = PartSize.NONE;
        this.mass = mass;
        this.attributes = new Object[]{type, Float.valueOf(consumption), Float.valueOf(lift), thrust, isp};
        this.func_111206_d("hbm:mp_thruster");
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (this == ModItems.rp_pod_20) {
            return;
        }
        if (this.title != null) {
            list.add(EnumChatFormatting.DARK_PURPLE + "\"" + this.title + "\"");
        }
        try {
            switch (this.type) {
                case CHIP: {
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.inaccuracy", new Object[0]) + ": " + EnumChatFormatting.GRAY + ((Float)this.attributes[0]).floatValue() * 100.0f + "%");
                    break;
                }
                case WARHEAD: {
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.size", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getSize(this.bottom));
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.type", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getWarhead());
                    if (this.attributes[0] != WarheadType.APOLLO && this.attributes[0] != WarheadType.SATELLITE) {
                        list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.strength", new Object[0]) + ": " + EnumChatFormatting.GRAY + (Float)this.attributes[1]);
                    }
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.mass", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.mass + "kg");
                    break;
                }
                case FUSELAGE: {
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.topSize", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getSize(this.top));
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.bottomSize", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getSize(this.bottom));
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.fuelType", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getFuelName());
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.fuelAmount", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getTankSize() + "mB");
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.mass", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.mass + "kg");
                    break;
                }
                case FINS: {
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.size", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getSize(this.top));
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.inaccuracy", new Object[0]) + ": " + EnumChatFormatting.GRAY + ((Float)this.attributes[0]).floatValue() * 100.0f + "%");
                    break;
                }
                case THRUSTER: {
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.size", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getSize(this.top));
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.fuelType", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.getFuelName());
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.fuelConsumption", new Object[0]) + ": " + EnumChatFormatting.GRAY + (Float)this.attributes[1] + "l/tick");
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.maxPayload", new Object[0]) + ": " + EnumChatFormatting.GRAY + (Float)this.attributes[2] + "kg");
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.thrust", new Object[0]) + ": " + EnumChatFormatting.GRAY + (Integer)this.attributes[3] + "N");
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.isp", new Object[0]) + ": " + EnumChatFormatting.GRAY + (Integer)this.attributes[4] + "s");
                    list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.mass", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.mass + "kg");
                }
            }
        }
        catch (Exception ex) {
            list.add(I18nUtil.resolveKey("error.generic", new Object[0]));
        }
        if (this.rarity != null) {
            list.add(EnumChatFormatting.BOLD + I18nUtil.resolveKey("item.missile.part.rarity", new Object[0]) + ": " + EnumChatFormatting.GRAY + this.rarity.getDisplay());
        }
        if (this.author != null) {
            list.add(EnumChatFormatting.WHITE + "   " + I18nUtil.resolveKey("item.missile.part.by", new Object[0]) + " " + this.author);
        }
        if (this.witty != null) {
            list.add(EnumChatFormatting.GOLD + "   " + EnumChatFormatting.ITALIC + "\"" + this.witty + "\"");
        }
    }

    public String getSize(PartSize size) {
        switch (size) {
            case ANY: {
                return I18nUtil.resolveKey("item.missile.part.size.any", new Object[0]);
            }
            case SIZE_10: {
                return "1.0m";
            }
            case SIZE_15: {
                return "1.5m";
            }
            case SIZE_20: {
                return "2.0m";
            }
        }
        return I18nUtil.resolveKey("item.missile.part.size.none", new Object[0]);
    }

    public String getWarhead() {
        if (!(this.attributes[0] instanceof WarheadType)) {
            return EnumChatFormatting.BOLD + I18nUtil.resolveKey("general.na", new Object[0]);
        }
        WarheadType type = (WarheadType)((Object)this.attributes[0]);
        if (type.labelCustom != null) {
            return type.labelCustom;
        }
        switch (type) {
            case HE: {
                return EnumChatFormatting.YELLOW + I18nUtil.resolveKey(WarheadType.HE.unlocalizedName, new Object[0]);
            }
            case INC: {
                return EnumChatFormatting.GOLD + I18nUtil.resolveKey(WarheadType.INC.unlocalizedName, new Object[0]);
            }
            case CLUSTER: {
                return EnumChatFormatting.GRAY + I18nUtil.resolveKey(WarheadType.CLUSTER.unlocalizedName, new Object[0]);
            }
            case BUSTER: {
                return EnumChatFormatting.WHITE + I18nUtil.resolveKey(WarheadType.BUSTER.unlocalizedName, new Object[0]);
            }
            case NUCLEAR: {
                return EnumChatFormatting.DARK_GREEN + I18nUtil.resolveKey(WarheadType.NUCLEAR.unlocalizedName, new Object[0]);
            }
            case TX: {
                return EnumChatFormatting.DARK_PURPLE + I18nUtil.resolveKey(WarheadType.TX.unlocalizedName, new Object[0]);
            }
            case N2: {
                return EnumChatFormatting.RED + I18nUtil.resolveKey(WarheadType.N2.unlocalizedName, new Object[0]);
            }
            case BALEFIRE: {
                return EnumChatFormatting.GREEN + I18nUtil.resolveKey(WarheadType.BALEFIRE.unlocalizedName, new Object[0]);
            }
            case SCHRAB: {
                return EnumChatFormatting.AQUA + I18nUtil.resolveKey(WarheadType.SCHRAB.unlocalizedName, new Object[0]);
            }
            case TAINT: {
                return EnumChatFormatting.DARK_PURPLE + I18nUtil.resolveKey(WarheadType.TAINT.unlocalizedName, new Object[0]);
            }
            case CLOUD: {
                return EnumChatFormatting.LIGHT_PURPLE + I18nUtil.resolveKey(WarheadType.CLOUD.unlocalizedName, new Object[0]);
            }
            case TURBINE: {
                return (System.currentTimeMillis() % 1000L < 500L ? EnumChatFormatting.RED : EnumChatFormatting.LIGHT_PURPLE) + I18nUtil.resolveKey(WarheadType.TURBINE.unlocalizedName, new Object[0]);
            }
            case APOLLO: {
                return (System.currentTimeMillis() % 1000L < 500L ? EnumChatFormatting.GOLD : EnumChatFormatting.RED) + I18nUtil.resolveKey(WarheadType.APOLLO.unlocalizedName, new Object[0]);
            }
            case SATELLITE: {
                return (System.currentTimeMillis() % 1000L < 500L ? EnumChatFormatting.GOLD : EnumChatFormatting.RED) + I18nUtil.resolveKey(WarheadType.SATELLITE.unlocalizedName, new Object[0]);
            }
        }
        return EnumChatFormatting.BOLD + I18nUtil.resolveKey("general.na", new Object[0]);
    }

    public String getFuelName() {
        if (!(this.attributes[0] instanceof FuelType)) {
            return EnumChatFormatting.BOLD + I18nUtil.resolveKey("general.na", new Object[0]);
        }
        switch ((FuelType)((Object)this.attributes[0])) {
            case ANY: {
                return EnumChatFormatting.GRAY + I18nUtil.resolveKey(FuelType.ANY.unlocalizedName, new Object[0]);
            }
            case KEROSENE: {
                return EnumChatFormatting.LIGHT_PURPLE + I18nUtil.resolveKey(FuelType.KEROSENE.unlocalizedName, new Object[0]);
            }
            case METHALOX: {
                return EnumChatFormatting.YELLOW + I18nUtil.resolveKey(FuelType.METHALOX.unlocalizedName, new Object[0]);
            }
            case KEROLOX: {
                return EnumChatFormatting.LIGHT_PURPLE + I18nUtil.resolveKey(FuelType.KEROLOX.unlocalizedName, new Object[0]);
            }
            case SOLID: {
                return EnumChatFormatting.GOLD + I18nUtil.resolveKey(FuelType.SOLID.unlocalizedName, new Object[0]);
            }
            case HYDROGEN: {
                return EnumChatFormatting.DARK_AQUA + I18nUtil.resolveKey(FuelType.HYDROGEN.unlocalizedName, new Object[0]);
            }
            case XENON: {
                return EnumChatFormatting.DARK_PURPLE + I18nUtil.resolveKey(FuelType.XENON.unlocalizedName, new Object[0]);
            }
            case BALEFIRE: {
                return EnumChatFormatting.GREEN + I18nUtil.resolveKey(FuelType.BALEFIRE.unlocalizedName, new Object[0]);
            }
            case HYDRAZINE: {
                return EnumChatFormatting.AQUA + I18nUtil.resolveKey(FuelType.HYDRAZINE.unlocalizedName, new Object[0]);
            }
        }
        return EnumChatFormatting.BOLD + I18nUtil.resolveKey("general.na", new Object[0]);
    }

    public FluidType getFuel() {
        if (!(this.attributes[0] instanceof FuelType)) {
            return null;
        }
        switch ((FuelType)((Object)this.attributes[0])) {
            case KEROSENE: {
                return Fluids.KEROSENE;
            }
            case KEROLOX: {
                return Fluids.KEROSENE;
            }
            case METHALOX: {
                return Fluids.GAS;
            }
            case HYDROGEN: {
                return Fluids.HYDROGEN;
            }
            case XENON: {
                return Fluids.XENON;
            }
            case BALEFIRE: {
                return Fluids.BALEFIRE;
            }
            case HYDRAZINE: {
                return Fluids.HYDRAZINE;
            }
            case SOLID: {
                return Fluids.NONE;
            }
        }
        return null;
    }

    public FluidType getOxidizer() {
        if (!(this.attributes[0] instanceof FuelType)) {
            return null;
        }
        switch ((FuelType)((Object)this.attributes[0])) {
            case METHALOX: 
            case KEROLOX: 
            case HYDROGEN: {
                return Fluids.OXYGEN;
            }
            case KEROSENE: 
            case BALEFIRE: {
                return Fluids.PEROXIDE;
            }
        }
        return null;
    }

    public int getThrust() {
        if (this.type != PartType.THRUSTER) {
            return 0;
        }
        if (this.attributes[3] == null || !(this.attributes[3] instanceof Integer)) {
            return 0;
        }
        return (Integer)this.attributes[3];
    }

    public int getISP() {
        if (this.type != PartType.THRUSTER) {
            return 0;
        }
        if (this.attributes[4] == null || !(this.attributes[4] instanceof Integer)) {
            return 0;
        }
        return (Integer)this.attributes[4];
    }

    public int getTankSize() {
        if (this.type != PartType.FUSELAGE) {
            return 0;
        }
        if (!(this.attributes[1] instanceof Integer)) {
            return 0;
        }
        return (Integer)this.attributes[1];
    }

    public ItemCustomMissilePart copy() {
        ItemCustomMissilePart part = new ItemCustomMissilePart();
        part.type = this.type;
        part.top = this.top;
        part.bottom = this.bottom;
        part.health = this.health;
        part.attributes = this.attributes;
        part.health = this.health;
        part.mass = this.mass;
        part.func_111206_d(this.field_111218_cA);
        return part;
    }

    public ItemCustomMissilePart setAuthor(String author) {
        this.author = author;
        return this;
    }

    public ItemCustomMissilePart setTitle(String title) {
        this.title = title;
        return this;
    }

    public ItemCustomMissilePart setWittyText(String witty) {
        this.witty = witty;
        return this;
    }

    public ItemCustomMissilePart setHealth(float health) {
        this.health = health;
        return this;
    }

    public ItemCustomMissilePart setRarity(Rarity rarity) {
        this.rarity = rarity;
        if (this.type == PartType.FUSELAGE) {
            if (this.top == PartSize.SIZE_10) {
                ItemLootCrate.list10.add(this);
            }
            if (this.top == PartSize.SIZE_15) {
                ItemLootCrate.list15.add(this);
            }
        } else {
            ItemLootCrate.listMisc.add(this);
        }
        return this;
    }

    public static enum Rarity {
        COMMON("item.missile.part.rarity.common", EnumChatFormatting.GRAY),
        UNCOMMON("item.missile.part.rarity.uncommon", EnumChatFormatting.YELLOW),
        RARE("item.missile.part.rarity.rare", EnumChatFormatting.AQUA),
        EPIC("item.missile.part.rarity.epic", EnumChatFormatting.LIGHT_PURPLE),
        LEGENDARY("item.missile.part.rarity.legendary", EnumChatFormatting.DARK_GREEN),
        SEWS_CLOTHES_AND_SUCKS_HORSE_COCK("item.missile.part.rarity.strange", EnumChatFormatting.DARK_AQUA);

        private final String key;
        private final EnumChatFormatting color;

        private Rarity(String key, EnumChatFormatting color) {
            this.key = key;
            this.color = color;
        }

        public String getDisplay() {
            return this.color + I18nUtil.resolveKey(this.key, new Object[0]);
        }
    }

    public static enum FuelType {
        ANY("item.custom_missile_part.fuel.any"),
        KEROSENE("item.custom_missile_part.fuel.kerosene"),
        SOLID("item.custom_missile_part.fuel.solid"),
        HYDROGEN("item.custom_missile_part.fuel.hydrogen"),
        XENON("item.custom_missile_part.fuel.xenon"),
        BALEFIRE("item.custom_missile_part.fuel.balefire"),
        HYDRAZINE("item.custom_missile_part.fuel.hydrazine"),
        METHALOX("item.custom_missile_part.fuel.methalox"),
        KEROLOX("item.custom_missile_part.fuel.kerolox");

        public final String unlocalizedName;

        private FuelType(String unlocalizedName) {
            this.unlocalizedName = unlocalizedName;
        }
    }

    public static enum WarheadType {
        HE("item.warhead.desc.he"),
        INC("item.warhead.desc.incendiary"),
        BUSTER("item.warhead.desc.bunker_buster"),
        CLUSTER("item.warhead.desc.cluster"),
        NUCLEAR("item.warhead.desc.nuclear"),
        TX("item.warhead.desc.thermonuclear"),
        N2("item.warhead.desc.n2"),
        BALEFIRE("item.warhead.desc.balefire"),
        SCHRAB("item.warhead.desc.schrab"),
        TAINT("item.warhead.desc.taint"),
        CLOUD("item.warhead.desc.cloud"),
        TURBINE("item.warhead.desc.turbine"),
        APOLLO("item.warhead.desc.apollo"),
        SATELLITE("item.warhead.desc.satellite"),
        CUSTOM0("item.warhead.custom0"),
        CUSTOM1("item.warhead.custom1"),
        CUSTOM2("item.warhead.custom2"),
        CUSTOM3("item.warhead.custom3"),
        CUSTOM4("item.warhead.custom4"),
        CUSTOM5("item.warhead.custom5"),
        CUSTOM6("item.warhead.custom6"),
        CUSTOM7("item.warhead.custom7"),
        CUSTOM8("item.warhead.custom8"),
        CUSTOM9("item.warhead.custom9");

        public final String unlocalizedName;
        public Consumer<EntityMissileCustom> impactCustom = null;
        public Consumer<EntityMissileCustom> updateCustom = null;
        public String labelCustom = null;

        private WarheadType(String unlocalizedName) {
            this.unlocalizedName = unlocalizedName;
        }
    }

    public static enum PartSize {
        ANY,
        NONE,
        SIZE_10(1.0),
        SIZE_15(1.5),
        SIZE_20(2.0),
        SIZE_25(2.5),
        SIZE_30(3.0);

        public double radius;

        private PartSize() {
            this.radius = 0.0;
        }

        private PartSize(double radius) {
            this.radius = radius;
        }
    }

    public static enum PartType {
        CHIP,
        WARHEAD,
        FUSELAGE,
        FINS,
        THRUSTER;

    }
}

