/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.lib;

import com.hbm.blocks.BlockEnums;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockNTMFlower;
import com.hbm.config.GeneralConfig;
import com.hbm.config.MobConfig;
import com.hbm.config.WorldConfig;
import com.hbm.dim.WorldProviderCelestial;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.itempool.ItemPool;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.saveddata.TomSaveData;
import com.hbm.tileentity.bomb.TileEntityLandmine;
import com.hbm.tileentity.deco.TileEntityLanternBehemoth;
import com.hbm.tileentity.machine.storage.TileEntitySafe;
import com.hbm.tileentity.machine.storage.TileEntitySoyuzCapsule;
import com.hbm.util.Compat;
import com.hbm.util.LootGenerator;
import com.hbm.util.WeightedRandomGeneric;
import com.hbm.world.dungeon.AncientTomb;
import com.hbm.world.dungeon.Antenna;
import com.hbm.world.dungeon.ArcticVault;
import com.hbm.world.dungeon.Barrel;
import com.hbm.world.dungeon.DesertAtom001;
import com.hbm.world.dungeon.LibraryDungeon;
import com.hbm.world.dungeon.Relay;
import com.hbm.world.dungeon.Spaceship;
import com.hbm.world.feature.BedrockOre;
import com.hbm.world.feature.DepthDeposit;
import com.hbm.world.feature.Dud;
import com.hbm.world.feature.Geyser;
import com.hbm.world.feature.GeyserLarge;
import com.hbm.world.feature.GlyphidHive;
import com.hbm.world.feature.Meteorite;
import com.hbm.world.gen.MapGenChainloader;
import com.hbm.world.generator.CellularDungeonFactory;
import com.hbm.world.generator.DungeonToolbox;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenBeach;
import net.minecraft.world.biome.BiomeGenForest;
import net.minecraft.world.biome.BiomeGenJungle;
import net.minecraft.world.biome.BiomeGenPlains;
import net.minecraft.world.biome.BiomeGenRiver;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.util.ForgeDirection;

public class HbmWorldGen
implements IWorldGenerator {
    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == 0) {
            MapGenChainloader.repairBadGeneration(world, chunkX, chunkZ);
        }
        if (world.field_73011_w instanceof WorldProviderCelestial) {
            this.generateSurface(world, rand, chunkX * 16, chunkZ * 16);
            return;
        }
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                this.generateNether(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.generateSurface(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                this.generateEnd(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            default: {
                if (!GeneralConfig.enableMDOres) break;
                this.generateSurface(world, rand, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateSurface(World world, Random rand, int i, int j) {
        int z;
        int x;
        int k;
        int z2;
        int x2;
        int y;
        if (world.field_73011_w instanceof WorldProviderHell || world.field_73011_w instanceof WorldProviderEnd) {
            return;
        }
        BiomeGenBase biome = world.func_72959_q().func_76935_a(i, j);
        if (WorldConfig.meteoriteSpawn > 0 && rand.nextInt(WorldConfig.meteoriteSpawn) == 0 && (y = world.func_72976_f(x2 = i + rand.nextInt(16) + 8, z2 = j + rand.nextInt(16) + 8) - rand.nextInt(10)) > 1) {
            new Meteorite().generate(world, rand, x2, y, z2, false, false, false);
        }
        if (WorldConfig.spaceshipStructure > 0 && rand.nextInt(WorldConfig.spaceshipStructure) == 0) {
            x2 = i + rand.nextInt(16);
            z2 = j + rand.nextInt(16);
            y = world.func_72976_f(x2, z2);
            new Spaceship().func_76484_a(world, rand, x2, y, z2);
        }
        if (world.field_73011_w instanceof WorldProviderCelestial && world.field_73011_w.field_76574_g != 0) {
            return;
        }
        if (!TomSaveData.forWorld((World)world).impact) {
            if (biome instanceof BiomeGenForest && rand.nextInt(16) == 0) {
                DungeonToolbox.generateFlowers(world, rand, i, j, ModBlocks.plant_flower, BlockNTMFlower.EnumFlowerType.FOXGLOVE.ordinal());
            }
            if (biome == BiomeGenBase.field_150585_R && rand.nextInt(8) == 0) {
                DungeonToolbox.generateFlowers(world, rand, i, j, ModBlocks.plant_flower, BlockNTMFlower.EnumFlowerType.NIGHTSHADE.ordinal());
            }
            if (biome instanceof BiomeGenJungle && rand.nextInt(8) == 0) {
                DungeonToolbox.generateFlowers(world, rand, i, j, ModBlocks.plant_flower, BlockNTMFlower.EnumFlowerType.TOBACCO.ordinal());
            }
            if (rand.nextInt(64) == 0) {
                DungeonToolbox.generateFlowers(world, rand, i, j, ModBlocks.plant_flower, BlockNTMFlower.EnumFlowerType.WEED.ordinal());
            }
            if (biome instanceof BiomeGenPlains && rand.nextInt(32) == 0) {
                DungeonToolbox.generateFlowers(world, rand, i, j, ModBlocks.plant_flower, BlockNTMFlower.EnumFlowerType.STRAWBERRY.ordinal());
            }
            if (biome instanceof BiomeGenPlains && rand.nextInt(32) == 0) {
                DungeonToolbox.generateFlowers(world, rand, i, j, ModBlocks.plant_flower, BlockNTMFlower.EnumFlowerType.MINT.ordinal());
            }
            if (biome instanceof BiomeGenRiver && rand.nextInt(4) == 0) {
                DungeonToolbox.generateFlowers(world, rand, i, j, ModBlocks.reeds, 0);
            }
            if (biome instanceof BiomeGenBeach && rand.nextInt(8) == 0) {
                DungeonToolbox.generateFlowers(world, rand, i, j, ModBlocks.reeds, 0);
            }
        }
        if (WorldConfig.gasbubbleSpawn > 0 && rand.nextInt(WorldConfig.gasbubbleSpawn) == 0) {
            DungeonToolbox.generateOre(world, rand, i, j, 1, 32, 30, 10, ModBlocks.gas_flammable, 1);
        }
        if (WorldConfig.explosivebubbleSpawn > 0 && rand.nextInt(WorldConfig.explosivebubbleSpawn) == 0) {
            DungeonToolbox.generateOre(world, rand, i, j, 1, 32, 30, 10, ModBlocks.gas_explosive, 1);
        }
        if (WorldConfig.alexandriteSpawn > 0 && rand.nextInt(WorldConfig.alexandriteSpawn) == 0) {
            DungeonToolbox.generateOre(world, rand, i, j, 1, 3, 10, 5, ModBlocks.ore_alexandrite);
        }
        if (WorldConfig.overworldOre) {
            DepthDeposit.generateConditionOverworld(world, i, 0, 3, j, 5, 0.6, ModBlocks.cluster_depth_iron, rand, 24);
            DepthDeposit.generateConditionOverworld(world, i, 0, 3, j, 5, 0.6, ModBlocks.cluster_depth_titanium, rand, 32);
            DepthDeposit.generateConditionOverworld(world, i, 0, 3, j, 5, 0.6, ModBlocks.cluster_depth_tungsten, rand, 32);
            DepthDeposit.generateConditionOverworld(world, i, 0, 3, j, 5, 0.8, ModBlocks.ore_depth_cinnebar, rand, 16);
            DepthDeposit.generateConditionOverworld(world, i, 0, 3, j, 5, 0.8, ModBlocks.ore_depth_zirconium, rand, 16);
            DepthDeposit.generateConditionOverworld(world, i, 0, 3, j, 5, 0.8, ModBlocks.ore_depth_borax, rand, 16);
            DungeonToolbox.generateOre(world, rand, i, j, 25, 6, 30, 10, ModBlocks.ore_gneiss_iron, ModBlocks.stone_gneiss);
            DungeonToolbox.generateOre(world, rand, i, j, 10, 6, 30, 10, ModBlocks.ore_gneiss_gold, ModBlocks.stone_gneiss);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.uraniumSpawn * 3, 6, 30, 10, ModBlocks.ore_gneiss_uranium, ModBlocks.stone_gneiss);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.copperSpawn * 3, 6, 30, 10, ModBlocks.ore_gneiss_copper, ModBlocks.stone_gneiss);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.asbestosSpawn * 3, 6, 30, 10, ModBlocks.ore_gneiss_asbestos, ModBlocks.stone_gneiss);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.rareSpawn, 6, 30, 10, ModBlocks.ore_gneiss_rare, ModBlocks.stone_gneiss);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.gassshaleSpawn * 3, 10, 30, 10, ModBlocks.ore_gneiss_gas, ModBlocks.stone_gneiss);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.uraniumSpawn, 5, 5, 20, ModBlocks.ore_uranium);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.thoriumSpawn, 5, 5, 25, ModBlocks.ore_thorium);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.titaniumSpawn, 6, 5, 30, ModBlocks.ore_titanium);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.sulfurSpawn, 8, 5, 30, ModBlocks.ore_sulfur);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.aluminiumSpawn, 6, 5, 40, ModBlocks.ore_aluminium);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.copperSpawn, 6, 5, 45, ModBlocks.ore_copper);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.zincSpawn, 6, 5, 32, ModBlocks.ore_zinc);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.fluoriteSpawn, 4, 5, 45, ModBlocks.ore_fluorite);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.niterSpawn, 6, 5, 30, ModBlocks.ore_niter);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.tungstenSpawn, 8, 5, 30, ModBlocks.ore_tungsten);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.leadSpawn, 9, 5, 30, ModBlocks.ore_lead);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.berylliumSpawn, 4, 5, 30, ModBlocks.ore_beryllium);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.rareSpawn, 5, 5, 20, ModBlocks.ore_rare);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.ligniteSpawn, 24, 35, 25, ModBlocks.ore_lignite);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.asbestosSpawn, 4, 16, 16, ModBlocks.ore_asbestos);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.cinnebarSpawn, 4, 8, 16, ModBlocks.ore_cinnebar);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.cobaltSpawn, 4, 4, 8, ModBlocks.ore_cobalt);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.ironClusterSpawn, 6, 15, 45, ModBlocks.cluster_iron);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.titaniumClusterSpawn, 6, 15, 30, ModBlocks.cluster_titanium);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.aluminiumClusterSpawn, 6, 15, 35, ModBlocks.cluster_aluminium);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.copperClusterSpawn, 6, 15, 20, ModBlocks.cluster_copper);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.limestoneSpawn, 16, 25, 30, ModBlocks.stone_resource, BlockEnums.EnumStoneType.LIMESTONE.ordinal());
            if (WorldConfig.newBedrockOres) {
                if (rand.nextInt(10) == 0) {
                    int randPosX = i + rand.nextInt(2) + 8;
                    int randPosZ = j + rand.nextInt(2) + 8;
                    BedrockOre.generate(world, randPosX, randPosZ, new ItemStack(ModItems.bedrock_ore_base), null, 14125590, 1);
                }
            } else if (rand.nextInt(3) == 0) {
                WeightedRandomGeneric item = (WeightedRandomGeneric)WeightedRandom.func_76271_a((Random)rand, BedrockOre.weightedOres);
                BedrockOre.BedrockOreDefinition def = (BedrockOre.BedrockOreDefinition)item.get();
                int randPosX = i + rand.nextInt(2) + 8;
                int randPosZ = j + rand.nextInt(2) + 8;
                BedrockOre.generate(world, randPosX, randPosZ, def.stack, def.acid, def.color, def.tier);
            }
            if (GeneralConfig.enable528ColtanSpawn) {
                DungeonToolbox.generateOre(world, rand, i, j, GeneralConfig.coltanRate, 4, 15, 40, ModBlocks.ore_coltan);
            }
            Random colRand = new Random(world.func_72905_C() + 5L);
            int colX = (int)(colRand.nextGaussian() * 1500.0);
            int colZ = (int)(colRand.nextGaussian() * 1500.0);
            int colRange = 750;
            if (GeneralConfig.enable528ColtanDeposit) {
                for (k = 0; k < 2; ++k) {
                    for (int r = 1; r <= 5; ++r) {
                        int randPosX = i + rand.nextInt(16);
                        int randPosY = rand.nextInt(25) + 15;
                        int randPosZ = j + rand.nextInt(16);
                        int range = colRange / r;
                        if (randPosX > colX + range || randPosX < colX - range || randPosZ > colZ + range || randPosZ < colZ - range) continue;
                        new WorldGenMinable(ModBlocks.ore_coltan, 4).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
                    }
                }
            }
        }
        boolean enableDungeons = world.func_72912_H().func_76089_r();
        if (GeneralConfig.enableDungeons == 1) {
            enableDungeons = true;
        }
        if (GeneralConfig.enableDungeons == 0) {
            enableDungeons = false;
        }
        if (enableDungeons && world.field_73011_w.field_76574_g == 0) {
            int y2;
            int x3;
            int a;
            int y3;
            int z3;
            if (MobConfig.enableHives && rand.nextInt(MobConfig.hiveSpawn) == 0) {
                x = i + rand.nextInt(16) + 8;
                z3 = j + rand.nextInt(16) + 8;
                y3 = world.func_72976_f(x, z3);
                for (k = 3; k >= -1; --k) {
                    if (!world.func_147439_a(x, y3 - 1 + k, z3).func_149721_r()) continue;
                    GlyphidHive.generateSmall(world, x, y3 + k, z3, rand, rand.nextInt(10) == 0, true);
                    break;
                }
            }
            if (biome.field_76750_F >= 0.4f && biome.field_76751_G <= 0.6f && WorldConfig.antennaStructure > 0 && rand.nextInt(WorldConfig.antennaStructure) == 0) {
                for (a = 0; a < 1; ++a) {
                    x3 = i + rand.nextInt(16);
                    z = j + rand.nextInt(16);
                    y2 = world.func_72976_f(x3, z);
                    new Antenna().func_76484_a(world, rand, x3, y2, z);
                }
            }
            if (!biome.func_76738_d() && biome.field_76750_F >= 1.5f && WorldConfig.atomStructure > 0 && rand.nextInt(WorldConfig.atomStructure) == 0) {
                for (a = 0; a < 1; ++a) {
                    x3 = i + rand.nextInt(16);
                    z = j + rand.nextInt(16);
                    y2 = world.func_72976_f(x3, z);
                    new DesertAtom001().func_76484_a(world, rand, x3, y2, z);
                }
            }
            if (WorldConfig.dungeonStructure > 0 && rand.nextInt(WorldConfig.dungeonStructure) == 0) {
                x = i + rand.nextInt(16);
                y = rand.nextInt(256);
                z = j + rand.nextInt(16);
                new LibraryDungeon().func_76484_a(world, rand, x, y, z);
            }
            if ((biome.field_76750_F == 0.5f || biome.field_76750_F == 2.0f) && WorldConfig.relayStructure > 0 && rand.nextInt(WorldConfig.relayStructure) == 0) {
                for (a = 0; a < 1; ++a) {
                    x3 = i + rand.nextInt(16);
                    z = j + rand.nextInt(16);
                    y2 = world.func_72976_f(x3, z);
                    new Relay().func_76484_a(world, rand, x3, y2, z);
                }
            }
            if (WorldConfig.dudStructure > 0 && rand.nextInt(WorldConfig.dudStructure) == 0) {
                x = i + 8 + rand.nextInt(16);
                z3 = j + 8 + rand.nextInt(16);
                y3 = world.func_72976_f(x, z3);
                new Dud().func_76484_a(world, rand, x, y3, z3);
            }
            if (WorldConfig.barrelStructure > 0 && biome.field_76750_F >= 1.5f && !biome.func_76738_d() && rand.nextInt(WorldConfig.barrelStructure) == 0) {
                x = i + rand.nextInt(16);
                z3 = j + rand.nextInt(16);
                y3 = world.func_72976_f(x, z3);
                new Barrel().func_76484_a(world, rand, x, y3, z3);
            }
            if (WorldConfig.broadcaster > 0 && rand.nextInt(WorldConfig.broadcaster) == 0 && world.func_147439_a(x = i + rand.nextInt(16), (y3 = world.func_72976_f(x, z3 = j + rand.nextInt(16))) - 1, z3).canPlaceTorchOnTop(world, x, y3 - 1, z3)) {
                world.func_147465_d(x, y3, z3, ModBlocks.broadcaster_pc, rand.nextInt(4) + 2, 2);
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned corrupted broadcaster at " + x + " " + y3 + " " + z3);
                }
            }
            if (WorldConfig.minefreq > 0 && GeneralConfig.enableMines && rand.nextInt(WorldConfig.minefreq) == 0) {
                x = i + rand.nextInt(16) + 8;
                z3 = j + rand.nextInt(16) + 8;
                y3 = world.func_72976_f(x, z3);
                for (int g = y3 + 2; g >= y3; --g) {
                    if (!world.func_147439_a(x, g - 1, z3).canPlaceTorchOnTop(world, x, g - 1, z3)) continue;
                    world.func_147449_b(x, g, z3, ModBlocks.mine_ap);
                    TileEntity tile = world.func_147438_o(x, g, z3);
                    if (tile instanceof TileEntityLandmine) {
                        TileEntityLandmine landmine = (TileEntityLandmine)tile;
                        landmine.waitingForPlayer = true;
                    }
                    if (!GeneralConfig.enableDebugMode) break;
                    MainRegistry.logger.info("[Debug] Successfully spawned landmine at " + x + " " + g + " " + z3);
                    break;
                }
            }
            if (rand.nextInt(2000) == 0 && world.func_147439_a(x = i + rand.nextInt(16), (y3 = world.func_72976_f(x, z3 = j + rand.nextInt(16))) - 1, z3).canPlaceTorchOnTop(world, x, y3 - 1, z3) && world.func_147439_a(x, y3, z3).isReplaceable((IBlockAccess)world, x, y3, z3)) {
                world.func_147465_d(x, y3, z3, ModBlocks.lantern_behemoth, 12, 3);
                MultiblockHandlerXR.fillSpace(world, x, y3, z3, new int[]{4, 0, 0, 0, 0, 0}, ModBlocks.lantern_behemoth, ForgeDirection.NORTH);
                TileEntity tile = world.func_147438_o(x, y3, z3);
                if (tile instanceof TileEntityLanternBehemoth) {
                    TileEntityLanternBehemoth lantern = (TileEntityLanternBehemoth)tile;
                    lantern.isBroken = true;
                }
                if (rand.nextInt(2) == 0) {
                    LootGenerator.setBlock(world, x, y3, z3 - 2);
                    LootGenerator.lootBooklet(world, x, y3, z3 - 2);
                }
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned lantern at " + x + " " + y3 + " " + z3);
                }
            }
            if (GeneralConfig.enable528BosniaSimulator && rand.nextInt(16) == 0 && world.func_147439_a(x = i + rand.nextInt(16), (y3 = world.func_72976_f(x, z3 = j + rand.nextInt(16))) - 1, z3).canPlaceTorchOnTop(world, x, y3 - 1, z3)) {
                world.func_147449_b(x, y3, z3, ModBlocks.mine_he);
                TileEntity tile = world.func_147438_o(x, y3, z3);
                if (tile instanceof TileEntityLandmine) {
                    TileEntityLandmine landmine = (TileEntityLandmine)tile;
                    landmine.waitingForPlayer = true;
                }
            }
            if (WorldConfig.geyserChlorine > 0 && biome == BiomeGenBase.field_76772_c && rand.nextInt(WorldConfig.geyserWater) == 0 && world.func_147439_a(x = i + rand.nextInt(16), (y3 = world.func_72976_f(x, z3 = j + rand.nextInt(16))) - 1, z3) == Blocks.field_150349_c) {
                new Geyser().func_76484_a(world, rand, x, y3, z3);
            }
            if (WorldConfig.geyserWater > 0 && biome == BiomeGenBase.field_76769_d && rand.nextInt(WorldConfig.geyserChlorine) == 0 && world.func_147439_a(x = i + rand.nextInt(16), (y3 = world.func_72976_f(x, z3 = j + rand.nextInt(16))) - 1, z3) == Blocks.field_150354_m) {
                new GeyserLarge().func_76484_a(world, rand, x, y3, z3);
            }
            if (WorldConfig.capsuleStructure > 0 && biome == BiomeGenBase.field_76787_r && rand.nextInt(WorldConfig.capsuleStructure) == 0 && world.func_147439_a(x = i + rand.nextInt(16), (y3 = world.func_72976_f(x, z3 = j + rand.nextInt(16)) - 4) + 1, z3).canPlaceTorchOnTop(world, x, y3 + 1, z3)) {
                world.func_147465_d(x, y3, z3, ModBlocks.soyuz_capsule, 3, 2);
                TileEntity tile = world.func_147438_o(x, y3, z3);
                if (tile instanceof TileEntitySoyuzCapsule) {
                    TileEntitySoyuzCapsule cap = (TileEntitySoyuzCapsule)tile;
                    cap.func_70299_a(rand.nextInt(cap.func_70302_i_()), new ItemStack(ModItems.record_glass));
                }
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned capsule at " + x + " " + z3);
                }
            }
            if (WorldConfig.geyserVapor > 0 && rand.nextInt(WorldConfig.geyserVapor) == 0) {
                x = i + rand.nextInt(16);
                if (world.func_147439_a(x, y3 = world.func_72976_f(x, z3 = j + rand.nextInt(16)), z3) == Blocks.field_150348_b) {
                    world.func_147449_b(x, y3, z3, ModBlocks.geysir_vapor);
                } else if (world.func_147439_a(x, y3 - 1, z3) == Blocks.field_150348_b) {
                    world.func_147449_b(x, y3 - 1, z3, ModBlocks.geysir_vapor);
                }
            }
            if (rand.nextInt(1000) == 0) {
                x = i + rand.nextInt(16);
                z3 = j + rand.nextInt(16);
                boolean done = false;
                for (int k2 = 0; k2 < 256; ++k2) {
                    if (world.func_147439_a(x, k2, z3) != Blocks.field_150364_r || world.func_72805_g(x, k2, z3) != 0) continue;
                    world.func_147449_b(x, k2, z3, ModBlocks.pink_log);
                    done = true;
                }
                if (GeneralConfig.enableDebugMode && done) {
                    MainRegistry.logger.info("[Debug] Successfully spawned pink tree at " + x + " " + z3);
                }
            }
            if (WorldConfig.vaultfreq > 0 && GeneralConfig.enableVaults && rand.nextInt(WorldConfig.vaultfreq) == 0 && world.func_147439_a(x = i + rand.nextInt(16), (y3 = world.func_72976_f(x, z3 = j + rand.nextInt(16))) - 1, z3).canPlaceTorchOnTop(world, x, y3 - 1, z3)) {
                world.func_147465_d(x, y3, z3, ModBlocks.safe, rand.nextInt(4) + 2, 2);
                TileEntity tile = world.func_147438_o(x, y3, z3);
                if (tile instanceof TileEntitySafe) {
                    TileEntitySafe safe = (TileEntitySafe)tile;
                    switch (rand.nextInt(10)) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            safe.setMod(1.0);
                            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])ItemPool.getPool("POOL_VAULT_RUSTY"), (IInventory)safe, (int)(rand.nextInt(4) + 3));
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            safe.setMod(0.1);
                            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])ItemPool.getPool("POOL_VAULT_STANDARD"), (IInventory)safe, (int)(rand.nextInt(3) + 2));
                            break;
                        }
                        case 7: 
                        case 8: {
                            safe.setMod(0.02);
                            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])ItemPool.getPool("POOL_VAULT_REINFORCED"), (IInventory)safe, (int)(rand.nextInt(3) + 1));
                            break;
                        }
                        case 9: {
                            safe.setMod(0.0);
                            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])ItemPool.getPool("POOL_VAULT_UNBREAKABLE"), (IInventory)safe, (int)(rand.nextInt(2) + 1));
                        }
                    }
                    safe.setPins(rand.nextInt(999) + 1);
                    safe.lock();
                    if (rand.nextInt(10) < 3) {
                        safe.fillWithSpiders();
                    }
                }
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned safe at " + x + " " + (y3 + 1) + " " + z3);
                }
            }
            if ((biome == BiomeGenBase.field_76782_w || biome == BiomeGenBase.field_150574_L || biome == BiomeGenBase.field_76792_x) && WorldConfig.jungleStructure > 0 && rand.nextInt(WorldConfig.jungleStructure) == 0) {
                x = i + rand.nextInt(16);
                z3 = j + rand.nextInt(16);
                CellularDungeonFactory.jungle.generate(world, x, 20, z3, world.field_73012_v);
                CellularDungeonFactory.jungle.generate(world, x, 24, z3, world.field_73012_v);
                CellularDungeonFactory.jungle.generate(world, x, 28, z3, world.field_73012_v);
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned jungle dungeon at " + x + " 10 " + z3);
                }
                y3 = world.func_72976_f(x, z3);
                for (int f = 0; f < 3; ++f) {
                    world.func_147449_b(x, y3 + f, z3, ModBlocks.deco_titanium);
                }
                world.func_147449_b(x, y3 + 3, z3, Blocks.field_150451_bX);
            }
            if (WorldConfig.arcticStructure > 0 && rand.nextInt(WorldConfig.arcticStructure) == 0) {
                x = i + rand.nextInt(16);
                z3 = j + rand.nextInt(16);
                y3 = 16 + rand.nextInt(32);
                new ArcticVault().trySpawn(world, x, y3, z3);
            }
            if (WorldConfig.pyramidStructure > 0 && biome.field_76750_F >= 2.0f && !biome.func_76738_d() && rand.nextInt(WorldConfig.pyramidStructure) == 0) {
                x = i + rand.nextInt(16);
                z3 = j + rand.nextInt(16);
                y3 = world.func_72976_f(x, z3);
                new AncientTomb().build(world, rand, x, y3, z3);
            }
        }
        if (rand.nextInt(4) == 0 && world.func_147439_a(x = i + rand.nextInt(16) + 8, y = 6 + rand.nextInt(13), z = j + rand.nextInt(16) + 8).isReplaceableOreGen(world, x, y, z, Blocks.field_150348_b)) {
            world.func_147449_b(x, y, z, ModBlocks.stone_keyhole);
        }
        HbmWorldGen.genBlueprintChest(world, rand, i, j, 5000, 5000);
    }

    private static void genBlueprintChest(World world, Random rand, int i, int j, int boundsX, int boundsZ) {
        if (Math.abs(i) < 100 && Math.abs(j) < 100) {
            return;
        }
        if (rand.nextInt(20) < 10) {
            return;
        }
        int cX = Math.abs(i) % boundsX;
        int cZ = Math.abs(j) % boundsZ;
        if (cX >= 0 && cX < 16 && cZ >= 0 && cZ < 16) {
            int x = i + 8;
            int z = j + 8;
            int y = world.func_72976_f(x, z) - rand.nextInt(2);
            world.func_147449_b(x, y, z, (Block)Blocks.field_150486_ae);
            for (int a = x - 1; a <= x + 1; ++a) {
                for (int b = y - 1; b <= y + 1; ++b) {
                    for (int c = z - 1; c <= z + 1; ++c) {
                        if (a == x && b == y && c == z) continue;
                        world.func_147449_b(a, b, c, Blocks.field_150343_Z);
                    }
                }
            }
            TileEntity tile = Compat.getTileStandard(world, x, y, z);
            if (tile instanceof TileEntityChest) {
                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])ItemPool.getPool("POOL_BLUEPRINTS"), (IInventory)((TileEntityChest)tile), (int)50);
            }
        }
    }

    private void generateNether(World world, Random rand, int i, int j) {
        int y;
        int d;
        int z;
        int k;
        if (WorldConfig.netherOre) {
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.netherUraniumuSpawn, 6, 0, 127, ModBlocks.ore_nether_uranium, Blocks.field_150424_aL);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.netherTungstenSpawn, 10, 0, 127, ModBlocks.ore_nether_tungsten, Blocks.field_150424_aL);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.netherSulfurSpawn, 12, 0, 127, ModBlocks.ore_nether_sulfur, Blocks.field_150424_aL);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.netherPhosphorusSpawn, 6, 0, 127, ModBlocks.ore_nether_fire, Blocks.field_150424_aL);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.netherCoalSpawn, 32, 16, 96, ModBlocks.ore_nether_coal, Blocks.field_150424_aL);
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.netherCobaltSpawn, 6, 100, 26, ModBlocks.ore_nether_cobalt, Blocks.field_150424_aL);
            if (GeneralConfig.enablePlutoniumOre) {
                DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.netherPlutoniumSpawn, 4, 0, 127, ModBlocks.ore_nether_plutonium, Blocks.field_150424_aL);
            }
            if (rand.nextInt(10) == 0) {
                WeightedRandomGeneric item = (WeightedRandomGeneric)WeightedRandom.func_76271_a((Random)rand, BedrockOre.weightedOresNether);
                BedrockOre.BedrockOreDefinition def = (BedrockOre.BedrockOreDefinition)item.get();
                int randPosX = i + rand.nextInt(2) + 8;
                int randPosZ = j + rand.nextInt(2) + 8;
                BedrockOre.generate(world, randPosX, randPosZ, def.stack, def.acid, def.color, def.tier, ModBlocks.stone_depth_nether, Blocks.field_150424_aL);
            }
            DepthDeposit.generateConditionNether(world, i, 0, 3, j, 7, 0.6, ModBlocks.ore_depth_nether_neodymium, rand, 16);
            DepthDeposit.generateConditionNether(world, i, 125, 3, j, 7, 0.6, ModBlocks.ore_depth_nether_neodymium, rand, 16);
        }
        for (k = 0; k < 30; ++k) {
            int x = i + rand.nextInt(16);
            z = j + rand.nextInt(16);
            d = 16 + rand.nextInt(96);
            for (y = d - 5; y <= d; ++y) {
                if (world.func_147439_a(x, y + 1, z) != Blocks.field_150350_a || world.func_147439_a(x, y, z) != Blocks.field_150424_aL) continue;
                world.func_147449_b(x, y, z, ModBlocks.ore_nether_smoldering);
            }
        }
        for (k = 0; k < 1; ++k) {
            int x = i + rand.nextInt(16);
            z = j + rand.nextInt(16);
            d = 16 + rand.nextInt(96);
            for (y = d - 5; y <= d; ++y) {
                if (world.func_147439_a(x, y + 1, z) != Blocks.field_150350_a || world.func_147439_a(x, y, z) != Blocks.field_150424_aL) continue;
                world.func_147449_b(x, y, z, ModBlocks.geysir_nether);
            }
        }
    }

    private void generateEnd(World world, Random rand, int i, int j) {
        if (WorldConfig.endOre) {
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.endTikiteSpawn, 6, 0, 127, ModBlocks.ore_tikite, Blocks.field_150377_bs);
        }
    }
}

