/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet.toclient;

import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.util.BufferUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public class SerializableRecipePacket
implements IMessage {
    private String filename;
    private byte[] fileBytes;
    private boolean reinit;

    public SerializableRecipePacket() {
    }

    public SerializableRecipePacket(File recipeFile) {
        try {
            this.filename = recipeFile.getName();
            this.fileBytes = Files.readAllBytes(recipeFile.toPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public SerializableRecipePacket(boolean reinit) {
        this.reinit = reinit;
    }

    public void fromBytes(ByteBuf buf) {
        this.reinit = buf.readBoolean();
        if (this.reinit) {
            return;
        }
        this.filename = BufferUtil.readString(buf);
        this.fileBytes = new byte[buf.readInt()];
        buf.readBytes(this.fileBytes);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.reinit);
        if (this.reinit) {
            return;
        }
        BufferUtil.writeString(buf, this.filename);
        buf.writeInt(this.fileBytes.length);
        buf.writeBytes(this.fileBytes);
    }

    public static class Handler
    implements IMessageHandler<SerializableRecipePacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(SerializableRecipePacket m, MessageContext ctx) {
            try {
                if (m.reinit) {
                    SerializableRecipe.initialize();
                    return null;
                }
                SerializableRecipe.receiveRecipes(m.filename, m.fileBytes);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

