/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import com.hbm.animloader.AnimatedModel;
import com.hbm.animloader.Animation;
import com.hbm.lib.Library;
import com.hbm.main.ResourceManager;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.loader.IModelCustomNamed;
import com.hbm.render.tileentity.door.IRenderDoors;
import com.hbm.render.tileentity.door.RenderAirlockDoor;
import com.hbm.render.tileentity.door.RenderContainmentDoor;
import com.hbm.render.tileentity.door.RenderFireDoor;
import com.hbm.render.tileentity.door.RenderSealDoor;
import com.hbm.render.tileentity.door.RenderSecureDoor;
import com.hbm.render.tileentity.door.RenderSlidingBlastDoor;
import com.hbm.render.tileentity.door.RenderSlidingDoor;
import com.hbm.render.tileentity.door.RenderVaultDoor;
import com.hbm.render.tileentity.door.RenderVehicleDoor;
import com.hbm.render.tileentity.door.RenderWaterDoor;
import com.hbm.tileentity.TileEntityDoorGeneric;
import com.hbm.util.BobMathUtil;
import com.hbm.util.Clock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.function.Consumer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class DoorDecl {
    public static final DoorDecl TRANSITION_SEAL = new DoorDecl(){

        @Override
        public String getOpenSoundStart() {
            return "hbm:door.TransitionSealOpen";
        }

        @Override
        public float getSoundVolume() {
            return 6.0f;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if (!partName.equals("base")) {
                this.set(trans, 0.0f, 3.5f * this.getNormTime(openTicks), 0.0f);
            } else {
                super.getTranslation(partName, openTicks, child, trans);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void doOffsetTransform() {
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.5);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public double[][] getClippingPlanes() {
            return super.getClippingPlanes();
        }

        @Override
        public int timeToOpen() {
            return 480;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{-9, 2, 0, 20, 20, 1}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{23, 0, 0, 0, 13, 12};
        }

        @Override
        public AxisAlignedBB getBlockBound(int x, int y, int z, boolean open, boolean forCollision) {
            return super.getBlockBound(x, y, z, open, forCollision);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getTextureForPart(int skinIndex, String partName) {
            return ResourceManager.transition_seal_tex;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Animation getAnim() {
            return ResourceManager.transition_seal_anim;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public AnimatedModel getAnimatedModel() {
            return ResourceManager.transition_seal;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IModelCustomNamed getModel() {
            return null;
        }
    };
    public static final DoorDecl VAULT_DOOR = new DoorDecl(){
        public Consumer<TileEntityDoorGeneric> onUpdate = door -> {
            block6: {
                block5: {
                    if (door.func_145831_w().field_72995_K) {
                        return;
                    }
                    if (door.state != 3) break block5;
                    if (door.openTicks == 0) {
                        door.func_145831_w().func_72908_a((double)door.field_145851_c, (double)door.field_145848_d, (double)door.field_145849_e, "hbm:block.vaultScrapeNew", 1.0f, 1.0f);
                    }
                    for (int i = 45; i <= 115; i += 10) {
                        if (door.openTicks != i) continue;
                        door.func_145831_w().func_72908_a((double)door.field_145851_c, (double)door.field_145848_d, (double)door.field_145849_e, "hbm:block.vaultThudNew", 1.0f, 1.0f);
                    }
                    break block6;
                }
                if (door.state != 2) break block6;
                if (door.openTicks == 30) {
                    door.func_145831_w().func_72908_a((double)door.field_145851_c, (double)door.field_145848_d, (double)door.field_145849_e, "hbm:block.vaultScrapeNew", 1.0f, 1.0f);
                }
                for (int i = 45; i <= 115; i += 10) {
                    if (door.openTicks != i) continue;
                    door.func_145831_w().func_72908_a((double)door.field_145851_c, (double)door.field_145848_d, (double)door.field_145849_e, "hbm:block.vaultThudNew", 1.0f, 1.0f);
                }
            }
        };

        @Override
        public IRenderDoors getSEDNARenderer() {
            return RenderVaultDoor.INSTANCE;
        }

        @Override
        public BusAnimation getBusAnimation(byte state, byte skinIndex) {
            if (state == 3) {
                return new BusAnimation().addBus("PULL", new BusAnimationSequence().setPos(0.0, 0.0, 0.0).addPos(0.0, 0.0, 1.0, 2000, BusAnimationKeyframe.IType.SIN_FULL)).addBus("SLIDE", new BusAnimationSequence().addPos(0.0, 0.0, 0.0, 2000).addPos(1.0, 0.0, 0.0, 4000));
            }
            if (state == 2) {
                return new BusAnimation().addBus("PULL", new BusAnimationSequence().setPos(0.0, 0.0, 1.0).addPos(0.0, 0.0, 1.0, 4000).addPos(0.0, 0.0, 0.0, 2000, BusAnimationKeyframe.IType.SIN_FULL)).addBus("SLIDE", new BusAnimationSequence().setPos(1.0, 0.0, 0.0).addPos(0.0, 0.0, 0.0, 4000));
            }
            return null;
        }

        @Override
        public int getSkinCount() {
            return 7;
        }

        @Override
        public int timeToOpen() {
            return 120;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{-1, 1, 0, 3, 3, 2}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{4, 0, 0, 0, 2, 2};
        }

        @Override
        public int[][] getExtraDimensions() {
            return new int[][]{{0, 0, 1, -1, 2, 2}};
        }

        @Override
        public AxisAlignedBB getBlockBound(int x, int y, int z, boolean open, boolean forCollision) {
            if (!open || y == 0) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            }
            return super.getBlockBound(x, y, z, open, forCollision);
        }

        @Override
        public Consumer<TileEntityDoorGeneric> onDoorUpdate() {
            return this.onUpdate;
        }
    };
    public static final DoorDecl FIRE_DOOR = new DoorDecl(){

        @Override
        public String getOpenSoundEnd() {
            return "hbm:door.wghStop";
        }

        @Override
        public String getOpenSoundLoop() {
            return "hbm:door.wghStart";
        }

        @Override
        public String getSoundLoop2() {
            return "hbm:door.alarm6";
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        public IRenderDoors getSEDNARenderer() {
            return RenderFireDoor.INSTANCE;
        }

        @Override
        public BusAnimation getBusAnimation(byte state, byte skinIndex) {
            if (state == 3) {
                return new BusAnimation().addBus("DOOR", new BusAnimationSequence().setPos(0.0, 0.0, 0.0).addPos(0.0, 1.0, 0.0, this.timeToOpen() * 50));
            }
            if (state == 2) {
                return new BusAnimation().addBus("DOOR", new BusAnimationSequence().setPos(0.0, 1.0, 0.0).addPos(0.0, 0.0, 0.0, this.timeToOpen() * 50));
            }
            return null;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation[] getSEDNASkins() {
            return new ResourceLocation[]{ResourceManager.pheo_fire_door_tex, ResourceManager.pheo_fire_door_black_tex, ResourceManager.pheo_fire_door_orange_tex};
        }

        @Override
        public int getSkinCount() {
            return 3;
        }

        @Override
        public int timeToOpen() {
            return 160;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{-1, 0, 0, 3, 4, 1}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{2, 0, 0, 0, 2, 1};
        }

        @Override
        public AxisAlignedBB getBlockBound(int x, int y, int z, boolean open, boolean forCollision) {
            if (!open) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            }
            if (z == 1) {
                return AxisAlignedBB.func_72330_a((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            }
            if (z == -2) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0);
            }
            if (y > 1) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            }
            if (y == 0) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)(forCollision ? 0.0 : 0.1), (double)1.0);
            }
            return super.getBlockBound(x, y, z, open, forCollision);
        }
    };
    public static final DoorDecl SLIDE_DOOR = new DoorDecl(){

        @Override
        public String getOpenSoundEnd() {
            return "hbm:door.sliding_door_opened";
        }

        @Override
        public String getCloseSoundEnd() {
            return "hbm:door.sliding_door_shut";
        }

        @Override
        public String getOpenSoundLoop() {
            return "hbm:door.sliding_door_opening";
        }

        @Override
        public String getSoundLoop2() {
            return "hbm:door.sliding_door_opening";
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        public IRenderDoors getSEDNARenderer() {
            return RenderSlidingBlastDoor.INSTANCE;
        }

        @Override
        public BusAnimation getBusAnimation(byte state, byte skinIndex) {
            if (state == 3) {
                return new BusAnimation().addBus("LOCK", new BusAnimationSequence().setPos(0.0, 0.0, 0.0).addPos(1.0, 0.0, 0.0, 200)).addBus("DOOR", new BusAnimationSequence().setPos(0.0, 0.0, 0.0).addPos(0.0, 0.0, 0.0, 350).addPos(0.0, 0.05, 0.0, 200).addPos(0.0, 1.0, 0.0, 650, BusAnimationKeyframe.IType.SIN_UP));
            }
            if (state == 2) {
                return new BusAnimation().addBus("LOCK", new BusAnimationSequence().setPos(1.0, 0.0, 0.0).addPos(1.0, 0.0, 0.0, 1000).addPos(0.0, 0.0, 0.0, 200)).addBus("DOOR", new BusAnimationSequence().setPos(0.0, 1.0, 0.0).addPos(0.0, 0.05, 0.0, 650, BusAnimationKeyframe.IType.SIN_UP).addPos(0.0, 0.0, 0.0, 200));
            }
            return null;
        }

        @Override
        public int timeToOpen() {
            return 24;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{-2, 0, 0, 4, 5, 1}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{3, 0, 0, 0, 3, 3};
        }

        @Override
        public AxisAlignedBB getBlockBound(int x, int y, int z, boolean open, boolean forCollision) {
            if (open) {
                if (y == 3) {
                    return AxisAlignedBB.func_72330_a((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
                }
                if (y == 0) {
                    return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)(forCollision ? 0.0 : 0.08), (double)1.0);
                }
            }
            return super.getBlockBound(x, y, z, open, forCollision);
        }

        @Override
        public int getSkinCount() {
            return 3;
        }
    };
    public static final DoorDecl SLIDING_SEAL_DOOR = new DoorDecl(){

        @Override
        public String getOpenSoundEnd() {
            return "hbm:door.sliding_seal_stop";
        }

        @Override
        public String getOpenSoundStart() {
            return "hbm:door.sliding_seal_open";
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        public IRenderDoors getSEDNARenderer() {
            return RenderSealDoor.INSTANCE;
        }

        @Override
        public BusAnimation getBusAnimation(byte state, byte skinIndex) {
            if (state == 3) {
                return new BusAnimation().addBus("DOOR", new BusAnimationSequence().setPos(0.0, 0.0, 0.0).addPos(0.0, 1.0, 0.0, this.timeToOpen() * 50));
            }
            if (state == 2) {
                return new BusAnimation().addBus("DOOR", new BusAnimationSequence().setPos(0.0, 1.0, 0.0).addPos(0.0, 0.0, 0.0, this.timeToOpen() * 50));
            }
            return null;
        }

        @Override
        public int timeToOpen() {
            return 20;
        }

        @Override
        public AxisAlignedBB getBlockBound(int x, int y, int z, boolean open, boolean forCollision) {
            if (forCollision && open) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            }
            return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.75, (double)1.0, (double)1.0, (double)1.0);
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{0, 0, 0, 1, 2, 2}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{1, 0, 0, 0, 0, 0};
        }
    };
    public static final DoorDecl SECURE_ACCESS_DOOR = new DoorDecl(){

        @Override
        public String getCloseSoundLoop() {
            return "hbm:door.garage_move";
        }

        @Override
        public String getCloseSoundEnd() {
            return "hbm:door.garage_stop";
        }

        @Override
        public String getOpenSoundEnd() {
            return "hbm:door.garage_stop";
        }

        @Override
        public String getOpenSoundLoop() {
            return "hbm:door.garage_move";
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        public IRenderDoors getSEDNARenderer() {
            return RenderSecureDoor.INSTANCE;
        }

        @Override
        public BusAnimation getBusAnimation(byte state, byte skinIndex) {
            if (state == 3) {
                return new BusAnimation().addBus("DOOR", new BusAnimationSequence().setPos(0.0, 0.0, 0.0).addPos(0.0, 1.0, 0.0, this.timeToOpen() * 50));
            }
            if (state == 2) {
                return new BusAnimation().addBus("DOOR", new BusAnimationSequence().setPos(0.0, 1.0, 0.0).addPos(0.0, 0.0, 0.0, this.timeToOpen() * 50));
            }
            return null;
        }

        @Override
        public int timeToOpen() {
            return 120;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{-2, 1, 0, 4, 5, 1}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{4, 0, 0, 0, 2, 2};
        }

        @Override
        public AxisAlignedBB getBlockBound(int x, int y, int z, boolean open, boolean forCollision) {
            if (!open) {
                if (y > 0) {
                    return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.375, (double)1.0, (double)1.0, (double)0.625);
                }
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            }
            if (y == 1) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)(forCollision ? 0.0 : 0.0625), (double)1.0);
            }
            if (y == 4) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.5, (double)0.15, (double)1.0, (double)1.0, (double)0.85);
            }
            if (y == 0) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            }
            return super.getBlockBound(x, y, z, open, forCollision);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation[] getSEDNASkins() {
            return new ResourceLocation[]{ResourceManager.pheo_secure_door_tex, ResourceManager.pheo_secure_door_grey_tex};
        }

        @Override
        public int getSkinCount() {
            return 2;
        }
    };
    public static final DoorDecl ROUND_AIRLOCK_DOOR = new DoorDecl(){

        @Override
        public String getOpenSoundEnd() {
            return "hbm:door.garage_stop";
        }

        @Override
        public String getOpenSoundLoop() {
            return "hbm:door.garage_move";
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        public IRenderDoors getSEDNARenderer() {
            return RenderAirlockDoor.INSTANCE;
        }

        @Override
        public BusAnimation getBusAnimation(byte state, byte skinIndex) {
            if (state == 3) {
                return new BusAnimation().addBus("DOOR", new BusAnimationSequence().setPos(0.0, 0.0, 0.0).addPos(0.0, 1.0, 0.0, this.timeToOpen() * 50));
            }
            if (state == 2) {
                return new BusAnimation().addBus("DOOR", new BusAnimationSequence().setPos(0.0, 1.0, 0.0).addPos(0.0, 0.0, 0.0, this.timeToOpen() * 50));
            }
            return null;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation[] getSEDNASkins() {
            return new ResourceLocation[]{ResourceManager.pheo_airlock_door_tex, ResourceManager.pheo_airlock_door_clean_tex, ResourceManager.pheo_airlock_door_green_tex};
        }

        @Override
        public int getSkinCount() {
            return 3;
        }

        @Override
        public AxisAlignedBB getBlockBound(int x, int y, int z, boolean open, boolean forCollision) {
            if (!open) {
                return super.getBlockBound(x, y, z, open, forCollision);
            }
            if (z == 1) {
                return AxisAlignedBB.func_72330_a((double)0.4, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            }
            if (z == -2) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.6, (double)1.0, (double)1.0);
            }
            if (y == 3) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            }
            if (y == 0) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)(forCollision ? 0.0 : 0.0625), (double)1.0);
            }
            return super.getBlockBound(x, y, z, open, forCollision);
        }

        @Override
        public int timeToOpen() {
            return 60;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{0, 0, 0, -2, 4, 2}, {0, 0, 0, 3, 4, 2}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{3, 0, 0, 0, 2, 1};
        }
    };
    public static final DoorDecl QE_SLIDING = new DoorDecl(){

        @Override
        public String getOpenSoundEnd() {
            return "hbm:door.qe_sliding_opened";
        }

        @Override
        public String getCloseSoundEnd() {
            return "hbm:door.qe_sliding_shut";
        }

        @Override
        public String getOpenSoundLoop() {
            return "hbm:door.qe_sliding_opening";
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        public int timeToOpen() {
            return 10;
        }

        @Override
        public IRenderDoors getSEDNARenderer() {
            return RenderSlidingDoor.INSTANCE;
        }

        @Override
        public BusAnimation getBusAnimation(byte state, byte skinIndex) {
            if (state == 3) {
                return new BusAnimation().addBus("DOOR", new BusAnimationSequence().setPos(0.0, 0.0, 0.0).addPos(0.0, 1.0, 0.0, this.timeToOpen() * 50));
            }
            if (state == 2) {
                return new BusAnimation().addBus("DOOR", new BusAnimationSequence().setPos(0.0, 1.0, 0.0).addPos(0.0, 0.0, 0.0, this.timeToOpen() * 50));
            }
            return null;
        }

        @Override
        public AxisAlignedBB getBlockBound(int x, int y, int z, boolean open, boolean forCollision) {
            if (forCollision && open) {
                if (z == 0) {
                    return AxisAlignedBB.func_72330_a((double)0.875, (double)0.0, (double)0.8125, (double)1.0, (double)1.0, (double)1.0);
                }
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.8125, (double)0.125, (double)1.0, (double)1.0);
            }
            return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.8125, (double)1.0, (double)1.0, (double)1.0);
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{0, 0, 0, 2, 2, 2}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{1, 0, 0, 0, 1, 0};
        }
    };
    public static final DoorDecl QE_CONTAINMENT = new DoorDecl(){

        @Override
        public String getOpenSoundEnd() {
            return "hbm:door.wgh_stop";
        }

        @Override
        public String getOpenSoundLoop() {
            return "hbm:door.wgh_start";
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        public IRenderDoors getSEDNARenderer() {
            return RenderContainmentDoor.INSTANCE;
        }

        @Override
        public BusAnimation getBusAnimation(byte state, byte skinIndex) {
            if (state == 3) {
                return new BusAnimation().addBus("DOOR", new BusAnimationSequence().setPos(0.0, 0.0, 0.0).addPos(0.0, 1.0, 0.0, this.timeToOpen() * 50));
            }
            if (state == 2) {
                return new BusAnimation().addBus("DOOR", new BusAnimationSequence().setPos(0.0, 1.0, 0.0).addPos(0.0, 0.0, 0.0, this.timeToOpen() * 50));
            }
            return null;
        }

        @Override
        public int timeToOpen() {
            return 160;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{-1, 0, 0, 3, 3, 1}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{2, 0, 0, 0, 1, 1};
        }

        @Override
        public AxisAlignedBB getBlockBound(int x, int y, int z, boolean open, boolean forCollision) {
            if (!open) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0);
            }
            if (y > 1) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.25, (double)0.5, (double)1.0, (double)1.0, (double)1.0);
            }
            if (y == 0) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)(forCollision ? 0.0 : 0.125), (double)1.0);
            }
            return super.getBlockBound(x, y, z, open, forCollision);
        }
    };
    public static final DoorDecl WATER_DOOR = new DoorDecl(){

        @Override
        public String getOpenSoundEnd() {
            return "hbm:door.wgh_big_stop";
        }

        @Override
        public String getOpenSoundLoop() {
            return "hbm:door.wgh_big_start";
        }

        @Override
        public String getOpenSoundStart() {
            return "hbm:door.lever";
        }

        @Override
        public String getCloseSoundStart() {
            return null;
        }

        @Override
        public String getCloseSoundEnd() {
            return "hbm:door.lever";
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        public IRenderDoors getSEDNARenderer() {
            return RenderWaterDoor.INSTANCE;
        }

        @Override
        public BusAnimation getBusAnimation(byte state, byte skinIndex) {
            if (state == 3) {
                return new BusAnimation().addBus("DOOR", new BusAnimationSequence().setPos(0.0, 0.0, 0.0).addPos(0.0, 0.0, 0.0, 1500).addPos(0.0, 1.0, 0.0, 1500, BusAnimationKeyframe.IType.SIN_FULL)).addBus("BOLT", new BusAnimationSequence().setPos(0.0, 0.0, 0.0).addPos(0.0, 0.0, 1.0, 1500, BusAnimationKeyframe.IType.SIN_FULL));
            }
            if (state == 2) {
                return new BusAnimation().addBus("DOOR", new BusAnimationSequence().setPos(0.0, 1.0, 0.0).addPos(0.0, 0.0, 0.0, 1500, BusAnimationKeyframe.IType.SIN_FULL)).addBus("BOLT", new BusAnimationSequence().setPos(0.0, 0.0, 1.0).addPos(0.0, 0.0, 1.0, 1200).addPos(0.0, 0.0, 0.0, 1500, BusAnimationKeyframe.IType.SIN_FULL));
            }
            return null;
        }

        @Override
        public AxisAlignedBB getBlockBound(int x, int y, int z, boolean open, boolean forCollision) {
            if (!open) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.75, (double)1.0, (double)1.0, (double)1.0);
            }
            if (y > 1) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.85, (double)0.75, (double)1.0, (double)1.0, (double)1.0);
            }
            if (y == 0) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.75, (double)1.0, (double)(forCollision ? 0.0 : 0.15), (double)1.0);
            }
            return super.getBlockBound(x, y, z, open, forCollision);
        }

        @Override
        public int timeToOpen() {
            return 60;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{1, 0, 0, -3, 3, 2}};
        }

        @Override
        public float getDoorRangeOpenTime(int ticks, int idx) {
            return this.getNormTime(ticks, 35.0f, 40.0f);
        }

        @Override
        public int[] getDimensions() {
            return new int[]{2, 0, 0, 0, 1, 1};
        }
    };
    public static final DoorDecl SILO_HATCH = new DoorDecl(){

        @Override
        public String getOpenSoundEnd() {
            return "hbm:door.wgh_big_stop";
        }

        @Override
        public String getOpenSoundLoop() {
            return "hbm:door.wgh_big_start";
        }

        @Override
        public String getOpenSoundStart() {
            return null;
        }

        @Override
        public String getCloseSoundStart() {
            return null;
        }

        @Override
        public String getCloseSoundEnd() {
            return "hbm:door.wgh_big_stop";
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        public boolean remoteControllable() {
            return true;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if ("Hatch".equals(partName)) {
                this.set(trans, 0.0f, 0.25f * Library.smoothstep(this.getNormTime(openTicks, 0.0f, 10.0f), 0.0f, 1.0f), 0.0f);
            } else {
                this.set(trans, 0.0f, 0.0f, 0.0f);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getOrigin(String partName, float[] orig) {
            if ("Hatch".equals(partName)) {
                this.set(orig, 0.0f, 0.875f, -1.875f);
                return;
            }
            this.set(orig, 0.0f, 0.0f, 0.0f);
            super.getOrigin(partName, orig);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getRotation(String partName, float openTicks, float[] rot) {
            if ("Hatch".equals(partName)) {
                this.set(rot, Library.smoothstep(this.getNormTime(openTicks, 20.0f, 100.0f), 0.0f, 1.0f) * -240.0f, 0.0f, 0.0f);
                return;
            }
            super.getRotation(partName, openTicks, rot);
        }

        @Override
        public int timeToOpen() {
            return 60;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{1, 0, 1, -3, 3, 0}, {0, 0, 1, -3, 3, 0}, {-1, 0, 1, -3, 3, 0}};
        }

        @Override
        public float getDoorRangeOpenTime(int ticks, int idx) {
            return this.getNormTime(ticks, 20.0f, 20.0f);
        }

        @Override
        public int getBlockOffset() {
            return 2;
        }

        @Override
        public int[] getDimensions() {
            return new int[]{0, 0, 2, 2, 2, 2};
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getTextureForPart(String partName) {
            return ResourceManager.silo_hatch_tex;
        }

        @Override
        public ResourceLocation getTextureForPart(int skinIndex, String partName) {
            return ResourceManager.silo_hatch_tex;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IModelCustomNamed getModel() {
            return ResourceManager.silo_hatch;
        }
    };
    public static final DoorDecl SILO_HATCH_LARGE = new DoorDecl(){

        @Override
        public String getOpenSoundEnd() {
            return "hbm:door.wgh_big_stop";
        }

        @Override
        public String getOpenSoundLoop() {
            return "hbm:door.wgh_big_start";
        }

        @Override
        public String getOpenSoundStart() {
            return null;
        }

        @Override
        public String getCloseSoundStart() {
            return null;
        }

        @Override
        public String getCloseSoundEnd() {
            return "hbm:door.wgh_big_stop";
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        public boolean remoteControllable() {
            return true;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if ("Hatch".equals(partName)) {
                this.set(trans, 0.0f, 0.25f * Library.smoothstep(this.getNormTime(openTicks, 0.0f, 10.0f), 0.0f, 1.0f), 0.0f);
            } else {
                this.set(trans, 0.0f, 0.0f, 0.0f);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getOrigin(String partName, float[] orig) {
            if ("Hatch".equals(partName)) {
                this.set(orig, 0.0f, 0.875f, -2.875f);
                return;
            }
            this.set(orig, 0.0f, 0.0f, 0.0f);
            super.getOrigin(partName, orig);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void getRotation(String partName, float openTicks, float[] rot) {
            if ("Hatch".equals(partName)) {
                this.set(rot, Library.smoothstep(this.getNormTime(openTicks, 20.0f, 100.0f), 0.0f, 1.0f) * -240.0f, 0.0f, 0.0f);
                return;
            }
            super.getRotation(partName, openTicks, rot);
        }

        @Override
        public int timeToOpen() {
            return 60;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{2, 0, 1, -3, 3, 0}, {1, 0, 2, -5, 3, 0}, {0, 0, 2, -5, 3, 0}, {-1, 0, 2, -5, 3, 0}, {-2, 0, 1, -3, 3, 0}};
        }

        @Override
        public float getDoorRangeOpenTime(int ticks, int idx) {
            return this.getNormTime(ticks, 20.0f, 20.0f);
        }

        @Override
        public int getBlockOffset() {
            return 3;
        }

        @Override
        public int[] getDimensions() {
            return new int[]{0, 0, 3, 3, 3, 3};
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation getTextureForPart(String partName) {
            return ResourceManager.silo_hatch_large_tex;
        }

        @Override
        public ResourceLocation getTextureForPart(int skinIndex, String partName) {
            return ResourceManager.silo_hatch_large_tex;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IModelCustomNamed getModel() {
            return ResourceManager.silo_hatch_large;
        }
    };
    public static final DoorDecl LARGE_VEHICLE_DOOR = new DoorDecl(){

        @Override
        public String getOpenSoundEnd() {
            return "hbm:door.garage_stop";
        }

        @Override
        public String getOpenSoundLoop() {
            return "hbm:door.garage_move";
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }

        @Override
        public IRenderDoors getSEDNARenderer() {
            return RenderVehicleDoor.INSTANCE;
        }

        @Override
        public BusAnimation getBusAnimation(byte state, byte skinIndex) {
            if (state == 3) {
                return new BusAnimation().addBus("DOOR", new BusAnimationSequence().setPos(0.0, 0.0, 0.0).addPos(0.0, 1.0, 0.0, this.timeToOpen() * 50));
            }
            if (state == 2) {
                return new BusAnimation().addBus("DOOR", new BusAnimationSequence().setPos(0.0, 1.0, 0.0).addPos(0.0, 0.0, 0.0, this.timeToOpen() * 50));
            }
            return null;
        }

        @Override
        public AxisAlignedBB getBlockBound(int x, int y, int z, boolean open, boolean forCollision) {
            if (!open) {
                return super.getBlockBound(x, y, z, open, forCollision);
            }
            if (z == 3) {
                return AxisAlignedBB.func_72330_a((double)0.4, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            }
            if (z == -3) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.6, (double)1.0, (double)1.0);
            }
            if (y == 0) {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)(forCollision ? 0.0 : 0.0625), (double)1.0);
            }
            return super.getBlockBound(x, y, z, open, forCollision);
        }

        @Override
        public int timeToOpen() {
            return 60;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{0, 0, 0, -4, 6, 2}, {0, 0, 0, 4, 6, 2}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{5, 0, 0, 0, 3, 3};
        }
    };
    private static final String[] nothing = new String[0];

    public abstract int[][] getDoorOpenRanges();

    public abstract int[] getDimensions();

    public int[][] getExtraDimensions() {
        return null;
    }

    public int getBlockOffset() {
        return 0;
    }

    public boolean remoteControllable() {
        return false;
    }

    public float getDoorRangeOpenTime(int ticks, int idx) {
        return this.getNormTime(ticks);
    }

    public int timeToOpen() {
        return 20;
    }

    public float getNormTime(float time) {
        return this.getNormTime(time, 0.0f, this.timeToOpen());
    }

    public float getNormTime(float time, float min, float max) {
        return BobMathUtil.remap01_clamp(time, min, max);
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTextureForPart(String partName) {
        return this.getTextureForPart(0, partName);
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTextureForPart(int skinIndex, String partName) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IModelCustomNamed getModel() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AnimatedModel getAnimatedModel() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Animation getAnim() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
        this.set(trans, 0.0f, 0.0f, 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void getRotation(String partName, float openTicks, float[] rot) {
        this.set(rot, 0.0f, 0.0f, 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void getOrigin(String partName, float[] orig) {
        this.set(orig, 0.0f, 0.0f, 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesRender(String partName, boolean child) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getChildren(String partName) {
        return nothing;
    }

    @SideOnly(value=Side.CLIENT)
    public double[][] getClippingPlanes() {
        return new double[0][];
    }

    @SideOnly(value=Side.CLIENT)
    public void doOffsetTransform() {
    }

    public AxisAlignedBB getBlockBound(int x, int y, int z, boolean open, boolean forCollision) {
        return open ? AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0) : AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    }

    public boolean isLadder(boolean open) {
        return false;
    }

    public String getOpenSoundLoop() {
        return null;
    }

    public String getSoundLoop2() {
        return null;
    }

    public String getCloseSoundLoop() {
        return this.getOpenSoundLoop();
    }

    public String getOpenSoundStart() {
        return null;
    }

    public String getCloseSoundStart() {
        return this.getOpenSoundStart();
    }

    public String getOpenSoundEnd() {
        return null;
    }

    public String getCloseSoundEnd() {
        return this.getOpenSoundEnd();
    }

    public float getSoundVolume() {
        return 1.0f;
    }

    public float[] set(float[] f, float x, float y, float z) {
        f[0] = x;
        f[1] = y;
        f[2] = z;
        return f;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation[] getSEDNASkins() {
        return null;
    }

    public boolean hasSkins() {
        return this.getSkinCount() > 0;
    }

    public int getSkinCount() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getCyclingSkins() {
        ResourceLocation[] skins = this.getSEDNASkins();
        int index = (int)(Clock.get_ms() % (long)(skins.length * 1000) / 1000L);
        return skins[index];
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSkinFromIndex(int index) {
        ResourceLocation[] skins = this.getSEDNASkins();
        return skins[Math.abs(index) % skins.length];
    }

    public IRenderDoors getSEDNARenderer() {
        return null;
    }

    public BusAnimation getBusAnimation(byte state, byte skinIndex) {
        return null;
    }

    public HbmAnimations.Animation getSEDNAAnim(byte state, byte skinIndex) {
        BusAnimation anim = this.getBusAnimation(state, skinIndex);
        if (anim != null) {
            return new HbmAnimations.Animation("DOOR_ANIM", System.currentTimeMillis(), anim);
        }
        return null;
    }

    public Consumer<TileEntityDoorGeneric> onDoorUpdate() {
        return null;
    }
}

