/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import com.hbm.blocks.BlockCrop;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.container.ContainerHydroponic;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIHydroponic;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.InventoryUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHydroponic
extends TileEntityMachineBase
implements IGUIProvider,
IFluidStandardTransceiverMK2,
IEnergyReceiverMK2 {
    public FluidTank[] tanks;
    public long power;
    public static long maxPower = 2000L;
    public int fertilizer;
    public static int maxFertilizer = 200;
    private boolean lightsOn = false;
    private int[] prevMeta = new int[3];
    AxisAlignedBB bb = null;

    public TileEntityHydroponic() {
        super(6);
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(Fluids.CARBONDIOXIDE, 16000);
        this.tanks[1] = new FluidTank(Fluids.OXYGEN, 16000);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerHydroponic(player.field_71071_by, (IInventory)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIHydroponic(player.field_71071_by, this);
    }

    @Override
    public String getName() {
        return "container.hydrobay";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int strength;
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
            for (DirPos pos : this.getFluidPos()) {
                this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos);
                this.tryProvide(this.tanks[1].getTankType(), this.field_145850_b, pos);
            }
            for (DirPos pos : this.getPowerPos()) {
                this.trySubscribe(this.field_145850_b, pos);
            }
            if (this.power > 0L) {
                this.power = Math.max(this.power - 25L, 0L);
            }
            if (this.slots[1] != null && (strength = this.getFertilizerStrength(this.slots[1])) > 0 && this.fertilizer <= maxFertilizer - strength) {
                --this.slots[1].field_77994_a;
                this.fertilizer += strength;
                if (this.slots[1].field_77994_a <= 0) {
                    this.slots[1] = null;
                }
                this.func_70296_d();
            }
            this.power = Library.chargeTEFromItems(this.slots, 2, this.power, maxPower);
            BlockDummyable.safeRem = true;
            int lMeta = this.field_145850_b.func_72805_g(this.field_145851_c - rot.offsetX, this.field_145848_d + 2, this.field_145849_e - rot.offsetZ);
            int rMeta = this.field_145850_b.func_72805_g(this.field_145851_c + rot.offsetX, this.field_145848_d + 2, this.field_145849_e + rot.offsetZ);
            if (this.power >= 200L) {
                if (!this.lightsOn) {
                    this.field_145850_b.func_147465_d(this.field_145851_c - rot.offsetX, this.field_145848_d + 2, this.field_145849_e - rot.offsetZ, ModBlocks.dummy_beam, lMeta, 3);
                    this.field_145850_b.func_147465_d(this.field_145851_c + rot.offsetX, this.field_145848_d + 2, this.field_145849_e + rot.offsetZ, ModBlocks.dummy_beam, rMeta, 3);
                    this.lightsOn = true;
                }
            } else if (this.lightsOn) {
                this.field_145850_b.func_147465_d(this.field_145851_c - rot.offsetX, this.field_145848_d + 2, this.field_145849_e - rot.offsetZ, ModBlocks.hydrobay, lMeta, 3);
                this.field_145850_b.func_147465_d(this.field_145851_c + rot.offsetX, this.field_145848_d + 2, this.field_145849_e + rot.offsetZ, ModBlocks.hydrobay, rMeta, 3);
                this.lightsOn = false;
            }
            BlockDummyable.safeRem = false;
            for (int i = 0; i < 3; ++i) {
                int x = this.field_145851_c + rot.offsetX * (i - 1);
                int y = this.field_145848_d + 1;
                int z = this.field_145849_e + rot.offsetZ * (i - 1);
                Block currentPlant = this.field_145850_b.func_147439_a(x, y, z);
                if (this.power >= 200L && this.tanks[0].getFill() >= 100) {
                    int newMeta;
                    if (!(currentPlant instanceof IGrowable)) {
                        IPlantable plantable;
                        if (this.slots[0] == null || !(this.slots[0].func_77973_b() instanceof IPlantable) || (plantable = (IPlantable)this.slots[0].func_77973_b()).getPlantType((IBlockAccess)this.field_145850_b, x, y, z) != EnumPlantType.Crop || !((currentPlant = plantable.getPlant((IBlockAccess)this.field_145850_b, x, y, z)) instanceof IGrowable) || currentPlant instanceof BlockStem || currentPlant instanceof BlockCrop && !((BlockCrop)currentPlant).canHydro) continue;
                        this.field_145850_b.func_147449_b(x, y, z, currentPlant);
                        this.prevMeta[i] = 0;
                        --this.slots[0].field_77994_a;
                        if (this.slots[0].field_77994_a <= 0) {
                            this.slots[0] = null;
                        }
                        this.func_70296_d();
                    }
                    IGrowable currentGrowable = (IGrowable)currentPlant;
                    if (this.field_145850_b.field_73012_v.nextInt(120) == 0) {
                        currentPlant.func_149674_a(this.field_145850_b, x, y, z, this.field_145850_b.field_73012_v);
                    }
                    boolean fullyGrown = false;
                    if (currentGrowable.func_149851_a(this.field_145850_b, x, y, z, this.field_145850_b.field_72995_K)) {
                        if (this.fertilizer > 0 && this.field_145850_b.field_73012_v.nextInt(60) == 0) {
                            if (currentGrowable.func_149852_a(this.field_145850_b, this.field_145850_b.field_73012_v, x, y, z)) {
                                currentGrowable.func_149853_b(this.field_145850_b, this.field_145850_b.field_73012_v, x, y, z);
                                this.field_145850_b.func_72926_e(2005, x, y, z, 0);
                            }
                            --this.fertilizer;
                        }
                    } else {
                        fullyGrown = true;
                    }
                    if ((newMeta = this.field_145850_b.func_72805_g(x, y, z)) != this.prevMeta[i]) {
                        int toProduce = Math.max(newMeta - this.prevMeta[i], 0) * 15;
                        this.tanks[0].setFill(Math.max(this.tanks[0].getFill() - toProduce, 0));
                        this.tanks[1].setFill(Math.min(this.tanks[1].getFill() + toProduce, this.tanks[1].getMaxFill()));
                        this.prevMeta[i] = newMeta;
                    }
                    if (!fullyGrown || !this.attemptHarvest(currentPlant.getDrops(this.field_145850_b, x, y, z, newMeta, 0))) continue;
                    this.field_145850_b.func_147468_f(x, y, z);
                    this.func_70296_d();
                    continue;
                }
                if (!(currentPlant instanceof IGrowable)) continue;
                this.field_145850_b.func_72921_c(x, y, z, this.prevMeta[i], 2);
            }
            this.networkPackNT(15);
        }
    }

    public ItemStack[] getValidFertilizers() {
        return new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, 15), new ItemStack(ModItems.powder_fertilizer)};
    }

    private int getFertilizerStrength(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        if (stack.func_77973_b() == Items.field_151100_aR && stack.func_77960_j() == 15) {
            return 1;
        }
        if (stack.func_77973_b() == ModItems.powder_fertilizer) {
            return 9;
        }
        return 0;
    }

    private boolean attemptHarvest(List<ItemStack> drops) {
        ItemStack[] originals = new ItemStack[]{this.slots[3], this.slots[4], this.slots[5]};
        for (ItemStack drop : drops) {
            if (InventoryUtil.tryAddItemToInventory(this.slots, 3, 5, drop) == null) continue;
            this.slots[3] = originals[0];
            this.slots[4] = originals[1];
            this.slots[5] = originals[2];
            return false;
        }
        return true;
    }

    private DirPos[] getFluidPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX * 2 + dir.offsetX, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2 + dir.offsetZ, dir), new DirPos(this.field_145851_c - rot.offsetX * 2 + dir.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2 + dir.offsetZ, dir), new DirPos(this.field_145851_c + rot.offsetX * 2 - dir.offsetX, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2 - dir.offsetZ, dir.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX * 2 - dir.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2 - dir.offsetZ, dir.getOpposite())};
    }

    private DirPos[] getPowerPos() {
        return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e, ForgeDirection.UP)};
    }

    @Override
    public void serialize(ByteBuf buf) {
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].serialize(buf);
        }
        buf.writeLong(this.power);
        buf.writeInt(this.fertilizer);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].deserialize(buf);
        }
        this.power = buf.readLong();
        this.fertilizer = buf.readInt();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        int i;
        super.func_145841_b(nbt);
        for (i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
        for (i = 0; i < 3; ++i) {
            nbt.func_74768_a("p" + i, this.prevMeta[i]);
        }
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("lights", this.lightsOn);
        nbt.func_74768_a("fertilizer", this.fertilizer);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        int i;
        super.func_145839_a(nbt);
        for (i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
        for (i = 0; i < 3; ++i) {
            this.prevMeta[i] = nbt.func_74762_e("p" + i);
        }
        this.power = nbt.func_74763_f("power");
        this.lightsOn = nbt.func_74767_n("lights");
        this.fertilizer = nbt.func_74762_e("fertilizer");
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 0) {
            return itemStack.func_77973_b() instanceof IPlantable;
        }
        if (slot == 1) {
            return this.getFertilizerStrength(itemStack) > 0;
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return slot >= 3;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }
}

