/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyProviderMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.handler.CompatHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerCombustionEngine;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Combustible;
import com.hbm.inventory.fluid.trait.FluidTrait;
import com.hbm.inventory.gui.GUICombustionEngine;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemPistons;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachinePolluting;
import com.hbm.util.EnumUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityMachineCombustionEngine
extends TileEntityMachinePolluting
implements IEnergyProviderMK2,
IFluidStandardTransceiver,
IControlReceiver,
IGUIProvider,
SimpleComponent,
CompatHandler.OCComponent,
IFluidCopiable {
    public boolean isOn = false;
    public static long maxPower = 2500000L;
    public long power;
    private int playersUsing = 0;
    public int setting = 0;
    public boolean wasOn = false;
    public float doorAngle = 0.0f;
    public float prevDoorAngle = 0.0f;
    private AudioWrapper audio;
    public FluidTank tank = new FluidTank(Fluids.DIESEL, 24000);
    public int tenth = 0;
    AxisAlignedBB bb = null;

    public TileEntityMachineCombustionEngine() {
        super(5, 50);
    }

    @Override
    public String getName() {
        return "container.combustionEngine";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tank.loadTank(0, 1, this.slots);
            if (this.tank.setType(4, this.slots)) {
                this.tenth = 0;
            }
            this.wasOn = false;
            int fill = this.tank.getFill() * 10 + this.tenth;
            if (this.isOn && this.setting > 0 && this.slots[2] != null && this.slots[2].func_77973_b() == ModItems.piston_set && fill > 0 && this.tank.getTankType().hasTrait(FT_Combustible.class)) {
                ItemPistons.EnumPistonType piston = (ItemPistons.EnumPistonType)((Object)EnumUtil.grabEnumSafely(ItemPistons.EnumPistonType.class, this.slots[2].func_77960_j()));
                FT_Combustible trait = this.tank.getTankType().getTrait(FT_Combustible.class);
                double eff = piston.eff[trait.getGrade().ordinal()];
                if (eff > 0.0 && this.breatheAir(this.field_145850_b.func_82737_E() % 5L == 0L ? this.setting : 0)) {
                    int speed = this.setting * 2;
                    int toBurn = Math.min(fill, speed);
                    this.power = (long)((double)this.power + (double)toBurn * ((double)trait.getCombustionEnergy() / 10000.0) * eff);
                    fill -= toBurn;
                    if (this.field_145850_b.func_82737_E() % 5L == 0L && toBurn > 0) {
                        super.pollute(this.tank.getTankType(), FluidTrait.FluidReleaseType.BURN, (float)toBurn * 0.5f);
                    }
                    if (toBurn > 0) {
                        this.wasOn = true;
                    }
                    this.tank.setFill(fill / 10);
                    this.tenth = fill % 10;
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", Math.min(this.power, maxPower));
            this.power = Library.chargeItemsFromTE(this.slots, 3, this.power, this.power);
            for (DirPos pos : this.getConPos()) {
                this.tryProvide(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.trySubscribe(this.tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.sendSmoke(pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            if (this.power > maxPower) {
                this.power = maxPower;
            }
            this.networkPackNT(50);
        } else {
            this.prevDoorAngle = this.doorAngle;
            float swingSpeed = this.doorAngle / 10.0f + 3.0f;
            this.doorAngle = this.playersUsing > 0 ? (this.doorAngle += swingSpeed) : (this.doorAngle -= swingSpeed);
            this.doorAngle = MathHelper.func_76131_a((float)this.doorAngle, (float)0.0f, (float)135.0f);
            if (this.wasOn) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.keepAlive();
                this.audio.updateVolume(this.getVolume(1.0f));
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    private DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 1 + rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 1 + rot.offsetZ, dir), new DirPos(this.field_145851_c + dir.offsetX * 1 - rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 1 - rot.offsetZ, dir), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 - rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 - rot.offsetZ, dir.getOpposite())};
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.igeneratorOperate", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 10.0f, 1.0f, 20);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.DOWN;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.DOWN;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.playersUsing);
        buf.writeInt(this.setting);
        buf.writeLong(this.power);
        buf.writeBoolean(this.isOn);
        buf.writeBoolean(this.wasOn);
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.playersUsing = buf.readInt();
        this.setting = buf.readInt();
        this.power = buf.readLong();
        this.isOn = buf.readBoolean();
        this.wasOn = buf.readBoolean();
        this.tank.deserialize(buf);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setting = nbt.func_74762_e("setting");
        this.power = nbt.func_74763_f("power");
        this.isOn = nbt.func_74767_n("isOn");
        this.tank.readFromNBT(nbt, "tank");
        this.tenth = nbt.func_74762_e("tenth");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("setting", this.setting);
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("isOn", this.isOn);
        this.tank.writeToNBT(nbt, "tank");
        nbt.func_74768_a("tenth", this.tenth);
    }

    @Override
    public void func_70295_k_() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.playersUsing;
        }
    }

    @Override
    public void func_70305_f() {
        if (!this.field_145850_b.field_72995_K) {
            --this.playersUsing;
        }
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCombustionEngine(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICombustionEngine(player.field_71071_by, this);
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return this.getSmokeTanks();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)this.field_145848_d, (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 4), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 4));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 25.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("turnOn")) {
            boolean bl = this.isOn = !this.isOn;
        }
        if (data.func_74764_b("setting")) {
            this.setting = data.func_74762_e("setting");
        }
        this.markChanged();
    }

    @Override
    public NBTTagCompound getSettings(World world, int x, int y, int z) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("fluidID", new int[]{this.tank.getTankType().getID()});
        tag.func_74757_a("isOn", this.isOn);
        tag.func_74768_a("burnRate", this.setting);
        return tag;
    }

    @Override
    public void pasteSettings(NBTTagCompound nbt, int index, World world, EntityPlayer player, int x, int y, int z) {
        int id = nbt.func_74759_k("fluidID")[index];
        this.tank.setTankType(Fluids.fromID(id));
        if (nbt.func_74764_b("isOn")) {
            this.isOn = nbt.func_74767_n("isOn");
        }
        if (nbt.func_74764_b("burnRate")) {
            this.setting = nbt.func_74762_e("burnRate");
        }
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_combustion_engine";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluid(Context context, Arguments args) {
        return new Object[]{this.tank.getFill(), this.tank.getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getType(Context context, Arguments args) {
        return new Object[]{this.tank.getTankType().getName()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getPower(Context context, Arguments args) {
        return new Object[]{this.power};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getThrottle(Context context, Arguments args) {
        return new Object[]{this.setting};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getState(Context context, Arguments args) {
        return new Object[]{this.isOn};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getEfficiency(Context context, Arguments args) {
        ItemPistons.EnumPistonType piston = (ItemPistons.EnumPistonType)((Object)EnumUtil.grabEnumSafely(ItemPistons.EnumPistonType.class, this.slots[2].func_77960_j()));
        FT_Combustible trait = this.tank.getTankType().getTrait(FT_Combustible.class);
        double eff = piston.eff[trait.getGrade().ordinal()];
        return new Object[]{eff};
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] setThrottle(Context context, Arguments args) {
        int throttleRequest = args.checkInteger(0);
        if (throttleRequest < 0 || throttleRequest > 30) {
            return new Object[]{false, "Throttle request outside of range 0-30"};
        }
        this.setting = throttleRequest;
        return new Object[]{true};
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] start(Context context, Arguments args) {
        this.isOn = true;
        return new Object[0];
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] stop(Context context, Arguments args) {
        this.isOn = false;
        return new Object[0];
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        ItemPistons.EnumPistonType piston = (ItemPistons.EnumPistonType)((Object)EnumUtil.grabEnumSafely(ItemPistons.EnumPistonType.class, this.slots[2].func_77960_j()));
        FT_Combustible trait = this.tank.getTankType().getTrait(FT_Combustible.class);
        double eff = piston.eff[trait.getGrade().ordinal()];
        return new Object[]{this.setting, this.isOn, this.power, eff, this.tank.getFill(), this.tank.getMaxFill(), this.tank.getTankType().getName()};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getFluid", "getType", "getPower", "getThrottle", "getState", "getEfficiency", "setThrottle", "start", "stop", "getInfo"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getFluid": {
                return this.getFluid(context, args);
            }
            case "getType": {
                return this.getType(context, args);
            }
            case "getPower": {
                return this.getPower(context, args);
            }
            case "getThrottle": {
                return this.getThrottle(context, args);
            }
            case "getState": {
                return this.getState(context, args);
            }
            case "getEfficiency": {
                return this.getEfficiency(context, args);
            }
            case "setThrottle": {
                return this.setThrottle(context, args);
            }
            case "start": {
                return this.start(context, args);
            }
            case "stop": {
                return this.stop(context, args);
            }
            case "getInfo": {
                return this.getInfo(context, args);
            }
        }
        throw new NoSuchMethodException();
    }
}

