/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.tile.IPropulsion;
import com.hbm.dim.SolarSystem;
import com.hbm.handler.atmosphere.IBlockSealable;
import com.hbm.inventory.recipes.FusionRecipe;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.machine.albion.TileEntityCooledBase;
import com.hbm.tileentity.machine.fusion.IFusionPowerReceiver;
import com.hbm.uninos.GenNode;
import com.hbm.uninos.NodeNet;
import com.hbm.uninos.UniNodespace;
import com.hbm.uninos.networkproviders.PlasmaNetwork;
import com.hbm.uninos.networkproviders.PlasmaNetworkProvider;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineHTRNeo
extends TileEntityCooledBase
implements IPropulsion,
IFusionPowerReceiver,
IBlockSealable {
    protected GenNode plasmaNode;
    public long plasmaEnergy;
    public long plasmaEnergySync;
    public static long maxPower = 200000000L;
    public static final int COOLANT_USE = 50;
    public float rotor;
    public float prevRotor;
    public float rotorSpeed;
    private float soundtime;
    private AudioWrapper audio;
    private boolean hasRegistered;
    public boolean isOn;
    public int fuelCost;
    public float thrustAmount;
    public FusionRecipe recipe;
    public float plasmaR;
    public float plasmaG;
    public float plasmaB;
    AxisAlignedBB bb = null;

    public TileEntityMachineHTRNeo() {
        super(0);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.hasRegistered) {
                if (this.isFacingPrograde()) {
                    this.registerPropulsion();
                }
                this.hasRegistered = true;
                this.isOn = false;
            }
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos);
                this.trySubscribe(this.coolantTanks[0].getTankType(), this.field_145850_b, pos);
                this.tryProvide(this.coolantTanks[1], this.field_145850_b, pos);
            }
            this.plasmaEnergySync = this.plasmaEnergy;
            this.temperature += 2.5f;
            if (this.temperature > 293.0f) {
                this.temperature = 293.0f;
            }
            if (this.temperature > 123.0f) {
                int cyclesTemp = (int)Math.ceil(Math.min(this.temperature - 123.0f, 7.5f) / 0.5f);
                int cyclesCool = this.coolantTanks[0].getFill();
                int cyclesHot = this.coolantTanks[1].getMaxFill() - this.coolantTanks[1].getFill();
                int cycles = BobMathUtil.min(cyclesTemp, cyclesCool, cyclesHot);
                this.coolantTanks[0].setFill(this.coolantTanks[0].getFill() - cycles);
                this.coolantTanks[1].setFill(this.coolantTanks[1].getFill() + cycles);
                this.temperature -= 0.5f * (float)cycles;
            }
            if (this.isOn) {
                this.soundtime += 1.0f;
                if (this.soundtime == 1.0f) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:misc.htrfstart", 1.5f, 1.0f);
                } else if (this.soundtime > 30.0f) {
                    this.soundtime = 30.0f;
                }
            } else {
                this.soundtime -= 1.0f;
                if (this.soundtime == 29.0f) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:misc.htrstop", 2.0f, 1.0f);
                } else if (this.soundtime <= 0.0f) {
                    this.soundtime = 0.0f;
                }
            }
            if (this.plasmaNode == null || this.plasmaNode.expired) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getRotation(ForgeDirection.UP);
                this.plasmaNode = UniNodespace.getNode(this.field_145850_b, this.field_145851_c + dir.offsetX * -10, this.field_145848_d, this.field_145849_e + dir.offsetZ * -10, PlasmaNetworkProvider.THE_PROVIDER);
                if (this.plasmaNode == null) {
                    this.plasmaNode = new GenNode<PlasmaNetwork>(PlasmaNetworkProvider.THE_PROVIDER, new BlockPos(this.field_145851_c + dir.offsetX * -10, this.field_145848_d, this.field_145849_e + dir.offsetZ * -10)).setConnections(new DirPos(this.field_145851_c + dir.offsetX * -11, this.field_145848_d, this.field_145849_e + dir.offsetZ * -11, dir));
                    UniNodespace.createNode(this.field_145850_b, this.plasmaNode);
                }
            }
            if (this.plasmaNode != null && this.plasmaNode.hasValidNet()) {
                ((NodeNet)this.plasmaNode.net).addReceiver((TileEntityMachineHTRNeo)this);
            }
            this.networkPackNT(200);
            this.plasmaEnergy = 0L;
        } else {
            this.rotorSpeed = this.power >= maxPower || this.isOn ? (this.rotorSpeed += 0.125f) : (this.rotorSpeed -= 0.125f);
            this.rotorSpeed = MathHelper.func_76131_a((float)this.rotorSpeed, (float)0.0f, (float)15.0f);
            this.prevRotor = this.rotor;
            this.rotor += this.rotorSpeed;
            if (this.rotor >= 360.0f) {
                this.rotor -= 360.0f;
                this.prevRotor -= 360.0f;
            }
            if (this.isOn) {
                if (this.soundtime > 28.0f) {
                    if (this.audio == null) {
                        this.audio = this.createAudioLoop();
                        this.audio.startSound();
                    } else if (!this.audio.isPlaying()) {
                        this.audio = this.rebootAudio(this.audio);
                    }
                    this.audio.updateVolume(this.getVolume(1.0f));
                    this.audio.keepAlive();
                }
                this.thrustAmount = (float)((double)this.thrustAmount + 0.01);
                if (this.thrustAmount > 1.0f) {
                    this.thrustAmount = 1.0f;
                }
            } else {
                if (this.audio != null) {
                    this.audio.stopSound();
                    this.audio = null;
                }
                this.thrustAmount = (float)((double)this.thrustAmount - 0.01);
                if (this.thrustAmount < 0.0f) {
                    this.thrustAmount = 0.0f;
                }
            }
        }
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:misc.htrloop", this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.25f, 27.5f, 1.0f, 20);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hasRegistered) {
            this.unregisterPropulsion();
            this.hasRegistered = false;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hasRegistered) {
            this.unregisterPropulsion();
            this.hasRegistered = false;
        }
        if (!this.field_145850_b.field_72995_K && this.plasmaNode != null) {
            UniNodespace.destroyNode(this.field_145850_b, this.plasmaNode);
        }
    }

    @Override
    public boolean receivesFusionPower() {
        return true;
    }

    @Override
    public void receiveFusionPower(long fusionPower, double neutronPower) {
        this.plasmaEnergy = fusionPower;
    }

    @Override
    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c - rot.offsetX * 5 - dir.offsetX * 3, this.field_145848_d - 2, this.field_145849_e - rot.offsetZ * 5 - dir.offsetZ * 3, dir.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX * -1 - dir.offsetX * 3, this.field_145848_d - 2, this.field_145849_e - rot.offsetZ * -1 - dir.offsetZ * 3, dir.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX * 5 - dir.offsetX * -3, this.field_145848_d - 2, this.field_145849_e - rot.offsetZ * 5 - dir.offsetZ * -3, dir), new DirPos(this.field_145851_c - rot.offsetX * -1 - dir.offsetX * -3, this.field_145848_d - 2, this.field_145849_e - rot.offsetZ * -1 - dir.offsetZ * -3, dir)};
    }

    @Override
    public boolean canPerformBurn(int shipMass, double deltaV) {
        this.fuelCost = SolarSystem.getFuelCost(deltaV, shipMass, 250);
        if (this.plasmaEnergySync < (long)this.fuelCost) {
            return false;
        }
        if (this.power < maxPower) {
            return false;
        }
        return this.isCool();
    }

    @Override
    public void addErrors(List<String> errors) {
        if (this.plasmaEnergySync < (long)this.fuelCost) {
            errors.add(EnumChatFormatting.RED + "Insufficient plasma energy: needs " + BobMathUtil.getShortNumber(this.fuelCost) + " TU");
        }
        if (this.power < maxPower) {
            errors.add(EnumChatFormatting.RED + "Insufficient power");
        }
        if (!this.isCool()) {
            errors.add(EnumChatFormatting.RED + "Coolant loop not operational!");
        }
    }

    @Override
    public float getThrust() {
        return 1.6E9f;
    }

    @Override
    public int startBurn() {
        this.isOn = true;
        this.power = 0L;
        return 180;
    }

    @Override
    public int endBurn() {
        this.isOn = false;
        return 180;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.plasmaEnergySync);
        buf.writeBoolean(this.isOn);
        buf.writeInt(this.fuelCost);
        buf.writeFloat(this.soundtime);
        if (this.recipe != null) {
            buf.writeBoolean(true);
            buf.writeFloat(this.recipe.r);
            buf.writeFloat(this.recipe.g);
            buf.writeFloat(this.recipe.b);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.plasmaEnergy = buf.readLong();
        this.isOn = buf.readBoolean();
        this.fuelCost = buf.readInt();
        this.soundtime = buf.readFloat();
        if (buf.readBoolean()) {
            this.plasmaR = buf.readFloat();
            this.plasmaG = buf.readFloat();
            this.plasmaB = buf.readFloat();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("plasma", this.plasmaEnergy);
        nbt.func_74757_a("on", this.isOn);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.plasmaEnergy = nbt.func_74763_f("plasma");
        this.isOn = nbt.func_74767_n("on");
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 11), (double)(this.field_145848_d - 2), (double)(this.field_145849_e - 11), (double)(this.field_145851_c + 12), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 12));
        }
        return this.bb;
    }

    @Override
    public String getName() {
        return "container.htrfneo";
    }

    public boolean isFacingPrograde() {
        return ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)) == ForgeDirection.SOUTH;
    }

    @Override
    public boolean isSealed(World world, int x, int y, int z) {
        return true;
    }
}

