/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import api.hbm.fluidmk2.FluidNetMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.rbmk.RBMKBase;
import com.hbm.entity.effect.EntitySpear;
import com.hbm.entity.projectile.EntityRBMKDebris;
import com.hbm.handler.neutron.NeutronNodeWorld;
import com.hbm.handler.neutron.RBMKNeutronHandler;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.main.MainRegistry;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.saveddata.TomSaveData;
import com.hbm.tileentity.IOverpressurable;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKRod;
import com.hbm.util.BobMathUtil;
import com.hbm.util.Compat;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class TileEntityRBMKBase
extends TileEntityLoadedBase {
    public double heat;
    public int reasimWater;
    public static final int maxWater = 16000;
    public int reasimSteam;
    public static final int maxSteam = 16000;
    public static final ForgeDirection[] neighborDirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
    protected TileEntityRBMKBase[] neighborCache = new TileEntityRBMKBase[4];
    protected static boolean diag = false;
    public static HashSet<TileEntityRBMKBase> columns = new HashSet();
    public static HashSet<FluidNetMK2> pipes = new HashSet();

    public boolean hasLid() {
        if (!this.isLidRemovable()) {
            return true;
        }
        return this.func_145832_p() != RBMKBase.DIR_NO_LID.ordinal() + 10;
    }

    public boolean isLidRemovable() {
        return true;
    }

    public double maxHeat() {
        return 1500.0;
    }

    public double passiveCooling() {
        return RBMKDials.getPassiveCooling(this.field_145850_b);
    }

    public boolean shouldUpdate() {
        return true;
    }

    public int trackingRange() {
        return 15;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.field_72984_F.func_76320_a("rbmkBase_heat_movement");
            this.moveHeat();
            if (RBMKDials.getReasimBoilers(this.field_145850_b)) {
                this.field_145850_b.field_72984_F.func_76318_c("rbmkBase_reasim_boilers");
                this.boilWater();
            }
            this.field_145850_b.field_72984_F.func_76318_c("rbmkBase_rpassive_cooling");
            this.coolPassively();
            this.field_145850_b.field_72984_F.func_76319_b();
            this.networkPackNT(this.trackingRange());
        }
    }

    private void boilWater() {
        if (this.heat < 100.0) {
            return;
        }
        double heatConsumption = RBMKDials.getBoilerHeatConsumption(this.field_145850_b);
        double availableHeat = (this.heat - 100.0) / heatConsumption;
        double availableWater = this.reasimWater;
        double availableSpace = 16000 - this.reasimSteam;
        int processedWater = (int)Math.floor(BobMathUtil.min(availableHeat, availableWater, availableSpace) * MathHelper.func_151237_a((double)RBMKDials.getReaSimBoilerSpeed(this.field_145850_b), (double)0.0, (double)1.0));
        if (processedWater <= 0) {
            return;
        }
        this.reasimWater -= processedWater;
        this.reasimSteam += processedWater;
        this.heat -= (double)processedWater * heatConsumption;
    }

    private void moveHeat() {
        boolean reasim = RBMKDials.getReasimBoilers(this.field_145850_b);
        ArrayList<TileEntityRBMKBase> rec = new ArrayList<TileEntityRBMKBase>();
        rec.add(this);
        double heatTot = this.heat;
        int waterTot = this.reasimWater;
        int steamTot = this.reasimSteam;
        int index = 0;
        for (ForgeDirection forgeDirection : neighborDirs) {
            TileEntity te;
            if (this.neighborCache[index] != null && this.neighborCache[index].func_145837_r()) {
                this.neighborCache[index] = null;
            }
            if (this.neighborCache[index] == null && (te = Compat.getTileStandard(this.field_145850_b, this.field_145851_c + forgeDirection.offsetX, this.field_145848_d, this.field_145849_e + forgeDirection.offsetZ)) instanceof TileEntityRBMKBase) {
                TileEntityRBMKBase base;
                this.neighborCache[index] = base = (TileEntityRBMKBase)te;
            }
            ++index;
        }
        for (TileEntityRBMKBase tileEntityRBMKBase : this.neighborCache) {
            if (tileEntityRBMKBase == null) continue;
            rec.add(tileEntityRBMKBase);
            heatTot += tileEntityRBMKBase.heat;
            if (!reasim) continue;
            waterTot += tileEntityRBMKBase.reasimWater;
            steamTot += tileEntityRBMKBase.reasimSteam;
        }
        int n = rec.size();
        double stepSize = RBMKDials.getColumnHeatFlow(this.field_145850_b);
        if (n > 1) {
            double d = heatTot / (double)n;
            int tWater = waterTot / n;
            int rWater = waterTot % n;
            int tSteam = steamTot / n;
            int rSteam = steamTot % n;
            for (TileEntityRBMKBase rbmk : rec) {
                double delta = d - rbmk.heat;
                rbmk.heat += delta * stepSize;
                if (!reasim) continue;
                rbmk.reasimWater = tWater;
                rbmk.reasimSteam = tSteam;
            }
            if (reasim) {
                this.reasimWater += rWater;
                this.reasimSteam += rSteam;
            }
            this.func_70296_d();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        NeutronNodeWorld.removeNode(this.field_145850_b, new BlockPos(this));
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        NeutronNodeWorld.removeNode(this.field_145850_b, new BlockPos(this));
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
        }
    }

    protected void coolPassively() {
        double light;
        if ((double)TomSaveData.forWorld((World)this.field_145850_b).fire > 1.0E-5 && this.heat < 20.0 + 480.0 * (light = (double)this.field_145850_b.func_72972_b(EnumSkyBlock.Sky, this.field_145851_c, this.field_145848_d, this.field_145849_e) / 15.0)) {
            this.heat += this.passiveCooling() * 2.0;
        }
        this.heat -= this.passiveCooling();
        if (this.heat < 20.0) {
            this.heat = 20.0;
        }
    }

    public RBMKNeutronHandler.RBMKType getRBMKType() {
        return RBMKNeutronHandler.RBMKType.OTHER;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        if (!diag) {
            super.func_145839_a(nbt);
        }
        this.heat = nbt.func_74769_h("heat");
        this.reasimWater = nbt.func_74762_e("reasimWater");
        this.reasimSteam = nbt.func_74762_e("reasimSteam");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        if (!diag) {
            super.func_145841_b(nbt);
        }
        nbt.func_74780_a("heat", this.heat);
        nbt.func_74768_a("reasimWater", this.reasimWater);
        nbt.func_74768_a("reasimSteam", this.reasimSteam);
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeDouble(this.heat);
        buf.writeInt(this.reasimWater);
        buf.writeInt(this.reasimSteam);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.heat = buf.readDouble();
        this.reasimWater = buf.readInt();
        this.reasimSteam = buf.readInt();
    }

    public void getDiagData(NBTTagCompound nbt) {
        diag = true;
        this.func_145841_b(nbt);
        diag = false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void diagnosticPrintHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution resolution = event.resolution;
        RBMKBase rbmk = (RBMKBase)world.func_147439_a(x, y, z);
        int[] pos = rbmk.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntityRBMKBase te = (TileEntityRBMKBase)world.func_147438_o(pos[0], pos[1], pos[2]);
        NBTTagCompound flush = new NBTTagCompound();
        te.getDiagData(flush);
        Set keys = flush.func_150296_c();
        GL11.glPushMatrix();
        int pX = resolution.func_78326_a() / 2 + 8;
        int pZ = resolution.func_78328_b() / 2;
        ArrayList<String> exceptions = new ArrayList<String>();
        exceptions.add("x");
        exceptions.add("y");
        exceptions.add("z");
        exceptions.add("items");
        exceptions.add("id");
        exceptions.add("muffled");
        String title = "Dump of Ordered Data Diagnostic (DODD)";
        mc.field_71466_p.func_78276_b(title, pX + 1, pZ - 19, 24576);
        mc.field_71466_p.func_78276_b(title, pX, pZ - 20, 65280);
        mc.field_71466_p.func_78276_b(I18nUtil.resolveKey(rbmk.func_149739_a() + ".name", new Object[0]), pX + 1, pZ - 9, 0x606000);
        mc.field_71466_p.func_78276_b(I18nUtil.resolveKey(rbmk.func_149739_a() + ".name", new Object[0]), pX, pZ - 10, 0xFFFF00);
        Object[] ents = new String[keys.size()];
        keys.toArray(ents);
        Arrays.sort(ents);
        for (Object key : ents) {
            char lastChar;
            if (exceptions.contains(key)) continue;
            String value = flush.func_74781_a((String)key).toString();
            if (!(value.isEmpty() || (lastChar = value.charAt(value.length() - 1)) != 'd' && lastChar != 's' && lastChar != 'b')) {
                value = value.substring(0, value.length() - 1);
            }
            mc.field_71466_p.func_78276_b(I18nUtil.resolveKey("tile.rbmk.dodd." + (String)key, new Object[0]) + ": " + value, pX, pZ, 0xFFFFFF);
            pZ += 10;
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    public void onOverheat() {
        for (int i = 0; i < 4; ++i) {
            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + i, this.field_145849_e, Blocks.field_150353_l);
        }
    }

    public void onMelt(int reduce) {
        this.standardMelt(reduce);
        if (this.func_145832_p() == RBMKBase.DIR_NORMAL_LID.ordinal() + 10) {
            this.spawnDebris(EntityRBMKDebris.DebrisType.LID);
        }
    }

    protected void standardMelt(int reduce) {
        int h = RBMKDials.getColumnHeight(this.field_145850_b);
        reduce = MathHelper.func_76125_a((int)reduce, (int)1, (int)h);
        if (this.field_145850_b.field_73012_v.nextInt(3) == 0) {
            ++reduce;
        }
        for (int i = h; i >= 0; --i) {
            if (i <= h + 1 - reduce) {
                if (reduce > 1 && i == h + 1 - reduce) {
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + i, this.field_145849_e, ModBlocks.pribris_burning);
                } else {
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + i, this.field_145849_e, ModBlocks.pribris);
                }
            } else {
                this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + i, this.field_145849_e, Blocks.field_150350_a);
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d + i, this.field_145849_e);
        }
    }

    protected void spawnDebris(EntityRBMKDebris.DebrisType type) {
        EntityRBMKDebris debris = new EntityRBMKDebris(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 4.0, (double)this.field_145849_e + 0.5, type);
        debris.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * 0.25;
        debris.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * 0.25;
        debris.field_70181_x = 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 1.25;
        if (type == EntityRBMKDebris.DebrisType.LID) {
            debris.field_70159_w *= 0.5;
            debris.field_70181_x += 0.5;
            debris.field_70179_y *= 0.5;
        }
        this.field_145850_b.func_72838_d((Entity)debris);
    }

    public void meltdown() {
        RBMKBase.dropLids = false;
        columns.clear();
        pipes.clear();
        this.getFF(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int minX = this.field_145851_c;
        int maxX = this.field_145851_c;
        int minZ = this.field_145849_e;
        int maxZ = this.field_145849_e;
        for (TileEntityRBMKBase rbmk : columns) {
            if (rbmk.field_145851_c < minX) {
                minX = rbmk.field_145851_c;
            }
            if (rbmk.field_145851_c > maxX) {
                maxX = rbmk.field_145851_c;
            }
            if (rbmk.field_145849_e < minZ) {
                minZ = rbmk.field_145849_e;
            }
            if (rbmk.field_145849_e <= maxZ) continue;
            maxZ = rbmk.field_145849_e;
        }
        for (TileEntityRBMKBase rbmk : columns) {
            int distFromMinX = rbmk.field_145851_c - minX;
            int distFromMaxX = maxX - rbmk.field_145851_c;
            int distFromMinZ = rbmk.field_145849_e - minZ;
            int distFromMaxZ = maxZ - rbmk.field_145849_e;
            int minDist = Math.min(distFromMinX, Math.min(distFromMaxX, Math.min(distFromMinZ, distFromMaxZ)));
            rbmk.onMelt(minDist + 1);
        }
        for (TileEntityRBMKBase rbmk : columns) {
            if (!(rbmk instanceof TileEntityRBMKRod) || this.field_145850_b.func_147439_a(rbmk.field_145851_c, rbmk.field_145848_d, rbmk.field_145849_e) != ModBlocks.corium_block) continue;
            for (int x2 = rbmk.field_145851_c - 1; x2 <= rbmk.field_145851_c + 1; ++x2) {
                for (int y = rbmk.field_145848_d - 1; y <= rbmk.field_145848_d + 1; ++y) {
                    for (int z = rbmk.field_145849_e - 1; z <= rbmk.field_145849_e + 1; ++z) {
                        Block b = this.field_145850_b.func_147439_a(x2, y, z);
                        if (this.field_145850_b.field_73012_v.nextInt(3) != 0 || b != ModBlocks.pribris && b != ModBlocks.pribris_burning) continue;
                        if (RBMKBase.digamma) {
                            this.field_145850_b.func_147449_b(x2, y, z, ModBlocks.pribris_digamma);
                            continue;
                        }
                        this.field_145850_b.func_147449_b(x2, y, z, ModBlocks.pribris_radiating);
                    }
                }
            }
        }
        if (RBMKDials.getOverpressure(this.field_145850_b) && !pipes.isEmpty()) {
            TileEntity tile;
            HashSet pipeBlocks = new HashSet();
            HashSet pipeReceivers = new HashSet();
            pipes.forEach(x -> {
                pipeBlocks.addAll(x.links);
                pipeReceivers.addAll(x.receiverEntries.entrySet());
            });
            int max = Math.min(pipeBlocks.size() / 5, 100);
            Iterator itPipes = pipeBlocks.iterator();
            Iterator itReceivers = pipeReceivers.iterator();
            for (int count = 0; itPipes.hasNext() && count < max; ++count) {
                Object pipe = itPipes.next();
                if (!(pipe instanceof TileEntity)) continue;
                tile = (TileEntity)pipe;
                this.field_145850_b.func_147449_b(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, Blocks.field_150350_a);
            }
            while (itReceivers.hasNext()) {
                Object con = itReceivers.next();
                if (!(con instanceof TileEntity)) continue;
                tile = (TileEntity)con;
                if (con instanceof IOverpressurable) {
                    ((IOverpressurable)con).explode(this.field_145850_b, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
                    continue;
                }
                this.field_145850_b.func_147449_b(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, Blocks.field_150350_a);
                this.field_145850_b.func_72885_a(null, (double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 0.5, (double)tile.field_145849_e + 0.5, 5.0f, false, false);
            }
        }
        int smallDim = Math.min(maxX - minX, maxZ - minZ);
        int avgX = minX + (maxX - minX) / 2;
        int avgZ = minZ + (maxZ - minZ) / 2;
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "rbmkmush");
        data.func_74776_a("scale", (float)smallDim);
        PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, (double)avgX + 0.5, this.field_145848_d + 1, (double)avgZ + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)avgX + 0.5, (double)(this.field_145848_d + 1), (double)avgZ + 0.5, 250.0));
        MainRegistry.proxy.effectNT(data);
        this.field_145850_b.func_72908_a((double)avgX + 0.5, (double)(this.field_145848_d + 1), (double)avgZ + 0.5, "hbm:block.rbmk_explosion", 50.0f, 1.0f);
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5)).func_72314_b(50.0, 50.0, 50.0));
        for (EntityPlayer player : players) {
            player.func_71029_a((StatBase)MainRegistry.achRBMKBoom);
        }
        if (RBMKBase.digamma) {
            EntitySpear spear = new EntitySpear(this.field_145850_b);
            spear.field_70165_t = (double)avgX + 0.5;
            spear.field_70161_v = (double)avgZ + 0.5;
            spear.field_70163_u = this.field_145848_d + 100;
            this.field_145850_b.func_72838_d((Entity)spear);
        }
        RBMKBase.dropLids = true;
        RBMKBase.digamma = false;
    }

    private void getFF(int x, int y, int z) {
        TileEntityRBMKBase rbmk;
        TileEntity te = Compat.getTileStandard(this.field_145850_b, x, y, z);
        if (te instanceof TileEntityRBMKBase && !columns.contains(rbmk = (TileEntityRBMKBase)te)) {
            columns.add(rbmk);
            this.getFF(x + 1, y, z);
            this.getFF(x - 1, y, z);
            this.getFF(x, y, z + 1);
            this.getFF(x, y, z - 1);
        }
    }

    public boolean isModerated() {
        return false;
    }

    public abstract TileEntityRBMKConsole.ColumnType getConsoleType();

    public NBTTagCompound getNBTForConsole() {
        return null;
    }

    public static List<String> getFancyStats(NBTTagCompound nbt) {
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 17), (double)(this.field_145849_e + 1));
    }
}

