/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.storage;

import com.hbm.entity.effect.EntityCloudFleija;
import com.hbm.entity.effect.EntityNukeTorex;
import com.hbm.entity.logic.EntityBalefire;
import com.hbm.entity.logic.EntityNukeExplosionMK3;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.tileentity.IOverpressurable;
import com.hbm.tileentity.machine.storage.TileEntityBarrel;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineOrbus
extends TileEntityBarrel
implements IOverpressurable {
    protected DirPos[] conPos;
    AxisAlignedBB bb = null;

    public TileEntityMachineOrbus() {
        super(512000);
    }

    @Override
    public String getName() {
        return "container.orbus";
    }

    @Override
    public void checkFluidInteraction() {
    }

    @Override
    protected DirPos[] getConPos() {
        if (this.conPos != null) {
            return this.conPos;
        }
        this.conPos = new DirPos[8];
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        for (int i = -1; i < 6; i += 6) {
            ForgeDirection out = i == -1 ? ForgeDirection.DOWN : ForgeDirection.UP;
            int index = i == -1 ? 0 : 4;
            this.conPos[index + 0] = new DirPos(this.field_145851_c, this.field_145848_d + i, this.field_145849_e, out);
            this.conPos[index + 1] = new DirPos(this.field_145851_c + dir.offsetX, this.field_145848_d + i, this.field_145849_e + dir.offsetZ, out);
            this.conPos[index + 2] = new DirPos(this.field_145851_c + rot.offsetX, this.field_145848_d + i, this.field_145849_e + rot.offsetZ, out);
            this.conPos[index + 3] = new DirPos(this.field_145851_c + dir.offsetX + rot.offsetX, this.field_145848_d + i, this.field_145849_e + dir.offsetZ + rot.offsetZ, out);
        }
        return this.conPos;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void explode(World world, int x, int y, int z) {
        if (this.tank.getTankType() == Fluids.AMAT || this.tank.getTankType() == Fluids.ASCHRAB) {
            float amat = Math.min(this.tank.getFill() / 100, 90);
            float aschrab = Math.min(this.tank.getFill() / 100, 90);
            if (this.hasExploded && !this.field_145850_b.field_72995_K) {
                if (amat > 0.0f) {
                    if (amat >= 25.0f) {
                        EntityBalefire bf = new EntityBalefire(this.field_145850_b);
                        bf.antimatter();
                        bf.func_70107_b(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        bf.destructionRange = (int)amat;
                        this.field_145850_b.func_72838_d((Entity)bf);
                        EntityNukeTorex.startFacAnti(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, amat * 1.5f);
                        return;
                    }
                    new ExplosionVNT(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, amat).makeAmat().explode();
                }
                if (aschrab > 0.0f) {
                    EntityNukeExplosionMK3 ex = EntityNukeExplosionMK3.statFacFleija(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, (int)aschrab);
                    if (!ex.field_70128_L) {
                        this.field_145850_b.func_72838_d((Entity)ex);
                        EntityCloudFleija cloud = new EntityCloudFleija(this.field_145850_b, (int)aschrab);
                        cloud.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                        this.field_145850_b.func_72838_d((Entity)cloud);
                    }
                    return;
                }
            }
        }
        this.markChanged();
    }
}

