/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import api.hbm.fluidmk2.IFluidStandardReceiverMK2;
import com.hbm.inventory.container.ContainerPneumoTube;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIPneumoTube;
import com.hbm.lib.Library;
import com.hbm.module.ModulePatternMatcher;
import com.hbm.tileentity.IControlReceiverFilter;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.uninos.GenNode;
import com.hbm.uninos.UniNodespace;
import com.hbm.uninos.networkproviders.PneumaticNetwork;
import com.hbm.uninos.networkproviders.PneumaticNetworkProvider;
import com.hbm.util.Compat;
import com.hbm.util.EnumUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPneumoTube
extends TileEntityMachineBase
implements IGUIProvider,
IFluidStandardReceiverMK2,
IControlReceiverFilter {
    public ModulePatternMatcher pattern = new ModulePatternMatcher(15);
    public ForgeDirection insertionDir = ForgeDirection.UNKNOWN;
    public ForgeDirection ejectionDir = ForgeDirection.UNKNOWN;
    public boolean whitelist = false;
    public boolean redstone = false;
    public byte sendOrder = 0;
    public byte receiveOrder = 0;
    public int soundDelay = 0;
    public int sendCounter = 0;
    public FluidTank compair = new FluidTank(Fluids.AIR, 4000).withPressure(1);
    protected PneumaticNode node;

    public TileEntityPneumoTube() {
        super(15);
    }

    @Override
    public String getName() {
        return "container.pneumoTube";
    }

    public boolean matchesFilter(ItemStack stack) {
        for (int i = 0; i < 15; ++i) {
            ItemStack filter = this.slots[i];
            if (filter == null || !this.pattern.isValidForFilter(filter, i, stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            TileEntity tile;
            if (this.soundDelay > 0) {
                --this.soundDelay;
            }
            if (this.node == null || this.node.expired) {
                this.node = (PneumaticNode)UniNodespace.getNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PneumaticNetworkProvider.THE_PROVIDER);
                if (this.node == null || this.node.expired) {
                    this.node = (PneumaticNode)new PneumaticNode(new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e)).setConnections(new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, Library.NEG_Z));
                    UniNodespace.createNode(this.field_145850_b, this.node);
                }
            }
            if (this.isCompressor() && !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) ^ this.redstone) {
                TileEntity sendFrom;
                int randTime = Math.abs((int)(this.field_145850_b.func_82737_E() + (long)TileEntityPneumoTube.getIdentifier(this.field_145851_c, this.field_145848_d, this.field_145849_e)));
                if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        if (dir == this.insertionDir || dir == this.ejectionDir) continue;
                        this.trySubscribe(this.compair.getTankType(), this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
                    }
                }
                if (randTime % 5 == 0 && this.node != null && !this.node.expired && this.node.net != null && this.compair.getFill() >= 50 && (sendFrom = Compat.getTileStandard(this.field_145850_b, this.field_145851_c + this.insertionDir.offsetX, this.field_145848_d + this.insertionDir.offsetY, this.field_145849_e + this.insertionDir.offsetZ)) instanceof IInventory) {
                    PneumaticNetwork net = (PneumaticNetwork)this.node.net;
                    if (net.send((IInventory)sendFrom, this, this.insertionDir.getOpposite(), this.sendOrder, this.receiveOrder, TileEntityPneumoTube.getRangeFromPressure(this.compair.getPressure()), this.sendCounter)) {
                        this.compair.setFill(this.compair.getFill() - 50);
                        if (this.soundDelay <= 0 && !this.muffled) {
                            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:weapon.reload.tubeFwoomp", 0.25f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
                            this.soundDelay = 20;
                        }
                    }
                    ++this.sendCounter;
                }
            }
            if (this.isEndpoint() && this.node != null && this.node.net != null && this.field_145850_b.func_82737_E() % 10L == 0L && (tile = Compat.getTileStandard(this.field_145850_b, this.field_145851_c + this.ejectionDir.offsetX, this.field_145848_d + this.ejectionDir.offsetY, this.field_145849_e + this.ejectionDir.offsetZ)) instanceof IInventory) {
                ((PneumaticNetwork)this.node.net).addReceiver((IInventory)tile, this.ejectionDir, this);
            }
            this.networkPackNT(15);
        }
    }

    public static int getRangeFromPressure(int pressure) {
        if (pressure == 0) {
            return 0;
        }
        if (pressure == 1) {
            return 10;
        }
        if (pressure == 2) {
            return 25;
        }
        if (pressure == 3) {
            return 100;
        }
        if (pressure == 4) {
            return 250;
        }
        if (pressure == 5) {
            return 1000;
        }
        return 0;
    }

    public static int getIdentifier(int x, int y, int z) {
        return (y + z * 27644437) * 27644437 + x;
    }

    @Override
    public long getReceiverSpeed(FluidType type, int pressure) {
        return MathHelper.func_76125_a((int)((this.compair.getMaxFill() - this.compair.getFill()) / 25), (int)1, (int)100);
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != this.insertionDir && dir != this.ejectionDir && type == this.compair.getTankType() && this.isCompressor();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.node != null) {
            UniNodespace.destroyNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PneumaticNetworkProvider.THE_PROVIDER);
        }
    }

    public boolean isCompressor() {
        return this.insertionDir != ForgeDirection.UNKNOWN;
    }

    public boolean isEndpoint() {
        return this.ejectionDir != ForgeDirection.UNKNOWN;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.redstone);
        buf.writeBoolean(this.whitelist);
        buf.writeByte((int)this.sendOrder);
        buf.writeByte((int)this.receiveOrder);
        this.pattern.serialize(buf);
        this.compair.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.redstone = buf.readBoolean();
        this.whitelist = buf.readBoolean();
        this.sendOrder = buf.readByte();
        this.receiveOrder = buf.readByte();
        this.pattern.deserialize(buf);
        this.compair.deserialize(buf);
    }

    @Override
    public void nextMode(int index) {
        this.pattern.nextMode(this.field_145850_b, this.slots[index], index);
    }

    public void initPattern(ItemStack stack, int index) {
        this.pattern.initPatternSmart(this.field_145850_b, stack, index);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("insertionDir", (byte)this.insertionDir.ordinal());
        nbt.func_74774_a("ejectionDir", (byte)this.ejectionDir.ordinal());
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.insertionDir = (ForgeDirection)EnumUtil.grabEnumSafely(ForgeDirection.class, nbt.func_74771_c("insertionDir"));
        this.ejectionDir = (ForgeDirection)EnumUtil.grabEnumSafely(ForgeDirection.class, nbt.func_74771_c("ejectionDir"));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.insertionDir = (ForgeDirection)EnumUtil.grabEnumSafely(ForgeDirection.class, nbt.func_74771_c("insertionDir"));
        this.ejectionDir = (ForgeDirection)EnumUtil.grabEnumSafely(ForgeDirection.class, nbt.func_74771_c("ejectionDir"));
        this.compair.readFromNBT(nbt, "tank");
        this.pattern.readFromNBT(nbt);
        this.sendOrder = nbt.func_74771_c("sendOrder");
        this.receiveOrder = nbt.func_74771_c("receiveOrder");
        this.sendCounter = nbt.func_74762_e("sendCounter");
        this.whitelist = nbt.func_74767_n("whitelist");
        this.redstone = nbt.func_74767_n("redstone");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("insertionDir", (byte)this.insertionDir.ordinal());
        nbt.func_74774_a("ejectionDir", (byte)this.ejectionDir.ordinal());
        this.compair.writeToNBT(nbt, "tank");
        this.pattern.writeToNBT(nbt);
        nbt.func_74774_a("sendOrder", this.sendOrder);
        nbt.func_74774_a("receiveOrder", this.receiveOrder);
        nbt.func_74768_a("sendCounter", this.sendCounter);
        nbt.func_74757_a("whitelist", this.whitelist);
        nbt.func_74757_a("redstone", this.redstone);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerPneumoTube(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIPneumoTube(player.field_71071_by, this, ID == 1);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("whitelist")) {
            boolean bl = this.whitelist = !this.whitelist;
        }
        if (data.func_74764_b("redstone")) {
            boolean bl = this.redstone = !this.redstone;
        }
        if (data.func_74764_b("pressure")) {
            int pressure = this.compair.getPressure() + 1;
            if (pressure > 5) {
                pressure = 1;
            }
            this.compair.withPressure(pressure);
        }
        if (data.func_74764_b("send")) {
            this.sendOrder = (byte)(this.sendOrder + 1);
            if (this.sendOrder > 2) {
                this.sendOrder = 0;
            }
        }
        if (data.func_74764_b("receive")) {
            this.receiveOrder = (byte)(this.receiveOrder + 1);
            if (this.receiveOrder > 1) {
                this.receiveOrder = 0;
            }
        }
        if (data.func_74764_b("slot")) {
            this.setFilterContents(data);
        }
        this.func_70296_d();
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public int[] getFilterSlots() {
        return new int[]{0, 15};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.compair};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.compair};
    }

    public static class PneumaticNode
    extends GenNode<PneumaticNetwork> {
        public PneumaticNode(BlockPos ... positions) {
            super(PneumaticNetworkProvider.THE_PROVIDER, positions);
        }
    }
}

