/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import api.hbm.redstoneoverradio.IRORValueProvider;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.tileentity.network.RTTYSystem;
import com.hbm.util.BufferUtil;
import com.hbm.util.Compat;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRadioTorchReader
extends TileEntityLoadedBase
implements IControlReceiver {
    public String[] channels = new String[8];
    public String[] names = new String[8];
    public String[] prev = new String[8];
    public boolean polling = false;

    public TileEntityRadioTorchReader() {
        int i;
        for (i = 0; i < this.channels.length; ++i) {
            this.channels[i] = "";
        }
        for (i = 0; i < this.names.length; ++i) {
            this.names[i] = "";
        }
        for (i = 0; i < this.prev.length; ++i) {
            this.prev[i] = "";
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite();
            TileEntity tile = Compat.getTileStandard(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (tile instanceof IRORValueProvider) {
                IRORValueProvider prov = (IRORValueProvider)tile;
                for (int i = 0; i < 8; ++i) {
                    String value;
                    String channel = this.channels[i];
                    String name = this.names[i];
                    String previous = this.prev[i];
                    if (channel == null || channel.isEmpty() || name == null || name.isEmpty() || (value = prov.provideRORValue("VAL:" + name)) == null || !this.polling && value.equals(previous)) continue;
                    RTTYSystem.broadcast(this.field_145850_b, channel, value);
                    this.prev[i] = value;
                }
            }
            this.networkPackNT(50);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        int i;
        buf.writeBoolean(this.polling);
        for (i = 0; i < this.channels.length; ++i) {
            BufferUtil.writeString(buf, this.channels[i]);
        }
        for (i = 0; i < this.names.length; ++i) {
            BufferUtil.writeString(buf, this.names[i]);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        int i;
        this.polling = buf.readBoolean();
        for (i = 0; i < this.channels.length; ++i) {
            this.channels[i] = BufferUtil.readString(buf);
        }
        for (i = 0; i < this.names.length; ++i) {
            this.names[i] = BufferUtil.readString(buf);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        int i;
        super.func_145839_a(nbt);
        this.polling = nbt.func_74767_n("p");
        for (i = 0; i < this.channels.length; ++i) {
            this.channels[i] = nbt.func_74779_i("c" + i);
        }
        for (i = 0; i < this.names.length; ++i) {
            this.names[i] = nbt.func_74779_i("n" + i);
        }
        for (i = 0; i < this.prev.length; ++i) {
            this.prev[i] = nbt.func_74779_i("p" + i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        int i;
        super.func_145841_b(nbt);
        nbt.func_74757_a("p", this.polling);
        for (i = 0; i < this.channels.length; ++i) {
            nbt.func_74778_a("c" + i, this.channels[i]);
        }
        for (i = 0; i < this.names.length; ++i) {
            nbt.func_74778_a("n" + i, this.names[i]);
        }
        for (i = 0; i < this.prev.length; ++i) {
            nbt.func_74778_a("p" + i, this.prev[i]);
        }
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        int i;
        if (data.func_74764_b("p")) {
            this.polling = data.func_74767_n("p");
        }
        for (i = 0; i < this.channels.length; ++i) {
            if (!data.func_74764_b("c" + i)) continue;
            this.channels[i] = data.func_74779_i("c" + i);
        }
        for (i = 0; i < this.names.length; ++i) {
            if (!data.func_74764_b("n" + i)) continue;
            this.names[i] = data.func_74779_i("n" + i);
        }
        this.func_70296_d();
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 16.0;
    }
}

