/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PrivateKeyFileResource;
import net.schmizz.sshj.userauth.password.PrivateKeyReaderResource;
import net.schmizz.sshj.userauth.password.PrivateKeyStringResource;
import net.schmizz.sshj.userauth.password.Resource;

public abstract class BaseFileKeyProvider
implements FileKeyProvider {
    protected Resource<?> resource;
    protected PasswordFinder pwdf;
    protected KeyPair kp;
    protected KeyType type;

    @Override
    public void init(Reader location) {
        this.init(location, (PasswordFinder)null);
    }

    @Override
    public void init(Reader location, PasswordFinder pwdf) {
        this.init(location, null, pwdf);
    }

    @Override
    public void init(Reader privateKey, Reader publicKey) {
        this.init(privateKey, publicKey, null);
    }

    @Override
    public void init(Reader privateKey, Reader publicKey, PasswordFinder pwdf) {
        assert (publicKey == null);
        this.resource = new PrivateKeyReaderResource(privateKey);
        this.pwdf = pwdf;
    }

    @Override
    public void init(File location) {
        this.init(location, null);
    }

    @Override
    public void init(File location, PasswordFinder pwdf) {
        this.resource = new PrivateKeyFileResource(location.getAbsoluteFile());
        this.pwdf = pwdf;
    }

    @Override
    public void init(String privateKey, String publicKey) {
        this.init(privateKey, publicKey, null);
    }

    @Override
    public void init(String privateKey, String publicKey, PasswordFinder pwdf) {
        assert (privateKey != null);
        assert (publicKey == null);
        this.resource = new PrivateKeyStringResource(privateKey);
        this.pwdf = pwdf;
    }

    @Override
    public PrivateKey getPrivate() throws IOException {
        PrivateKey privateKey;
        if (this.kp != null) {
            privateKey = this.kp.getPrivate();
        } else {
            this.kp = this.readKeyPair();
            privateKey = this.kp.getPrivate();
        }
        return privateKey;
    }

    @Override
    public PublicKey getPublic() throws IOException {
        PublicKey publicKey;
        if (this.kp != null) {
            publicKey = this.kp.getPublic();
        } else {
            this.kp = this.readKeyPair();
            publicKey = this.kp.getPublic();
        }
        return publicKey;
    }

    @Override
    public KeyType getType() throws IOException {
        return this.type != null ? this.type : (this.type = KeyType.fromKey(this.getPublic()));
    }

    protected abstract KeyPair readKeyPair() throws IOException;
}

