/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.wmi.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.wmi.model.WMIClass;
import org.jkiss.dbeaver.ext.wmi.model.WMIClassElement;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;
import org.jkiss.wmi.service.WMIException;
import org.jkiss.wmi.service.WMIObjectAttribute;

public class WMIClassAttribute
extends WMIClassElement<WMIObjectAttribute>
implements DBSEntityAttribute,
DBPImageProvider {
    private static final Log log = Log.getLog(WMIClassAttribute.class);

    protected WMIClassAttribute(WMIClass wmiClass, WMIObjectAttribute attribute) {
        super(wmiClass, attribute);
    }

    @Property(viewable=true, order=10)
    @NotNull
    public String getTypeName() {
        return ((WMIObjectAttribute)this.element).getTypeName();
    }

    @NotNull
    public String getFullTypeName() {
        return DBUtils.getFullTypeName((DBSTypedObject)this);
    }

    public int getTypeID() {
        return ((WMIObjectAttribute)this.element).getType();
    }

    @NotNull
    public DBPDataKind getDataKind() {
        return WMIClassAttribute.getDataKindById(((WMIObjectAttribute)this.element).getType());
    }

    @Nullable
    public Integer getScale() {
        return 0;
    }

    @Nullable
    public Integer getPrecision() {
        return 0;
    }

    public long getMaxLength() {
        try {
            Object maxLengthQ = this.getQualifiedObject().getQualifier("MaxLen");
            if (maxLengthQ instanceof Number) {
                return ((Number)maxLengthQ).longValue();
            }
        }
        catch (WMIException e) {
            log.warn((Object)e);
        }
        return 0L;
    }

    public long getTypeModifiers() {
        return 0L;
    }

    public boolean isRequired() {
        return false;
    }

    public boolean isAutoGenerated() {
        return false;
    }

    public int getOrdinalPosition() {
        return 0;
    }

    public boolean isKey() throws DBException {
        return this.getFlagQualifier("Key") || this.getFlagQualifier("CIM_Key");
    }

    @Property(viewable=true, order=20)
    public String getDefaultValue() {
        return CommonUtils.toString((Object)((WMIObjectAttribute)this.element).getValue());
    }

    @Nullable
    public DBPImage getObjectImage() {
        return WMIClassAttribute.getPropertyImage(((WMIObjectAttribute)this.element).getType());
    }

    public static DBPImage getPropertyImage(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return DBIcon.TYPE_NUMBER;
            }
            case 11: {
                return DBIcon.TYPE_BOOLEAN;
            }
            case 8: 
            case 103: {
                return DBIcon.TYPE_STRING;
            }
            case 101: {
                return DBIcon.TYPE_DATETIME;
            }
        }
        return DBIcon.TYPE_UNKNOWN;
    }

    public static DBPDataKind getDataKindById(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return DBPDataKind.NUMERIC;
            }
            case 11: {
                return DBPDataKind.BOOLEAN;
            }
            case 8: 
            case 103: {
                return DBPDataKind.STRING;
            }
            case 101: {
                return DBPDataKind.DATETIME;
            }
        }
        return DBPDataKind.OBJECT;
    }
}

