--*********************************************************************************

cog_x = 0.0
cog_y = 1.46238
cog_z = 0.0

dofile(current_mod_path .. "/default_radio_presets.lua")
local radio_presets = get_default_radio_presets()

local _MainRotorPos	=	{ 0.015185, 2.17548, 0 }		-- [m] Main rotor hub position (3D model center of hub)
local _TailRotorPos	=	{ -4.60074, 1.4844, -0.3946 }	-- [m] Tail rotor hub position (3D model center of hub)
local _ExhstNozzPos	=	{ -1.88, 0.790, 0.0 }			-- [m] Origin of exhaust heat blur, smoke trail, and other effects
local _CG 			= 	{ cog_x, cog_y, cog_z }			-- [m] CG w.r.t. EDM 3D mesh origin in TsAGI order
local _MOI			=	{ 600, 1980, 2450, -128 }		-- [kg*m^2] {Roll, Yaw, Pitch, POI} Empty AH-6J/MH-6J

local function merge_table(a,b)
	for i = 1, #b do
    	table.insert(a, b[i])
	end
end

local function combine_tables(a,b)
	res = {}
	for i = 1, #a do
    	table.insert(res, a[i])
	end
	for i = 1, #b do
    	table.insert(res, b[i])
	end
	return res
end

local F_DOORS = 1
local R_DOORS = 2

local L_OUT = 9
local L_IN = 10
local R_IN = 11
local R_OUT = 12

local m260offset_r = { 0.04, -0.06, 0 }
local m260offset_out = { -0.05, -0.07, 0 }
local m261offset_out = { -0.07, -0.16, 0 }

local m299offset = { 0.15, 0.00, 0 }
local hmpoffset = { 0.15, 0.05, 0 }


local removed_doors = {
	{ station = F_DOORS, loadout = { "<CLEAN>" } },
}

local installed_backdoors = {
	{ station = R_DOORS, loadout = { "{AH-6_DOORS}" } }, -- Back Doors
}
-- required for removing plank
local CLEAN_L_OUT = {
	{ station = R_OUT, loadout = { "<CLEAN>" } },
}

local CLEAN_R_OUT = {
	{ station = L_OUT, loadout = { "<CLEAN>" } },
}

local CLEAN_R_IN = {
	{ station = L_IN,  loadout = { "<CLEAN>" } },
	{ station = L_OUT, loadout = { "<CLEAN>" } },
	{ station = R_OUT, loadout = { "<CLEAN>" } },
}


local CLEAN_L_IN = {
	{ station = R_IN,  loadout = { "<CLEAN>" } },
	{ station = L_OUT, loadout = { "<CLEAN>" } },
	{ station = R_OUT, loadout = { "<CLEAN>" } },
}


local CLEAN_IN_OUT = {
	{ station = R_IN,  loadout = { "<CLEAN>" } },
	{ station = L_OUT, loadout = { "<CLEAN>" } },
	{ station = R_OUT, loadout = { "<CLEAN>" } },
	{ station = L_IN,  loadout = { "<CLEAN>" } },	
}

-- forbidden for using plank
local PYLON_L_OUT = {
	{ station = R_OUT,   loadout = { "<CLEAN>" } },
	{ station = R_DOORS, loadout = { "{AH-6_DOORS}" } },
}
local PYLON_R_OUT = { -- R_OUT
	{ station = L_OUT,   loadout = { "<CLEAN>" } },
	{ station = R_DOORS, loadout = { "{AH-6_DOORS}" } },
}

local PYLON_L_IN = { -- L_IN
	{ station = R_IN,    loadout = { "<CLEAN>" } },
	{ station = R_DOORS, loadout = { "{AH-6_DOORS}" } },
}
local PYLON_R_IN = { -- R_IN
	{ station = L_IN,    loadout = { "<CLEAN>" } },
	{ station = R_DOORS, loadout = { "{AH-6_DOORS}" } },
}

--clean plank
local CLEAN_PLANK = {
	{ station = R_IN,  loadout = { "<CLEAN>" } },
	{ station = L_OUT, loadout = { "<CLEAN>" } },
	{ station = R_OUT, loadout = { "<CLEAN>" } },
	{ station = L_IN,  loadout = { "<CLEAN>" } },
}


function common_xh_6(name, displayname)
	local XH6 = {
	Name = name,
	Picture                  = 'OH-6.png',
	DisplayName = displayname,
	date_of_introduction	 = 1989.12,
	country_of_origin		 = "USA",
	

	shape_table_data         = 
	{
		{
			file     = 'AH-6J',
			desrt    = 'AH-6J',
			index    = WSTYPE_PLACEHOLDER,
			life     = 6, --   The strength of the object (ie. lifebar *)
			vis      = 3, -- Visibility factor (For a small objects is better to put lower nr).
			fire     = { 300, 2 }, -- Fire on the ground after destoyed: 300sec 4m
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
		},
		{
			name = "AH-6J",
			file = "AH-6J",
			fire = { 240, 2 },
		},
	},

	InternalCargo =
		{
			nominalCapacity = 400,
			maximalCapacity = 500,

			para_unit_point = 4,
			unit_point 	  = 4,
			area 	  	  = {1.2, 1.4, 1.5},-- cargo bay dimensions (lenght, width, height)
			far_wall_pos  = {0.43,0.33,0}, -- coordinates on  point on corner of floor and centerline of far wall , together with area  it will give  geometry of cargo compartment in BCS
			out_door =
			{
				cargo_generic =
				{
					large = true, x = 0, z = 0, heading = math.rad(90),
					mechanicals =
					{
						close = {"CargoBayGates", "Close"},
						board = {"CargoBayGates", "Open"},
						boardable = {{mechanism = "CargoBayGates", states = {"Open"}}, {mechanism = "CargoBayGate0", states = {"Open"}},},
					},
				},
			},
		},

	mapclasskey              = "P0091000021",
	attribute                = { wsType_Air, wsType_Helicopter, wsType_Battleplane, WSTYPE_PLACEHOLDER,
		"Attack helicopters", "Transport helicopters",},
	Categories               = { "Helicopter", },
	Rate                     = 30, -- RewardPoint in Multiplayer
	Countries                = { "USA" },
	-------------- Aircraft Physical properties -----------
	length                   = 10.0, -- meters
	height                   = 3.0, -- meters
	rotor_RPM                = 470,					-- [rpm] Main rotor RPM (positive: CCW looking from above; negative is CW)
	M_empty                  = 897, --998, --kg 897-40 for doors
	M_nominal                = 1089, --kg
	M_max                    = 1792, --kg		
	M_fuel_max               = 181, -- kg	

	average_fuel_consumption = 0.3,
	tanker_type              = 0,
	RCS                      = 3, -- Radar Cross Section m^2
	IR_emission_coeff        = 0.3, -- 1 is IR emission of Su-27

	------------------ AI defs ------------------------------	
	tail_rotor_RPM			 = 2848, 				-- [rpm] Tail rotor RPM (positive: CCW looking from port side; negative is CW)
	V_max                    = 282,					-- [kph] (approx 152 kts - Vne)
	V_max_cruise             = 250,					-- [kph] (approx 135 kts)
	Vy_max                   = 10.47,				-- [m/s] Max climb speed
	H_stat_max_L             = 5600,				-- [m] Hover OGE (Lightweight)
	H_stat_max               = 3350,				-- [m] Hover OGE (Max weight)
	H_max                    = 5700, 				-- [m] Max operation height
	H_din_two_eng            = 5700,				-- [m] Service Ceiling (18,300 ft)
	H_din_one_eng            = 5700,				-- [m] Same as above (Single Engine aircraft)
	range                    = 430,					-- [km] Ferry range on internal tanks & clean (232 nmi)
	flight_time_typical      = 120,					-- [min] Flight time with internal fuel
	flight_time_maximum      = 240,					-- [min] With Rovertson Aux Fuel Tanks
	Vy_land_max              = 3.05,				-- [m/s] Max vertical landing speed: 10 ft/sec
	Ny_max                   = 3.5,					-- [G] Max load factor
	Sensors                  = {					-- Defines what the AI can use in terms of sensors
		RWR = "Abstract RWR"						-- A/MH-6J didn't carry RWR, but required for AI to detect incoming IR missiles
	},
	radar_can_see_ground	 = true,				-- [bool] Sensors/eyeballs can/cannot see enemy surface entities (tanks, ships)
	detection_range_max		 = 15,					-- [km] How far this aircraft's sensors can possibly detect something (determines absolute maximum SA range)
	CanopyGeometry           = {
		azimuth   = { -140.0, 140.0 },				-- crew horizontal view (AI) (-180 to +180)
		elevation = { -50.0, 90.0 }					-- crew vertical view (AI) (-90 to +90)
	},
	-------------------------------------------------------------------		
	nose_gear_pos            = { -0.423371 + cog_x, -0.504654 - 0 * cog_y, 0.0 }, -- used for starting placement on ground {forward/back,up/down,left/right}
	main_gear_pos            = { 1.61942 + cog_x, -0.619909 - 0 * cog_y, 1.0 },
	---------------------- unknown
	---------------------- unknown ---------------------------------------------
	lead_stock_main          = -0.10,				-- [m] Fore oleo-damped strut compression (negative means it's a skid)
	lead_stock_support       = -0.10,				-- [m] Aft oleo-damped strut compression (negative means it's a skid)
	scheme                   = 0,					-- [enum] "Regular" main rotor/tail rotor helicopter modeling scheme
	fire_rate                = 0,
	cannon_sight_type        = 2,
	------------ AI flight model probably (doesnt affect human FM)---------------
	rotor_height             = _MainRotorPos[2],	-- [m] Front hub height in the 3D model itself, in its TsAGI coordinate frame (not from the ground!)
	rotor_diameter           = 8.38,				-- [m] Main rotor diameter (27 ft 6 in)
	blade_chord              = 0.1715,				-- [m] Main rotor blade chord (6.75 inches)
	blades_number            = 5,					-- [#] Number of blades on the main rotor (A/MH-6M has 6 blades)
	blade_area               = 0.719,				-- [m^2] The area of each blade (approx. blade chord * blade radius)
	fuselage_Cxa0            = 0.32,				-- [coeff] 0 degree AoA drag coefficient (Forward drag - C_x)
	fuselage_Cxa90           = 1.20,				-- [coeff] 90 degree AoA drag coefficient (Vertical drag - C_y)
	fuselage_area            = 1.60,				-- [m^2] Frontal Reference Area (S_ref)
	centering                = -0.14,				-- [deg] Pitch offset (magic number to tune pitch behavior)
	tail_pos                 = _TailRotorPos,		-- [m] Tail rotor hub position (3D model center of hub)
	tail_fin_area            = 0.68,				-- [m^2] Vertical stabilizer area
	tail_stab_area           = 0.76,				-- [m^2] Horizontal stabilizer area
	thrust_correction        = 0.76,				-- Rotor efficiency factor (Figure of Merit)
	rotor_MOI                = 315,					-- [kg*m^2] Rotor total moment of inertia (not per blade)
	rotor_pos                = _MainRotorPos,		-- [m] Main rotor hub position (3D model center of hub)
	MOI						 = _MOI, 				-- [kg*m^2] {Roll, Yaw, Pitch, POI}
	center_of_mass			 = _CG, 				-- [m] CG w.r.t. EDM 3D mesh origin in TsAGI coordinate order
	sounderName              = "Aircraft/Planes/AH6",
	--sound_name               = "External/oh6_ExteriorRotor",
	sound_name               = "External/oh6_Silent",
	helicopter_hook_pos		 = { 0.018, 0.008, 0 },	-- [m] Hook/fuselage attachment point

	engines_count            = 2,					-- [#] A/MH-6J is single engine
	engines_nozzles          = {
		{
			pos             	= _ExhstNozzPos,	-- Heat blur origin
			elevation 			= -5.0,				-- [deg] Exhaust plume depressed 5 degrees w.r.t. horizon
			azimuth				= 10.0,				-- [deg] +90 degrees is perpendicular to the longitudinal axis and parallel to the ground (left engine)
			diameter        	= 0.32,
			exhaust_length_ab 	= 1.3,				-- [m] Exhaust blur length
			smokiness_level 	= 0.01,
			engine_number   	= 1,
		},
		{
			pos             	= _ExhstNozzPos,	-- Heat blur origin
			elevation 			= -5.0,				-- [deg] Exhaust plume depressed 5 degrees w.r.t. horizon
			azimuth				= -10.0,			-- [deg] -90 degrees is perpendicular to the longitudinal axis and parallel to the ground (right engine)
			diameter        	= 0.32,
			exhaust_length_ab 	= 1.3,				-- [m] Exhaust blur length
			smokiness_level 	= 0.01,
			engine_number   	= 1,
		},
	},
	
	cargo_max_weight		 = 907,					-- [kg] Operational external load limit (approx 2,000 lbs)
	cargo_radius_in_menu	 = 2000,				-- [m] Distance limit for cargo to show up in menu
	h_max_gear_hook			 = 2.4,					-- [m] How far the hook has to be to automatically "capture" load

	crew_size                = 2,
	crew_members             =
	{
		[1] =
		{
			ejection_seat_name = 0,
			drop_canopy_name   = 0,
			pos                = { 1.3, 1.0, 1.5 },
			ejection_order     = 1,
			can_be_playable    = true,
			role               = "pilot",
			role_display_name  = _("Pilot"),
			canopy_arg         = 38,
			pilot_name         = "pilot_ah64",
		},
		[2] =
		{
			ejection_seat_name = 0,
			drop_canopy_name   = 0,
			pos                = { 1.3, 1.0, -1.5 },
			ejection_order     = 2,
			can_be_playable    = true,
			role               = "instructor",
			role_display_name  = _("Instructor pilot"),
			canopy_arg         = 38,
			pilot_name         = "pilot_ah64",
		},
	},

	fires_pos                =
	{
		[1] = { -1.87641, 0.790134, 0.0 }, -- turbine exit
	},

	Guns                     = {

	},

	

	Tasks                    = { -- defined in db_units_planes.lua
		aircraft_task(Transport), --31
		aircraft_task(Reconnaissance),
		aircraft_task(CAP),
		aircraft_task(CAS),
		aircraft_task(GroundAttack),
	},
	DefaultTask              = aircraft_task(Reconnaissance),


	passivCounterm =
	{
		CMDS_Edit = true,
		SingleChargeTotal = 30,
		flare = { default = 30, increment = 30, chargeSz = 1 },
		chaff = { default = 0, increment = 30, chargeSz = 1 },
	},

	chaff_flare_dispenser =
	{
		--{ dir =  {Z, Y, X}, pos =  {Z, Y, X}, }  -- Z=back/fwd,Y=down/up, X=left/right
		[1] = { dir = { 0.956935, -0.2903036, 0 }, pos = { 0.050, -0.216716, 0 }, },
	},


	LandRWCategories = -- adds these takeoff and landing options avaliable in mission editor
	{
		[1] =
		{
			Name = "HelicopterCarrier",
		},
		[2] =
		{
			Name = "AircraftCarrier",
		},
	},
	TakeOffRWCategories =
	{
		[1] =
		{
			Name = "HelicopterCarrier",
		},
		[2] =
		{
			Name = "AircraftCarrier",
		},
	},

	Damage = verbose_to_dmg_properties( --index meaning see in Scripts\Aircrafts\_Common\Damage.lua
		{
			-- deps_cells defines what other parts get destroyed along with it
			["ROTOR"]          = {
				critical_damage = 2.5,
				args = { 419 },                                    --63
				deps_cells = { "BLADE_1_IN", "BLADE_2_IN", "BLADE_3_IN", "BLADE_4_IN","BLADE_4_IN" }
			},                                                     -- 64
			["BLADE_1_IN"]     = { critical_damage = 0.5, args = { 420 } }, -- 64
			["BLADE_2_IN"]     = { critical_damage = 0.5, args = { 421 } }, -- 67
			["BLADE_3_IN"]     = { critical_damage = 0.5, args = { 422 } }, -- 70
			["BLADE_4_IN"]     = { critical_damage = 0.5, args = { 423 } }, -- 73
			["BLADE_5_IN"]     = { critical_damage = 0.5, args = { 428 } }, -- 76

			["BLADE_6_IN"]     = { critical_damage = 0.5, args = { 424 } }, -- 79 Tailrotor

			["STABILIZATOR_L"] = { critical_damage = 0.5, args = { 426 },},
			["ELEVATOR_L_OUT"] = { critical_damage = 0.5, args = { 425 },deps_cell = {"STABILIZATOR_L"}}, -- 49
				--deps_cell = {"ELEVATOR_L_OUT"}}, -- 47
			


			["WHEEL_L"] = { critical_damage = 1, args = { 430 }, deps_cells = { "AIR_BRAKE_L", "Line_STABIL_L" } }, -- 84
			["AIR_BRAKE_L"] = { critical_damage = 1, args = { 430 } },
			["Line_STABIL_L"] = { critical_damage = 1, args = { 430 } },

			["WHEEL_R"] = { critical_damage = 1, args = { 431 }, deps_cells = { "AIR_BRAKE_R", "Line_STABIL_R" } }, --85
			["AIR_BRAKE_R"] = { critical_damage = 1, args = { 431 } },
			["Line_STABIL_R"] = { critical_damage = 1, args = { 431 } },

			["FUEL_TANK_F"] = { critical_damage = 1, args = { 477 } }, --61

			["CABIN_BOTTOM"] = { critical_damage = 0.5, args = { 472 } }, --6
			["CABIN_LEFT_SIDE"] = { critical_damage = 0.5, args = { 471 } }, --4
			["CABIN_RIGHT_SIDE"] = { critical_damage = 0.5, args = { 470 } }, --5

			["ELERON_L"] = { critical_damage = 1, args = { 475 } },   --25
			["ELERON_R"] = { critical_damage = 1, args = { 476 } },   --26
			["ENGINE"] = { critical_damage = 1, args = { 483 } },     --11
			["FLAP_L_OUT"] = { critical_damage = 1, args = { -1 } },  --31
			["FLAP_R_OUT"] = { critical_damage = 1, args = { -1 } },  --32

			
			["FUSELAGE_LEFT_SIDE"] = { critical_damage = 1, args = { 479 } }, --9
			["FUSELAGE_RIGHT_SIDE"] = { critical_damage = 1, args = { 480 } }, --10
			["NOSE_LEFT_SIDE"] = { critical_damage = 1, args = { 473 } }, --1
			["NOSE_RIGHT_SIDE"] = { critical_damage = 1, args = { 474 } }, --2
			["LEFT_GEAR_BOX"] = { critical_damage = 1, args = { 482 } }, --15
			["RIGHT_GEAR_BOX"] = { critical_damage = 1, args = { 481 } }, --16
			["TAIL_LEFT_SIDE"] = { critical_damage = 1, args = { -1 } }, --56
			["TAIL_RIGHT_SIDE"] = { critical_damage = 1, args = { -1 } }, --57
			["WING_L_PART_IN"] = { critical_damage = 1, args = { -1 } }, --33
			["WING_R_PART_IN"] = { critical_damage = 1, args = { -1 } }, --34
			["COCKPIT_Line"] = { critical_damage = 1, args = { -1 } },


			["FUEL_TANK_B"] = { critical_damage = 2, args = { -1 } }, -- 62
			["ENGINE_1"] = { critical_damage = 2, args = { -1 } }, -- 103
			["FRONT_GEAR_BOX"] = { critical_damage = 2, args = { -1 } }, -- 8


			["COCKPIT"] = { critical_damage = 1, args = { 65 } },    -- 3

			["CREW_1"] = { critical_damage = 1, deps_cells = { "COCKPIT" } }, --90
			["CREW_2"] = { critical_damage = 1, deps_cells = { "COCKPIT" } }, --91

		}),

	Failures = {
	},

	DamageParts = { -- parts that fall off when aircraft is hit or crashes

	},
	lights_data = {
	},


	net_animation = { --transmits draw arguments over multiplyer for others to see
		
	},

	--sound_name = "Rotor", -- rotor sound from Sounds/sdef
	
	engine_data =
	{
		power_take_off    = 485/2,                -- [kW] Max takeoff power (5-min limit)
		power_WEP        = 522/2,                -- [kW] Emergency power (transmission limited)
		power_max        = 415/2,                -- [kW] Max continuous power
		
		power_TH_k = {
			[1] = { 2.50/2, -56.00/2, 485.0/2 },    -- [coeffs] Max Takeoff (5 min limit) - Thermodynamic Limit: 650 SHP
			[2] = { 2.70/2, -60.00/2, 522.0/2 },    -- [coeffs] Emergency (2.5 min limit) - Thermodynamic Limit: 700 SHP
			[3] = { 2.10/2, -47.60/2, 415.0/2 },    -- [coeffs] Max Continuous - Thermodynamic Limit: 557 SHP
			[4] = { 1.70/2, -38.50/2, 335.0/2 },    -- [coeffs] Typical cruise power setting (~75-80% of Continuous)
		},
		
		SFC_k =     {0/2,    -0.0003171/2,    0.512/2},    -- [coeffs] SFC curve: SFC [kg/kWh] vs. power [kW]
		power_RPM_k = { -0.08639, 0.24277, 0.84175 },	-- [coeffs] Power Turbine (N2/Np) Efficiency Curve
		power_RPM_min 	= 15,				-- [%] A/MH-6J rotor starts turning as engine passes up through 12-15% RPM
		sound_name = "External/oh6_Silent",
		-- sound_name = "Aircrafts/Engines/OH58DEngine",	-- Same engine
		
		Nmg_Ready		= 82,				-- [%] Flight idle Ng RPM
	},
	
	SFM_Data = {
		engine = {
			type 		= "TurboShaft",
			name 		= "T703-AD-700",			-- Engine model (DCS mostly doesn't care)
			typeng 		= 5,						-- Enumeration for turboshaft engines


			Nmg     	= 64.0,						-- Ground idle Ng or N1 RPM (%)
			Nominal_RPM = 50970.0,					-- 100% speed for Ng or N1 (gas generator turbine)
			-- Nominal_Fan_RPM = 6000.0,				-- Engine output shaft feeds directly into the main transmission
		
			MinRUD  	= 0, 						-- Min state of the throttle
			MaxRUD  	= 1, 						-- Max state of the throttle
			MaksRUD 	= 1, 						-- Military power state of the throttle
			ForsRUD 	= 1, 						-- Afterburner state of the throttle
		}, -- end of engine
	},


	HumanRadio = {
		frequency = 262.0,
		editable = true,
		minFrequency = 30,
		maxFrequency = 399.975,
		rangeFrequency = {
			{min = 30.0,  max = 87.975,  modulation	= MODULATION_FM},	-- AN/ARC-201 (SINCGARS) (30  - 87.975 MHz)
			{min = 108.0, max = 135.995, modulation	= MODULATION_AM},	-- AN/ARC-186 (108 - 151.975 MHz)
			{min = 136.0, max = 151.975,								-- AN/ARC-186 (108 - 151.975 MHz)
				modulation	  = MODULATION_AM_AND_FM,
				modulationDef = MODULATION_FM,
			},
			{min = 225.0, max = 399.975, modulation	= MODULATION_AM}	-- AN/ARC-164 (225 - 399.975 MHz)
		},
		modulation = MODULATION_AM
	},
	panelRadio =
	{
		[1] =
		{
			name = _("AN/ARC-186"), -- 225.000 to 399.975 MHz AM
			range =
			{
				{ min = 108.0, max = 155.0 }
			},
			channels =
			{
				[1] =  { name = _("Channel 1"),  default = radio_presets[1][1] }, -- Kobuleti ATC
				[2] =  { name = _("Channel 2"),  default = radio_presets[1][2] }, -- Ground Control Approach
				[3] =  { name = _("Channel 3"),  default = radio_presets[1][3] }, -- Gudauta ATC
				[4] =  { name = _("Channel 4"),  default = radio_presets[1][4] }, 	-- Tblisi - Soganiug ATC
				[5] =  { name = _("Channel 5"),  default = radio_presets[1][5] }, 	-- Vazinai ATC
				[6] =  { name = _("Channel 6"),  default = radio_presets[1][6] }, 	-- Kutaisi - Kopitnari ATC
				[7] =  { name = _("Channel 7"),  default = radio_presets[1][7] }, 	-- Senaki-Koikhi ATC
				[8] =  { name = _("Channel 8"),  default = radio_presets[1][8] }, 	-- Batumi ATC
				[9] =  { name = _("Channel 9"),  default = radio_presets[1][9] }, 	-- Sukhumi - Babushara
				[10] = { name = _("Channel 10"), default = radio_presets[1][10] },	-- Tiblisi - Lochini ATC
				[11] = { name = _("Channel 11"), default = radio_presets[1][11] },	-- Anapa ATC
				[12] = { name = _("Channel 12"), default = radio_presets[1][12] },	-- Gelendzhik ATC
				[13] = { name = _("Channel 13"), default = radio_presets[1][13] },	-- Maykop - Khanskaya ATC
				[14] = { name = _("Channel 14"), default = radio_presets[1][14] },	-- Krasnodar-Pashkovsky ATC
				[15] = { name = _("Channel 15"), default = radio_presets[1][15] }, -- Novorossiysk ATC
				[16] = { name = _("Channel 16"), default = radio_presets[1][16] }, -- Krymsk ATC
				[17] = { name = _("Channel 17"), default = radio_presets[1][17] }, -- Mineralnye Vody ATC
				[18] = { name = _("Channel 18"), default = radio_presets[1][18] }, -- Nalchik ATC
				[19] = { name = _("Channel 19"), default = radio_presets[1][19] }, -- Beslan ATC
				[20] = { name = _("Channel 20"), default = radio_presets[1][20] }, -- Sochi Adler ATC
			},
		},
		[2] =
		{
			name = _("AN/ARC-182"), -- 225.000 to 399.975 MHz AM
			range =
			{
				{ min = 225.0, max = 399.975 }
			},
			channels =
			{
				[1] =  { name = _("Channel 1"),  default = radio_presets[2][1] }, -- mineralnye-vody (URMM) : 264.0
				[2] =  { name = _("Channel 2"),  default = radio_presets[2][2] }, -- nalchik (URMN) : 265.0
				[3] =  { name = _("Channel 3"),  default = radio_presets[2][3] }, -- sochi-adler (URSS) : 256.0
				[4] =  { name = _("Channel 4"),  default = radio_presets[2][4] }, -- maykop-khanskaya (URKH), nellis (KLSV) : 254.0
				[5] =  { name = _("Channel 5"),  default = radio_presets[2][5] }, -- anapa (URKA) : 250.0
				[6] =  { name = _("Channel 6"),  default = radio_presets[2][6] }, -- beslan (URMO) : 270.0
				[7] =  { name = _("Channel 7"),  default = radio_presets[2][7] }, -- krasnodar-pashkovsky (URKK) : 257.0
				[8] =  { name = _("Channel 8"),  default = radio_presets[2][8] }, -- sukhumi-babushara (UGSS) : 255.0
				[9] =  { name = _("Channel 9"),  default = radio_presets[2][9] }, -- kobuleti (UG5X) : 262.0
				[10] = { name = _("Channel 10"), default = radio_presets[2][10] }, -- gudauta (UG23) : 259.0
				[11] = { name = _("Channel 11"), default = radio_presets[2][11] }, -- tbilisi-soganlug (UG24) : 268.0
				[12] = { name = _("Channel 12"), default = radio_presets[2][12] }, -- tbilisi-vaziani (UG27) : 269.0
				[13] = { name = _("Channel 13"), default = radio_presets[2][13] }, -- batumi (UGSB) : 260.0
				[14] = { name = _("Channel 14"), default = radio_presets[2][14] }, -- kutaisi-kopitnari (UGKO) : 263.0
				[15] = { name = _("Channel 15"), default = radio_presets[2][15] }, -- senaki-kolkhi (UGKS) :  261.0
				[16] = { name = _("Channel 16"), default = radio_presets[2][16] }, -- tbilisi-lochini (UGTB) : 267.0
				[17] = { name = _("Channel 17"), default = radio_presets[2][17] }, -- krasnodar-center (URKI), creech (KINS) : 251.0
				[18] = { name = _("Channel 18"), default = radio_presets[2][18] }, -- krymsk (URKW), mccarran (KLAS) : 253.0
				[19] = { name = _("Channel 19"), default = radio_presets[2][19] }, -- mozdok (XRMF) : 266.0
				[20] = { name = _("Channel 20"), default = radio_presets[2][20] }, -- N/A, groom lake/homey (KXTA) : 252.0
			},
		},
		[3] =
		{
			name = _("AN/ARC-210"), -- 225.000 to 399.975 MHz AM
			range =
			{
				{ min = 225.0, max = 399.975 }
			},
			channels =
			{
				[1] =  { name = _("Channel 1"),  default = radio_presets[3][1] }, -- mineralnye-vody (URMM) : 264.0
				[2] =  { name = _("Channel 2"),  default = radio_presets[3][2] }, -- nalchik (URMN) : 265.0
				[3] =  { name = _("Channel 3"),  default = radio_presets[3][3] }, -- sochi-adler (URSS) : 256.0
				[4] =  { name = _("Channel 4"),  default = radio_presets[3][4] }, -- maykop-khanskaya (URKH), nellis (KLSV) : 254.0
				[5] =  { name = _("Channel 5"),  default = radio_presets[3][5] }, -- anapa (URKA) : 250.0
				[6] =  { name = _("Channel 6"),  default = radio_presets[3][6] }, -- beslan (URMO) : 270.0
				[7] =  { name = _("Channel 7"),  default = radio_presets[3][7] }, -- krasnodar-pashkovsky (URKK) : 257.0
				[8] =  { name = _("Channel 8"),  default = radio_presets[3][8] }, -- sukhumi-babushara (UGSS) : 255.0
				[9] =  { name = _("Channel 9"),  default = radio_presets[3][9] }, -- kobuleti (UG5X) : 262.0
				[10] = { name = _("Channel 10"), default = radio_presets[3][10] }, -- gudauta (UG23) : 259.0
				[11] = { name = _("Channel 11"), default = radio_presets[3][11] }, -- tbilisi-soganlug (UG24) : 268.0
				[12] = { name = _("Channel 12"), default = radio_presets[3][12] }, -- tbilisi-vaziani (UG27) : 269.0
				[13] = { name = _("Channel 13"), default = radio_presets[3][13] }, -- batumi (UGSB) : 260.0
				[14] = { name = _("Channel 14"), default = radio_presets[3][14] }, -- kutaisi-kopitnari (UGKO) : 263.0
				[15] = { name = _("Channel 15"), default = radio_presets[3][15] }, -- senaki-kolkhi (UGKS) :  261.0
				[16] = { name = _("Channel 16"), default = radio_presets[3][16] }, -- tbilisi-lochini (UGTB) : 267.0
				[17] = { name = _("Channel 17"), default = radio_presets[3][17] }, -- krasnodar-center (URKI), creech (KINS) : 251.0
				[18] = { name = _("Channel 18"), default = radio_presets[3][18] }, -- krymsk (URKW), mccarran (KLAS) : 253.0
				[19] = { name = _("Channel 19"), default = radio_presets[3][19] }, -- mozdok (XRMF) : 266.0
				[20] = { name = _("Channel 20"), default = radio_presets[3][20] }, -- N/A, groom lake/homey (KXTA) : 252.0
			},
		},
	},
	AddPropAircraft =
	{
		{
			id = "CableCutterEnables",
			control = "checkbox",
			label = _("Cable Cutter"),
			defValue = false,
			weightWhenOn = 0,
			arg = 150,
		},
		{
			id = "FlaresEquipped",
			control = "checkbox",
			label = _("Equip Flares"),
			defValue = false,
			weightWhenOn = 10,
			arg = 127,
		},
		-- {
		-- 	id = "RWREquipped",
		-- 	control = "checkbox",
		-- 	label = _("Equip RWR"),
		-- 	defValue = false,
		-- 	weightWhenOn = 10,
		-- 	arg = 31,
		-- },
	},


	-- rotor_animation = {
    --     rotor_locations = {
    --         {pos = { 0.015825, 2.28875, 0.0}, pitch = math.rad(-3.0)},
            
    --     },
    --     rotor_models = {
    --         {
    --             modelRotorHub_EDM       = "ah6j_rotor_hub", -- works now
    --             modelRotorHubLod_FBX    = "/models/ah6j_rotor_hub_lod.fbx", -- not textured, all black?
    --             boundRotorHub_FBX       = "/models/ah6j_rotor_hub_bound.fbx",
    --             boundBlade_FBX          = "/models/ah6j_rotor_blade_bound.fbx",
    --             modelBlade_FBX          = {"/models/ah6j_rotor_blade.fbx"},
    --         },
    --     },
    -- },


	InheriteCommonCallnames = true,
	
	-----------------------------------------------------------------------
	-------------- Lights -------------------------------------------------
	-----------------------------------------------------------------------
	--[[
		DCS World\Scripts\Aircrafts\_Common\Lights.lua
		
		WOLALIGHT_STROBES          = 1		-- White strobe anti-collision lights.
		WOLALIGHT_SPOTS            = 2		-- Take-off and landing high power headlights.
		WOLALIGHT_LANDING_LIGHTS   = 2		-- Take-off and landing high power headlights.
		WOLALIGHT_NAVLIGHTS        = 3		-- P-Z colored navigation (position) wingtip lights..
		WOLALIGHT_FORMATION_LIGHTS = 4		-- Formation / Logo lights.
		WOLALIGHT_TIPS_LIGHTS      = 5		-- Helicopter-specific: rotor anti-collision tips lights.
		WOLALIGHT_TAXI_LIGHTS      = 6		-- Taxi headlights.
		WOLALIGHT_BEACONS          = 7		-- Rotary anti-collision lights.
		WOLALIGHT_CABIN_BOARDING   = 8		-- Cabin incandescence illumination.
		WOLALIGHT_CABIN_NIGHT      = 9		-- Cabin night time (UV) illumination.
		WOLALIGHT_REFUEL_LIGHTS    = 10		-- Refuel apparatus illumination.
		WOLALIGHT_PROJECTORS       = 11		-- Search lights, direction-controlled.
		WOLALIGHT_AUX_LIGHTS       = 12		-- White anti-collision strobes & others
		WOLALIGHT_IR_FORMATION     = 13		-- IR formation strips. Currently not implemented due to engine NVG limitations.
		WOLALIGHT_CABIN_WORK	   = 14		-- Flight instrument illumination of pilots
	]]
	lights_data	= {
		typename = "Collection",
		lights = {
			[WOLALIGHT_BEACONS] = {
				-- DCS seems to only turn this collection on during startup of the engines then turns them off when it's time to taxi.
				typename = "Collection",
				lights = { 
					-- Tail red beacon strobe
					{typename = "argumentlight", argument = 123, controller = "Strobe", period = 1.2, flash_time = 0.05, phase_shift = 0.0},
					-- Ventral (bottom) red beacon strobe
					{typename = "argumentlight", argument = 124, controller = "Strobe", period = 1.2, flash_time = 0.05, phase_shift = 0.5},
				},
			},
			[WOLALIGHT_STROBES] = {
				-- Red beacon lights. Old aircraft have rotating/oscillating ones. Modern aircraft flash.
				typename = "Collection",
				lights = {
					-- Tail red beacon strobe
					{typename = "argumentlight", argument = 123, controller = "Strobe", period = 1.2, flash_time = 0.05, phase_shift = 0.0},
					-- Ventral (bottom) red beacon strobe
					{typename = "argumentlight", argument = 124, controller = "Strobe", period = 1.2, flash_time = 0.05, phase_shift = 0.5},
				},
			},
			[WOLALIGHT_TIPS_LIGHTS] = {
				-- This lighting set should be on whenever it's dark outside and the helicopter isn't in combat.
				typename = "Collection",
				lights = { },
			},
			[WOLALIGHT_PROJECTORS] = {
				-- Handles spotlights
				typename = "Collection",
				lights = {
					{typename = "argumentlight", argument = 116},			-- Steerable spotlight
				},
			},
			[WOLALIGHT_LANDING_LIGHTS] = {
				-- This collection turns on for approach and landing, obviously.
				typename = "Collection",
				lights = {
					-- {	typename = "Spot", argument = 115,					-- Nose landing flood
						-- position = { 1.714, 0.40, 0 },
						-- proto = lamp_prototypes.LFS_R_27_130,
						-- color = {1, 0.945, 0.8784},
						-- direction = {azimuth = math.rad(0.0), elevation = math.rad(20.0)},
						-- angle_max = math.rad(30),							-- 30 degree beam width
						-- cool_t = 0.6,
						-- range = 400,
					-- },
				},
			},
			[WOLALIGHT_TAXI_LIGHTS] = {
				-- This collection turns on when taxiing around on the ground.
				typename = "Collection",
				lights = {
					-- {typename = "argumentlight",	argument  = 115},		-- Nose landing flood
					-- {	typename = "Spot", argument = 115,					-- Nose landing flood
						-- position = { 1.714, 0.40, 0 },
						-- proto = lamp_prototypes.LFS_R_27_130,
						-- color = {1, 0.945, 0.8784},
						-- direction = {azimuth = math.rad(0.0), elevation = math.rad(25.0)},
						-- angle_max = math.rad(45.0),
						-- intensity_max = 300,
						-- range = 60,
					-- },
				},
			},
			[WOLALIGHT_NAVLIGHTS] = {
				typename = "Collection",
				lights = {
					{typename = "argumentlight", argument = 122},		-- navigation lights: port side red, stbd side green, & tail white
				},
			},
			[WOLALIGHT_IR_FORMATION] = {
				typename = "Collection",
				lights = { },
			},
			[WOLALIGHT_AUX_LIGHTS] = {
				typename = "Collection",
				lights = {
					{ 	-- IR strobe - Top of "T" vertical/horizontal stabilizer aft end of boom
                        typename = "Omni", position = { -4.87, 2.55, 0.133 },
                        color = {2, 0, 0, 0.12}, flir_amount = 1.0, range = 16,
						controller = "VariablePatternStrobe", mode = "2 Flash Long", period = 0.5,
                    },
					{ 	-- IR strobe - Ventral (bottom) beacon strobe housing
                        typename = "Omni", position = { 0.858, 0.025, -0.218 },
                        color = {2, 0, 0, 0.12}, flir_amount = 1.0, range = 16,
						controller = "VariablePatternStrobe", mode = "2 Flash Long", period = 0.5, phase_shift = 2.0,
                    },
				},
			},
			[WOLALIGHT_CABIN_WORK] = {
				typename = "Collection",
				lights = { },
			},
			[WOLALIGHT_CABIN_NIGHT] = {
				-- This collection turns on when the aircraft is in motion at night (including in combat conditions, I think).
				typename = "Collection",
				lights = { },
			},
			[WOLALIGHT_CABIN_BOARDING] = {
				-- These lights are used from engine startup, through taxi, and turn off just after takeoff.
				typename = "Collection",
				lights = { },
			},
			[WOLALIGHT_FORMATION_LIGHTS] = {
				-- Slime lights, etc. used around airfields (ground and air), but especially around other aircraft (e.g., aerial refuelers).
				typename = "Collection",
				lights = { },
			},
		},
	},
}
return XH6
end


function base_pylons(door_requirement) 
	local Pylons = {

		pylon(1, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
			{ use_full_connector_position = false, DisplayName = "F.Drs", arg = 209, arg_value = 1.0 },
			{
				{ CLSID = "{AH-6_DOORS}", arg_value = 0.0 },
			}
		),

		pylon(2, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
			{ use_full_connector_position = false, DisplayName = "R.Drs", arg = 210, arg_value = 1.0 },
			{
				{ CLSID = "{AH-6_DOORS}", arg_value = 0.0, required = door_requirement },
				{ CLSID = "<CLEAN>", arg_value = 1.0, required = CLEAN_IN_OUT },			
			} 
		),

		

		pylon(3, 0, 0, 0, 0,
			{ use_full_connector_position = false, connector = "C_aux_tank", arg = 2000, DisplayName = "Aux Fuel" },
			{
				{ CLSID = "{AH6_GOLIATH}", arg_value = 0, attach_point_position = { 0, 0, 0 }, attach_point_oriented = true },
			}
		),


		pylon(4, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
			{
				DisplayName = "Xtra", arg = 140, arg_value = 0.0 },
			{
				{
					CLSID = "{AH-6_CAMRIG}",
					arg_value = 0.55,
					attach_point_oriented = false,
					--forbidden = CAMRIG_Restrictions
				},
				-- {
				-- 	CLSID = "{AH-6_CAMMAN}",
				-- 	arg_value = 0.4,
				-- 	attach_point_oriented = false,
				-- 	--forbidden = CAMRIG_Restrictions
				-- },
				{ CLSID = "{AH-6_Searchlight}", arg_value = 1.0,  attach_point_oriented = false },
				{ CLSID = "{AH-6_FLOATERS}",    arg_value = -1.0, attach_point_oriented = false }
			}
		),

		
		pylon(5, 0, 0.241, 0.926, 1.55, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
		{ use_full_connector_position = false, DisplayName = "G4",},--arg = 133, arg_value = 0 },
		{
			{CLSID = "{AH6_SMOKE_RED}",    forbidden = { station = F_DOORS, loadout = { "{AH-6_DOORS}" } }},
			{CLSID = "{AH6_SMOKE_GREEN}",  forbidden = { station = F_DOORS, loadout = { "{AH-6_DOORS}" } }},
			{CLSID = "{AH6_SMOKE_BLUE}",   forbidden = { station = F_DOORS, loadout = { "{AH-6_DOORS}" } }},
			{CLSID = "{AH6_SMOKE_YELLOW}", forbidden = { station = F_DOORS, loadout = { "{AH-6_DOORS}" } }},
		}
		),
		pylon(6, 0, 0.241, 0.926, 1.55, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
		{ use_full_connector_position = false, DisplayName = "G3" },
		{
			{CLSID = "{AH6_SMOKE_RED}",    forbidden = { station = F_DOORS, loadout = { "{AH-6_DOORS}" } }},
			{CLSID = "{AH6_SMOKE_GREEN}",  forbidden = { station = F_DOORS, loadout = { "{AH-6_DOORS}" } }},
			{CLSID = "{AH6_SMOKE_BLUE}",   forbidden = { station = F_DOORS, loadout = { "{AH-6_DOORS}" } }},
			{CLSID = "{AH6_SMOKE_YELLOW}", forbidden = { station = F_DOORS, loadout = { "{AH-6_DOORS}" } }},
		}
		),
		pylon(7, 0, 0.241, 0.926, 1.55, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
		{ use_full_connector_position = false, DisplayName = "G2",arg = 131, arg_value = 0 },
		{
			{CLSID = "{AH6_SMOKE_RED}",    forbidden = { station = F_DOORS, loadout = { "{AH-6_DOORS}" } }},
			{CLSID = "{AH6_SMOKE_GREEN}",  forbidden = { station = F_DOORS, loadout = { "{AH-6_DOORS}" } }},
			{CLSID = "{AH6_SMOKE_BLUE}",   forbidden = { station = F_DOORS, loadout = { "{AH-6_DOORS}" } }},
			{CLSID = "{AH6_SMOKE_YELLOW}", forbidden = { station = F_DOORS, loadout = { "{AH-6_DOORS}" } }},
		}
		),
		pylon(8, 0, 0.241, 0.926, 1.55, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
		{ use_full_connector_position = false, DisplayName = "G1"},
		{
			{CLSID = "{AH6_SMOKE_RED}",    forbidden = { station = F_DOORS, loadout = { "{AH-6_DOORS}" } }},
			{CLSID = "{AH6_SMOKE_GREEN}",  forbidden = { station = F_DOORS, loadout = { "{AH-6_DOORS}" } }},
			{CLSID = "{AH6_SMOKE_BLUE}",   forbidden = { station = F_DOORS, loadout = { "{AH-6_DOORS}" } }},
			{CLSID = "{AH6_SMOKE_YELLOW}", forbidden = { station = F_DOORS, loadout = { "{AH-6_DOORS}" } }},
		}
		),
	}
	return Pylons
end


ah6_pylons = {
	pylon(L_OUT, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
		{
			use_full_connector_position = false,
			connector = "Pylon1",
			attach_point_oriented = true,  
			DisplayName = "L-OB",
			arg = 501,
			arg_value = 0.15,
		},
		{

			{
				CLSID = "{AH-6_FN_HMP400}",
				forbidden = PYLON_L_OUT,
				attach_point_position =hmpoffset
			},

			{
				CLSID = "AH6_AGM_114K_L",
				forbidden = PYLON_L_OUT,
				attach_point_position =m299offset
			},
			{
				CLSID = "AH6_AGM_114K_L1",
				forbidden = PYLON_L_OUT,
				attach_point_position =m299offset
			},

			{
				CLSID = "{LAU-131 - 7 AGR-20A}",
				arg_value = 0.25,				
				forbidden = PYLON_L_OUT,
				attach_point_position = m260offset_out
			},
			{
				CLSID = "{LAU-131 - 7 AGR-20 M282}",
				arg_value = 0.25,				
				forbidden = PYLON_L_OUT,
				attach_point_position = m260offset_out 
			},
			{
				CLSID = "{M260_APKWS_M151}",  
				arg_value = 0.25,
				attach_point_position = m260offset_out,  
				forbidden = PYLON_L_OUT
			},

			{
				CLSID = "{FC85D2ED-501A-48ce-9863-49D468DDD5FC}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},

			{
				CLSID = "{174C6E6D-0C3D-42ff-BCB3-0853CB371F5C}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},

			{
				CLSID = "{65396399-9F5C-4ec3-A7D2-5A8F4C1D90C4}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},
			
			{
				CLSID = "{A021F29D-18AB-4d3e-985C-FC9C60E35E9E}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},			
			
			{
				CLSID = "{4F977A2A-CD25-44df-90EF-164BFA2AE72F}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},			
			
			{
				CLSID = "{1F7136CB-8120-4e77-B97B-945FF01FB67C}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},			
			
			{
				CLSID = "{647C5F26-BDD1-41e6-A371-8DE1E4CC0E94}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},			
			
			{
				CLSID = "{0877B74B-5A00-4e61-BA8A-A56450BA9E27}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},			
			
			{
				CLSID = "{9115A5AF-6D5C-4b6b-BEA9-31D48B5C6001}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},			
			
			{
				CLSID = "{D22C2D63-E5C9-4247-94FB-5E8F3DE22B71}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},			
			
			{
				CLSID = "{319293F2-392C-4617-8315-7C88C22AF7C4}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},			
			
			{
				CLSID = "{1CA5E00B-D545-4ff9-9B53-5970E292F14D}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},			
			
			{
				CLSID = "{69926055-0DA8-4530-9F2F-C86B157EA9F6}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},			
			
			{
				CLSID = "{2AF2EC3F-9065-4de5-93E1-1739C9A71EF7}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},			
			
			{
				CLSID = "{DDCE7D70-5313-4181-8977-F11018681662}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},			
			
			{
				CLSID = "{DAD45FE5-CFF0-4a2b-99D4-5D044D3BC22F}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},			
			
			{
				CLSID = "{6D6D5C07-2A90-4a68-9A74-C5D0CFFB05D9}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},			
						
			{
				CLSID = "{1FE353C6-5EB6-4d22-9CFD-6DB384EC7296}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},	
			
			{
				CLSID = "{M260_M151}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},
			{
				CLSID = "{M260_M156}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},
			{
				CLSID = "{M260_M229}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},
			{
				CLSID = "{M260_M257}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},
			{
				CLSID = "{M260_M259}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},
			{
				CLSID = "{M260_M274}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_OUT
			},

			{
				CLSID = "{M261_M229}",
				arg_value = 0.25,
				attach_point_position = m261offset_out,
				forbidden = PYLON_L_OUT
			},
			{
				CLSID = "{M261_M257}",
				arg_value = 0.25,
				attach_point_position = m261offset_out,
				forbidden = PYLON_L_OUT
			},
			{
				CLSID = "{M261_M259}",
				arg_value = 0.25,
				attach_point_position = m261offset_out,
				forbidden = PYLON_L_OUT
			},
			{
				CLSID = "{M261_M274}",
				arg_value = 0.25,
				attach_point_position = m261offset_out,
				forbidden = PYLON_L_OUT
			},
			{
				CLSID = "{M261_M282}",
				arg_value = 0.25,
				attach_point_position = m261offset_out,
				forbidden = PYLON_L_OUT
			},

			{ CLSID = "<CLEAN>", arg_value = 0.0, required = CLEAN_L_OUT },
		}
	),

		pylon(L_IN, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
			{
				use_full_connector_position = false,
				connector = "C_minigun_L",
				attach_point_oriented = true,
				DisplayName = "L-IB",
				arg = 500,
				arg_value = 0.15,
			},
			{
				{
					CLSID = "{AH6_M134L}",
					arg_value = 0.25,
					attach_point_position = { 0, 0, 0 },
					forbidden = PYLON_L_IN
				},
				{
					CLSID = "{LAU-131 - 7 AGR-20A}",
					arg_value = 1,					
					--forbidden = combine_tables(PYLON_R_IN, ROCKETS_R_OUT),  
					forbidden = PYLON_L_IN,
					attach_point_position = m260offset_out
				},
				{
					CLSID = "{LAU-131 - 7 AGR-20 M282}",
					arg_value = 1,					
					--forbidden = combine_tables(PYLON_R_IN, ROCKETS_R_OUT),
					forbidden = PYLON_L_IN,
					attach_point_position = m260offset_out
				},
			{
				CLSID = "{M260_APKWS_M151}",  
				arg_value = 1,
				attach_point_position = m260offset_out,  
				forbidden = PYLON_L_IN
			},

			{
				CLSID = "{FC85D2ED-501A-48ce-9863-49D468DDD5FC}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},

			{
				CLSID = "{174C6E6D-0C3D-42ff-BCB3-0853CB371F5C}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},

			{
				CLSID = "{65396399-9F5C-4ec3-A7D2-5A8F4C1D90C4}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},
			
			{
				CLSID = "{A021F29D-18AB-4d3e-985C-FC9C60E35E9E}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},			
			
			{
				CLSID = "{4F977A2A-CD25-44df-90EF-164BFA2AE72F}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},			
			
			{
				CLSID = "{1F7136CB-8120-4e77-B97B-945FF01FB67C}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},			
			
			{
				CLSID = "{647C5F26-BDD1-41e6-A371-8DE1E4CC0E94}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},			
			
			{
				CLSID = "{0877B74B-5A00-4e61-BA8A-A56450BA9E27}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},			
			
			{
				CLSID = "{9115A5AF-6D5C-4b6b-BEA9-31D48B5C6001}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},			
			
			{
				CLSID = "{D22C2D63-E5C9-4247-94FB-5E8F3DE22B71}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},			
			
			{
				CLSID = "{319293F2-392C-4617-8315-7C88C22AF7C4}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},			
			
			{
				CLSID = "{1CA5E00B-D545-4ff9-9B53-5970E292F14D}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},			
			
			{
				CLSID = "{69926055-0DA8-4530-9F2F-C86B157EA9F6}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},			
			
			{
				CLSID = "{2AF2EC3F-9065-4de5-93E1-1739C9A71EF7}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},			
			
			{
				CLSID = "{DDCE7D70-5313-4181-8977-F11018681662}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},			
			
			{
				CLSID = "{DAD45FE5-CFF0-4a2b-99D4-5D044D3BC22F}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},			
			
			{
				CLSID = "{6D6D5C07-2A90-4a68-9A74-C5D0CFFB05D9}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},			
						
			{
				CLSID = "{1FE353C6-5EB6-4d22-9CFD-6DB384EC7296}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_L_IN
			},											
								
				{
					CLSID = "{M260_M151}",
					arg_value = 1,
					attach_point_position = m260offset_r,
					--forbidden = combine_tables(PYLON_R_IN, ROCKETS_R_OUT)
					forbidden = PYLON_L_IN
				},
				{
					CLSID = "{M260_M156}",
					arg_value = 1,
					attach_point_position = m260offset_r,
					--forbidden = combine_tables(PYLON_R_IN, ROCKETS_R_OUT)
					forbidden = PYLON_L_IN
				},
				{
					CLSID = "{M260_M229}",
					arg_value = 1,
					attach_point_position = m260offset_r,
					--forbidden = combine_tables(PYLON_R_IN, ROCKETS_R_OUT)
					forbidden = PYLON_L_IN
				},
				{
					CLSID = "{M260_M257}",
					arg_value = 1,
					attach_point_position = m260offset_r,
					--forbidden = combine_tables(PYLON_R_IN, ROCKETS_R_OUT)
					forbidden = PYLON_L_IN
				},
				{
					CLSID = "{M260_M259}",
					arg_value = 1,
					attach_point_position = m260offset_r,
					--forbidden = combine_tables(PYLON_R_IN, ROCKETS_R_OUT)
					forbidden = PYLON_L_IN
				},
				{
					CLSID = "{M260_M274}",
					arg_value = 1,
					attach_point_position = m260offset_r,
					--forbidden = combine_tables(PYLON_R_IN, ROCKETS_R_OUT)
					forbidden = PYLON_L_IN
				},

				{
					CLSID = "{M261_M229}",
					arg_value = 1,
					attach_point_position = { -0.05, -0.16, 0 },
					--forbidden = combine_tables(PYLON_R_IN, ROCKETS_R_OUT)
					forbidden = PYLON_L_IN
				},
				{
					CLSID = "{M261_M257}",
					arg_value = 1,
					attach_point_position = { -0.05, -0.16, 0 },
					forbidden = PYLON_L_IN
				},
				{
					CLSID = "{M261_M259}",
					arg_value = 1,
					attach_point_position = { -0.05, -0.16, 0 },
					forbidden = PYLON_L_IN
				},
				{
					CLSID = "{M261_M274}",
					arg_value = 1,
					attach_point_position = { -0.05, -0.16, 0 },
					forbidden = PYLON_L_IN,
				},
				{
					CLSID = "{M261_M282}",
					arg_value = 1,
					attach_point_position = { -0.05, -0.16, 0 },
					forbidden = PYLON_L_IN,
				},

				{ CLSID = "<CLEAN>", arg_value = 0, required = CLEAN_L_IN },
			}
		),

		pylon(R_IN, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
			{
				use_full_connector_position = false,
				connector = "C_minigun_R",
				attach_point_oriented = true,
				DisplayName = "R-IB",
				arg = 502,
				arg_value = 0.15,
			},
			{
				{
					CLSID = "{AH6_M134R}",
					arg_value = 0.25,
					attach_point_position = { 0, 0, 0 },
					forbidden = PYLON_R_IN
				},

				{
					CLSID = "{LAU-131 - 7 AGR-20A}",
					arg_value = 1,					
					forbidden = PYLON_R_IN,
					attach_point_position = m260offset_out
				},
				{
					CLSID = "{LAU-131 - 7 AGR-20 M282}",
					arg_value = 1,					
					forbidden = PYLON_R_IN,
					attach_point_position = m260offset_out
				},
				
			{
				CLSID = "{M260_APKWS_M151}",  
				arg_value = 1,
				attach_point_position = m260offset_out,  
				forbidden = PYLON_R_IN
			},

			{
				CLSID = "{FC85D2ED-501A-48ce-9863-49D468DDD5FC}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},

			{
				CLSID = "{174C6E6D-0C3D-42ff-BCB3-0853CB371F5C}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},

			{
				CLSID = "{65396399-9F5C-4ec3-A7D2-5A8F4C1D90C4}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},
			
			{
				CLSID = "{A021F29D-18AB-4d3e-985C-FC9C60E35E9E}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},			
			
			{
				CLSID = "{4F977A2A-CD25-44df-90EF-164BFA2AE72F}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},			
			
			{
				CLSID = "{1F7136CB-8120-4e77-B97B-945FF01FB67C}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},			
			
			{
				CLSID = "{647C5F26-BDD1-41e6-A371-8DE1E4CC0E94}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},			
			
			{
				CLSID = "{0877B74B-5A00-4e61-BA8A-A56450BA9E27}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},			
			
			{
				CLSID = "{9115A5AF-6D5C-4b6b-BEA9-31D48B5C6001}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},			
			
			{
				CLSID = "{D22C2D63-E5C9-4247-94FB-5E8F3DE22B71}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},			
			
			{
				CLSID = "{319293F2-392C-4617-8315-7C88C22AF7C4}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},			
			
			{
				CLSID = "{1CA5E00B-D545-4ff9-9B53-5970E292F14D}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},			
			
			{
				CLSID = "{69926055-0DA8-4530-9F2F-C86B157EA9F6}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},			
			
			{
				CLSID = "{2AF2EC3F-9065-4de5-93E1-1739C9A71EF7}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},			
			
			{
				CLSID = "{DDCE7D70-5313-4181-8977-F11018681662}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},			
			
			{
				CLSID = "{DAD45FE5-CFF0-4a2b-99D4-5D044D3BC22F}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},			
			
			{
				CLSID = "{6D6D5C07-2A90-4a68-9A74-C5D0CFFB05D9}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},			
						
			{
				CLSID = "{1FE353C6-5EB6-4d22-9CFD-6DB384EC7296}",
				arg_value = 1,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_IN
			},							
			
				{
					CLSID = "{M260_M151}",
					arg_value = 1,
					attach_point_position = m260offset_r,
					forbidden = PYLON_R_IN
				},
				{
					CLSID = "{M260_M156}",
					arg_value = 1,
					attach_point_position = m260offset_r,
					forbidden = PYLON_R_IN
				},
				{
					CLSID = "{M260_M229}",
					arg_value = 1,
					attach_point_position = m260offset_r,
					forbidden = PYLON_R_IN
				},
				{
					CLSID = "{M260_M257}",
					arg_value = 1,
					attach_point_position = m260offset_r,
					forbidden = PYLON_R_IN
				},
				{
					CLSID = "{M260_M259}",
					arg_value = 1,
					attach_point_position = m260offset_r,
					forbidden = PYLON_R_IN
				},
				{
					CLSID = "{M260_M274}",
					arg_value = 1,
					attach_point_position = m260offset_r,
					forbidden = PYLON_R_IN
				},

				{
					CLSID = "{M261_M229}",
					arg_value = 1,
					attach_point_position = { -0.05, -0.16, 0 },
					forbidden = PYLON_R_IN
				},
				{
					CLSID = "{M261_M257}",
					arg_value = 1,
					attach_point_position = { -0.05, -0.16, 0 },
					forbidden = PYLON_R_IN
				},
				{
					CLSID = "{M261_M259}",
					arg_value = 1,
					attach_point_position = { -0.05, -0.16, 0 },
					forbidden = PYLON_R_IN
				},
				{
					CLSID = "{M261_M274}",
					arg_value = 1,
					attach_point_position = { -0.05, -0.16, 0 },
					forbidden = PYLON_R_IN,
				},
				{
					CLSID = "{M261_M282}",
					arg_value = 1,
					attach_point_position = { -0.05, -0.16, 0 },
					forbidden = PYLON_R_IN,
				},

				{ CLSID = "<CLEAN>", arg_value = 0.0, required = CLEAN_R_IN },
			}
		),

		pylon(R_OUT, 0, 0.0, 0.0, 0.0, -- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)
			{
				use_full_connector_position = false,
				connector = "Pylon2",
				attach_point_oriented = true,
				DisplayName = "R-OB",
				arg = 503,
				arg_value = 0.15,
			},
			{
				{
					CLSID = "{AH-6_FN_HMP400}",
					forbidden = PYLON_R_OUT,
					attach_point_position =hmpoffset
				},

				{
					CLSID = "AH6_AGM_114K_R",
					forbidden = PYLON_R_OUT,
					attach_point_position =m299offset
				},
				{
					CLSID = "AH6_AGM_114K_R1",
					forbidden = PYLON_R_OUT,
					attach_point_position =m299offset
				},
				
				{
					CLSID = "{LAU-131 - 7 AGR-20A}",
					arg_value = 0.25,					
					forbidden =PYLON_R_OUT,
					attach_point_position = m260offset_out
				},
				{
					CLSID = "{LAU-131 - 7 AGR-20 M282}",
					arg_value = 0.25,					
					forbidden = PYLON_R_OUT,
					attach_point_position = m260offset_out
				},

			{
				CLSID = "{M260_APKWS_M151}",  
				arg_value = 0.25,
				attach_point_position = m260offset_out,  
				forbidden = PYLON_R_OUT
			},

			{
				CLSID = "{FC85D2ED-501A-48ce-9863-49D468DDD5FC}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},

			{
				CLSID = "{174C6E6D-0C3D-42ff-BCB3-0853CB371F5C}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},

			{
				CLSID = "{65396399-9F5C-4ec3-A7D2-5A8F4C1D90C4}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},
			
			{
				CLSID = "{A021F29D-18AB-4d3e-985C-FC9C60E35E9E}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},			
			
			{
				CLSID = "{4F977A2A-CD25-44df-90EF-164BFA2AE72F}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},			
			
			{
				CLSID = "{1F7136CB-8120-4e77-B97B-945FF01FB67C}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},			
			
			{
				CLSID = "{647C5F26-BDD1-41e6-A371-8DE1E4CC0E94}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},			
			
			{
				CLSID = "{0877B74B-5A00-4e61-BA8A-A56450BA9E27}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},			
			
			{
				CLSID = "{9115A5AF-6D5C-4b6b-BEA9-31D48B5C6001}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},			
			
			{
				CLSID = "{D22C2D63-E5C9-4247-94FB-5E8F3DE22B71}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},			
			
			{
				CLSID = "{319293F2-392C-4617-8315-7C88C22AF7C4}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},			
			
			{
				CLSID = "{1CA5E00B-D545-4ff9-9B53-5970E292F14D}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},			
			
			{
				CLSID = "{69926055-0DA8-4530-9F2F-C86B157EA9F6}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},			
			
			{
				CLSID = "{2AF2EC3F-9065-4de5-93E1-1739C9A71EF7}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},			
			
			{
				CLSID = "{DDCE7D70-5313-4181-8977-F11018681662}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},			
			
			{
				CLSID = "{DAD45FE5-CFF0-4a2b-99D4-5D044D3BC22F}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},			
			
			{
				CLSID = "{6D6D5C07-2A90-4a68-9A74-C5D0CFFB05D9}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},			
						
			{
				CLSID = "{1FE353C6-5EB6-4d22-9CFD-6DB384EC7296}",
				arg_value = 0.25,
				attach_point_position = m260offset_out,
				forbidden = PYLON_R_OUT
			},			

				{
					CLSID = "{M260_M151}",
					arg_value = 0.25,
					attach_point_position = m260offset_out,
					forbidden = PYLON_R_OUT,
				},
				{
					CLSID = "{M260_M156}",
					arg_value = 0.25,
					attach_point_position = m260offset_out,
					forbidden = PYLON_R_OUT
				},
				{
					CLSID = "{M260_M229}",
					arg_value = 0.25,
					attach_point_position = m260offset_out,
					forbidden = PYLON_R_OUT, 
				},
				{
					CLSID = "{M260_M257}",
					arg_value = 0.25,
					attach_point_position = m260offset_out,
					forbidden = PYLON_R_OUT,
				},
				{
					CLSID = "{M260_M259}",
					arg_value = 0.25,
					attach_point_position = m260offset_out,
					forbidden = PYLON_R_OUT,
				},
				{
					CLSID = "{M260_M274}",
					arg_value = 0.25,
					attach_point_position = m260offset_out,
					forbidden = PYLON_R_OUT,
				},

				{
					CLSID = "{M261_M229}",
					arg_value = 0.25,
					attach_point_position = m261offset_out,
					forbidden = PYLON_R_OUT
				},
				{
					CLSID = "{M261_M257}",
					arg_value = 0.25,
					attach_point_position = m261offset_out,
					forbidden = PYLON_R_OUT,
				},
				{
					CLSID = "{M261_M259}",
					arg_value = 0.25,
					attach_point_position = m261offset_out,
					forbidden = PYLON_R_OUT,
				},
				{
					CLSID = "{M261_M274}",
					arg_value = 0.25,
					attach_point_position = m261offset_out,
					forbidden = PYLON_R_OUT,
				},
				{
					CLSID = "{M261_M282}",
					arg_value = 0.25,
					attach_point_position = m261offset_out,
					forbidden = PYLON_R_OUT,
				},

				{ CLSID = "<CLEAN>", arg_value = 0.0, required = CLEAN_R_OUT },
			}
		),
	}

	mh6_pylons = {
		pylon(9, 0, 0.0, 0.0, 0.0,
			{
				use_full_connector_position = true,
				connector = "C_ah6_gunner_weapon",
				DisplayName = "GFR",
				arg = 601,
				arg_value = 0.1
			},
			{
				{
					CLSID = "{AH-6_Door}",
					arg_value = 0.5,
					forbidden = installed_backdoors,
					required = {
						{ station = 10,     loadout = {"{AH-6_Door}"} },
					}
				},
				{ CLSID = "<CLEAN>", arg_value = 0.0 },
			}
		),
		pylon(10, 0, 0.0, 0.0, 0.0,
			{
				use_full_connector_position = true,
				connector = "C_ah6_gunner_2_weapon",
				DisplayName = "GFL",
				arg = 602,
				arg_value = 0.1,
			},
			{
				{
					CLSID = "{AH-6_Door}",
					arg_value = 0.8,
					forbidden = installed_backdoors,
					required = {
						{ station = 9,     loadout = {"{AH-6_Door}"} },
					}
				},
				{ CLSID = "<CLEAN>", arg_value = 0.0 },
			}
		),
		pylon(11, 0, 0.0, 0.0, 0.0,
			{
				use_full_connector_position = true,
				connector = "C_ah6_gunner_3_weapon",
				DisplayName = "GRR",
				arg = 603,
				arg_value = 0.1
			},
			{
				{
					CLSID = "{AH-6_Door}",
					arg_value = 0.5,
					forbidden = installed_backdoors,
					required = {
						{ station = 12,     loadout = {"{AH-6_Door}"} },
					}
				},
				{ CLSID = "<CLEAN>", arg_value = 0.0 },
			}
		),
		pylon(12, 0, 0.0, 0.0, 0.0,
			{
				use_full_connector_position = true,
				connector = "C_ah6_gunner_4_weapon",
				DisplayName = "GRL",
				arg = 604,
				arg_value = 0.1,
			},
			{
				{
					CLSID = "{AH-6_Door}",
					arg_value = 0.8,
					forbidden = installed_backdoors,
					required = {
						{ station = 11,     loadout = {"{AH-6_Door}"} },
					}
				},
				{ CLSID = "<CLEAN>", arg_value = 0.0 },
			}
		),
}

ah6 = common_xh_6('AH-6J',_('AH-6J'))
ah6.net_animation = { --transmits draw arguments over multiplyer for others to see
		35,        -- doors
		36,        -- tail rotor
		39,        --canopy
		40,
		

		115, -- Taxi light
		116, -- Searchlight??

		--120, -- pos light left
		--121, -- pos light right
		122, -- pos tail
		123, -- acol tail
		124, -- acol belly

		127, --flares

		140, --cam rig
		141, -- orientation special equip
		142,

		201,       -- skids
		202,
		203,
		204,
		
		209, --doors
		210,

		500, -- pylons
		501,
		502,
		503,
	}

ah6pylons = base_pylons(CLEAN_PLANK)
merge_table(ah6pylons, ah6_pylons)
ah6.Pylons = ah6pylons


mh6 = common_xh_6('MH-6J',_('MH-6J'))

mh6.net_animation = { --transmits draw arguments over multiplyer for others to see
		35,        -- doors
		36,        -- tail rotor
		39,        --canopy
		40,
		

		115, -- Taxi light
		116, -- Searchlight??

		--120, -- pos light left
		--121, -- pos light right
		122, -- pos tail
		123, -- acol tail
		124, -- acol belly

		127, --flares

		140, --cam rig
		141, -- orientation special equip
		142,

		201,       -- skids
		202,
		203,
		204,
		
		209, --doors
		210,


		--gunner 1
		601,
		603,

		605,

		610,
		611,
		612,

		--gunner 2
		621,
		622,

		--gunner 2
		631,
		632,

		--gunner 2
		631,
		632,


	}

mh6pylons = base_pylons({
	    { station = 9,  loadout = { "<CLEAN>" } },
		{ station = 10, loadout = { "<CLEAN>" } },
		{ station = 11, loadout = { "<CLEAN>" } },
		{ station = 12, loadout = { "<CLEAN>" } },
	})
merge_table(mh6pylons, mh6_pylons)
	
mh6.Pylons =mh6pylons

mh6.AddPropAircraft =
	{
		{
			id = "CableCutterEnables",
			control = "checkbox",
			label = _("Cable Cutter"),
			defValue = false,
			weightWhenOn = 0,
			arg = 150,
		},
		{
			id = "FlaresEquipped",
			control = "checkbox",
			label = _("Equip Flares"),
			defValue = false,
			weightWhenOn = 10,
			arg = 127,
		},
		-- {
		-- 	id = "RWREquipped",
		-- 	control = "checkbox",
		-- 	label = _("Equip RWR"),
		-- 	defValue = false,
		-- 	weightWhenOn = 10,
		-- 	arg = 31,
		-- },
	}

	mh6.Tasks                    = {
		aircraft_task(Transport), 
		aircraft_task(Reconnaissance),
	}
	mh6.DefaultTask              = aircraft_task(Reconnaissance)

	add_aircraft(mh6) 
	add_aircraft(ah6)