dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."math_tools.lua")

package.cpath 	= package.cpath..";".. LockOn_Options.script_path.. "..\\..\\bin\\?.dll"
require('XH6GunnerTools')
local dev = GetSelf()
local sensor_data = get_base_data()
local update_time_step = 0.02

local targets={}
local position
local velocity
local muz_vel = 856.2
local bullet_drag = 0.00102




local qx = get_param_handle("QUATERNIONX")
local qy = get_param_handle("QUATERNIONY")
local qz = get_param_handle("QUATERNIONZ")
local qw = get_param_handle("QUATERNIONW")
local shoot_doorgun1 = get_param_handle("SHOOT_DOOR_GUN1")
local shoot_doorgun2 = get_param_handle("SHOOT_DOOR_GUN2")
local shoot_doorgun3 = get_param_handle("SHOOT_DOOR_GUN3")
local shoot_doorgun4 = get_param_handle("SHOOT_DOOR_GUN4")

local roe_text = get_param_handle("ROE_TEXT")
local burst_text = get_param_handle("BURST_TEXT")

local show_gui_handle = get_param_handle("SHOW_CREW_GUI")


local function create_gunner(cov, fav_cov, fov_lim, offset, az_arg, el_arg, pylon_arg, roe_arg, shoot_handle)
	local gunner = 
	{
		cov = cov,
		fav_cov = fav_cov,
		fov = fov_lim,
		az_arg = az_arg,
		el_arg = el_arg,

		target_az = 0.0,
		target_el = 0.0,

		gun_az = 0.0,
		gun_el = 0.0,

		v_az = 0.0,
		v_el = 0.0,

		time_on_target = 0,
		time_shooting = 0,
		time_rest = 0,
		shooting = false,
		actual_target = nil,
		pylon_arg = pylon_arg,
		equipped = false,
		offset = offset,
		is_aimed = false,
		roe = 0,
		roe_anim = 0,
		roe_arg = roe_arg,
		shoot_handle= shoot_handle
	}
	return gunner
end

local gunners =
{
	-- FR
	create_gunner(
		{ --center of view
			az=-90,
			el=0
		},
		{ -- favorite center of view
			az=-90,
			el=0
		},
		{ --fov limits
			az = {min=-60,max=30},
			el = {min=-90,max=90}
		},
		{
			x = -0.7, -- -forward, + back
			y = 0,  -- - down, + up
			z = -1.0,  -- -right, + left
		},
		611,
		612,
		601,
		610,
		shoot_doorgun1
	),
	-- FL
	create_gunner(
		{ --center of view
			az=90,
			el=0
		},
		{  -- favorite center of view
			az=90,
			el=0
		},
		{ --fov limits
			az = {min=-30,max=60},
			el = {min=-90,max=90}
		},
		{
			x = -0.7, -- -forward, + back
			y = 0,  -- - down, + up
			z = 1.0,  -- -right, + left
		},
		621,
		622,
		601,
		610,
		shoot_doorgun2
	),
	-- RR
	create_gunner(
		{ --center of view
			az=-90,
			el=0
		},
		{ -- favorite center of view
			az=-90,
			el=0
		},
		{ --fov limits
			az = {min=-45,max=70},
			el = {min=-90,max=90}
		},
		{
			x = 0.3, -- -forward, + back
			y = 0,  -- - down, + up
			z = -1.0,  -- -right, + left
		},
		631,
		632,
		601,
		610,
		shoot_doorgun3
	),
	-- RL
	create_gunner(
		{ --center of view
			az=90,
			el=0
		},
		{  -- favorite center of view
			az=90,
			el=0
		},
		{ --fov limits
			az = {min=-60,max=30},
			el = {min=-90,max=90}
		},
		{
			x = 0.3, -- -forward, + back
			y = 0,  -- - down, + up
			z = 1.0,  -- -right, + left
		},
		641,
		642,
		601,
		610,
		shoot_doorgun4
	)
}

local burst_time =1.0
local rest_time =0.5
local max_dev = 2
local t_data = 0.0

local burst_mode = 'SHORT'-- 'LONG'

roe_text:set("HOLD")
burst_text:set(burst_mode)

local N = 50
local roe =0
local show_gui = 0.0
if get_plugin_option_value("AH-6J", "AH6ShowCrewStatus", "local") then
	show_gui = 1.0
end
show_gui_handle:set(show_gui)
dev:listen_command(Keys.roe)
dev:listen_command(Keys.toggle_burst_length)
dev:listen_command(Keys.toggle_crew_gui)

local contacts = 	{}
for ia = 0,N do	
	contacts[ia] =
	{
		id = get_param_handle("VIS_CONTACT" .. ia .. "ID"),
		x = get_param_handle("VIS_CONTACT" .. ia .. "X"),
		y = get_param_handle("VIS_CONTACT" .. ia .. "Y"),
		z = get_param_handle("VIS_CONTACT" .. ia .. "Z"),
		vx = get_param_handle("VIS_CONTACT" .. ia .. "VX"),
		vy = get_param_handle("VIS_CONTACT" .. ia .. "VY"),
		vz = get_param_handle("VIS_CONTACT" .. ia .. "VZ"),
		type = get_param_handle("VIS_CONTACT" .. ia .. "TYPE"),
	}
end
updateddata = get_param_handle("VISCONTACTUPDATE");

local function equipped(gunner)
	local value = get_aircraft_draw_argument_value(gunner.pylon_arg)
	if value > 0.05 then 
		gunner.equipped = true
		return true
	else
		gunner.equipped = false
		return false
	end
end



local function set_burst_time()
	if burst_mode == 'SHORT' then 
		burst_time = 1.0
	else
		burst_time = 2.0
	end
end



local function read_targets()
	if updateddata:get()>0.5 then 
		old_targets = targets
		targets = {}
		local x,y, z = sensor_data.getSelfCoordinates()
		position = {x=x,y=y,z=z}
		x,y, z = sensor_data.getSelfVelocity()
		velocity ={x=x,y=y,z=z}
		local count = 0
		for i = 0,N do
			--printm
			local id= contacts[i].id:get()
			if id > 0 then 
				targets[id] = {
					position = {
						x=contacts[i].x:get(),
						y=contacts[i].y:get(),
						z=contacts[i].z:get()
					},
					v = 
					{
						x=contacts[i].vx:get(),
						y=contacts[i].vy:get(),
						z=contacts[i].vz:get()
						
					},
					type=contacts[i].type:get(),
				}
				--print_message_to_user(contacts[i].v.x)
				count =count + 1
			end
		end	
		t_data = 0.0
		
		updateddata:set(0.0)
	end
end

local function pre_calc_targets(gunner)
	XH6GunnerTools.prepareR(qx:get(),qy:get(),qz:get(),qw:get())

	for k,v in pairs(targets) do
		local rel_pos =
		{
			x=v.position.x-position.x,
			y=v.position.y-position.y,
			z=v.position.z-position.z
		}

		local rel_vel =
		{
			x=v.v.x-velocity.x,
			y=v.v.y-velocity.y,
			z=v.v.z-velocity.z
		}
		
		rel_pos.x = rel_pos.x+rel_vel.x*t_data
		rel_pos.y = rel_pos.y+rel_vel.y*t_data
		rel_pos.z = rel_pos.z+rel_vel.z*t_data

		local az, el, dist = XH6GunnerTools.calcAzAndEl(
			rel_pos.x,rel_pos.y,rel_pos.z,
			rel_vel.x,rel_vel.y,rel_vel.z,
			gunner.offset.x, gunner.offset.y, gunner.offset.z,
			bullet_drag,muz_vel)
		v.az = az
		v.el = el
		
		v.in_range = dist<1000
	end

end

local function in_fov(gunner,target)
	local gun_az = target.az + gunner.cov.az
	local gun_el = target.el + gunner.cov.el
	local result = gun_az >= gunner.fov.az.min 
		and gun_az <=  gunner.fov.az.max 
		and gun_el >= gunner.fov.el.min 
		and gun_el <= gunner.fov.el.max
	return result
end

local function choose_target(gunner)
	if gunner.actual_target ~= nil then 
		if targets then 
			if targets[gunner.actual_target] then
				if in_fov(gunner,targets[gunner.actual_target]) and 
					targets[gunner.actual_target].in_range then
					return 				
				else
					--print_message_to_user("Out of fov")
				end
			else
				
				--print_message_to_user("Looking for new target")
			end
		end
	end
	
	gunner.actual_target = nil
	for k,v in pairs(targets) do
		if in_fov(gunner,v) and v.in_range then 
			--check prio --range
			gunner.actual_target = k
			gunner.time_on_target = 0.0
			return
		end
	end
end

local function aim(gunner)
	gunner.is_aimed= false
	if gunner.actual_target ~= nil then
		local target = targets[gunner.actual_target]
		if target ~= nil then 
			gunner.target_az = target.az+gunner.cov.az
			gunner.target_el = target.el+gunner.cov.el
			local k=50.0
			local D=8.0
			k=200.0
			D=5.0
			local v_max = 45
			local a_az = (gunner.target_az-gunner.gun_az)*k-gunner.v_az*D
			local a_el = (gunner.target_el-gunner.gun_el)*k-gunner.v_el*D

			gunner.v_az = gunner.v_az+a_az*update_time_step
			gunner.v_el = gunner.v_el+a_el*update_time_step

			local v = math.sqrt(gunner.v_az*gunner.v_az+
								gunner.v_el*gunner.v_el)
			if v > v_max then
				gunner.v_az = gunner.v_az/v*v_max
				gunner.v_el = gunner.v_el/v*v_max
			end

			gunner.gun_az = gunner.gun_az + gunner.v_az*update_time_step
			gunner.gun_el = gunner.gun_el + gunner.v_el*update_time_step
			
			gunner.gun_az = Limit(gunner.gun_az,gunner.fov.az.min,gunner.fov.az.max)
			gunner.gun_el = Limit(gunner.gun_el,gunner.fov.el.min,gunner.fov.el.max)
			
			local on_target = math.abs(gunner.gun_az - gunner.target_az) < max_dev and 
				math.abs(gunner.gun_el - gunner.target_el) < max_dev
			
			if on_target then 
				gunner.time_on_target = gunner.time_on_target + update_time_step
			else
				gunner.time_on_target = 0.0
			end
			if gunner.time_on_target > 1.5 then
				gunner.is_aimed = true
			end
		end
	end
	set_aircraft_draw_argument_value(gunner.az_arg, gunner.roe_anim*gunner.gun_az/90.0)
	set_aircraft_draw_argument_value(gunner.el_arg, gunner.roe_anim*gunner.gun_el/90.0)
end




make_default_activity(update_time_step)


function post_initialize()
    local birth = LockOn_Options.init_conditions.birth_place	
    if birth=="GROUND_HOT" or birth=="AIR_HOT" then
		
    elseif birth=="GROUND_COLD" then
		
    end
	

	
end


function SetCommand(command,value)
	if equipped(gunners[1]) then  
		if command == Keys.roe then
			if gunners[1].roe < 0.5 then
				gunners[1].roe = 1
				gunners[2].roe = 1
				gunners[3].roe = 1
				gunners[4].roe = 1
				print_message_to_user("Doorgunner: Free Fire")
			else
				gunners[1].roe = 0
				gunners[2].roe = 0
				gunners[3].roe = 0
				gunners[4].roe = 0
				print_message_to_user("Doorgunner: Hold")
			end
		end

		if command == Keys.toggle_burst_length then
			if burst_mode == 'SHORT' then
				burst_mode = 'LONG'
			else
				burst_mode = 'SHORT'
			end
			set_burst_time()
		end
	end

	if command == Keys.toggle_crew_gui then
		if show_gui >0.5 then 
			show_gui = 0.0
		else
			show_gui = 1.0
		end
		show_gui_handle:set(show_gui)
	end
end

function update()
	
	local gunners_equipped = false
	for k, g in pairs(gunners) do
		if g.roe == 0 then 
			g.roe_anim = g.roe_anim - 1.0/0.5*update_time_step
			if g.roe_anim <= 0.0 then g.roe_anim =0.0 end
		else
			g.roe_anim = g.roe_anim + 1.0/0.5*update_time_step
			if g.roe_anim >= 1.0 then g.roe_anim =1.0 end
		end
		set_aircraft_draw_argument_value(g.roe_arg, g.roe_anim)

		gunners_equipped = gunners_equipped or equipped(g)
	end
	
	if gunners_equipped then 
		read_targets()
	
		for k, g in pairs(gunners) do
			pre_calc_targets(g)
			choose_target(g)
			aim(g)
			

			if g.is_aimed and g.roe == 1 and g.time_rest >= rest_time then 
				g.time_shooting = g.time_shooting + update_time_step
				if g.time_shooting > burst_time then
					g.time_rest = 0.0
					g.time_shooting = 0.0
					g.shooting = false
				else
					g.shooting = true
				end
			else
				g.time_rest = g.time_rest + update_time_step
				g.shooting = false
			end
			
			if g.roe == 1 then 
				roe_text:set("FIRE")
			else
				roe_text:set("HOLD")
			end

			if g.shooting and g.roe ==1 and g.roe_anim ==1.0 then 
				--print_message_to_user("shoot",0.01)
				g.shoot_handle:set(1)
			else
				g.shoot_handle:set(0)
				--print_message_to_user(g.roe .. " "..g.roe_anim,0.01)
			end
			burst_text:set(burst_mode)
		end
	else
		burst_text:set("-")
		roe_text:set("-")
	end
	t_data =t_data+update_time_step
end

need_to_be_closed = false 