dofile(LockOn_Options.common_script_path.."elements_defs.lua")

SetScale(METERS) 

DEFAULT_LEVEL = 6
NOCLIP_LEVEL  = DEFAULT_LEVEL - 1
local FONT    = MakeFont({used_DXUnicodeFontData = "font7segment"},{0,255,0,215})
local FONT1   = MakeFont({used_DXUnicodeFontData = "font7segment"},{255,0,0,215})
local FONT2   = MakeFont({used_DXUnicodeFontData = "font7segment"},{0,0,255,215})


center={0,0,0}  --- {L/R,U/D,forward/back}

function AddElement(object)
	object.use_mipfilter    = true
	object.h_clip_relation  = h_clip_relations.compare
	object.level			= DEFAULT_LEVEL
    Add(object)
end

verts = {}
dx=.037
dy=.0147
verts [1]= {-dx,-dy}
verts [2]= {-dx,dy}
verts [3]= {dx,dy}
verts [4]= {dx,-dy}

base 			 	 = CreateElement "ceMeshPoly"
base.name 			 = "base"
base.vertices 		 = verts
base.indices 		 = {0,1,2,2,3,0}
base.init_pos		 = center   
base.material		 = MakeMaterial(nil,{30,3,3,255})
base.h_clip_relation = h_clip_relations.REWRITE_LEVEL 
base.level			 = NOCLIP_LEVEL
base.isdraw			 = true
base.change_opacity  = false
base.isvisible		 = false
base.element_params  = {"CLOCK_POWER"}  
base.controllers     =  {{"parameter_compare_with_number", 0, 1}}
Add(base)

local GMT_hours           = CreateElement "ceStringPoly"
GMT_hours.name            = create_guid_string()
GMT_hours.parent_element  = base.name
GMT_hours.material        = FONT
GMT_hours.init_pos        = {center[1]-.01,center[2]+0.0025,center[3]}		
GMT_hours.alignment       = "RightBottom"
GMT_hours.stringdefs      = {0.01,0.7 * 0.01, 0, 0}  -- {size vertical, horizontal, 0, 0}
GMT_hours.formats         = {"%02.0f"} 					-- 2 caractères 0 décimale
GMT_hours.element_params  = {"GMT_HOURS","GMT_BLINK_H"}
GMT_hours.controllers     = {{"text_using_parameter",0,0},{"opacity_using_parameter",1}}  
AddElement(GMT_hours)

local GMT_mins           = CreateElement "ceStringPoly"
GMT_mins.name            = create_guid_string()
GMT_mins.parent_element  = base.name
GMT_mins.material        = FONT
GMT_mins.init_pos        = {center[1],center[2]+0.0025,center[3]}
GMT_mins.alignment       = "CenterBottom"
GMT_mins.stringdefs      = {0.01,0.7 * 0.01, 0, 0}  -- {size vertical, horizontal, 0, 0}
GMT_mins.formats         = {"%02.0f"} 
GMT_mins.element_params  = {"GMT_MINS","GMT_MS"}
GMT_mins.controllers     = {{"text_using_parameter",0,0},{"opacity_using_parameter",1}}  
AddElement(GMT_mins)

local GMT_sec           = CreateElement "ceStringPoly"
GMT_sec.name            = create_guid_string()
GMT_sec.parent_element  = base.name
GMT_sec.material        = FONT
GMT_sec.init_pos        = {center[1]+.01,center[2]+0.0025,center[3]}
GMT_sec.alignment       = "LeftBottom"
GMT_sec.stringdefs      = {0.01,0.7 * 0.01, 0, 0}  -- {size vertical, horizontal, 0, 0}
GMT_sec.formats         = {"%02.0f"} 
GMT_sec.element_params  = {"GMT_SECS","GMT_MS"}
GMT_sec.controllers     = {{"text_using_parameter",0,0},{"opacity_using_parameter",1}}  
AddElement(GMT_sec)

--*************************************************************

local LT_Dhours           = CreateElement "ceStringPoly"
LT_Dhours.name            = create_guid_string()
LT_Dhours.parent_element  = base.name
LT_Dhours.material        = FONT
LT_Dhours.init_pos        = {center[1]-.0171,center[2]-0.0025,center[3]}		
LT_Dhours.alignment       = "RightTop"
LT_Dhours.stringdefs      = {0.01,0.7 * 0.01, 0, 0}  -- {size vertical, horizontal, 0, 0}
LT_Dhours.formats         = {"%01.0f"} 
LT_Dhours.element_params  = {"LT_DHOURS","LT_BLINK_HH"}
LT_Dhours.controllers     = {{"text_using_parameter",0,0},{"opacity_using_parameter",1}}  
AddElement(LT_Dhours)

local LT_hours           = CreateElement "ceStringPoly"
LT_hours.name            = create_guid_string()
LT_hours.parent_element  = base.name
LT_hours.material        = FONT
LT_hours.init_pos        = {center[1]-.01,center[2]-0.0025,center[3]}		
LT_hours.alignment       = "RightTop"
LT_hours.stringdefs      = {0.01,0.7 * 0.01, 0, 0}  -- {size vertical, horizontal, 0, 0}
LT_hours.formats         = {"%01.0f"} 
LT_hours.element_params  = {"LT_HOURS","LT_BLINK_H"}
LT_hours.controllers     = {{"text_using_parameter",0,0},{"opacity_using_parameter",1}}  
AddElement(LT_hours)

local LT_Dmins           = CreateElement "ceStringPoly"
LT_Dmins.name            = create_guid_string()
LT_Dmins.parent_element  = base.name
LT_Dmins.material        = FONT
LT_Dmins.init_pos        = {center[1]-0.0035,center[2]-0.0025,center[3]}	 
LT_Dmins.alignment       = "CenterTop"
LT_Dmins.stringdefs      = {0.01,0.7 * 0.01, 0, 0}  -- {size vertical, horizontal, 0, 0}
LT_Dmins.formats         = {"%01.0f"} 
LT_Dmins.element_params  = {"LT_DMINS","LT_BLINK_MM"}
LT_Dmins.controllers     = {{"text_using_parameter",0,0},{"opacity_using_parameter",1}}  
AddElement(LT_Dmins)

local LT_mins           = CreateElement "ceStringPoly"
LT_mins.name            = create_guid_string()
LT_mins.parent_element  = base.name
LT_mins.material        = FONT
LT_mins.init_pos        = {center[1]+0.0035,center[2]-0.0025,center[3]}	 
LT_mins.alignment       = "CenterTop"
LT_mins.stringdefs      = {0.01,0.7 * 0.01, 0, 0}  -- {size vertical, horizontal, 0, 0}
LT_mins.formats         = {"%01.0f"} 
LT_mins.element_params  = {"LT_MINS","LT_BLINK_M"}
LT_mins.controllers     = {{"text_using_parameter",0,0},{"opacity_using_parameter",1}}  
AddElement(LT_mins)

--**************************************************************

local GMT_mode           = CreateElement "ceStringPoly"
GMT_mode.name            = create_guid_string()
GMT_mode.parent_element  = base.name
GMT_mode.material        = FONT
GMT_mode.init_pos        = {center[1]-0.0225,center[2]-0.0224,center[3]}	 
GMT_mode.alignment       = "RightBottom"
GMT_mode.stringdefs      = {0.8 * 0.01, 0.7 * 0.01, 0, 0}  -- {size vertical, horizontal, 0, 0}
GMT_mode.formats         = {"%s"}
GMT_mode.value           = "1"
GMT_mode.element_params  = {"GMT_MODE"}
GMT_mode.controllers     = {{"opacity_using_parameter",0}}  
AddElement(GMT_mode)

local LT_mode           = CreateElement "ceStringPoly"
LT_mode.name            = create_guid_string()
LT_mode.parent_element  = base.name
LT_mode.material        = FONT
LT_mode.init_pos        = {center[1]-0.015,center[2]-0.0224,center[3]}	 
LT_mode.alignment       = "CenterBottom"
LT_mode.stringdefs      = {0.8 * 0.01, 0.7 * 0.01, 0, 0}  -- {size vertical, horizontal, 0, 0}
LT_mode.formats         = {"%s"}
LT_mode.value            = "1"
LT_mode.element_params  = {"LT_MODE"}
LT_mode.controllers     = {{"opacity_using_parameter",0}}  
AddElement(LT_mode)

local EL_mode           = CreateElement "ceStringPoly"
EL_mode.name            = create_guid_string()
EL_mode.parent_element  = base.name
EL_mode.material        = FONT
EL_mode.init_pos        = {center[1]+0.0015,center[2]-0.0224,center[3]}	 
EL_mode.alignment       = "CenterBottom"
EL_mode.stringdefs      = {0.8 * 0.01, 0.7 * 0.01, 0, 0}  -- {size vertical, horizontal, 0, 0}
EL_mode.formats         = {"%s"}
EL_mode.value           = "1"
EL_mode.element_params  = {"EL_MODE"}
EL_mode.controllers     = {{"opacity_using_parameter",0}}  
AddElement(EL_mode)

