dofile(LockOn_Options.common_script_path .. "elements_defs.lua")



local LEVEL          = 1

local screen         = MakeMaterial(nil, { 150, 0, 0, 255 })

local redColor       = { 250, 20, 20, 255 }
local font7segment   = MakeFont({ used_DXUnicodeFontData = "DSEG7Classic-bold" }, redColor)

local Width          = 0.051936
local Height         = 0.01747

local verts          = {}
verts[1]             = { -0.5 * Width, 0.5 * Height }
verts[2]             = { 0.5 * Width, 0.5 * Height }
verts[3]             = { 0.5 * Width, -0.5 * Height }
verts[4]             = { -0.5 * Width, -0.5 * Height }

-- background
local base           = CreateElement "ceMeshPoly"
base.name            = create_guid_string()
base.material        = screen
base.vertices        = verts
base.indices         = { 0, 1, 2, 2, 3, 0 }
base.init_pos        = { 0, 0.0005, 0 }
base.h_clip_relation = h_clip_relations.REWRITE_LEVEL
base.level           = LEVEL
base.isdraw          = true
base.isvisible       = false
base.element_params  = {
	"ANARC182_DISP_POWER",
	"ANARC182_BRIGHTNESS",
}
base.controllers     = {
	{"parameter_in_range",0,0.9,1.1}
}
Add(base)

local fonx             = 0.0065
local fony             = 0.008
local digits           = CreateElement "ceStringPoly"
digits.name            = create_guid_string()
digits.material        = font7segment
digits.alignment       = "RightCenter"
digits.init_pos        = { -0.05 * fonx, 0.0, 0, 0 }
digits.stringdefs      = { fony, fonx, -0.1 * fonx, 0 } -- {size vertical, horizontal, 0, 0}
digits.formats         = { "%3.0f" }
digits.element_params  = {
	"ANARC182_MHZ",
	"ANARC182_BRIGHTNESS"
}
digits.controllers     = {
	{ "text_using_parameter",    0, 0 },
	{ "opacity_using_parameter", 1 }
}
digits.h_clip_relation = h_clip_relations.REWRITE_LEVEL
digits.level           = LEVEL
digits.parent_element  = base.name
Add(digits)



local dot           = CreateElement "ceStringPoly"
dot.name            = create_guid_string()
dot.material        = font7segment
dot.alignment       = "RightCenter"
dot.init_pos        = { 0.9 * fonx, 0, 0 }
dot.stringdefs      = { fony, fonx, -0.1 * fonx, 0 } -- {size vertical, horizontal, 0, 0}
dot.value           = "."
dot.element_params  = {
	"ANARC182_BRIGHTNESS"
}
dot.controllers     = {
	{ "opacity_using_parameter", 0 }
}
dot.h_clip_relation = h_clip_relations.REWRITE_LEVEL
dot.level           = LEVEL
dot.parent_element  = base.name
Add(dot)


local digittens           = CreateElement "ceStringPoly"
digittens.name            = create_guid_string()
digittens.material        = font7segment
digittens.alignment       = "RightCenter"
digittens.init_pos        = { 0.9 * fonx, 0, 0 }
digittens.stringdefs      = { fony, fonx, -0.1 * fonx, 0 } -- {size vertical, horizontal, 0, 0}
digittens.formats         = { "%1.0f" }
digittens.element_params  = {
	"ANARC182_100KHZ",
	"ANARC182_BRIGHTNESS"
}
digittens.controllers     = {
	{ "text_using_parameter",    0, 0 },
	{ "opacity_using_parameter", 1 }
}
digittens.h_clip_relation = h_clip_relations.REWRITE_LEVEL
digittens.level           = LEVEL
digittens.parent_element  = base.name
Add(digittens)


local digitshundrets           = CreateElement "ceStringPoly"
digitshundrets.name            = create_guid_string()
digitshundrets.material        = font7segment
digitshundrets.alignment       = "RightCenter"
digitshundrets.init_pos        = { 3 * 0.9 * fonx, 0, 0 }
digitshundrets.stringdefs      = { fony, fonx, -0.1 * fonx, 0 } -- {size vertical, horizontal, 0, 0}
digitshundrets.formats         = { "%02.0f" }
digitshundrets.element_params  = {
	"ANARC182_10KHZ",
	"ANARC182_VALID",
	"ANARC182_BRIGHTNESS"
}
digitshundrets.controllers     = {
	{ "text_using_parameter",    0, 0 },
	{ "parameter_in_range",      1, 0.5, 1.1 },
	{ "opacity_using_parameter", 2 }
}
digitshundrets.h_clip_relation = h_clip_relations.REWRITE_LEVEL
digitshundrets.level           = LEVEL
digitshundrets.parent_element  = base.name
Add(digitshundrets)


local not_valid           = CreateElement "ceStringPoly"
not_valid.name            = create_guid_string()
not_valid.material        = font7segment
not_valid.alignment       = "RightCenter"
not_valid.init_pos        = { 3*0.9 * fonx, 0, 0 }
not_valid.stringdefs      = { fony, fonx, -0.1 * fonx, 0 } -- {size vertical, horizontal, 0, 0}
not_valid.value           = "  "
not_valid.element_params  = {
	"ANARC182_BRIGHTNESS"
}
not_valid.controllers     = {
	{ "opacity_using_parameter", 0 }
}
not_valid.h_clip_relation = h_clip_relations.REWRITE_LEVEL
not_valid.level           = LEVEL
not_valid.parent_element  = base.name
Add(not_valid)