dofile(LockOn_Options.script_path .. "command_defs.lua")
dofile(LockOn_Options.script_path .. "devices.lua")

dofile(LockOn_Options.script_path .. "..\\..\\default_radio_presets.lua")

package.cpath = package.cpath .. ";" .. LockOn_Options.script_path .. "..\\..\\bin\\?.dll"
require('cefmRadio')



local COM3 = nil
local COM4 = nil
local COM5 = nil
local INTERCOM = nil
local timer = 0.0
local dev = GetSelf()
local radio_power = get_param_handle("RADIO_POWER_AVAIL")
local INTERCOM_SELECT = get_param_handle("INTERCOM_SELECT")
local ANARC182_DISP_POWER = get_param_handle("ANARC182_DISP_POWER")

local ANARC182_MHZ = get_param_handle("ANARC182_MHZ")
local ANARC182_100KHZ = get_param_handle("ANARC182_100KHZ")
local ANARC182_10KHZ = get_param_handle("ANARC182_10KHZ")
local ANARC182_BRIGHTNESS = get_param_handle("ANARC182_BRIGHTNESS")

local ANARC182_VALID = get_param_handle("ANARC182_VALID")
local RADIO2_ICS = get_param_handle("RADIO2_ICS")

local intercom_select = 2
local ind_10MHz = 0
local ind_1MHz = 0
local ind_100KHz = 0
local ind_10KHz = 0

local frequency = 100
local volume = 0.5
local brightness = 0.5

local mode = 2

local power = 0 --0 off,1 on
local preset = 10

local radio_presets

local update_time_step = 0.01

local AM_guard = 121.5
local FM_guard = 40.5

local modulation = 0        --0 FM 1 AM
local modulation_switch = 0 --0 FM 1 AM

local frequency_mode = 0


dev:listen_command(Keys.arc182_10mhz_up)
dev:listen_command(Keys.arc182_10mhz_down)
dev:listen_command(Keys.arc182_1mhz_up)
dev:listen_command(Keys.arc182_1mhz_down)
dev:listen_command(Keys.arc182_100khz_up)
dev:listen_command(Keys.arc182_100khz_down)
dev:listen_command(Keys.arc182_10khz_up)
dev:listen_command(Keys.arc182_10khz_down)
dev:listen_command(Keys.arc182_am)
dev:listen_command(Keys.arc182_fm)
dev:listen_command(Keys.arc182_amfm_toggle)
dev:listen_command(Keys.arc182_vol_inc)
dev:listen_command(Keys.arc182_vol_dec)
dev:listen_command(Keys.arc182_brt_inc)
dev:listen_command(Keys.arc182_brt_dec)
dev:listen_command(Keys.arc182_freq_mode_inc)
dev:listen_command(Keys.arc182_freq_mode_dec)
dev:listen_command(Keys.arc182_mode_inc)
dev:listen_command(Keys.arc182_mode_dec)
dev:listen_command(Keys.arc182_preset_inc)
dev:listen_command(Keys.arc182_preset_dec)


local function update_communicator()
  if intercom_select == 3 then
    if frequency <155 then 
      if modulation == 0 then
        INTERCOM:set_communicator(devices.COM3)
        INTERCOM:make_setup_for_communicator()
        cefmRadio.SetCurrentCommunicator(2)
        -- print_message_to_user("Enable Com3 182FM")
        -- print_message_to_user(COM3:get_frequency()/1E6)
      else
        INTERCOM:set_communicator(devices.COM4)
        INTERCOM:make_setup_for_communicator()
        cefmRadio.SetCurrentCommunicator(3)
        -- print_message_to_user("Enable Com4 182AM")
        -- print_message_to_user(COM4:get_frequency()/1E6)
      end
    else
      INTERCOM:set_communicator(devices.COM5)
      INTERCOM:make_setup_for_communicator()
      cefmRadio.SetCurrentCommunicator(4)
      -- print_message_to_user("Enable Com5 182 UHF")
      -- print_message_to_user(COM5:get_frequency()/1E6)
    end
  end
end

local function GetRadioChannels()
  if get_aircraft_mission_data == nil then
    return get_default_radio_presets()[2]
  end
  local radio = get_aircraft_mission_data("Radio")
  if radio == nil then
    return get_default_radio_presets()[2]
  end
  if radio[2] == nil then
    return get_default_radio_presets()[2]
  end
  if radio[2].channels then
    return radio[2].channels
  end
  return get_default_radio_presets()[2]
end

local function get_display_numbers_from_freq(freq)
  local mhz = math.floor(freq + 0.01)
  local khz1 = math.floor((freq - mhz) * 10 + 0.01)
  local khz2 = math.floor((1000 * (freq - mhz) - 100 * khz1) + 0.01)
  return mhz, khz1, khz2
end

local function update_frequency()
  local old_modulation = modulation
  if frequency_mode == 0 then
    frequency = 243.0
  elseif frequency_mode == 1 then
    frequency = (
      (ind_10MHz + 3) * 10 + ind_1MHz * 1 +
      ind_100KHz * 0.100 + ind_10KHz * 0.025)
  elseif frequency_mode == 2 then
    if modulation_switch == 0 then
      frequency = FM_guard
      modulation = 0
    else
      frequency = AM_guard
      modulation = 1
    end
  elseif frequency_mode == 3 then
    frequency = radio_presets[preset]
  end
  local valid = false
  if frequency < 88 then
    valid = true
    modulation = 0
  elseif frequency >= 118 and frequency < 156 then
    valid = true
    modulation = 1
  elseif frequency >= 225 then
    valid = true
    modulation = modulation_switch
    COM5:set_modulation(modulation)
  end

  if old_modulation ~= modulation then
    update_communicator()
  end
  if valid then
    ANARC182_VALID:set(1.0)
  else
    ANARC182_VALID:set(0.0)
  end

  COM3:set_frequency(frequency * 1E6)
  COM4:set_frequency(frequency * 1E6)
  COM5:set_frequency(frequency * 1E6)
  local mhz, khz1, khz2 = get_display_numbers_from_freq(frequency)
  ANARC182_MHZ:set(mhz)
  ANARC182_100KHZ:set(khz1)
  ANARC182_10KHZ:set(khz2)
end


local function increase_10MHz()
  if frequency_mode == 1 then
    ind_10MHz = ind_10MHz + 1
    if ind_10MHz > 36 then ind_10MHz = 0 end
    update_frequency()
  end
end
local function decrease_10MHz()
  if frequency_mode == 1 then
    ind_10MHz = ind_10MHz - 1
    if ind_10MHz < 0 then ind_10MHz = 36 end
    update_frequency()
  end
end

local function increase_1MHz()
  if frequency_mode == 1 then
    ind_1MHz = ind_1MHz + 1
    if ind_1MHz > 9 then ind_1MHz = 0 end
    update_frequency()
  end
end
local function decrease_1MHz()
  if frequency_mode == 1 then
    ind_1MHz = ind_1MHz - 1
    if ind_1MHz < 0 then ind_1MHz = 9 end
    update_frequency()
  end
end

local function increase_100KHz()
  if frequency_mode == 1 then
    ind_100KHz = ind_100KHz + 1
    if ind_100KHz > 9 then ind_100KHz = 0 end
    update_frequency()
  end
end
local function decrease_100KHz()
  if frequency_mode == 1 then
    ind_100KHz = ind_100KHz - 1
    if ind_100KHz < 0 then ind_100KHz = 9 end
    update_frequency()
  end
end

local function increase_10KHz()
  if frequency_mode == 1 then
    ind_10KHz = ind_10KHz + 1
    if ind_10KHz > 3 then ind_10KHz = 0 end
    update_frequency()
  end
end
local function decrease_10KHz()
  if frequency_mode == 1 then
    ind_10KHz = ind_10KHz - 1
    if ind_10KHz < 0 then ind_10KHz = 3 end
    update_frequency()
  end
end



make_default_activity(update_time_step)


function post_initialize()
  radio_presets = GetRadioChannels()


  COM3 = GetDevice(devices.COM3)
  COM4 = GetDevice(devices.COM4)
  COM5 = GetDevice(devices.COM5)
  INTERCOM = GetDevice(devices.INTERCOM)

  local birth = LockOn_Options.init_conditions.birth_place
  if birth == "GROUND_HOT" or birth == "AIR_HOT" then
    dev:performClickableAction(device_commands.ARC182_Mode,3.0/7.0,true)
  elseif birth == "GROUND_COLD" then
    dev:performClickableAction(device_commands.ARC182_Mode,0.0/7.0,true)
  end
  dev:performClickableAction(device_commands.ARC182_Brt, 0.5, true)
  dev:performClickableAction(device_commands.ARC182_Freq_Mode, 1.0/5.0, true)
  dev:performClickableAction(device_commands.ARC182_Vol, 0.5, true)

  update_frequency()
end

function SetCommand(command, value)
  if command == device_commands.ARC182_Sql then
    -- print_message_to_user("ARC182_Sql : " .. tostring(value), 5)
  end

  if command == Keys.arc182_10mhz_up then 
    increase_10MHz()
  end
  if command == Keys.arc182_10mhz_down then 
    decrease_10MHz()
  end
  if command == device_commands.ARC182_10MHz_down then
    if value < -0.5 then decrease_10MHz() end
  end
  if command == device_commands.ARC182_10MHz_up then
    if value > 0.5 then increase_10MHz() end
  end

  if command == Keys.arc182_1mhz_up then 
    increase_1MHz()
  end
  if command == Keys.arc182_1mhz_down then 
    decrease_1MHz()
  end
  if command == device_commands.ARC182_1MHz_down then
    if value < -0.5 then decrease_1MHz() end
  end
  if command == device_commands.ARC182_1MHz_up then
    if value > 0.5 then increase_1MHz() end
  end

  if command == Keys.arc182_100khz_up then 
    increase_100KHz()
  end
  if command == Keys.arc182_100khz_down then 
    decrease_100KHz()
  end
  if command == device_commands.ARC182_100KHz_down then
    if value < -0.5 then decrease_100KHz() end
  end
  if command == device_commands.ARC182_100KHz_up then
    if value > 0.5 then increase_100KHz() end
  end

  if command == Keys.arc182_10khz_up then 
    increase_10KHz()
  end
  if command == Keys.arc182_10khz_down then 
    decrease_10KHz()
  end
  if command == device_commands.ARC182_10KHz_down then
    if value < -0.5 then decrease_10KHz() end
  end
  if command == device_commands.ARC182_10KHz_up then
    if value > 0.5 then increase_10KHz() end
  end


  if command == Keys.arc182_am then 
    print_message_to_user("am")
    dev:performClickableAction(device_commands.ARC182_AM_FM,1,true)
  end
  if command == Keys.arc182_fm then 
    print_message_to_user("fm")
    dev:performClickableAction(device_commands.ARC182_AM_FM,0,true)
  end
  if command == Keys.arc182_amfm_toggle then 
    print_message_to_user("toggle")
    if modulation_switch >0.5 then 
      dev:performClickableAction(device_commands.ARC182_AM_FM,0,true)
    else
      dev:performClickableAction(device_commands.ARC182_AM_FM,1,true)
    end
  end
  if command == device_commands.ARC182_AM_FM then
    modulation_switch = value
    update_frequency()
  end

  if command == Keys.arc182_vol_inc then 
    volume = volume + 0.0015
    if volume > 1.0 then volume = 1.0 end
    dev:performClickableAction(device_commands.ARC182_Vol,volume,true)
  end
  if command == Keys.arc182_vol_dec then 
    volume = volume - 0.0015
    if volume < 0.0 then volume = 0.0 end
    dev:performClickableAction(device_commands.ARC182_Vol,volume,true)
  end
  if command == device_commands.ARC182_Vol then
    volume = value
    cefmRadio.SetVolume(2, volume*RADIO2_ICS:get())
    cefmRadio.SetVolume(3, volume*RADIO2_ICS:get())
    cefmRadio.SetVolume(4, volume*RADIO2_ICS:get())
  end

  if command == Keys.arc182_preset_inc then 
    dev:performClickableAction(device_commands.ARC182_Preset,0.1,true)
  end
  if command == Keys.arc182_preset_dec then 
    dev:performClickableAction(device_commands.ARC182_Preset,-0.1,true)
  end
  if command == device_commands.ARC182_Preset then 

    if value>0 then 
      preset = preset+1
      if preset >20 then preset = 1 end
    else
      preset = preset-1
      if preset <1 then preset = 20 end
    end
    update_frequency()
  end

  if command == Keys.arc182_freq_mode_inc then 
    frequency_mode = frequency_mode+1
    if frequency_mode > 5 then frequency_mode = 5 end
    dev:performClickableAction(device_commands.ARC182_Freq_Mode,frequency_mode*0.20,true)
  end
  if command == Keys.arc182_freq_mode_dec then 
    frequency_mode = frequency_mode-1
    if frequency_mode < 0 then frequency_mode = 0 end
    dev:performClickableAction(device_commands.ARC182_Freq_Mode,frequency_mode*0.20,true)
  end
  if command == device_commands.ARC182_Freq_Mode then
    frequency_mode = math.floor(value / 0.20 + 0.1)
    update_frequency()
  end

  if command == Keys.arc182_brt_inc then 
    brightness = brightness + 0.0015
    if brightness > 1.0 then brightness = 1.0 end
    dev:performClickableAction(device_commands.ARC182_Brt,brightness,true)
  end
  if command == Keys.arc182_brt_dec then 
    brightness = brightness - 0.0015
    if brightness < 0.0 then brightness = 0.0 end
    dev:performClickableAction(device_commands.ARC182_Brt,brightness,true)
  end
  if command == device_commands.ARC182_Brt then
    brightness = value
    ANARC182_BRIGHTNESS:set(value)
  end

  if command == Keys.arc182_mode_inc then 
    mode = mode+1
    if mode > 7 then mode = 7 end
    dev:performClickableAction(device_commands.ARC182_Mode,mode/7.0,true)
  end
  if command == Keys.arc182_mode_dec then 
    mode = mode-1
    if mode < 0 then mode = 0 end
    dev:performClickableAction(device_commands.ARC182_Mode,mode/7.0,true)
  end
  if command == device_commands.ARC182_Mode then
    mode = math.floor(value * 7.0 + 0.1)
  end
end

function update()
  local actual_power = radio_power:get() > 0.5
  local enable_radios = false
  local enable_display = false
  if (actual_power ==true) then
    if mode == 2 or mode == 3 then
      enable_radios = true
    end
    if mode > 0 then enable_display = true end
  end

  if enable_display then
    ANARC182_DISP_POWER:set(1.0)
  else
    ANARC182_DISP_POWER:set(0.0)
  end

  if enable_radios then 
    cefmRadio.SetPower(2, true)
    cefmRadio.SetPower(3, true)
    cefmRadio.SetPower(4, true)
  else
    cefmRadio.SetPower(2, false)
    cefmRadio.SetPower(3, false)
    cefmRadio.SetPower(4, false)
  end
  local actual_intercom_select = INTERCOM_SELECT:get()
  if intercom_select ~= actual_intercom_select then
    intercom_select = actual_intercom_select
    update_communicator()
  end
  timer = timer + update_time_step
  if timer > 1 then
    -- print_message_to_user("COM3: "..COM3:get_modulation())
    -- print_message_to_user("COM4: "..COM4:get_modulation())
    -- print_message_to_user("COM5: "..COM5:get_modulation())
    timer =0
  end
end

need_to_be_closed = false
