dofile(LockOn_Options.script_path .. "command_defs.lua")
dofile(LockOn_Options.script_path .. "devices.lua")

dofile(LockOn_Options.script_path .. "..\\..\\default_radio_presets.lua")

package.cpath = package.cpath .. ";" .. LockOn_Options.script_path .. "..\\..\\bin\\?.dll"
require('cefmRadio')


cefmRadio.ClearRadios()

local timer = 0

local COM1 = nil
local COM2 = nil
local INTERCOM = nil

local dev = GetSelf()
local dc_ok = false
local radio_power = get_param_handle("RADIO_POWER_AVAIL")

local INTERCOM_SELECT = get_param_handle("INTERCOM_SELECT")

local RADIO1_ICS = get_param_handle("RADIO1_ICS")

local intercom_select = 2
local ind_10MHz = 0
local ind_1MHz = 0
local ind_100KHz = 0
local ind_10KHz = 0

local frequency = 100
local volume = 0.5

local mode = 2  -- 0="em_am" 1="em_fm", 2="manual", 3="preset"

local power = 0 --0 off,1 on
local preset = 1
local ind_power = 0.5

local radio_presets

local update_time_step = 0.01

local AM_guard = 121.5
local FM_guard = 40.5

dev:listen_command(Keys.arc186_vol_inc)
dev:listen_command(Keys.arc186_vol_dec)
dev:listen_command(Keys.arc186_mode_inc)
dev:listen_command(Keys.arc186_mode_dec)
dev:listen_command(Keys.arc186_10mhz_up)
dev:listen_command(Keys.arc186_10mhz_down)
dev:listen_command(Keys.arc186_1mhz_up)
dev:listen_command(Keys.arc186_1mhz_down)
dev:listen_command(Keys.arc186_100khz_up)
dev:listen_command(Keys.arc186_100khz_down)
dev:listen_command(Keys.arc186_10khz_up)
dev:listen_command(Keys.arc186_10khz_down)
dev:listen_command(Keys.arc186_power_inc)
dev:listen_command(Keys.arc186_power_dec)
dev:listen_command(Keys.arc186_wheel_inc)
dev:listen_command(Keys.arc186_wheel_dec)


local function update_communicator()
  if intercom_select == 2 then
    if frequency < 90.0 then
      INTERCOM:set_communicator(devices.COM1)
      INTERCOM:make_setup_for_communicator()
      cefmRadio.SetCurrentCommunicator(0)
      -- print_message_to_user("Enable Com1 186FM")
    else
      INTERCOM:set_communicator(devices.COM2)
      INTERCOM:make_setup_for_communicator()
      cefmRadio.SetCurrentCommunicator(1)
      -- print_message_to_user("Enable Com2 186AM")
    end
  end
end

local function GetRadioChannels()
  if get_aircraft_mission_data == nil then
    return get_default_radio_presets()[1]
  end
  local radio = get_aircraft_mission_data("Radio")
  if radio == nil then
    return get_default_radio_presets()[1]
  end
  if radio[1] == nil then
    return get_default_radio_presets()[1]
  end
  if radio[1].channels then
    return radio[1].channels
  end
  return get_default_radio_presets()[1]
end

local function increase_10MHz()
  ind_10MHz = ind_10MHz + 1
  if ind_10MHz > 12 then ind_10MHz = 0 end
end
local function decrease_10Mhz()
  ind_10MHz = ind_10MHz - 1
  if ind_10MHz < 0 then ind_10MHz = 12 end
end

local function increase_1Mhz()
  ind_1MHz = ind_1MHz + 1
  if ind_1MHz > 9 then ind_1MHz = 0 end
end
local function decrease_1Mhz()
  ind_1MHz = ind_1MHz - 1
  if ind_1MHz < 0 then ind_1MHz = 9 end
end

local function increase_100Khz()
  ind_100KHz = ind_100KHz + 1
  if ind_100KHz > 9 then ind_100KHz = 0 end
end
local function decrease_100Khz()
  ind_100KHz = ind_100KHz - 1
  if ind_100KHz < 0 then ind_100KHz = 9 end
end

local function increase_10Khz()
  ind_10KHz = ind_10KHz + 1
  if ind_10KHz > 3 then ind_10KHz = 0 end
end
local function decrease_10Khz()
  ind_10KHz = ind_10KHz - 1
  if ind_10KHz < 0 then ind_10KHz = 3 end
end

local function update_frequency()
  local old_frequency = frequency
  if mode == 0 then
    frequency = FM_guard
  elseif mode == 1 then
    frequency = AM_guard
  elseif mode == 2 then
    frequency = (
      (ind_10MHz + 3) * 10 + ind_1MHz * 1 +
      ind_100KHz * 0.100 + ind_10KHz * 0.025)
  else
    frequency = radio_presets[preset]
  end
  COM1:set_frequency(frequency * 1E6)
  COM2:set_frequency(frequency * 1E6)
  if (old_frequency > 90.0 and frequency < 90.0) or
      (old_frequency < 90.0 and frequency > 90.0) then
    update_communicator()
  end
  -- print_message_to_user(frequency)
end


make_default_activity(update_time_step)

function post_initialize()
  radio_presets = GetRadioChannels()


  COM1 = GetDevice(devices.COM1)
  COM2 = GetDevice(devices.COM2)
  INTERCOM = GetDevice(devices.INTERCOM)

  if cefmRadio.SetElectricSystem(GetDevice(devices.ELECTRIC_SYSTEM)) then
    -- print_message_to_user("Radio - Set Electric System: Succesful")

    if cefmRadio.SetIntercom(INTERCOM) then
      -- print_message_to_user("Radio - Set Intercom: Succesful")

      if cefmRadio.AddRadio(GetDevice(devices.COM1)) then
        -- print_message_to_user("Radio - Set Radio: Succesful")
        if cefmRadio.AddRadio(GetDevice(devices.COM2)) then
          -- print_message_to_user("Radio - Set Radio: Succesful")
          if cefmRadio.AddRadio(GetDevice(devices.COM3)) then
            -- print_message_to_user("Radio - Set Radio: Succesful")
            if cefmRadio.AddRadio(GetDevice(devices.COM4)) then
              -- print_message_to_user("Radio - Set Radio: Succesful")
              if cefmRadio.AddRadio(GetDevice(devices.COM5)) then
                -- print_message_to_user("Radio - Set Radio: Succesful")
                if cefmRadio.AddRadio(GetDevice(devices.COM6)) then
                  -- print_message_to_user("Radio - Set Radio: Succesful")
                  if cefmRadio.AddRadio(GetDevice(devices.COM7)) then
                    -- print_message_to_user("Radio - Set Radio: Succesful")
                    if cefmRadio.AddRadio(GetDevice(devices.COM8)) then
                      -- print_message_to_user("Radio - Set Radio: Succesful")

                      if cefmRadio.Setup() == true then
                        cefmRadio.SetCrewComm(true)
                        cefmRadio.SetBareVoice(true)
                        cefmRadio.SetEnableTransmission(0, true)
                        cefmRadio.SetEnableTransmission(1, true)
                        --cefmRadio.SetPower(0, false)
                        --cefmRadio.SetPower(1, false)

                        -- print_message_to_user("Radio - Setup: Succesful")
                      else
                        print_message_to_user("Radio - Setup: Failed")
                      end
                    else
                      print_message_to_user("Radio - Set Radio: Failed")
                    end
                  else
                    print_message_to_user("Radio - Set Radio: Failed")
                  end
                else
                  print_message_to_user("Radio - Set Radio: Failed")
                end
              else
                print_message_to_user("Radio - Set Radio: Failed")
              end
            else
              print_message_to_user("Radio - Set Radio: Failed")
            end
          else
            print_message_to_user("Radio - Set Radio: Failed")
          end
        else
          print_message_to_user("Radio - Set Radio: Failed")
        end
      else
        print_message_to_user("Radio - Set Radio: Failed")
      end
    else
      print_message_to_user("Radio - Set Intercom: Failed")
    end
  else
    print_message_to_user("Radio - Set Electric System: Failed")
  end

  INTERCOM:set_communicator(devices.COM1)
  INTERCOM:make_setup_for_communicator()
  INTERCOM:set_communicator(devices.COM2)
  INTERCOM:make_setup_for_communicator()
  INTERCOM:set_communicator(devices.COM3)
  INTERCOM:make_setup_for_communicator()
  INTERCOM:set_communicator(devices.COM4)
  INTERCOM:make_setup_for_communicator()
  INTERCOM:set_communicator(devices.COM5)
  INTERCOM:make_setup_for_communicator()
  INTERCOM:set_communicator(devices.COM6)
  INTERCOM:make_setup_for_communicator()
  INTERCOM:set_communicator(devices.COM7)
  INTERCOM:make_setup_for_communicator()
  INTERCOM:set_communicator(devices.COM8)
  INTERCOM:make_setup_for_communicator()



  local birth = LockOn_Options.init_conditions.birth_place
  if birth == "GROUND_HOT" or birth == "AIR_HOT" then
    dev:performClickableAction(device_commands.ARC186_POWER, 0.5, true)
  elseif birth == "GROUND_COLD" then
    dev:performClickableAction(device_commands.ARC186_POWER, 0.0, true)
  end

  dev:performClickableAction(device_commands.ARC186_Mode, 2.0 / 3.0, true)

  dev:performClickableAction(device_commands.ARC186_10M, 0.0 / 12.0, true)
  dev:performClickableAction(device_commands.ARC186_1M, 0.0 / 9.0, true)
  dev:performClickableAction(device_commands.ARC186_100K, 0.0 / 9.0, true)
  dev:performClickableAction(device_commands.ARC186_100K, 0.0 / 9.0, true)

  dev:performClickableAction(device_commands.ARC186_Vol, 0.5, true)
end

function SetCommand(command, value)

  if command == Keys.arc186_vol_inc then 
    volume = volume + 0.0015
    if volume > 1.0 then volume = 1.0 end
    dev:performClickableAction(device_commands.ARC186_Vol,volume,true)
  end
  if command == Keys.arc186_vol_dec then 
    volume = volume - 0.0015
    if volume < 0.0 then volume = 0.0 end
    dev:performClickableAction(device_commands.ARC186_Vol,volume,true)
  end
  if command == device_commands.ARC186_Vol then
    volume = value
    cefmRadio.SetVolume(0, volume*RADIO1_ICS:get())
    cefmRadio.SetVolume(1, volume*RADIO1_ICS:get())
  end

  if command == Keys.arc186_mode_inc then 
    mode = mode+1
    if mode > 3 then mode = 3 end
    dev:performClickableAction(device_commands.ARC186_Mode,mode/3.0,true)
  end
  if command == Keys.arc186_mode_dec then 
    mode = mode-1
    if mode < 0 then mode = 0 end
    dev:performClickableAction(device_commands.ARC186_Mode,mode/3.0,true)
  end
  if command == device_commands.ARC186_Mode then
    mode = math.floor(value * 3 + 0.1)
    update_frequency()
  end


  if command == Keys.arc186_10mhz_up then 
    ind_10MHz = ind_10MHz+1
    if ind_10MHz > 12 then ind_10MHz = 0 end
    dev:performClickableAction(device_commands.ARC186_10M,ind_10MHz/12.0,true)
  end
  if command == Keys.arc186_10mhz_down then 
    ind_10MHz = ind_10MHz-1
    if ind_10MHz < 0 then ind_10MHz = 12 end
    dev:performClickableAction(device_commands.ARC186_10M,ind_10MHz/12.0,true)
  end
  if command == device_commands.ARC186_10M then
    ind_10MHz = math.floor(value * 12 + 0.1)
    update_frequency()
  end


  if command == Keys.arc186_1mhz_up then 
    ind_1MHz = ind_1MHz+1
    if ind_1MHz > 9 then ind_1MHz = 0 end
    dev:performClickableAction(device_commands.ARC186_1M,ind_1MHz/9.0,true)
  end
  if command == Keys.arc186_1mhz_down then 
    ind_1MHz = ind_1MHz-1
    if ind_1MHz < 0 then ind_1MHz = 9 end
    dev:performClickableAction(device_commands.ARC186_1M,ind_1MHz/9.0,true)
  end
  if command == device_commands.ARC186_1M then
    ind_1MHz = math.floor(value * 9 + 0.1)
    update_frequency()
  end

  if command == Keys.arc186_100khz_up then 
    ind_100KHz = ind_100KHz+1
    if ind_100KHz > 9 then ind_100KHz = 0 end
    dev:performClickableAction(device_commands.ARC186_100K,ind_100KHz/9.0,true)
  end
  if command == Keys.arc186_100khz_down then 
    ind_100KHz = ind_100KHz-1
    if ind_100KHz < 0 then ind_100KHz = 9 end
    dev:performClickableAction(device_commands.ARC186_100K,ind_100KHz/9.0,true)
  end
  if command == device_commands.ARC186_100K then
    ind_100KHz = math.floor(value * 9 + 0.1)
    update_frequency()
  end

  if command == Keys.arc186_10khz_up then 
    ind_10KHz = ind_10KHz+1
    if ind_10KHz > 3 then ind_10KHz = 0 end
    dev:performClickableAction(device_commands.ARC186_10K,ind_10KHz/3.0,true)
  end
  if command == Keys.arc186_10khz_down then 
    ind_10KHz = ind_10KHz-1
    if ind_10KHz < 0 then ind_10KHz = 3 end
    dev:performClickableAction(device_commands.ARC186_10K,ind_10KHz/3.0,true)
  end
  if command == device_commands.ARC186_10K then
    ind_10KHz = math.floor(value * 3 + 0.1)
    update_frequency()
  end

  if command == Keys.arc186_power_inc then 
    ind_power = ind_power + 1
    if ind_power > 2 then ind_power = 2 end
    dev:performClickableAction(device_commands.ARC186_POWER,ind_power/2.0,true)
  end
  if command == Keys.arc186_power_dec then 
    ind_power = ind_power - 1
    if ind_power < 0 then ind_power = 0 end
    dev:performClickableAction(device_commands.ARC186_POWER,ind_power/2.0,true)
  end
  if command == device_commands.ARC186_POWER then
    ind_power = math.floor(value*2.0+0.1)
    if ind_power ==1 then 
      power = 1
    else
      power = 0
    end
  end

  if command == Keys.arc186_wheel_inc then 
    preset = preset+1
    if preset > 20 then preset = 1 end
    dev:performClickableAction(device_commands.ARC186_Wheel,(preset-1.0)/19.0,true)
  end
  if command == Keys.arc186_wheel_dec then 
    preset = preset-1
    if preset < 1 then preset = 20 end
    dev:performClickableAction(device_commands.ARC186_Wheel,(preset-1.0)/19.0,true)
  end
  if command == device_commands.ARC186_Wheel then
    preset = math.floor(value * 19 + 0.1) + 1
    update_frequency()
  end
  
  if command == device_commands.ARC186_Tone then
    -- no effect
  end
end

function update()
  local actual_power = radio_power:get() > 0.5
  if dc_ok ~= actual_power and power == 1 then
    cefmRadio.SetPower(0, true)
    cefmRadio.SetPower(1, true)
  else
    cefmRadio.SetPower(0, false)
    cefmRadio.SetPower(1, false)
  end
  local actual_intercom_select = INTERCOM_SELECT:get()
  if intercom_select ~= actual_intercom_select then
    intercom_select = actual_intercom_select
    update_communicator()
  end
  timer = timer + update_time_step
  if timer > 1 then
    --COM1:set_modulation(0)
    -- COM2:set_modulation(1)
    -- print_message_to_user("COM1: " .. COM1:get_modulation())
    -- print_message_to_user("COM2: " .. COM2:get_modulation())
    -- print_message_to_user("COM1: " .. COM1:get_frequency() / 1E6)
    -- print_message_to_user("COM2: " .. COM2:get_frequency() / 1E6)
    -- print_message_to_user("COM2: "..COM2:get_modulation())
    timer = 0
  end
end

need_to_be_closed = false
