dofile(LockOn_Options.script_path.."TNL3100/TNL3100_typedefs.lua")
dofile(LockOn_Options.script_path.."TNL3100/TNL3100_formatter.lua")
local TNL3100_FPL = {}
TNL3100_FPL.__index = TNL3100_FPL

row1 = get_param_handle("TNL3100_ROW1")
row2 = get_param_handle("TNL3100_ROW2")


function calcBearing2D(a,b)
    local delta_x = b.x - a.x
    local delta_y = b.y - a.y
    
    local bearing = math.deg(math.atan2(delta_y, delta_x)) % 360

    return bearing
end

function calcDistance2D(a,b)
    local delta_x = b.x - a.x
    local delta_y = b.y - a.y
    local distance = math.sqrt(delta_x * delta_x + delta_y * delta_y)
    return distance
end


function TNL3100_FPL.new()
    return setmetatable({

        fpl_selection = 1,
        mode = FPL_MODE.active_plan,
        edit_menu_selection = FPL_EDIT_MENU.add,
        menu_selection = 3,
        leg_selection = 1,
        flash_timer = 0,
        timer = 0

    }, TNL3100_FPL)
end

function TNL3100_FPL:draw_fpl(state,edit,flash)
    wps = state:get_flight_plan_waypoints()
    if #wps > 1 then 
        local wp1 = wps[1]
        local wp_end = wps[#wps]
        
        local r1 = string.format("%sTO %s ACTIVE", 
            padToLength(wp1.name,5), padToLength(wp_end.name,5))
        local legstr
        if state.actual_waypoint <self.leg_selection + 1 then 
            legstr = padToLength(string.format("NEXT%.0f:",math.abs(state.actual_waypoint - self.leg_selection-1)),7)
        elseif state.actual_waypoint ==self.leg_selection + 1 then 
            legstr = padToLength("NOW:",7)
        elseif state.actual_waypoint > self.leg_selection + 1 then 
            legstr = padToLength(string.format("LAST%.0f:",math.abs(state.actual_waypoint - self.leg_selection-1)),7)
        end
        local r2 = string.format("%s %s- %s",legstr,
            padToLength(wps[self.leg_selection].name,5),
            padToLength(wps[self.leg_selection+1].name,5))
        row1:set(r1)
        row2:set(r2)
    else
        row1:set(" THIS FLIGHT PLAN   ")
        row2:set("     IS EMPTY       ")
    end
end


function TNL3100_FPL:draw_legs(state,edit,flash)
    wps = state:get_flight_plan_waypoints()
    if #wps > 1 then 
        local wp1 = wps[1]
        local wp_end = wps[#wps]
        
        local legstr
        if state.actual_waypoint <self.leg_selection + 1 then 
            legstr = padToLength(string.format("NEXT%.0f:",math.abs(state.actual_waypoint - self.leg_selection-1)),7)
        elseif state.actual_waypoint ==self.leg_selection + 1 then 
            legstr = padToLength("NOW:",7)
        elseif state.actual_waypoint > self.leg_selection + 1 then 
            legstr = padToLength(string.format("LAST%.0f:",math.abs(state.actual_waypoint - self.leg_selection-1)),7)
        end
        local r1 = string.format("%s %s- %s",legstr,
        padToLength(wps[self.leg_selection].name,5),
        padToLength(wps[self.leg_selection+1].name,5))
        
        
        local bearing = calcBearing2D(wps[self.leg_selection].point, wps[self.leg_selection+1].point)
        local dist = calcDistance2D(wps[self.leg_selection].point, wps[self.leg_selection+1].point)
        local r2 = string.format("%03.0f*     %.1fNM",bearing,dist/1852)
            
        
        row1:set(r1)
        row2:set(padToLength(r2,20))
    else
        row1:set(" THIS FLIGHT PLAN   ")
        row2:set("     IS EMPTY       ")
    end
end

function TNL3100_FPL:add_wpt()
   return self.mode == FPL_MODE.edit and 
    (self.edit_menu_selection == FPL_EDIT_MENU.add)
end

function TNL3100_FPL:replace_wpt()
   return self.mode == FPL_MODE.edit and 
    (self.edit_menu_selection == FPL_EDIT_MENU.replace)
end

function TNL3100_FPL:draw_edit_menu(state,edit,flash)
    wps = state:get_flight_plan_waypoints()
    if #wps == 0 then
        if self.flash_timer>0.25 then
            row2:set(padToLength("++",20))
        else
            row2:set(padToLength("  ",20))
        end
    elseif #wps == 1 then 
        local wp1 = wps[1]
        local wp1_str =  padToLength(wp1.name,9)
        if self.flash_timer>0.25 then
            row2:set(string.format("%s   ++      ",wp1_str))
        else
            row2:set(string.format("%s           ",wp1_str))
        end
    else
        local wp1 = wps[self.leg_selection]
        local wp1_str =  padToLength(wp1.name,8)
        local wp2 = wps[self.leg_selection+1]
        local wp2_str =  padToLength(wp2.name,8)
        if self.edit_menu_selection == FPL_EDIT_MENU.add then 
            if self.flash_timer>0.25 then
                row2:set(string.format(" %s++ %s",wp1_str,wp2_str))
            else
                row2:set(string.format(" %s   %s",wp1_str,wp2_str))
            end
        elseif self.edit_menu_selection == FPL_EDIT_MENU.replace then 
            row2:set(string.format("  REPLACE   %s",wp2_str))
        elseif self.edit_menu_selection == FPL_EDIT_MENU.delete then 
            row2:set(string.format("  DELETE    %s",wp2_str))
        elseif self.edit_menu_selection == FPL_EDIT_MENU.reverse then 
            row2:set("      REVERSE       ")
        end
    end
    row1:set("  EDIT FLIGHT PLAN  ")
end 

function TNL3100_FPL:draw(state)
    if self.mode == FPL_MODE.active_plan then 
        self:draw_fpl(state,false,false)
    elseif self.mode == FPL_MODE.active_legs then 
        self:draw_legs(state,false,false)
    elseif self.mode == FPL_MODE.edit then 
        self:draw_edit_menu(state,false,false)
    end
end



function TNL3100_FPL:update(timestep,state)
    self.flash_timer = self.flash_timer +timestep
    if self.flash_timer >0.5 then self.flash_timer=0.0 end
    self.timer=self.timer+timestep
    wps = state:get_flight_plan_waypoints()
    
    if #wps > 1 then 
        if self.leg_selection > #wps-1 then 
            self.leg_selection = #wps-1
        end
    else
        self.leg_selection = 1
    end

end

function TNL3100_FPL:Setcommand(command, value, state)
    
    if command == device_commands.TNL3100_D or (command == Keys.tnl3100_D and value <0.5) then 
        if self.mode == FPL_MODE.active_legs or self.mode == FPL_MODE.active_plan then
            state:enable_fpl_mode()
            state:set_actual_waypoint(self.leg_selection+1)
        end
        return
    end

    if command == device_commands.TNL3100_OUTER then 
        if self.mode == FPL_MODE.active_plan or self.mode == FPL_MODE.active_legs or self.mode == FPL_MODE.edit then 
            wps = state:get_flight_plan_waypoints()
            if value > 0 then 
                self.leg_selection = self.leg_selection+1
                if self.leg_selection > #wps-1 then self.leg_selection = #wps-1 end
            else
                self.leg_selection = self.leg_selection-1
                if self.leg_selection < 1 then self.leg_selection = 1 end
            end
        end
        return
    elseif command == device_commands.TNL3100_INNER then 
        if self.mode == FPL_MODE.edit then 
            if self.edit_menu_selection == FPL_EDIT_MENU.add then 
                if value >0 then 
                    self.edit_menu_selection = FPL_EDIT_MENU.delete 
                else
                    self.edit_menu_selection = FPL_EDIT_MENU.reverse
                end
            elseif self.edit_menu_selection == FPL_EDIT_MENU.delete then 
                if value >0 then 
                    self.edit_menu_selection = FPL_EDIT_MENU.replace 
                else
                    self.edit_menu_selection = FPL_EDIT_MENU.add
                end
            elseif self.edit_menu_selection == FPL_EDIT_MENU.replace then
                if value >0 then 
                    self.edit_menu_selection = FPL_EDIT_MENU.reverse 
                else
                    self.edit_menu_selection = FPL_EDIT_MENU.delete
                end
            elseif self.edit_menu_selection == FPL_EDIT_MENU.reverse then
                if value >0 then 
                    self.edit_menu_selection = FPL_EDIT_MENU.add 
                else
                    self.edit_menu_selection = FPL_EDIT_MENU.replace
                end
            end
        end
        return
    elseif command == device_commands.TNL3100_ENT or (command == Keys.tnl3100_ent and value <0.5) then
        if self.mode == FPL_MODE.active_plan or self.mode == FPL_MODE.active_legs then
            self.mode = FPL_MODE.edit
        elseif self.mode == FPL_MODE.edit then 
            if self.edit_menu_selection == FPL_EDIT_MENU.delete then 
                state:remove_wp(self.leg_selection+1)
                wps = state:get_flight_plan_waypoints()
                if self.leg_selection > #wps-1 then self.leg_selection = #wps-1 end
                if #wps ==1 then 
                    self.mode = FPL_MODE.active_plan
                    self.edit_menu_selection = FPL_EDIT_MENU.add
                end
            elseif self.edit_menu_selection == FPL_EDIT_MENU.reverse then
                state:reverse_flightplan()
            end
        end
        return
    elseif command == device_commands.TNL3100_FPL and value <0.5 then
        if self.mode == FPL_MODE.active_plan then 
            self.mode = FPL_MODE.active_legs
        elseif self.mode == FPL_MODE.active_legs then 
            self.mode = FPL_MODE.active_plan
        elseif self.mode == FPL_MODE.edit then 
            self.mode = FPL_MODE.active_plan
        end
        return
    end
end





return TNL3100_FPL
