package.path = package.path..";"..LockOn_Options.script_path.."TNL3100/?.lua"

dofile(LockOn_Options.script_path.."ConfigurePackage.lua")
dofile(LockOn_Options.script_path.."TNL3100/TNL3100_helper.lua")
dofile(LockOn_Options.script_path.."TNL3100/TNL3100_typedefs.lua")
dofile(LockOn_Options.script_path.."TNL3100/TNL3100_formatter.lua")

TNL3100_State = require("TNL3100_State")
TNL3100_WPT = require("TNL3100_WPT")
TNL3100_FPL = require("TNL3100_FPL")
TNL3100_NAV = require("TNL3100_NAV")
TNL3100_CALC = require("TNL3100_CALC")
TNL3100_AUX = require("TNL3100_AUX")
TNL3100_APT_VOR = require("TNL3100_APT_VOR")

local state = TNL3100_State.new()
local WPT = TNL3100_WPT.new()
local FPL = TNL3100_FPL.new()
local NAV = TNL3100_NAV.new()
local CALC = TNL3100_CALC.new()
local AUX = TNL3100_AUX.new()
local APT_VOR = TNL3100_APT_VOR.new()

local pwrKnobValue = 0
--require("TNL3100.TNL3100_helper")
OrderedList = dofile(LockOn_Options.script_path.."Nav/OrderedList.lua")

dofile(LockOn_Options.script_path.."command_defs.lua")

update_time_step=0.05 
local dev = GetSelf()

local TNL3100_power = get_param_handle("TNL3100_POWER")
local TNL3100_brightness = get_param_handle("TNL3100_BRIGHTNESS")


local CURRENT_HEADING = get_param_handle("CURRENT_HDG")
local GROUND_SPEED_KTS = get_param_handle("GROUND_SPEED_KTS")

local row1 = get_param_handle("TNL3100_ROW1")
local row2 = get_param_handle("TNL3100_ROW2")

local dc_elec = get_param_handle("DC_POWER_AVAIL")

page = TNL_PAGES.WPT

local flash_timer =0

state:load_waypoints()

function get_state()
    return state
end

local function tnl3100_draw()
    --print_message_to_user
    if page ==TNL_PAGES.WPT then 
        WPT:draw(state)
    end
    if page ==TNL_PAGES.FPL then 
        FPL:draw(state)
    end
    if page == TNL_PAGES.NAV then 
        NAV:draw(state)
    end
    if page == TNL_PAGES.CALC then 
        CALC:draw(state)
    end
    if page == TNL_PAGES.AUX then 
        AUX:draw(state)
    end

    if page == TNL_PAGES.APT_VOR then 
        APT_VOR:draw(state)
    end
end

function tnl3100_post_initialize()
    local birth = LockOn_Options.init_conditions.birth_place	
    if birth=="GROUND_HOT" or birth=="AIR_HOT" then 		
		dev:performClickableAction(device_commands.TNL3100_PWR, 0.5, true) 
    elseif birth=="GROUND_COLD" then
        dev:performClickableAction(device_commands.TNL3100_PWR, 0.0, true)
    end
end

function tnl3100_SetCommand(command,value)
    if command == device_commands.TNL3100_PWR then
        pwrKnobValue = value 
        return
    elseif (command == device_commands.TNL3100_NAV and value <0.5) or (command == Keys.tnl3100_nav and value <0.5)then
            page = TNL_PAGES.NAV
        return
    elseif (command == device_commands.TNL3100_WPT and value <0.5) or (command == Keys.tnl3100_wpt and value <0.5)then
        if page == TNL_PAGES.WPT then 
            if WPT.waypoint_type_selection == WPT_TYPES.airport then 
                WPT.waypoint_type_selection =  WPT_TYPES.user
            elseif WPT.waypoint_type_selection == WPT_TYPES.user then 
                WPT.waypoint_type_selection = WPT_TYPES.airport
                state.airports:goToFirst()
            end
        else
            state.entered_a_wp = false
            page = TNL_PAGES.WPT
            WPT.waypoint_type_selection = WPT_TYPES.user
            state.airports:goToFirst()
        end
        WPT.timer = 0
        WPT.mode = WPT_MODE.selection
        return
    elseif (command == device_commands.TNL3100_FPL and value <0.5) or (command == Keys.tnl3100_fpl and value <0.5) then
        if page == TNL_PAGES.FPL then 
            FPL:Setcommand(command, value, state)
        else
            if page == TNL_PAGES.WPT then 
                if FPL:add_wpt() then
                    state:add_selected_wp(FPL.leg_selection+1)
                elseif FPL:replace_wpt() then 
                    state:replace_wp(FPL.leg_selection+1)
                end 
            end
            page = TNL_PAGES.FPL
        end
        return
    elseif (command == device_commands.TNL3100_APT_VOR and value <0.5)or (command == Keys.tnl3100_apt_vor and value <0.5) then
            page = TNL_PAGES.APT_VOR
        return
    elseif (command == device_commands.TNL3100_CALC and value <0.5)or (command == Keys.tnl3100_calc and value <0.5) then
            page = TNL_PAGES.CALC
        return
    elseif (command == device_commands.TNL3100_AUX and value <0.5) or (command == Keys.tnl3100_aux and value <0.5) then
            page = TNL_PAGES.AUX
        return
    elseif command == Keys.tnl3100_inner_inc then
        dev:performClickableAction(device_commands.TNL3100_INNER, 0.0015, true)
        return
    elseif command == Keys.tnl3100_inner_dec then 
        dev:performClickableAction(device_commands.TNL3100_INNER, -0.0015, true)
        return
    elseif command == Keys.tnl3100_outer_inc then
        dev:performClickableAction(device_commands.TNL3100_OUTER, 0.0015, true)
        return
    elseif command == Keys.tnl3100_outer_dec then 
        dev:performClickableAction(device_commands.TNL3100_OUTER, -0.0015, true)
        return
    end

    if page == TNL_PAGES.WPT then 
        WPT:Setcommand(command, value, state)
        return
    end

    if page == TNL_PAGES.FPL then 
        FPL:Setcommand(command, value, state)
        return
    end
end

function tnl3100_update(_airports)

    if page ==TNL_PAGES.WPT then
        WPT:update(update_time_step)
    end
    if page ==TNL_PAGES.FPL then
        FPL:update(update_time_step,state)
    end
    state.airports = _airports
    state:update_position()
    state:check_actual_waypoint()
    state:updateNavParameter()
    tnl3100_draw()

    TNL3100_brightness:set(pwrKnobValue)
    local dc_ok = dc_elec:get() > 0.5
    if dc_ok then 
        if pwrKnobValue < 0.05 then 
            TNL3100_power:set(0) 
        else 
            TNL3100_power:set(1) 
        end
    else
        TNL3100_power:set(0)
    end
end



need_to_be_closed = false 