local Terrain = require("terrain")
dofile(LockOn_Options.script_path.."TNL3100/TNL3100_typedefs.lua")
dofile(LockOn_Options.script_path.."TNL3100/TNL3100_helper.lua")

row1 = get_param_handle("TNL3100_ROW1")
row2 = get_param_handle("TNL3100_ROW2")

local function replace_char(str,i,c)
    return str:sub(1, i-1) .. c .. str:sub(i+1)
end

function padToLength(str, length) -- pads a string to a certain length
    if #str < length then
        return str .. string.rep(" ", length - #str)
    else
        return str
    end
end

function draw_user_waypoint(waypoint,timer,edit,flash)
    if timer>0.75 then 
        local name_str = waypoint.name
        
        -- ========= ROW 2 Formatting =========
        local coord = lo_to_geo_coords(waypoint.point.x, waypoint.point.y)
        
        local dmsLat = decimalToDMM(waypoint.point.lat)
        local dmsLon = decimalToDMM(waypoint.point.lon)
        if dmsLat.deg > 0 then 
            coord.lat = string.format("%02.0f*%06.3fN", dmsLat.deg, dmsLat.min*0.001) 
        else 
            coord.lat = string.format("%02.0f*%06.3fS", -dmsLat.deg, dmsLat.min*0.001) 
        end

        if dmsLon.deg > 0 then 
            coord.lon = string.format("%02.0f*%06.3fE", dmsLon.deg, dmsLon.min*0.001) 
        else 
            coord.lon = string.format("%02.0f*%06.3fW", -dmsLon.deg, dmsLon.min*0.001) 
        end
        if not flash then 
            if edit >0 then 
                if edit <5 then
                    name_str = replace_char(name_str,edit," ")
                elseif edit >4 and edit <12 then 
                    edit=edit-4
                    local off =0
                    if edit >2 then off = off + 1 end
                    if edit >4 then off = off + 1 end
                    coord.lat = replace_char(coord.lat,edit+off," ")
                elseif edit >11 then 
                    edit=edit-11
                    local off =0
                    if edit >2 then off = off + 1 end
                    if edit >4 then off = off + 1 end
                    coord.lon = replace_char(coord.lon,edit+off," ")
                end
            end
        end
        row1:set(padToLength(string.format("%s      A %.0fFT", name_str, waypoint.alt), 20))
        row2:set(string.format("%s%s", coord.lat, coord.lon))
    else
        row1:set("   USER WAYPOINTS   ")
        row2:set("                    ")
    end
end

function draw_airport_waypoint(waypoint,timer)
    if timer>0.75 then 
        row1:set(padToLength(string.format("%s  D %.0fKM", waypoint.code, waypoint.distance*0.001), 20))

            -- ========= ROW 2 Formatting =========
        local coord = lo_to_geo_coords(waypoint.point.x, waypoint.point.y)

        local dmsLat = decimalToDMM(coord.lat)
        local dmsLon = decimalToDMM(coord.lon)
        if dmsLat.deg > 0 then 
            coord.lat = string.format("%02.0f*%06.3fN", dmsLat.deg, dmsLat.min*0.001) 
        else 
            coord.lat = string.format("%02.0f*%06.3fS", -dmsLat.deg, dmsLat.min*0.001) 
        end

        if dmsLon.deg > 0 then 
            coord.lon = string.format("%02.0f*%06.3fE", dmsLon.deg, dmsLon.min*0.001) 
        else 
            coord.lon = string.format("%02.0f*%06.3fW", -dmsLon.deg, dmsLon.min*0.001) 
        end

        row2:set(string.format("%s%s", coord.lat, coord.lon))
    else
        row1:set("     AIRPORTS       ")
        row2:set("                    ")
    end
end


function print_wpt_user_menu(selection)
    if selection == WPT_USERMENU_SEL.create then 
        row1:set("    ADD WAYPOINT?   ")
        row2:set("                    ")
    elseif selection == WPT_USERMENU_SEL.edit then 
        row1:set("        EDIT?       ")
        row2:set("                    ")
    elseif selection == WPT_USERMENU_SEL.delete then 
        row1:set("        ERASE?      ")
        row2:set("                    ")
    end
end

function print_wpt_create_menu(selection)
    if selection == WPT_CREATEMENU_SEL.ownpos then 
        row1:set("     SAVE USING     ")
        row2:set("    THIS POSITION   ")
    elseif selection == WPT_CREATEMENU_SEL.latlon then 
        row1:set("     SAVE USING     ")
        row2:set("      LAT/LON       ")
    elseif selection == WPT_CREATEMENU_SEL.wp_bear_dist then 
        row1:set("     SAVE USING     ")
        row2:set("     WPR+RNG&BRG    ")
    end
end
