dofile(LockOn_Options.common_script_path.."elements_defs.lua")

SetScale(METERS) 

local font7segment = MakeFont({used_DXUnicodeFontData = "font7segment"},{0,255,0,215}) --(R,G,B,opacity)
local center = {0,0,0}  --- {L/R,U/D,forward/back}

local verts = {}
local dx=.0125
local dy=.0075
verts [1]= {-dx,-dy}
verts [2]= {-dx,dy}
verts [3]= {dx,dy}
verts [4]= {dx,-dy}
	
local base 			 = CreateElement "ceMeshPoly"
base.name 			 = "base"
base.vertices 		 = verts
base.indices 		 = {0,1,2,2,3,0}
base.init_pos		 = center   
base.material		 = MakeMaterial(nil,{3,3,30,255})
base.h_clip_relation = h_clip_relations.REWRITE_LEVEL 
base.level			 = 5
base.isdraw			 = true
base.change_opacity  = false
base.isvisible		 = false
base.element_params  = {"DC_POWER_AVAIL"}  
base.controllers     = {{"parameter_in_range",0,0.9,1.1}} 
Add(base)

local N2rpm           = CreateElement "ceStringPoly"
N2rpm.name            = create_guid_string()
N2rpm.material        = font7segment	
N2rpm.alignment       = "RightCenter"
N2rpm.init_pos		  = {-0.005, 0, 0}
N2rpm.stringdefs      = {0.007,0.75*0.007, 0, 0}  -- {size vertical, horizontal, 0, 0}
N2rpm.formats         = {"%.0f"} 
N2rpm.element_params  = {
	"N2_PERCENT",
	"VIDS_BRIGHTNESS"
}
N2rpm.controllers     = { 
	{"text_using_parameter",0,0},
	{"opacity_using_parameter",1}
}
N2rpm.h_clip_relation = h_clip_relations.compare
N2rpm.level			  = 6
N2rpm.parent_element  = base.name
Add(N2rpm)

local NRrpm           = CreateElement "ceStringPoly"
NRrpm.name            = create_guid_string()
NRrpm.material        = font7segment	
NRrpm.alignment       = "RightCenter"
NRrpm.init_pos		  = {0.018, 0, 0}
NRrpm.stringdefs      = {0.007,0.75*0.007, 0, 0}  -- {size vertical, horizontal, 0, 0}
NRrpm.formats         = {"%.0f"} 
NRrpm.element_params  = {
	"NR_PERCENT",
	"VIDS_BRIGHTNESS"
}
NRrpm.controllers     = {
	{"text_using_parameter",0,0},
	{"opacity_using_parameter",1}
}
NRrpm.h_clip_relation = h_clip_relations.compare
NRrpm.level			  = 6
NRrpm.parent_element  = base.name
Add(NRrpm)

local mat_green = MakeMaterial(nil,{0,255,0,215})
local mat_yellow = MakeMaterial(nil,{255,255,0,215})
local mat_red = MakeMaterial(nil,{255,0,0,215})

local segments = {
	[1]= {min = 0,  cl = mat_red,    cr = mat_red},
	[2]= {min = 10, cl = mat_red,    cr = mat_red},
	[3]= {min = 20, cl = mat_red,    cr = mat_red},
	[4]= {min = 30, cl = mat_red,    cr = mat_red},
	[5]= {min = 40, cl = mat_red,    cr = mat_red},
	[6]= {min = 60, cl = mat_red,    cr = mat_red},
	[7]= {min = 80, cl = mat_red,    cr = mat_red},
	[8]= {min = 86, cl = mat_red,    cr = mat_red},
	[9]= {min = 87, cl = mat_red,    cr = mat_green},
	[10]={min = 88, cl = mat_red,    cr = mat_green},
	[11]={min = 89, cl = mat_red,    cr = mat_green},
	[12]={min = 90, cl = mat_red,    cr = mat_green},
	[13]={min = 91, cl = mat_red,    cr = mat_green},
	[14]={min = 92, cl = mat_red,    cr = mat_green},
	[15]={min = 93, cl = mat_red,    cr = mat_green},
	[16]={min = 94, cl = mat_red,    cr = mat_green},
	[17]={min = 95, cl = mat_red,    cr = mat_green},
	[18]={min = 96, cl = mat_yellow, cr = mat_green},
	[19]={min = 97, cl = mat_yellow, cr = mat_green},
	[20]={min = 98, cl = mat_yellow, cr = mat_green},
	[21]={min = 99, cl = mat_green,  cr = mat_green},
	[22]={min = 100, cl = mat_green,  cr = mat_green},
	[23]={min = 101, cl = mat_yellow, cr = mat_green},
	[24]={min = 102, cl = mat_yellow, cr = mat_green},
	[25]={min = 103, cl = mat_yellow, cr = mat_green},
	[26]={min = 104, cl = mat_yellow, cr = mat_green},
	[27]={min = 105, cl = mat_yellow, cr = mat_green},
	[28]={min = 106, cl = mat_yellow, cr = mat_green},
	[29]={min = 107, cl = mat_red,    cr = mat_red},
	[30]={min = 108, cl = mat_red,    cr = mat_red},
}

local dz= 0.00243
local x0 =0.01085
local z0 = -0.07962
local x_size = 0.0015
local y_size = 0.5*dz*0.8

local vertices = {{-x_size,  y_size},
				  { x_size,  y_size},
				  { x_size, -y_size},
				  {-x_size, -y_size}}

local function addSegment(element)
	element.vertices = vertices
	element.indices	   		= {0,1,2,2,3,0}
	element.h_clip_relation = h_clip_relations.REWRITE_LEVEL
	element.level 			= 6
	element.parent_element 	= base.name
	Add(element)
end

for i = 1,#segments,1 
do 
	local segmentL		  = CreateElement "ceMeshPoly"
	segmentL.name		  = "segmentL_"..i
	segmentL.init_pos	  = { -x0, z0 + (i-1)*dz, 0.002}
	segmentL.element_params  = {
		"N2_PERCENT",
		"VIDS_BRIGHTNESS"
	}
	segmentL.controllers  = {
		{"parameter_in_range",0, segments[i].min,110},
		{"opacity_using_parameter",1}
	}
	segmentL.material = segments[i].cl
	addSegment(segmentL)
	 
	local segmentR		  = CreateElement "ceMeshPoly"
	segmentR.name		  = "segmentR_"..i
	segmentR.init_pos	  = { x0, z0 + (i-1)*dz, 0.002}
	segmentR.element_params  = {
		"NR_PERCENT",
		"VIDS_BRIGHTNESS"
	}
	segmentR.controllers  = {
		{"parameter_in_range",0, segments[i].min,110},
		{"opacity_using_parameter",1}}
	segmentR.material = segments[i].cr
	addSegment(segmentR)
end
