/*
 * Copyright (c) 2024 Yunshan Networks
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

mod queue;

use std::time::Duration;

use tonic;

pub use queue::{send_to, QueueDebugger, QueueMessage};
pub const QUEUE_LEN: usize = 1024;
pub const DEBUG_QUEUE_IDLE_TIMEOUT: Duration = Duration::from_secs(30);
pub const MAX_BUF_SIZE: usize = 9000;

use thiserror::Error;

#[derive(Debug, Error)]
pub enum Error {
    #[error(transparent)]
    BinCodeDecode(#[from] bincode::error::DecodeError),
    #[error(transparent)]
    BinCodeEncode(#[from] bincode::error::EncodeError),
    #[error(transparent)]
    Tonic(#[from] tonic::Status),
    #[error(transparent)]
    IoError(#[from] std::io::Error),
    #[error("{0}")]
    NotFound(String),
    #[error("{0}")]
    FromUtf8(String),
}

pub type Result<T, E = Error> = std::result::Result<T, E>;
