/*
 * Copyright (c) 2024 Yunshan Networks
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

mod amqp;
mod kafka;
pub mod mqtt;
mod nats;
mod openwire;
mod pulsar;
mod rocketmq;
mod zmtp;

pub use amqp::{AmqpInfo, AmqpLog};
pub use kafka::{KafkaInfo, KafkaLog};
pub use mqtt::{MqttInfo, MqttLog};
pub use nats::{NatsInfo, NatsLog};
pub use openwire::{OpenWireInfo, OpenWireLog};
pub use pulsar::{PulsarInfo, PulsarLog};
pub use rocketmq::{RocketmqInfo, RocketmqLog};
pub use zmtp::{ZmtpInfo, ZmtpLog};

cfg_if::cfg_if! {
    if #[cfg(feature = "enterprise")] {
        mod web_sphere_mq;
        pub use web_sphere_mq::{WebSphereMqInfo, WebSphereMqLog};
    }
}
