/*
 * Copyright (c) 2024 Yunshan Networks
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

cfg_if::cfg_if! {
    if #[cfg(target_os = "linux")] {
        mod libvirt_xml_extractor;
        pub mod kubernetes;

        pub use libvirt_xml_extractor::LibvirtXmlExtractor;
        pub use kubernetes::{ApiWatcher, GenericPoller, Poller};
    }
}

mod platform_synchronizer;
pub use platform_synchronizer::process_info_enabled;
#[cfg(any(target_os = "linux", target_os = "android"))]
pub use platform_synchronizer::{
    get_os_app_tag_by_exec, OsAppTag, ProcessData, ProcessDataOp, SocketSynchronizer,
};

mod querier;
pub mod synchronizer;

pub const IGNORED_INTERFACES: [&str; 1] = ["kube-ipvs0"];

#[derive(Default, Debug, Clone, PartialEq, Eq)]
pub struct InterfaceEntry {
    pub name: String,
    pub mac: public::utils::net::MacAddr,
    pub domain_uuid: String,
    pub domain_name: String,
}

impl From<&InterfaceEntry> for public::proto::agent::InterfaceInfo {
    fn from(entry: &InterfaceEntry) -> Self {
        Self {
            name: Some(entry.name.clone()),
            mac: Some(entry.mac.into()),
            device_id: Some(entry.domain_uuid.clone()),
            device_name: Some(entry.domain_name.clone()),
            ..Default::default()
        }
    }
}
