/*RENAME TABLE*/
RENAME TABLE ch_epc TO ch_l3_epc;
RENAME TABLE ch_vl2 TO ch_subnet;
RENAME TABLE ch_pod_namespace TO ch_pod_ns;

/*CREATE TABLE*/
CREATE TABLE IF NOT EXISTS ch_k8s_label (
    `pod_id`        INTEGER NOT NULL,
    `key`           VARCHAR(256) NOT NULL,
    `value`         VARCHAR(256),
    `l3_epc_id`     INTEGER,
    `pod_ns_id`     INTEGER,
    `updated_at`    TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`pod_id`, `key`)
)ENGINE=innodb DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS go_genesis_host (
    id          INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
    lcuuid      CHAR(64),
    hostname    VARCHAR(256),
    ip          CHAR(64)
) ENGINE=innodb DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS go_genesis_vm (
    id              INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
    lcuuid          CHAR(64),
    name            VARCHAR(256),
    label           CHAR(64),
    vpc_lcuuid      CHAR(64),
    launch_server   CHAR(64),
    state           INTEGER,
    created_at      DATETIME
) ENGINE=innodb DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS go_genesis_vpc (
    id              INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
    lcuuid          CHAR(64),
    name            VARCHAR(256)
) ENGINE=innodb DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS go_genesis_network (
    id              INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
    name            VARCHAR(256),
    lcuuid          CHAR(64),
    segmentation_id INTEGER,
    net_type        INTEGER,
    external        TINYINT(1),
    vpc_lcuuid      CHAR(64)
) ENGINE=innodb DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS go_genesis_port (
    id              INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
    lcuuid          CHAR(64),
    type            INTEGER,
    device_type     INTEGER,
    mac             CHAR(32),
    device_lcuuid   CHAR(64),
    network_lcuuid  CHAR(64),
    vpc_lcuuid      CHAR(64)
) ENGINE=innodb DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS go_genesis_ip (
    id                  INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
    lcuuid              CHAR(64),
    ip                  CHAR(64),
    vinterface_lcuuid   CHAR(64),
    last_seen           DATETIME,
    masklen             INTEGER DEFAULT 0
) ENGINE=innodb DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS go_genesis_lldp (
    id                      INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
    lcuuid                  CHAR(64),
    host_ip                 CHAR(48),
    host_interface          CHAR(64),
    system_name             VARCHAR(512),
    management_address      VARCHAR(512),
    vinterface_lcuuid       VARCHAR(512),
    vinterface_description  VARCHAR(512),
    last_seen               DATETIME
) ENGINE=innodb DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS go_genesis_vinterface (
    id                    INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
    lcuuid                CHAR(64),
    name                  CHAR(64),
    mac                   CHAR(32),
    ips                   TEXT,
    tap_name              CHAR(64),
    tap_mac               CHAR(32),
    device_lcuuid         CHAR(64),
    device_name           VARCHAR(512),
    device_type           CHAR(64),
    host_ip               CHAR(48),
    last_seen             DATETIME,
    vtap_id               INTEGER,
    kubernetes_cluster_id CHAR(64)
) ENGINE=innodb DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1;

/*ALTER TABLE*/
ALTER TABLE domain
    MODIFY COLUMN synced_at DATETIME DEFAULT NULL,
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP;

ALTER TABLE sub_domain
    MODIFY COLUMN synced_at DATETIME DEFAULT NULL,
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP;

ALTER TABLE region
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE az
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE host_device
    CHANGE clusterid bak_clusterid INTEGER,
    ADD COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE vm
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    MODIFY COLUMN updated_at DATETIME ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;
UPDATE vm u JOIN vm s SET u.updated_at=s.created_at WHERE u.updated_at IS NULL;
ALTER TABLE vm
    MODIFY COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP;

ALTER TABLE epc
    CHANGE deleted bak_deleted TINYINT(1) DEFAULT 0,
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE vl2
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE vnet
    ADD COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE dhcp_port
    ADD COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE ip_resource
    CHANGE create_at bak_create_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP;

ALTER TABLE security_group
    ADD COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE nat_gateway
    ADD COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE lb
    ADD COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE lb_listener
    ADD COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE peer_connection
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    MODIFY COLUMN updated_at DATETIME ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;
UPDATE peer_connection u JOIN peer_connection s SET u.updated_at=s.created_at WHERE u.updated_at IS NULL;
ALTER TABLE peer_connection
    MODIFY COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP;

ALTER TABLE cen
    ADD COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE rds_instance
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE redis_instance
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE pod_cluster
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN updated_at DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE pod_node
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE pod_namespace
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE pod_service
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE pod_ingress
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE pod_group
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE pod_rs
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE pod
    MODIFY COLUMN created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ADD COLUMN deleted_at DATETIME DEFAULT NULL;

ALTER TABLE pod_rs ADD COLUMN label TEXT COMMENT 'separated by ,' AFTER alias;
ALTER TABLE pod ADD COLUMN label TEXT COMMENT 'separated by ,' AFTER alias;

ALTER TABLE kubernetes_cluster ADD  COLUMN synced_at DATETIME DEFAULT NULL;

ALTER TABLE vtap_group_configuration
    ADD COLUMN external_agent_http_proxy_enabled TINYINT(1) COMMENT '0: disabled 1:enabled',
    ADD COLUMN external_agent_http_proxy_port     INTEGER DEFAULT NULL,
    ADD COLUMN proxy_controller_port     INTEGER DEFAULT NULL,
    ADD COLUMN analyzer_port             INTEGER DEFAULT NULL,
    ADD COLUMN yaml_config  TEXT;
UPDATE vtap_group_configuration SET external_agent_http_proxy_enabled=0 where id=-1;
UPDATE vtap_group_configuration SET external_agent_http_proxy_port=8086 where id=-1;
UPDATE vtap_group_configuration SET stats_interval=60 WHERE id=-1;

ALTER TABLE vtap
    ADD COLUMN process_name            VARCHAR(256),
    ADD COLUMN tap_mode                INTEGER,
    ADD COLUMN expected_revision       TEXT,
    ADD COLUMN upgrade_package         TEXT;

UPDATE vtap_group SET name="default" WHERE id=1;

CREATE TABLE IF NOT EXISTS db_version (
    version             CHAR(64),
    created_at          DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    updated_at          DATETIME NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP
)ENGINE=innodb DEFAULT CHARSET=utf8;
INSERT INTO db_version (version) VALUE ('6.1.1.0');
