-- modify start, add upgrade sql
DROP PROCEDURE IF EXISTS update_data_sources;

CREATE PROCEDURE update_data_sources()
BEGIN
    DECLARE current_db_name VARCHAR(255);
    
    START TRANSACTION;

    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_log_counter\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.warning\",\"METRIC_NAME\":\"metrics.warning\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.error\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"log_counter_warning\",\"checked\":true,\"percentile\":null,\"_key\":\"50d7a2a2-a14d-d202-1f3d-85fe7b9efac3\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.warning)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_log_counter\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="采集器 WARN 日志过多";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_log_counter\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.error\",\"METRIC_NAME\":\"metrics.error\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.error\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"log_counter_error\",\"checked\":true,\"percentile\":null,\"_key\":\"50d7a2a2-a14d-d202-1f3d-85fe7b9efac3\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.error)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_log_counter\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="采集器 ERR 日志过多";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"controller_genesis_k8sinfo_delay\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.avg\",\"METRIC_NAME\":\"metrics.avg\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.avg\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Last\",\"perOperator\":\"\",\"METRIC_LABEL\":\"delay\",\"checked\":true,\"percentile\":null,\"_key\":\"8e92e913-a37f-ef34-8a4d-9169b96c6087\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Last(metrics.avg)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"controller_genesis_k8sinfo_delay\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="K8s 资源同步滞后";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_dispatcher\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.kernel_drops\",\"METRIC_NAME\":\"metrics.kernel_drops\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.err\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"dispatcher.metrics.kernel_drops\",\"checked\":true,\"percentile\":null,\"_key\":\"96fd254b-e6c1-4cc1-69fa-da5f4dd927ed\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.kernel_drops)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_dispatcher\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="采集器数据丢失 (dispatcher.metrics.kernel_drops)";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_queue\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.overwritten\",\"METRIC_NAME\":\"metrics.overwritten\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.in\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"queue.metrics.overwritten\",\"checked\":true,\"percentile\":null,\"_key\":\"d61628e5-df0b-9337-6ee6-a3316a047e24\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.overwritten)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_queue\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\",\"tag.module\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\",\"tag.module\"]},\"inputMode\":\"free\"}]}}]", query_params="{\"DATABASE\":\"deepflow_tenant\",\"TABLE\":\"deepflow_agent_queue\",\"interval\":60,\"fill\": \"none\",\"window_size\":1,\"QUERIES\":[{\"QUERY_ID\":\"R1\",\"SELECT\":\"Sum(`metrics.overwritten`) AS `queue.metrics.overwritten`\",\"WHERE\":\"1=1\",\"GROUP_BY\":\"`tag.host`, `tag.module`\",\"METRICS\":[\"Sum(`metrics.overwritten`) AS `queue.metrics.overwritten`\"]}]}", tag_conditions="过滤项: N/A | 分组项: tag.host, tag.module" WHERE name="采集器数据丢失 (queue.metrics.overwritten)";


    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_l7_session_aggr\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.throttle-drop\",\"METRIC_NAME\":\"metrics.throttle-drop\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.cached\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"l7_session_aggr.metrics.throttle-drop\",\"checked\":true,\"percentile\":null,\"_key\":\"c511eb55-3d46-c7a2-bfed-ebb42d02493c\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.throttle-drop)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_l7_session_aggr\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="采集器数据丢失 (l7_session_aggr.metrics.throttle-drop)";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_flow_aggr\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.drop-in-throttle\",\"METRIC_NAME\":\"metrics.drop-in-throttle\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.drop-before-window\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"flow_aggr.metrics.drop-in-throttle\",\"checked\":true,\"percentile\":null,\"_key\":\"e395cbb3-d5a2-283b-1b0a-834977bb6393\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.drop-in-throttle)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_flow_aggr\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="采集器数据丢失 (flow_aggr.metrics.drop-in-throttle)";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_ebpf_collector\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.kern_lost\",\"METRIC_NAME\":\"metrics.kern_lost\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.boot_time_update_diff\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"ebpf_collector.metrics.kern_lost\",\"checked\":true,\"percentile\":null,\"_key\":\"8f28cb9b-ec39-d605-c056-53b0f2788c13\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.kern_lost)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_ebpf_collector\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="采集器数据丢失 (ebpf_collector.metrics.kern_lost)";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_ebpf_collector\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.user_enqueue_lost\",\"METRIC_NAME\":\"metrics.user_enqueue_lost\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.boot_time_update_diff\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"ebpf_collector.metrics.user_enqueue_lost\",\"checked\":true,\"percentile\":null,\"_key\":\"8f28cb9b-ec39-d605-c056-53b0f2788c13\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.user_enqueue_lost)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_ebpf_collector\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="采集器数据丢失 (ebpf_collector.metrics.user_enqueue_lost)";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_dispatcher\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.invalid_packets\",\"METRIC_NAME\":\"metrics.invalid_packets\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.err\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"dispatcher.metrics.invalid_packets\",\"checked\":true,\"percentile\":null,\"_key\":\"41f6303b-f31e-8b7e-83c8-67a8edf735af\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.invalid_packets)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_dispatcher\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="采集器数据丢失 (dispatcher.metrics.invalid_packets)";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_dispatcher\",\"dbName\":\"deepflow_tenant\",\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_dispatcher\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]},\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.err\",\"METRIC_NAME\":\"metrics.err\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"checked\":true,\"operatorLv2\":[],\"_key\":\"6fb3545a-74eb-ac62-4e84-622c0265a840\",\"perOperator\":\"\",\"operatorLv1\":\"Sum\",\"percentile\":null,\"markLine\":null,\"METRIC_LABEL\":\"dispatcher.metrics.err\",\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.err)\"}]}]" WHERE name="采集器数据丢失 (dispatcher.metrics.err)";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_flow_map\",\"dbName\":\"deepflow_tenant\",\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_flow_map\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]},\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.drop_by_window\",\"METRIC_NAME\":\"metrics.drop_by_window\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.closed\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"flow_map.metrics.drop_by_window\",\"checked\":true,\"percentile\":null,\"_key\":\"629edc91-d806-d7ac-bdea-517f46ad6530\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.drop_by_window)\"}]}]" WHERE name="采集器数据丢失 (flow_map.metrics.drop_by_window)";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_flow_map\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.drop_by_capacity\",\"METRIC_NAME\":\"metrics.drop_by_capacity\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.closed\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"flow_map.metrics.drop_by_capacity\",\"checked\":true,\"percentile\":null,\"_key\":\"988eb89d-d8cd-6827-d359-86b6c29fdbb6\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.drop_by_capacity)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_flow_map\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="采集器数据丢失 (flow_map.metrics.drop_by_capacity)";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_flow_aggr\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.drop-before-window\",\"METRIC_NAME\":\"metrics.drop-before-window\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.drop-before-window\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"flow_aggr.metrics.drop-before-window\",\"checked\":true,\"percentile\":null,\"_key\":\"d5ebf837-b5b6-e853-7933-e09506a781ff\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.drop-before-window)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_flow_aggr\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="采集器数据丢失 (flow_aggr.metrics.drop-before-window)";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_quadruple_generator\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.drop-before-window\",\"METRIC_NAME\":\"metrics.drop-before-window\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.drop-before-window\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"quadruple_generator.metrics.drop-before-window\",\"checked\":true,\"percentile\":null,\"_key\":\"79facee8-3875-df77-e375-2f7f955b0035\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.drop-before-window)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_quadruple_generator\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="采集器数据丢失 (quadruple_generator.metrics.drop-before-window)";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_collector\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.drop-before-window\",\"METRIC_NAME\":\"metrics.drop-before-window\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.drop-before-window\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"collector.metrics.drop-before-window\",\"checked\":true,\"percentile\":null,\"_key\":\"e63575a2-333a-b612-0b57-684387f80431\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.drop-before-window)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_collector\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="采集器数据丢失 (collector.metrics.drop-before-window)";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_collector\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.drop-inactive\",\"METRIC_NAME\":\"metrics.drop-inactive\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.drop-before-window\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"collector.metrics.drop-inactive\",\"checked\":true,\"percentile\":null,\"_key\":\"e63575a2-333a-b612-0b57-684387f80431\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.drop-inactive)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_collector\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="采集器数据丢失 (collector.metrics.drop-inactive)";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_collect_sender\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.dropped\",\"METRIC_NAME\":\"metrics.dropped\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.dropped\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"collect_sender.metrics.dropped\",\"checked\":true,\"percentile\":null,\"_key\":\"7848fead-8554-591f-b0da-dec4180fa576\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.dropped)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_collect_sender\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="采集器数据丢失 (collect_sender.metrics.dropped)";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_monitor\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.max_millicpus_ratio\",\"METRIC_NAME\":\"metrics.max_millicpus_ratio\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"checked\":true,\"operatorLv2\":[{\"operateLabel\":\"Math\",\"mathOperator\":\"*\",\"operatorValue\":100}],\"_key\":\"38813299-6cca-9b7f-4a08-5861fa7d6ee3\",\"perOperator\":\"\",\"operatorLv1\":\"Min\",\"percentile\":null,\"markLine\":null,\"METRIC_LABEL\":\"cpu_usage\",\"ORIGIN_METRIC_LABEL\":\"Math(Min(metrics.max_millicpus_ratio)*100)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_monitor\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]", query_params="{\"DATABASE\":\"deepflow_tenant\",\"TABLE\":\"deepflow_agent_monitor\",\"interval\":60,\"fill\": \"none\",\"window_size\":5,\"QUERIES\":[{\"QUERY_ID\":\"R1\",\"SELECT\":\"Min(`metrics.max_millicpus_ratio`)*100 AS `cpu_usage`\",\"WHERE\":\"1=1\",\"GROUP_BY\":\"`tag.host`\",\"METRICS\":[\"Min(`metrics.max_millicpus_ratio`)*100 AS `cpu_usage`\"]}]}" WHERE name="采集器 CPU 超限";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_monitor\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.max_memory_ratio\",\"METRIC_NAME\":\"metrics.max_memory_ratio\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"checked\":true,\"operatorLv2\":[{\"operateLabel\":\"Math\",\"mathOperator\":\"*\",\"operatorValue\":100}],\"_key\":\"38813299-6cca-9b7f-4a08-5861fa7d6ee3\",\"perOperator\":\"\",\"operatorLv1\":\"Min\",\"percentile\":null,\"markLine\":null,\"METRIC_LABEL\":\"used_bytes\",\"ORIGIN_METRIC_LABEL\":\"Math(Min(metrics.max_memory_ratio)*100)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_monitor\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]", query_params="{\"DATABASE\":\"deepflow_tenant\",\"TABLE\":\"deepflow_agent_monitor\",\"interval\":60,\"fill\": \"none\",\"window_size\":5,\"QUERIES\":[{\"QUERY_ID\":\"R1\",\"SELECT\":\"Min(`metrics.max_memory_ratio`)*100 AS `used_bytes`\",\"WHERE\":\"1=1\",\"GROUP_BY\":\"`tag.host`\",\"METRICS\":[\"Min(`metrics.max_memory_ratio`)*100 AS `used_bytes`\"]}]}" WHERE name="采集器内存超限";
    UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_agent_monitor\",\"dbName\":\"deepflow_tenant\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.sys_free_memory_limit_ratio\",\"METRIC_NAME\":\"metrics.sys_free_memory_limit_ratio\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"checked\":true,\"operatorLv2\":[{\"operateLabel\":\"Math\",\"mathOperator\":\"*\",\"operatorValue\":100}],\"_key\":\"38813299-6cca-9b7f-4a08-5861fa7d6ee3\",\"perOperator\":\"\",\"operatorLv1\":\"Min\",\"percentile\":null,\"markLine\":null,\"METRIC_LABEL\":\"used_bytes\",\"ORIGIN_METRIC_LABEL\":\"Math(Min(metrics.sys_free_memory_limit_ratio)*100)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_tenant\",\"tableName\":\"deepflow_agent_monitor\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]", query_params="{\"DATABASE\":\"deepflow_tenant\",\"TABLE\":\"deepflow_agent_monitor\",\"interval\":60,\"fill\": \"none\",\"window_size\":5,\"QUERIES\":[{\"QUERY_ID\":\"R1\",\"SELECT\":\"Min(`metrics.sys_free_memory_limit_ratio`)*100 AS `used_bytes`\",\"WHERE\":\"1=1\",\"GROUP_BY\":\"`tag.host`\",\"METRICS\":[\"Min(`metrics.sys_free_memory_limit_ratio`)*100 AS `used_bytes`\"]}]}" WHERE name="采集器所在系统空闲内存低";

    -- do migration in default db
    
    SELECT DATABASE() INTO current_db_name;
    IF @defaultDatabaseName = current_db_name THEN
        UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_server_monitor_disk\",\"dbName\":\"deepflow_admin\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.used_percent\",\"METRIC_NAME\":\"metrics.used_percent\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.free\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Last\",\"perOperator\":\"\",\"METRIC_LABEL\":\"disk_used_percent\",\"checked\":true,\"percentile\":null,\"_key\":\"561bf802-10ae-4988-38f5-97001e896d8e\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Last(metrics.used_percent)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_admin\",\"tableName\":\"deepflow_server_monitor_disk\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\",\"tag.host_ip\",\"tag.path\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\",\"tag.host_ip\",\"tag.path\"]},\"inputMode\":\"free\"}]}}]" WHERE name="控制器磁盘空间不足";
        UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_server_monitor_disk\",\"dbName\":\"deepflow_admin\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.used_percent\",\"METRIC_NAME\":\"metrics.used_percent\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.free\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Last\",\"perOperator\":\"\",\"METRIC_LABEL\":\"disk_used_percent\",\"checked\":true,\"percentile\":null,\"_key\":\"561bf802-10ae-4988-38f5-97001e896d8e\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Last(metrics.used_percent)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_admin\",\"tableName\":\"deepflow_server_monitor_disk\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\",\"tag.host_ip\",\"tag.path\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\",\"tag.host_ip\",\"tag.path\"]},\"inputMode\":\"free\"}]}}]" WHERE name="数据节点磁盘空间不足";
        UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_server_ingester_force_delete_clickhouse_data\",\"dbName\":\"deepflow_admin\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.bytes_on_disk\",\"METRIC_NAME\":\"metrics.bytes_on_disk\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.bytes_on_disk\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"force_delete_clickhouse_data_bytes_on_disk\",\"checked\":true,\"percentile\":null,\"_key\":\"789ba080-5a52-11ad-25ae-097318b21194\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.bytes_on_disk)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_admin\",\"tableName\":\"deepflow_server_ingester_force_delete_clickhouse_data\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\",\"tag.db\",\"tag.partition\",\"tag.table\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\",\"tag.db\",\"tag.partition\",\"tag.table\"]},\"inputMode\":\"free\"}]}}]" WHERE name="数据节点数据强制删除";
        UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_server_ingester_recviver\",\"dbName\":\"deepflow_admin\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.invalid\",\"METRIC_NAME\":\"metrics.invalid\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"checked\":true,\"operatorLv2\":[],\"_key\":\"2dfe0af2-b363-95b9-f8ce-acd3e9f0f567\",\"perOperator\":\"\",\"operatorLv1\":\"Sum\",\"percentile\":null,\"markLine\":null,\"METRIC_LABEL\":\"ingester.recviver.metrics.invalid\",\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.invalid)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_admin\",\"tableName\":\"deepflow_server_ingester_recviver\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="数据节点数据丢失 (ingester.recviver.metrics.invalid)";
        UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_server_ingester_queue\",\"dbName\":\"deepflow_admin\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.overwritten\",\"METRIC_NAME\":\"metrics.overwritten\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.in\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"ingester.queue.metrics.overwritten\",\"checked\":true,\"percentile\":null,\"_key\":\"e3554a5e-ec69-abe7-2c94-a5000578c23a\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.overwritten)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_admin\",\"tableName\":\"deepflow_server_ingester_queue\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\",\"tag.module\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\",\"tag.module\"]},\"inputMode\":\"free\"}]}}]", query_params="{\"DATABASE\":\"deepflow_admin\",\"TABLE\":\"deepflow_server_ingester_queue\",\"interval\":60,\"fill\": \"none\",\"window_size\":1,\"QUERIES\":[{\"QUERY_ID\":\"R1\",\"SELECT\":\"Sum(`metrics.overwritten`) AS `ingester.queue.metrics.overwritten`\",\"WHERE\":\"1=1\",\"GROUP_BY\":\"`tag.host`, `tag.module`\",\"METRICS\":[\"Sum(`metrics.overwritten`) AS `ingester.queue.metrics.overwritten`\"]}]}", tag_conditions="过滤项: N/A | 分组项: tag.host, tag.module" WHERE name="数据节点数据丢失 (ingester.queue.metrics.overwritten)";
        UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_server_ingester_decoder\",\"dbName\":\"deepflow_admin\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.drop_count\",\"METRIC_NAME\":\"metrics.drop_count\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.avg_time\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"ingester.decoder.metrics.drop_count\",\"checked\":true,\"percentile\":null,\"_key\":\"3c32775e-72b5-a62c-c97d-b90bdf049923\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.drop_count)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_admin\",\"tableName\":\"deepflow_server_ingester_decoder\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="数据节点数据丢失 (ingester.decoder.metrics.drop_count)";
        UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_server_ingester_ckwriter\",\"dbName\":\"deepflow_admin\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.write_failed_count\",\"METRIC_NAME\":\"metrics.write_failed_count\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"cascaderLabel\":\"metrics.org_invalid_count\",\"display_name\":\"\-\-\",\"hasDerivative\":false,\"isPrometheus\":false,\"operatorLv2\":[],\"operatorLv1\":\"Sum\",\"perOperator\":\"\",\"METRIC_LABEL\":\"ingester.ckwriter.metrics.write_failed_count\",\"checked\":true,\"percentile\":null,\"_key\":\"14090ba1-13b7-97eb-de89-a141e06afc89\",\"markLine\":null,\"ORIGIN_METRIC_LABEL\":\"Sum(metrics.write_failed_count)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_admin\",\"tableName\":\"deepflow_server_ingester_ckwriter\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\"]},\"inputMode\":\"free\"}]}}]" WHERE name="数据节点数据丢失 (ingester.ckwriter.metrics.write_failed_count)";
        UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_server_monitor\",\"dbName\":\"deepflow_admin\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.load1_by_cpu_num\",\"METRIC_NAME\":\"metrics.load1_by_cpu_num\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"checked\":true,\"operatorLv2\":[{\"operateLabel\":\"Math\",\"mathOperator\":\"*\",\"operatorValue\":100}],\"_key\":\"48c02f46-f3c3-9ad6-924e-502a82762e18\",\"perOperator\":\"\",\"operatorLv1\":\"Min\",\"percentile\":null,\"markLine\":null,\"METRIC_LABEL\":\"load\",\"ORIGIN_METRIC_LABEL\":\"Math(Min(metrics.load1_by_cpu_num)*100)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_admin\",\"tableName\":\"deepflow_server_monitor\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\",\"tag.host_ip\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\",\"tag.host_ip\"]},\"inputMode\":\"free\"}]}}]", query_params="{\"DATABASE\":\"deepflow_admin\",\"TABLE\":\"deepflow_server_monitor\",\"interval\":60,\"fill\": \"none\",\"window_size\":5,\"QUERIES\":[{\"QUERY_ID\":\"R1\",\"SELECT\":\"Min(`metrics.load1_by_cpu_num`)*100 AS `load`\",\"WHERE\":\"1=1\",\"GROUP_BY\":\"`tag.host_ip`, `tag.host`\",\"METRICS\":[\"Min(`metrics.load1_by_cpu_num`)*100 AS `load`\"]}]}" WHERE name="控制器系统负载高";
        UPDATE alarm_policy SET query_conditions="[{\"type\":\"deepflow\",\"tableName\":\"deepflow_server_monitor\",\"dbName\":\"deepflow_admin\",\"metrics\":[{\"description\":\"\",\"typeName\":\"counter\",\"METRIC_CATEGORY\":\"metrics\",\"METRIC\":\"metrics.load1_by_cpu_num\",\"METRIC_NAME\":\"metrics.load1_by_cpu_num\",\"isTimeUnit\":false,\"type\":1,\"unit\":\"\",\"checked\":true,\"operatorLv2\":[{\"operateLabel\":\"Math\",\"mathOperator\":\"*\",\"operatorValue\":100}],\"_key\":\"48c02f46-f3c3-9ad6-924e-502a82762e18\",\"perOperator\":\"\",\"operatorLv1\":\"Min\",\"percentile\":null,\"markLine\":null,\"METRIC_LABEL\":\"load\",\"ORIGIN_METRIC_LABEL\":\"Math(Min(metrics.load1_by_cpu_num)*100)\"}],\"dataSource\":\"\",\"condition\":{\"dbName\":\"deepflow_admin\",\"tableName\":\"deepflow_server_monitor\",\"type\":\"simplified\",\"RESOURCE_SETS\":[{\"id\":\"R1\",\"condition\":[],\"groupBy\":[\"_\",\"tag.host\",\"tag.host_ip\"],\"groupInfo\":{\"mainGroupInfo\":[\"_\"],\"otherGroupInfo\":[\"tag.host\",\"tag.host_ip\"]},\"inputMode\":\"free\"}]}}]", query_params="{\"DATABASE\":\"deepflow_admin\",\"TABLE\":\"deepflow_server_monitor\",\"interval\":60,\"fill\": \"none\",\"window_size\":5,\"QUERIES\":[{\"QUERY_ID\":\"R1\",\"SELECT\":\"Min(`metrics.load1_by_cpu_num`)*100 AS `load`\",\"WHERE\":\"1=1\",\"GROUP_BY\":\"`tag.host_ip`, `tag.host`\",\"METRICS\":[\"Min(`metrics.load1_by_cpu_num`)*100 AS `load`\"]}]}" WHERE name="数据节点系统负载高";
    END IF;
    COMMIT; 

END;

CALL update_data_sources();

-- whether default db or not, update db_version to latest, remember update DB_VERSION_EXPECT in migrate/init.go
UPDATE db_version SET version='6.6.1.0';
-- modify end
