/*
 * Copyright (c) 2024 Yunshan Networks
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package flow_metrics

type Tagger interface {
	SetID(string)
	GetCode() uint64
	SetCode(uint64)
	GetTAPType() uint8
	ToKVString() string
	MarshalTo([]byte) int
	String() string
	Clone() Tagger
	Release()
}

type Meter interface {
	ID() uint8
	Name() string
	VTAPName() string
	ConcurrentMerge(Meter)
	SequentialMerge(Meter)
	ToKVString() string
	MarshalTo([]byte) int
	SortKey() uint64
	Release()
	Reverse()
	ToReversed() Meter
}
