# The Project

Pixie (The Project) is an open source software project. The goal of The Project is to develop open source software and enable out-of-the-box visibility into developer's Kubernetes applications. The Software developed by The Project is released under the Apache 2.0 license and is developed openly and hosted in public Github Repositories under the pixie-io organization. Examples of Project Software include the Pixie core library, Pixie Python API, Pixie Go API, and Pixie documentation.


## Principles

The Pixie community adheres to the following principles:
-   **Open**: Pixie is an open source community.
-   **Welcoming and respectful**: See [Code of Conduct](https://github.com/pixie-io/pixie/blob/main/CODE_OF_CONDUCT.md).
-   **Transparent and accessible**: Changes to the Pixie organization, Pixie code repositories, and CNCF related activities (e.g. level, involvement, etc) are done publicly.
-   **Merit**: Ideas and contributions are accepted according to their technical merit and alignment with project objectives, scope, and design principles.

## Governance Board

The project will have a governance board that consists of two project members, two community members, and two end-user community members. The overall role of the Board is to ensure the long-term well-being of the project from a high-level, both technically and as a community.

The Governance Board and its Members play a special role in certain situations. In particular, the Board may:
-   Make decisions about the overall scope, vision and direction of the project.
-   Make decisions about strategic collaborations with other organizations or individuals.
-   Make decisions about the Services that are run by The Project and manage those Services for the benefit of the Project and Community.
-   Make decisions when regular community discussion doesn't produce consensus on an issue in a reasonable time frame.

### Board Membership

All community and end-user community member positions are appointed for 12-months and are expected to rotate under the consensus and discretion of the board members. The project members of the governance board are decided by a vote from the maintainers every 12 months.

To become eligible for a Community Member board position, an individual should meet some of the following criteria:
-   Be a Project Contributor who has produced contributions that are substantial in quality and quantity.
-   Sustain this development consistently over several months.
-   Support the community through various activities (some examples below):
    -   code review
    -   answering user questions
    -   triaging bug reports
    -   participating constructively in broader conversations
    -   contributing to documentation
    -   maintaining infrastructure
-   Demonstrate breadth by supporting the community outside of their particular work interests or sub-project
-   Be civil in public discourse

We are currently looking to fill the position for two end-user community members! Please reach out to the Pixie project team to apply.

### Voting

In general, the Board makes decisions by lazy consensus with a minimum of participation based on the importance of the decisions to be made. Conversations happen on public GitHub for most cases, and through private e-mail for more sensitive issues.

To make a decision the Board discusses the topic, a proposal is made, and a suitable wait time occurs for Board members to either agree or veto. By consensus we mean that any Board member can veto a decision with justification. By lazy we mean that not all Board members must participate, and that absence is interpreted as assent. By a minimum of participation we mean that we require the participation of a certain number of individuals based on the importance of the issue; for non-contentious issues a single Board member may move forward after a suitable time, while for contentious issues we will often require a few, often from different institutions.

### Private communications of the Board

Unless specifically required, all Board discussions and activities will be public and done in collaboration and discussion with the Project Contributors and Community. The Board will have a private mailing list that will be used sparingly and only when a specific matter requires privacy. When private communications and decisions are needed, the Board will do its best to summarize those to the Community after eliding personal/private/sensitive information that should not be posted to the public internet.

## Contributors

The Project is developed by a distributed team of developers, called Contributors. Contributors are individuals who have contributed code, documentation, designs, user support, or other work to one or more Project repositories. Anyone can be a Contributor. Contributors can be affiliated with any legal entity or none. Contributors participate in the project by submitting, reviewing and discussing Code Contributions and Issues and participating in open and public Project discussions on GitHub, Slack, and mailing lists. 

## Maintainers

Maintainers are responsible for the overall quality and development of the Project and its components. 

### Expectations from Maintainers

Maintainers should actively participate in Pull Request reviews. Maintainers are expected to respond to assigned Pull Requests in a reasonable time frame, either providing insights, or assign the Pull Requests to other maintainers.


Every maintainer is listed in the [MAINTAINERS](https://github.com/pixie-io/pixie/blob/main/MAINTAINERS) file, with their Github handle.

### Becoming a Maintainer

#### Requirements
-   Sponsor from 2 existing maintainers
-   Enabled [two-factor authentication](https://help.github.com/articles/about-two-factor-authentication) on their GitHub account
-   Actively contributed to the community. Contributions may include, but are not limited to:
-   Authoring PRs
-   Reviewing issues/PRs authored by other community members
-   Participating in community discussions on Slack/mailing list
-   Participating in Pixie community meetings

#### Responsibilities and privileges
-   Member of the Pixie-io GitHub organization
-   Can be assigned to issues and PRs and community members can also request their review
-   Participate in assigned issues and PRs
-   Welcome new contributors
-   Help/Motivate new members in contributing to Pixie

### Changes in Maintainership

If a Maintainer feels they can not fulfill the "Expectations from Maintainers", they are free to step down.

The Pixie organization will never forcefully remove a current Maintainer, unless a maintainer fails to meet the principles of Pixie community, or adhere to the [Code of Conduct](https://github.com/pixie-io/pixie/blob/main/CODE_OF_CONDUCT.md).

### Decision-making process

Decisions are built on consensus between maintainers. Proposals and ideas can either be submitted for agreement via a GitHub issue or PR, or by sending an email to maintainers@px.dev.

In general, we prefer that technical issues and maintainer membership are amicably worked out between the persons involved. If a dispute cannot be resolved independently, get a third-party maintainer (e.g. a mutual contact with some background on the issue, but not involved in the conflict) to intercede. If a dispute still cannot be resolved, the Governance Board has the final say to decide an issue.

The decision-making process should be transparent to adhere to the Pixie Code of Conduct.

All proposals, ideas, and decisions by maintainers should either be part of a GitHub issue or PR, or be sent to maintainers@px.dev.

## Other Projects

The Pixie organization is open to receive new sub-projects under its umbrella. To accept a project into the Pixie organization, it has to meet the following criteria:

-   Must be licensed under the terms of the Apache License v2.0
-   Must be related to one or more scopes of the Pixie ecosystem:
-   Pixie project artifacts (website, deployments, CI, etc)
-   External plugins
-   Other observability/eBPF tooling
-   Must be supported by a Maintainer not associated or affiliated with the author(s) of the sub-projects

The submission process starts as a Pull Request or Issue on the [pixie-io/pixie](https://github.com/pixie-io/pixie/tree/main) repository with the required information mentioned above. Once a project is accepted, it's considered a CNCF sub-project under the umbrella of Pixie.

## Pixie and CNCF

Pixie is a CNCF project. As such, Pixie might be involved in CNCF (or other CNCF projects) related marketing, events, or activities. Any maintainer can help drive Pixie's involvement, as long as they create a GitHub Pull Request to call for participation from other maintainers. The Call for Participation should be kept open for no less than a week if time permits, or a reasonable time frame to allow maintainers to have a chance to volunteer.

## Code of Conduct

The [Pixie Code of Conduct](https://github.com/pixie-io/pixie/blob/main/CODE_OF_CONDUCT.md) is aligned with the CNCF Code of Conduct.

## Changing the Governance Documents

Changes to the governance documents are submitted via a GitHub pull request to The Project's governance document. The pull request is then refined in response to public comment and review, with the goal being consensus in the community.

## Credits

Sections of this document have been borrowed from [Volcano](https://github.com/volcano-sh/volcano/blob/master/GOVERNANCE.md) and [CoreDNS](https://github.com/coredns/coredns/blob/master/GOVERNANCE.md)
