/*
 * Copyright 2018- The Pixie Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#include "src/common/exec/exec.h"

#include <memory>

#include "src/common/base/error.h"

namespace px {

// GCC's ingnored-attribute warning is triggered without wrapping pclose. This is likely do to the
// nonnull attribute.
struct pclose_deleter {
  void operator()(FILE* file) const { pclose(file); }
};

StatusOr<std::string> Exec(std::string cmd) {
  std::unique_ptr<FILE, pclose_deleter> pipe(popen(cmd.c_str(), "r"));
  if (pipe == nullptr) {
    return error::Internal("popen() failed!");
  }

  std::array<char, 128> buffer;
  std::string result;
  while (fgets(buffer.data(), buffer.size(), pipe.get()) != nullptr) {
    result += buffer.data();
  }
  return result;
}

}  // namespace px
