// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "px.dev/pixie/src/operator/apis/px.dev/v1alpha1"
	scheme "px.dev/pixie/src/operator/client/versioned/scheme"
)

// ViziersGetter has a method to return a VizierInterface.
// A group's client should implement this interface.
type ViziersGetter interface {
	Viziers(namespace string) VizierInterface
}

// VizierInterface has methods to work with Vizier resources.
type VizierInterface interface {
	Create(ctx context.Context, vizier *v1alpha1.Vizier, opts v1.CreateOptions) (*v1alpha1.Vizier, error)
	Update(ctx context.Context, vizier *v1alpha1.Vizier, opts v1.UpdateOptions) (*v1alpha1.Vizier, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.Vizier, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.VizierList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Vizier, err error)
	VizierExpansion
}

// viziers implements VizierInterface
type viziers struct {
	client rest.Interface
	ns     string
}

// newViziers returns a Viziers
func newViziers(c *PxV1alpha1Client, namespace string) *viziers {
	return &viziers{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the vizier, and returns the corresponding vizier object, and an error if there is any.
func (c *viziers) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.Vizier, err error) {
	result = &v1alpha1.Vizier{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("viziers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Viziers that match those selectors.
func (c *viziers) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.VizierList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.VizierList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("viziers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested viziers.
func (c *viziers) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("viziers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a vizier and creates it.  Returns the server's representation of the vizier, and an error, if there is any.
func (c *viziers) Create(ctx context.Context, vizier *v1alpha1.Vizier, opts v1.CreateOptions) (result *v1alpha1.Vizier, err error) {
	result = &v1alpha1.Vizier{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("viziers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(vizier).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a vizier and updates it. Returns the server's representation of the vizier, and an error, if there is any.
func (c *viziers) Update(ctx context.Context, vizier *v1alpha1.Vizier, opts v1.UpdateOptions) (result *v1alpha1.Vizier, err error) {
	result = &v1alpha1.Vizier{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("viziers").
		Name(vizier.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(vizier).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the vizier and deletes it. Returns an error if one occurs.
func (c *viziers) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("viziers").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *viziers) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("viziers").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched vizier.
func (c *viziers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Vizier, err error) {
	result = &v1alpha1.Vizier{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("viziers").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
