// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: src/shared/services/jwtpb/jwt.proto

package jwtpb

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type JWTClaims struct {
	Audience  string   `protobuf:"bytes,1,opt,name=audience,proto3" json:"aud"`
	ExpiresAt int64    `protobuf:"varint,2,opt,name=expires_at,json=expiresAt,proto3" json:"exp"`
	JTI       string   `protobuf:"bytes,3,opt,name=jti,proto3" json:"jti"`
	IssuedAt  int64    `protobuf:"varint,4,opt,name=issued_at,json=issuedAt,proto3" json:"iat"`
	Issuer    string   `protobuf:"bytes,5,opt,name=issuer,proto3" json:"iss"`
	NotBefore int64    `protobuf:"varint,6,opt,name=not_before,json=notBefore,proto3" json:"nbf"`
	Subject   string   `protobuf:"bytes,7,opt,name=subject,proto3" json:"sub"`
	Scopes    []string `protobuf:"bytes,8,rep,name=scopes,proto3" json:"scopes,omitempty"`
	// Types that are valid to be assigned to CustomClaims:
	//
	//	*JWTClaims_UserClaims
	//	*JWTClaims_ServiceClaims
	//	*JWTClaims_ClusterClaims
	CustomClaims isJWTClaims_CustomClaims `protobuf_oneof:"custom_claims"`
}

func (m *JWTClaims) Reset()      { *m = JWTClaims{} }
func (*JWTClaims) ProtoMessage() {}
func (*JWTClaims) Descriptor() ([]byte, []int) {
	return fileDescriptor_33e330850bad81da, []int{0}
}
func (m *JWTClaims) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *JWTClaims) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_JWTClaims.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *JWTClaims) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JWTClaims.Merge(m, src)
}
func (m *JWTClaims) XXX_Size() int {
	return m.Size()
}
func (m *JWTClaims) XXX_DiscardUnknown() {
	xxx_messageInfo_JWTClaims.DiscardUnknown(m)
}

var xxx_messageInfo_JWTClaims proto.InternalMessageInfo

type isJWTClaims_CustomClaims interface {
	isJWTClaims_CustomClaims()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type JWTClaims_UserClaims struct {
	UserClaims *UserJWTClaims `protobuf:"bytes,9,opt,name=user_claims,json=userClaims,proto3,oneof" json:"user_claims,omitempty"`
}
type JWTClaims_ServiceClaims struct {
	ServiceClaims *ServiceJWTClaims `protobuf:"bytes,10,opt,name=service_claims,json=serviceClaims,proto3,oneof" json:"service_claims,omitempty"`
}
type JWTClaims_ClusterClaims struct {
	ClusterClaims *ClusterJWTClaims `protobuf:"bytes,11,opt,name=cluster_claims,json=clusterClaims,proto3,oneof" json:"cluster_claims,omitempty"`
}

func (*JWTClaims_UserClaims) isJWTClaims_CustomClaims()    {}
func (*JWTClaims_ServiceClaims) isJWTClaims_CustomClaims() {}
func (*JWTClaims_ClusterClaims) isJWTClaims_CustomClaims() {}

func (m *JWTClaims) GetCustomClaims() isJWTClaims_CustomClaims {
	if m != nil {
		return m.CustomClaims
	}
	return nil
}

func (m *JWTClaims) GetAudience() string {
	if m != nil {
		return m.Audience
	}
	return ""
}

func (m *JWTClaims) GetExpiresAt() int64 {
	if m != nil {
		return m.ExpiresAt
	}
	return 0
}

func (m *JWTClaims) GetJTI() string {
	if m != nil {
		return m.JTI
	}
	return ""
}

func (m *JWTClaims) GetIssuedAt() int64 {
	if m != nil {
		return m.IssuedAt
	}
	return 0
}

func (m *JWTClaims) GetIssuer() string {
	if m != nil {
		return m.Issuer
	}
	return ""
}

func (m *JWTClaims) GetNotBefore() int64 {
	if m != nil {
		return m.NotBefore
	}
	return 0
}

func (m *JWTClaims) GetSubject() string {
	if m != nil {
		return m.Subject
	}
	return ""
}

func (m *JWTClaims) GetScopes() []string {
	if m != nil {
		return m.Scopes
	}
	return nil
}

func (m *JWTClaims) GetUserClaims() *UserJWTClaims {
	if x, ok := m.GetCustomClaims().(*JWTClaims_UserClaims); ok {
		return x.UserClaims
	}
	return nil
}

func (m *JWTClaims) GetServiceClaims() *ServiceJWTClaims {
	if x, ok := m.GetCustomClaims().(*JWTClaims_ServiceClaims); ok {
		return x.ServiceClaims
	}
	return nil
}

func (m *JWTClaims) GetClusterClaims() *ClusterJWTClaims {
	if x, ok := m.GetCustomClaims().(*JWTClaims_ClusterClaims); ok {
		return x.ClusterClaims
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*JWTClaims) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*JWTClaims_UserClaims)(nil),
		(*JWTClaims_ServiceClaims)(nil),
		(*JWTClaims_ClusterClaims)(nil),
	}
}

type UserJWTClaims struct {
	UserID    string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"userID"`
	OrgID     string `protobuf:"bytes,2,opt,name=org_id,json=orgId,proto3" json:"orgID"`
	Email     string `protobuf:"bytes,3,opt,name=email,proto3" json:"email,omitempty"`
	IsAPIUser bool   `protobuf:"varint,4,opt,name=is_api_user,json=isApiUser,proto3" json:"isAPIUser"`
}

func (m *UserJWTClaims) Reset()      { *m = UserJWTClaims{} }
func (*UserJWTClaims) ProtoMessage() {}
func (*UserJWTClaims) Descriptor() ([]byte, []int) {
	return fileDescriptor_33e330850bad81da, []int{1}
}
func (m *UserJWTClaims) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UserJWTClaims) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UserJWTClaims.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UserJWTClaims) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserJWTClaims.Merge(m, src)
}
func (m *UserJWTClaims) XXX_Size() int {
	return m.Size()
}
func (m *UserJWTClaims) XXX_DiscardUnknown() {
	xxx_messageInfo_UserJWTClaims.DiscardUnknown(m)
}

var xxx_messageInfo_UserJWTClaims proto.InternalMessageInfo

func (m *UserJWTClaims) GetUserID() string {
	if m != nil {
		return m.UserID
	}
	return ""
}

func (m *UserJWTClaims) GetOrgID() string {
	if m != nil {
		return m.OrgID
	}
	return ""
}

func (m *UserJWTClaims) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *UserJWTClaims) GetIsAPIUser() bool {
	if m != nil {
		return m.IsAPIUser
	}
	return false
}

type ServiceJWTClaims struct {
	ServiceID string `protobuf:"bytes,1,opt,name=service_id,json=serviceId,proto3" json:"serviceID"`
}

func (m *ServiceJWTClaims) Reset()      { *m = ServiceJWTClaims{} }
func (*ServiceJWTClaims) ProtoMessage() {}
func (*ServiceJWTClaims) Descriptor() ([]byte, []int) {
	return fileDescriptor_33e330850bad81da, []int{2}
}
func (m *ServiceJWTClaims) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ServiceJWTClaims) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ServiceJWTClaims.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ServiceJWTClaims) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceJWTClaims.Merge(m, src)
}
func (m *ServiceJWTClaims) XXX_Size() int {
	return m.Size()
}
func (m *ServiceJWTClaims) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceJWTClaims.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceJWTClaims proto.InternalMessageInfo

func (m *ServiceJWTClaims) GetServiceID() string {
	if m != nil {
		return m.ServiceID
	}
	return ""
}

type ClusterJWTClaims struct {
	ClusterID string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"clusterID"`
}

func (m *ClusterJWTClaims) Reset()      { *m = ClusterJWTClaims{} }
func (*ClusterJWTClaims) ProtoMessage() {}
func (*ClusterJWTClaims) Descriptor() ([]byte, []int) {
	return fileDescriptor_33e330850bad81da, []int{3}
}
func (m *ClusterJWTClaims) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterJWTClaims) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterJWTClaims.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ClusterJWTClaims) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterJWTClaims.Merge(m, src)
}
func (m *ClusterJWTClaims) XXX_Size() int {
	return m.Size()
}
func (m *ClusterJWTClaims) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterJWTClaims.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterJWTClaims proto.InternalMessageInfo

func (m *ClusterJWTClaims) GetClusterID() string {
	if m != nil {
		return m.ClusterID
	}
	return ""
}

func init() {
	proto.RegisterType((*JWTClaims)(nil), "px.common.JWTClaims")
	proto.RegisterType((*UserJWTClaims)(nil), "px.common.UserJWTClaims")
	proto.RegisterType((*ServiceJWTClaims)(nil), "px.common.ServiceJWTClaims")
	proto.RegisterType((*ClusterJWTClaims)(nil), "px.common.ClusterJWTClaims")
}

func init() {
	proto.RegisterFile("src/shared/services/jwtpb/jwt.proto", fileDescriptor_33e330850bad81da)
}

var fileDescriptor_33e330850bad81da = []byte{
	// 585 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x64, 0x93, 0x4f, 0x6f, 0xd3, 0x3e,
	0x18, 0xc7, 0xe3, 0xe5, 0xd7, 0xb4, 0x71, 0xb5, 0xfd, 0x90, 0x35, 0xa1, 0x68, 0x48, 0x4e, 0xd9,
	0x10, 0x2a, 0x07, 0x5a, 0x09, 0x4e, 0xb0, 0x53, 0xbb, 0x1d, 0xe8, 0x24, 0x04, 0x32, 0x43, 0x48,
	0x5c, 0xaa, 0xfc, 0xf1, 0x8a, 0xab, 0xb6, 0x8e, 0x62, 0x07, 0x7a, 0xe4, 0x25, 0xf0, 0x32, 0x78,
	0x0f, 0xbc, 0x01, 0x8e, 0x3d, 0xee, 0x14, 0xd1, 0xf4, 0x82, 0x7a, 0xda, 0x2b, 0x40, 0xc8, 0xce,
	0xbf, 0x75, 0x5c, 0x92, 0xef, 0x63, 0x7f, 0x9f, 0x4f, 0x9f, 0x7c, 0x6b, 0xc3, 0x13, 0x11, 0x07,
	0x7d, 0xf1, 0xc9, 0x8b, 0x69, 0xd8, 0x17, 0x34, 0xfe, 0xcc, 0x02, 0x2a, 0xfa, 0xd3, 0x2f, 0x32,
	0xf2, 0xd5, 0xb3, 0x17, 0xc5, 0x5c, 0x72, 0x64, 0x47, 0xcb, 0x5e, 0xc0, 0xe7, 0x73, 0xbe, 0x38,
	0x3a, 0x9c, 0xf0, 0x09, 0xd7, 0xab, 0x7d, 0xa5, 0x72, 0xc3, 0xf1, 0x1f, 0x13, 0xda, 0x17, 0x1f,
	0x2e, 0xcf, 0x66, 0x1e, 0x9b, 0x0b, 0x74, 0x02, 0x5b, 0x5e, 0x12, 0x32, 0xba, 0x08, 0xa8, 0x03,
	0x3a, 0xa0, 0x6b, 0x0f, 0x9b, 0xdb, 0xd4, 0x35, 0xbd, 0x24, 0x24, 0xd5, 0x06, 0x7a, 0x0c, 0x21,
	0x5d, 0x46, 0x2c, 0xa6, 0x62, 0xec, 0x49, 0x67, 0xaf, 0x03, 0xba, 0x66, 0x6e, 0xa3, 0xcb, 0x88,
	0xd8, 0xc5, 0xd6, 0x40, 0xa2, 0x0e, 0x34, 0xa7, 0x92, 0x39, 0xa6, 0xe6, 0x1c, 0x64, 0xa9, 0x6b,
	0x5e, 0x5c, 0x8e, 0x94, 0x6f, 0x2a, 0x19, 0x51, 0x0f, 0xf4, 0x08, 0xda, 0x4c, 0x88, 0x84, 0x86,
	0x0a, 0xf4, 0x5f, 0x0d, 0x62, 0x9e, 0x24, 0xad, 0x7c, 0x67, 0x20, 0x91, 0x0b, 0x2d, 0xad, 0x63,
	0xa7, 0x51, 0x8f, 0xc4, 0x84, 0x20, 0xc5, 0xb2, 0x1a, 0x68, 0xc1, 0xe5, 0xd8, 0xa7, 0x57, 0x3c,
	0xa6, 0x8e, 0x55, 0x73, 0x16, 0xfe, 0x15, 0xb1, 0x17, 0x5c, 0x0e, 0xf5, 0x0e, 0x7a, 0x08, 0x9b,
	0x22, 0xf1, 0xa7, 0x34, 0x90, 0x4e, 0xb3, 0x26, 0x89, 0xc4, 0x27, 0xe5, 0x3a, 0xba, 0x0f, 0x2d,
	0x11, 0xf0, 0x88, 0x0a, 0xa7, 0xd5, 0x31, 0xbb, 0x36, 0x29, 0x2a, 0x74, 0x0a, 0xdb, 0x89, 0xa0,
	0xf1, 0x38, 0xd0, 0x39, 0x39, 0x76, 0x07, 0x74, 0xdb, 0xcf, 0x9c, 0x5e, 0x95, 0x6e, 0xef, 0xbd,
	0xa0, 0x71, 0x95, 0xe3, 0x2b, 0x83, 0x40, 0x65, 0x2f, 0x52, 0x3d, 0x87, 0x07, 0xc5, 0x1f, 0x54,
	0xf6, 0x43, 0xdd, 0xff, 0xe0, 0x56, 0xff, 0xbb, 0xdc, 0x70, 0x1b, 0xb1, 0x5f, 0x34, 0xd5, 0x94,
	0x60, 0x96, 0x08, 0x59, 0x4f, 0xd1, 0xfe, 0x87, 0x72, 0x96, 0x1b, 0x76, 0x28, 0x45, 0x53, 0xbe,
	0x30, 0xfc, 0x1f, 0xee, 0x07, 0x89, 0x90, 0x7c, 0x5e, 0x40, 0x8e, 0x7f, 0x00, 0xb8, 0xbf, 0x33,
	0x3c, 0x7a, 0x0a, 0x9b, 0xfa, 0x5b, 0x59, 0x58, 0x9c, 0x81, 0xc3, 0x2c, 0x75, 0x2d, 0xe5, 0x19,
	0x9d, 0x6f, 0x53, 0xd7, 0x4a, 0xb4, 0x22, 0xf9, 0x3b, 0x44, 0x4f, 0xa0, 0xc5, 0xe3, 0x89, 0x72,
	0xef, 0x69, 0x37, 0xca, 0x52, 0xb7, 0xf1, 0x26, 0x9e, 0x68, 0x73, 0x83, 0x2b, 0x41, 0xf4, 0x2b,
	0x44, 0x87, 0xb0, 0x41, 0xe7, 0x1e, 0x9b, 0xe5, 0x67, 0x82, 0xe4, 0x05, 0x7a, 0x09, 0xdb, 0x4c,
	0x8c, 0xbd, 0x88, 0x8d, 0x15, 0x51, 0x9f, 0x83, 0xd6, 0xf0, 0x28, 0x4b, 0x5d, 0x7b, 0x24, 0x06,
	0x6f, 0x47, 0xea, 0x87, 0xb7, 0xa9, 0x6b, 0xb3, 0xb2, 0x20, 0x4a, 0x46, 0x4c, 0xc9, 0xe3, 0xd7,
	0xf0, 0xde, 0xdd, 0xe4, 0xd0, 0x0b, 0x08, 0xcb, 0xb8, 0xab, 0x4f, 0xd0, 0xb8, 0xc2, 0xa9, 0x07,
	0xb3, 0x45, 0x59, 0x90, 0x4a, 0x86, 0x0a, 0x77, 0x37, 0x42, 0x85, 0x2b, 0x73, 0xdf, 0xc5, 0x15,
	0xce, 0x1c, 0x17, 0x94, 0x05, 0xa9, 0x64, 0x38, 0x3c, 0x5d, 0xad, 0xb1, 0x71, 0xbd, 0xc6, 0xc6,
	0xcd, 0x1a, 0x83, 0xaf, 0x19, 0x06, 0xdf, 0x33, 0x0c, 0x7e, 0x66, 0x18, 0xac, 0x32, 0x0c, 0x7e,
	0x65, 0x18, 0xfc, 0xce, 0xb0, 0x71, 0x93, 0x61, 0xf0, 0x6d, 0x83, 0x8d, 0xd5, 0x06, 0x1b, 0xd7,
	0x1b, 0x6c, 0x7c, 0x6c, 0xe8, 0x4b, 0xec, 0x5b, 0xfa, 0x82, 0x3e, 0xff, 0x1b, 0x00, 0x00, 0xff,
	0xff, 0x33, 0x6d, 0xf0, 0xc1, 0xe8, 0x03, 0x00, 0x00,
}

func (this *JWTClaims) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*JWTClaims)
	if !ok {
		that2, ok := that.(JWTClaims)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Audience != that1.Audience {
		return false
	}
	if this.ExpiresAt != that1.ExpiresAt {
		return false
	}
	if this.JTI != that1.JTI {
		return false
	}
	if this.IssuedAt != that1.IssuedAt {
		return false
	}
	if this.Issuer != that1.Issuer {
		return false
	}
	if this.NotBefore != that1.NotBefore {
		return false
	}
	if this.Subject != that1.Subject {
		return false
	}
	if len(this.Scopes) != len(that1.Scopes) {
		return false
	}
	for i := range this.Scopes {
		if this.Scopes[i] != that1.Scopes[i] {
			return false
		}
	}
	if that1.CustomClaims == nil {
		if this.CustomClaims != nil {
			return false
		}
	} else if this.CustomClaims == nil {
		return false
	} else if !this.CustomClaims.Equal(that1.CustomClaims) {
		return false
	}
	return true
}
func (this *JWTClaims_UserClaims) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*JWTClaims_UserClaims)
	if !ok {
		that2, ok := that.(JWTClaims_UserClaims)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.UserClaims.Equal(that1.UserClaims) {
		return false
	}
	return true
}
func (this *JWTClaims_ServiceClaims) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*JWTClaims_ServiceClaims)
	if !ok {
		that2, ok := that.(JWTClaims_ServiceClaims)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ServiceClaims.Equal(that1.ServiceClaims) {
		return false
	}
	return true
}
func (this *JWTClaims_ClusterClaims) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*JWTClaims_ClusterClaims)
	if !ok {
		that2, ok := that.(JWTClaims_ClusterClaims)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ClusterClaims.Equal(that1.ClusterClaims) {
		return false
	}
	return true
}
func (this *UserJWTClaims) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*UserJWTClaims)
	if !ok {
		that2, ok := that.(UserJWTClaims)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.UserID != that1.UserID {
		return false
	}
	if this.OrgID != that1.OrgID {
		return false
	}
	if this.Email != that1.Email {
		return false
	}
	if this.IsAPIUser != that1.IsAPIUser {
		return false
	}
	return true
}
func (this *ServiceJWTClaims) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ServiceJWTClaims)
	if !ok {
		that2, ok := that.(ServiceJWTClaims)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ServiceID != that1.ServiceID {
		return false
	}
	return true
}
func (this *ClusterJWTClaims) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ClusterJWTClaims)
	if !ok {
		that2, ok := that.(ClusterJWTClaims)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ClusterID != that1.ClusterID {
		return false
	}
	return true
}
func (this *JWTClaims) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 15)
	s = append(s, "&jwtpb.JWTClaims{")
	s = append(s, "Audience: "+fmt.Sprintf("%#v", this.Audience)+",\n")
	s = append(s, "ExpiresAt: "+fmt.Sprintf("%#v", this.ExpiresAt)+",\n")
	s = append(s, "JTI: "+fmt.Sprintf("%#v", this.JTI)+",\n")
	s = append(s, "IssuedAt: "+fmt.Sprintf("%#v", this.IssuedAt)+",\n")
	s = append(s, "Issuer: "+fmt.Sprintf("%#v", this.Issuer)+",\n")
	s = append(s, "NotBefore: "+fmt.Sprintf("%#v", this.NotBefore)+",\n")
	s = append(s, "Subject: "+fmt.Sprintf("%#v", this.Subject)+",\n")
	s = append(s, "Scopes: "+fmt.Sprintf("%#v", this.Scopes)+",\n")
	if this.CustomClaims != nil {
		s = append(s, "CustomClaims: "+fmt.Sprintf("%#v", this.CustomClaims)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *JWTClaims_UserClaims) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&jwtpb.JWTClaims_UserClaims{` +
		`UserClaims:` + fmt.Sprintf("%#v", this.UserClaims) + `}`}, ", ")
	return s
}
func (this *JWTClaims_ServiceClaims) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&jwtpb.JWTClaims_ServiceClaims{` +
		`ServiceClaims:` + fmt.Sprintf("%#v", this.ServiceClaims) + `}`}, ", ")
	return s
}
func (this *JWTClaims_ClusterClaims) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&jwtpb.JWTClaims_ClusterClaims{` +
		`ClusterClaims:` + fmt.Sprintf("%#v", this.ClusterClaims) + `}`}, ", ")
	return s
}
func (this *UserJWTClaims) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&jwtpb.UserJWTClaims{")
	s = append(s, "UserID: "+fmt.Sprintf("%#v", this.UserID)+",\n")
	s = append(s, "OrgID: "+fmt.Sprintf("%#v", this.OrgID)+",\n")
	s = append(s, "Email: "+fmt.Sprintf("%#v", this.Email)+",\n")
	s = append(s, "IsAPIUser: "+fmt.Sprintf("%#v", this.IsAPIUser)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ServiceJWTClaims) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&jwtpb.ServiceJWTClaims{")
	s = append(s, "ServiceID: "+fmt.Sprintf("%#v", this.ServiceID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ClusterJWTClaims) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&jwtpb.ClusterJWTClaims{")
	s = append(s, "ClusterID: "+fmt.Sprintf("%#v", this.ClusterID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringJwt(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *JWTClaims) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JWTClaims) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *JWTClaims) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.CustomClaims != nil {
		{
			size := m.CustomClaims.Size()
			i -= size
			if _, err := m.CustomClaims.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.Scopes) > 0 {
		for iNdEx := len(m.Scopes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Scopes[iNdEx])
			copy(dAtA[i:], m.Scopes[iNdEx])
			i = encodeVarintJwt(dAtA, i, uint64(len(m.Scopes[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.Subject) > 0 {
		i -= len(m.Subject)
		copy(dAtA[i:], m.Subject)
		i = encodeVarintJwt(dAtA, i, uint64(len(m.Subject)))
		i--
		dAtA[i] = 0x3a
	}
	if m.NotBefore != 0 {
		i = encodeVarintJwt(dAtA, i, uint64(m.NotBefore))
		i--
		dAtA[i] = 0x30
	}
	if len(m.Issuer) > 0 {
		i -= len(m.Issuer)
		copy(dAtA[i:], m.Issuer)
		i = encodeVarintJwt(dAtA, i, uint64(len(m.Issuer)))
		i--
		dAtA[i] = 0x2a
	}
	if m.IssuedAt != 0 {
		i = encodeVarintJwt(dAtA, i, uint64(m.IssuedAt))
		i--
		dAtA[i] = 0x20
	}
	if len(m.JTI) > 0 {
		i -= len(m.JTI)
		copy(dAtA[i:], m.JTI)
		i = encodeVarintJwt(dAtA, i, uint64(len(m.JTI)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ExpiresAt != 0 {
		i = encodeVarintJwt(dAtA, i, uint64(m.ExpiresAt))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Audience) > 0 {
		i -= len(m.Audience)
		copy(dAtA[i:], m.Audience)
		i = encodeVarintJwt(dAtA, i, uint64(len(m.Audience)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *JWTClaims_UserClaims) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *JWTClaims_UserClaims) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.UserClaims != nil {
		{
			size, err := m.UserClaims.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintJwt(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	return len(dAtA) - i, nil
}
func (m *JWTClaims_ServiceClaims) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *JWTClaims_ServiceClaims) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ServiceClaims != nil {
		{
			size, err := m.ServiceClaims.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintJwt(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	return len(dAtA) - i, nil
}
func (m *JWTClaims_ClusterClaims) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *JWTClaims_ClusterClaims) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ClusterClaims != nil {
		{
			size, err := m.ClusterClaims.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintJwt(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	return len(dAtA) - i, nil
}
func (m *UserJWTClaims) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UserJWTClaims) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UserJWTClaims) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.IsAPIUser {
		i--
		if m.IsAPIUser {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Email) > 0 {
		i -= len(m.Email)
		copy(dAtA[i:], m.Email)
		i = encodeVarintJwt(dAtA, i, uint64(len(m.Email)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.OrgID) > 0 {
		i -= len(m.OrgID)
		copy(dAtA[i:], m.OrgID)
		i = encodeVarintJwt(dAtA, i, uint64(len(m.OrgID)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.UserID) > 0 {
		i -= len(m.UserID)
		copy(dAtA[i:], m.UserID)
		i = encodeVarintJwt(dAtA, i, uint64(len(m.UserID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ServiceJWTClaims) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServiceJWTClaims) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ServiceJWTClaims) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ServiceID) > 0 {
		i -= len(m.ServiceID)
		copy(dAtA[i:], m.ServiceID)
		i = encodeVarintJwt(dAtA, i, uint64(len(m.ServiceID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ClusterJWTClaims) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterJWTClaims) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ClusterJWTClaims) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ClusterID) > 0 {
		i -= len(m.ClusterID)
		copy(dAtA[i:], m.ClusterID)
		i = encodeVarintJwt(dAtA, i, uint64(len(m.ClusterID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintJwt(dAtA []byte, offset int, v uint64) int {
	offset -= sovJwt(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *JWTClaims) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Audience)
	if l > 0 {
		n += 1 + l + sovJwt(uint64(l))
	}
	if m.ExpiresAt != 0 {
		n += 1 + sovJwt(uint64(m.ExpiresAt))
	}
	l = len(m.JTI)
	if l > 0 {
		n += 1 + l + sovJwt(uint64(l))
	}
	if m.IssuedAt != 0 {
		n += 1 + sovJwt(uint64(m.IssuedAt))
	}
	l = len(m.Issuer)
	if l > 0 {
		n += 1 + l + sovJwt(uint64(l))
	}
	if m.NotBefore != 0 {
		n += 1 + sovJwt(uint64(m.NotBefore))
	}
	l = len(m.Subject)
	if l > 0 {
		n += 1 + l + sovJwt(uint64(l))
	}
	if len(m.Scopes) > 0 {
		for _, s := range m.Scopes {
			l = len(s)
			n += 1 + l + sovJwt(uint64(l))
		}
	}
	if m.CustomClaims != nil {
		n += m.CustomClaims.Size()
	}
	return n
}

func (m *JWTClaims_UserClaims) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.UserClaims != nil {
		l = m.UserClaims.Size()
		n += 1 + l + sovJwt(uint64(l))
	}
	return n
}
func (m *JWTClaims_ServiceClaims) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ServiceClaims != nil {
		l = m.ServiceClaims.Size()
		n += 1 + l + sovJwt(uint64(l))
	}
	return n
}
func (m *JWTClaims_ClusterClaims) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClusterClaims != nil {
		l = m.ClusterClaims.Size()
		n += 1 + l + sovJwt(uint64(l))
	}
	return n
}
func (m *UserJWTClaims) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.UserID)
	if l > 0 {
		n += 1 + l + sovJwt(uint64(l))
	}
	l = len(m.OrgID)
	if l > 0 {
		n += 1 + l + sovJwt(uint64(l))
	}
	l = len(m.Email)
	if l > 0 {
		n += 1 + l + sovJwt(uint64(l))
	}
	if m.IsAPIUser {
		n += 2
	}
	return n
}

func (m *ServiceJWTClaims) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ServiceID)
	if l > 0 {
		n += 1 + l + sovJwt(uint64(l))
	}
	return n
}

func (m *ClusterJWTClaims) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ClusterID)
	if l > 0 {
		n += 1 + l + sovJwt(uint64(l))
	}
	return n
}

func sovJwt(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozJwt(x uint64) (n int) {
	return sovJwt(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *JWTClaims) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&JWTClaims{`,
		`Audience:` + fmt.Sprintf("%v", this.Audience) + `,`,
		`ExpiresAt:` + fmt.Sprintf("%v", this.ExpiresAt) + `,`,
		`JTI:` + fmt.Sprintf("%v", this.JTI) + `,`,
		`IssuedAt:` + fmt.Sprintf("%v", this.IssuedAt) + `,`,
		`Issuer:` + fmt.Sprintf("%v", this.Issuer) + `,`,
		`NotBefore:` + fmt.Sprintf("%v", this.NotBefore) + `,`,
		`Subject:` + fmt.Sprintf("%v", this.Subject) + `,`,
		`Scopes:` + fmt.Sprintf("%v", this.Scopes) + `,`,
		`CustomClaims:` + fmt.Sprintf("%v", this.CustomClaims) + `,`,
		`}`,
	}, "")
	return s
}
func (this *JWTClaims_UserClaims) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&JWTClaims_UserClaims{`,
		`UserClaims:` + strings.Replace(fmt.Sprintf("%v", this.UserClaims), "UserJWTClaims", "UserJWTClaims", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *JWTClaims_ServiceClaims) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&JWTClaims_ServiceClaims{`,
		`ServiceClaims:` + strings.Replace(fmt.Sprintf("%v", this.ServiceClaims), "ServiceJWTClaims", "ServiceJWTClaims", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *JWTClaims_ClusterClaims) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&JWTClaims_ClusterClaims{`,
		`ClusterClaims:` + strings.Replace(fmt.Sprintf("%v", this.ClusterClaims), "ClusterJWTClaims", "ClusterJWTClaims", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UserJWTClaims) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UserJWTClaims{`,
		`UserID:` + fmt.Sprintf("%v", this.UserID) + `,`,
		`OrgID:` + fmt.Sprintf("%v", this.OrgID) + `,`,
		`Email:` + fmt.Sprintf("%v", this.Email) + `,`,
		`IsAPIUser:` + fmt.Sprintf("%v", this.IsAPIUser) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ServiceJWTClaims) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ServiceJWTClaims{`,
		`ServiceID:` + fmt.Sprintf("%v", this.ServiceID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ClusterJWTClaims) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ClusterJWTClaims{`,
		`ClusterID:` + fmt.Sprintf("%v", this.ClusterID) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringJwt(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *JWTClaims) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJwt
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JWTClaims: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JWTClaims: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Audience", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJwt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthJwt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Audience = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpiresAt", wireType)
			}
			m.ExpiresAt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExpiresAt |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JTI", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJwt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthJwt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.JTI = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IssuedAt", wireType)
			}
			m.IssuedAt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IssuedAt |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Issuer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJwt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthJwt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Issuer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotBefore", wireType)
			}
			m.NotBefore = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NotBefore |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subject", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJwt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthJwt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subject = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scopes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJwt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthJwt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Scopes = append(m.Scopes, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserClaims", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJwt
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthJwt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &UserJWTClaims{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.CustomClaims = &JWTClaims_UserClaims{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceClaims", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJwt
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthJwt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ServiceJWTClaims{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.CustomClaims = &JWTClaims_ServiceClaims{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterClaims", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthJwt
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthJwt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ClusterJWTClaims{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.CustomClaims = &JWTClaims_ClusterClaims{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipJwt(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthJwt
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UserJWTClaims) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJwt
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UserJWTClaims: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UserJWTClaims: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJwt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthJwt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrgID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJwt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthJwt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrgID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Email", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJwt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthJwt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Email = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsAPIUser", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsAPIUser = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipJwt(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthJwt
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServiceJWTClaims) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJwt
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServiceJWTClaims: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServiceJWTClaims: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJwt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthJwt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipJwt(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthJwt
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterJWTClaims) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowJwt
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterJWTClaims: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterJWTClaims: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthJwt
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthJwt
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipJwt(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthJwt
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipJwt(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowJwt
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowJwt
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthJwt
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupJwt
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthJwt
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthJwt        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowJwt          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupJwt = fmt.Errorf("proto: unexpected end of group")
)
