/*
 * Copyright 2018- The Pixie Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

import * as React from 'react';

// eslint-disable-next-line react-memo/require-memo,react/display-name
export const PixienautBalloonSvg: React.FC<React.SVGProps<SVGSVGElement>> = (props) => (
  /* eslint-disable max-len */
  <svg width={129} height={179} viewBox='0 0 129 179' fill='none' {...props}>
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M29.4777 156.619C27.7429 157.583 27.2464 159.854 28.4632 161.422C32.5301 166.662 36.3314 170.783 39.867 173.787C46.1398 179.117 51.5227 178.701 54.2128 177.707C56.903 176.713 58.0464 173.9 56.903 171.911C55.7595 169.922 50.6831 164.892 51.2098 162.064C51.7365 159.235 55.1926 162.459 57.5642 164.77C59.9357 167.081 62.5276 168.983 66.1938 166.45C69.86 163.918 67.5877 160.047 65.2155 155.153C63.8173 152.269 60.9996 148.619 56.7624 144.203C55.7445 143.142 54.1368 142.92 52.8516 143.634L29.4777 156.619Z'
      fill='url(#paint0_linear)'
    />
    <path
      opacity={0.1}
      fillRule='evenodd'
      clipRule='evenodd'
      d='M33.7211 161.714L34.5772 161.164C48.2838 152.391 55.5021 150.011 56.2321 154.022L56.2526 154.148C56.8186 158.08 59.9042 162.324 65.5094 166.879C62.1999 168.74 59.7853 166.935 57.564 164.77L56.9761 164.202C54.6582 161.982 51.6942 159.462 51.2096 162.064C50.8277 164.115 53.3925 167.324 55.267 169.691C53.1549 168.469 50.8095 167.574 48.2311 167.007L47.7737 166.91C43.7424 166.092 39.0582 164.36 33.7211 161.714Z'
      fill='#262626'
    />
    <path
      d='M57.0271 172.149C57.954 174.118 56.7971 176.752 54.2127 177.707C53.4079 178.005 52.3622 178.25 51.1237 178.306C50.9022 177.726 50.9811 177.022 51.3604 176.195C52.2021 174.359 54.5619 172.283 56.9848 172.151L57.0271 172.149ZM68.0868 162.406L68.0947 162.482C68.2454 164.034 67.7649 165.365 66.1937 166.45C64.8581 167.373 63.6651 167.707 62.5734 167.647C62.3502 166.961 62.4393 166.23 62.8398 165.452C63.4654 164.238 65.8053 162.31 68.0868 162.406Z'
      fill='url(#paint1_linear)'
    />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M52.3567 140.804C53.399 141.847 55.0607 141.902 56.1849 140.949C60.4586 137.322 63.5365 132.41 65.4184 126.212C68.6585 115.541 67.2226 108.465 64.8281 106.738C62.4336 105.011 58.0412 105.266 56.5321 108.712C55.023 112.159 58.3 122.361 51.7362 128.725C47.8584 132.485 48.0652 136.511 52.3567 140.804Z'
      fill='url(#paint2_linear)'
    />
    <path
      d='M58.3232 106.572C60.2998 105.275 63.0902 105.485 64.8281 106.738C65.4371 107.177 65.9842 107.963 66.408 109.065C65.1312 109.904 63.0988 110.175 61.272 109.455C59.5979 108.795 58.5975 107.846 58.2708 106.608L58.3232 106.572Z'
      fill='url(#paint3_linear)'
    />
    <path
      opacity={0.1}
      fillRule='evenodd'
      clipRule='evenodd'
      d='M56.2291 140.911L56.1982 140.938C55.5627 141.477 54.9007 141.989 54.2123 142.472L53.8225 142.148C48.2156 137.403 47.4728 132.975 51.5938 128.865L51.7362 128.725C53.9848 126.545 55.0785 123.915 55.6054 121.259C57.0934 129.308 57.3014 135.858 56.2291 140.911Z'
      fill='#262626'
    />
    <path
      d='M51.736 125.693C55.1804 127.928 56.276 133.521 55.0229 142.472C53.1432 155.899 44.7483 129.045 45.1722 129.045C45.4548 129.045 47.6428 127.928 51.736 125.693Z'
      fill='url(#paint4_linear)'
    />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M17.8383 139.165C16.5464 137.342 13.839 137.488 12.781 139.457C10.5477 143.612 9.1744 147.6 8.6611 151.421C7.65375 158.921 10.6132 164.865 13.9532 166.733C17.2933 168.601 21.2492 167.502 21.87 164.348C22.4908 161.194 19.3557 154.026 21.5165 150.087C22.6973 147.934 21.4713 144.293 17.8383 139.165Z'
      fill='url(#paint5_linear)'
    />
    <path
      d='M21.6659 165.052L21.617 165.168C20.5252 167.68 16.986 168.429 13.9543 166.733C13.8631 166.682 13.7723 166.628 13.6818 166.571C13.7573 165.179 14.5723 164.224 16.1262 163.706C18.1991 163.014 20.7084 163.806 21.6659 165.052Z'
      fill='url(#paint6_linear)'
    />
    <path
      d='M16.8632 133.434C14.9047 134.037 13.6916 136.164 13.2237 139.814C12.5218 145.29 17.0509 151.422 22.0369 151.422C25.361 151.422 23.6364 145.426 16.8632 133.434Z'
      fill='url(#paint7_linear)'
    />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M19.8658 132.967C18.1952 133.058 16.8421 134.389 16.8664 136.062C16.9886 144.488 19.8775 152 25.533 158.598C34.9895 169.63 52.5187 165.342 56.0978 159.65C59.6769 153.958 57.9838 145.97 56.0978 141.969C55.1052 139.864 54.2007 137.178 53.384 133.914C52.9914 132.344 51.5602 131.242 49.9448 131.33L19.8658 132.967Z'
      fill='url(#paint8_linear)'
    />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M49.945 131.33C51.5606 131.242 52.9917 132.344 53.3843 133.913C54.1653 137.036 55.0267 139.628 55.9686 141.69L56.0982 141.969C57.9842 145.97 59.6773 153.958 56.0982 159.65C55.4332 160.707 54.0083 160.872 52.9322 160.237C51.4087 159.339 49.8506 158.181 48.2576 156.765C41.8848 151.099 37.8412 144.041 36.1268 135.592C35.7478 133.724 37.1778 132.025 39.081 131.922L49.945 131.33Z'
      fill='url(#paint9_linear)'
    />
    <path
      d='M24.2064 146.228C24.4959 146.062 24.8652 146.162 25.0313 146.451C26.0792 148.278 27.1809 149.772 28.334 150.933C28.5692 151.17 28.5679 151.552 28.3311 151.787C28.0943 152.022 27.7116 152.021 27.4765 151.784C26.2442 150.544 25.0805 148.966 23.9829 147.053C23.8169 146.763 23.9169 146.394 24.2064 146.228Z'
      fill='url(#paint10_linear)'
    />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M48.6139 143.082L49.8204 142.472L51.736 145.937L50.7623 146.554L48.6139 143.082Z'
      fill='url(#paint11_linear)'
    />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M51.4984 143.195L52.795 142.472L51.064 139.489L47.2031 140.855L47.832 142.052L50.3127 141.106L51.4984 143.195Z'
      fill='url(#paint12_linear)'
    />
    <path
      opacity={0.3}
      fillRule='evenodd'
      clipRule='evenodd'
      d='M58.1941 151.422C58.2163 154.254 57.6578 157.17 56.0983 159.65C53.9557 163.057 46.8136 165.962 39.397 165.377C40.632 164.152 41.3978 162.494 41.695 160.404L41.7297 160.141C42.3405 155.11 46.2523 152.239 49.8392 152.239C52.9557 152.239 55.7804 153.503 58.1123 151.494L58.1941 151.422Z'
      fill='url(#paint13_linear)'
    />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M18.5415 132.506C18.1213 132.385 17.7268 132.182 17.3953 131.897C14.0272 128.999 11.9875 125.433 11.2761 121.197C10.1563 114.53 11.7384 105.159 21.5564 98.8226C31.3745 92.486 44.3058 95.6711 50.188 103.234C56.0703 110.797 57.1747 125.262 50.188 130.462C43.2014 135.663 38.0904 136.036 33.7431 135.849C30.926 135.728 25.8588 134.614 18.5415 132.506Z'
      fill='url(#paint14_linear)'
    />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M25.5332 112.135C25.9145 117.807 24.7398 126.487 23.6506 132.913C23.5632 133.429 23.0516 133.755 22.5458 133.621C21.2956 133.287 19.9606 132.915 18.5409 132.506C18.1207 132.385 17.7268 132.182 17.3953 131.897C14.0272 128.999 11.9875 125.433 11.2761 121.198L11.2134 120.802C10.3402 114.959 11.5605 107.184 18.4324 101.169C19.6728 100.083 21.5656 100.288 22.4473 101.681C24.2248 104.489 25.2534 107.973 25.5332 112.135Z'
      fill='url(#paint15_linear)'
    />
    <path
      opacity={0.2}
      d='M45.8398 99.2263L45.7623 99.2419C41.7991 100.121 38.1264 105.394 33.7781 105.694C28.9081 106.03 26.3237 104.882 23.047 102.567C21.3031 101.335 19.3805 101.228 17.2791 102.246C18.4895 101.038 19.9067 99.8873 21.5563 98.8226C29.3894 93.7671 39.2042 94.7724 45.8398 99.2263Z'
      fill='url(#paint16_linear)'
    />
    <path
      d='M33.3912 102.384C33.42 102.716 33.1737 103.009 32.8412 103.038C32.5088 103.067 32.2159 102.82 32.1871 102.488C31.9128 99.3208 31.3234 97.025 30.4496 95.609C30.8881 95.5544 31.3269 95.5132 31.7654 95.4851C32.5975 97.0937 33.1321 99.3913 33.3912 102.384Z'
      fill='url(#paint17_linear)'
    />
    <path
      d='M43.3632 109.456C46.2856 109.456 49.566 112.329 50.9173 116.459C51.958 119.64 52.1044 125.903 50.7863 129.977C50.5942 130.147 50.3949 130.308 50.1885 130.462C43.2018 135.663 38.0908 136.035 33.7435 135.849L33.4177 135.831C30.8468 135.663 26.6074 134.758 20.6997 133.117C18.9169 130.316 17.746 127.052 17.1858 123.327C16.2041 116.798 18.6973 111.144 23.167 110.442C27.6367 109.74 31.2287 113.631 35.1362 113.147C39.0438 112.663 40.4408 109.456 43.3632 109.456Z'
      fill='url(#paint18_linear)'
    />
    <path
      d='M11.3035 113.683C10.8693 113.756 10.2657 114.244 9.49258 115.147C8.33297 116.502 9.4694 120.958 10.1326 122.091C10.7958 123.223 13.5171 122.525 13.8754 121.954C14.2338 121.384 14.1028 116.71 13.8754 115.662C13.7239 114.963 12.8666 114.303 11.3035 113.683Z'
      fill='url(#paint19_linear)'
    />
    <path
      d='M9.26853 115.503C9.37994 115.263 9.64998 115.165 9.9127 115.195C10.8542 115.312 11.5241 115.467 11.9226 115.662C12.6056 115.995 12.5622 118.431 12.5622 120.648C12.5622 120.929 12.5498 121.176 12.5267 121.395C12.436 122.256 11.5927 122.858 10.7743 122.578C10.4978 122.483 10.2706 122.327 10.1326 122.091C9.51933 121.043 8.50141 117.154 9.26853 115.503Z'
      fill='url(#paint20_linear)'
    />
    <path
      d='M14.5032 126.298C14.837 126.298 15.1075 126.027 15.1075 125.693C15.1075 125.36 14.837 125.089 14.5032 125.089C14.1695 125.089 13.8989 125.36 13.8989 125.693C13.8989 126.027 14.1695 126.298 14.5032 126.298Z'
      fill='white'
    />
    <path
      d='M16.3159 128.11C16.6496 128.11 16.9202 127.84 16.9202 127.506C16.9202 127.172 16.6496 126.902 16.3159 126.902C15.9822 126.902 15.7116 127.172 15.7116 127.506C15.7116 127.84 15.9822 128.11 16.3159 128.11Z'
      fill='white'
    />
    <path
      d='M52.2559 128.222C47.4833 131.319 42.1833 133.251 36.3559 134.017C27.6147 135.166 18.5794 130.635 16.9731 130.635C15.3669 130.635 15.0641 133.371 16.9731 135.484C18.8822 137.597 29.589 140.756 39.3272 139.546C49.0653 138.335 53.6434 133.969 54.1292 131.561C54.4531 129.955 53.8287 128.842 52.2559 128.222Z'
      fill='url(#paint21_linear)'
    />
    <path
      d='M36.9847 133.929L37.7643 139.703C37.1028 139.754 36.4392 139.787 35.7765 139.803L35.3247 134.127C35.6686 134.098 36.0125 134.062 36.3559 134.017C36.5662 133.989 36.7758 133.96 36.9847 133.929ZM31.979 134.164C32.5315 134.194 33.0881 134.208 33.6468 134.202L33.7784 139.801C33.1141 139.784 32.4538 139.752 31.8007 139.706L31.979 134.164ZM28.681 133.803C29.224 133.891 29.7756 133.967 30.3338 134.028L29.8548 139.527C29.1926 139.451 28.5416 139.363 27.9052 139.264L28.681 133.803ZM40.2886 133.304L41.7296 139.166C41.0999 139.288 40.4445 139.396 39.7632 139.489L38.6484 133.65C39.2001 133.546 39.7468 133.431 40.2886 133.304ZM25.3902 133.126C25.92 133.257 26.465 133.382 27.0225 133.497L25.9539 138.916C25.2939 138.784 24.6558 138.64 24.0442 138.488L25.3902 133.126ZM43.5528 132.391L45.5962 138.155C44.9953 138.358 44.3609 138.548 43.6923 138.722L41.9356 132.883C42.4799 132.73 43.019 132.567 43.5528 132.391ZM22.1414 132.21C22.6546 132.37 23.1954 132.533 23.7597 132.693L22.1555 137.968C21.4927 137.766 20.8759 137.555 20.3132 137.341L22.1414 132.21ZM46.7523 131.177L49.2349 136.573C48.6923 136.872 48.1028 137.163 47.4653 137.438L45.1723 131.819C45.7043 131.617 46.231 131.403 46.7523 131.177ZM16.934 135.44L18.9005 131.141L20.5265 131.687L18.54 136.564C17.8166 136.192 17.2807 135.824 16.9731 135.484L16.934 135.44ZM49.7852 129.696L52.3688 134.309C51.941 134.726 51.4348 135.149 50.8476 135.566L48.2576 130.484C48.7723 130.234 49.2815 129.971 49.7852 129.696ZM16.9731 130.635C17.0403 130.635 17.1204 130.643 17.2129 130.658L15.8067 133.433C15.3783 131.934 15.8662 130.635 16.9731 130.635ZM52.2559 128.222C53.8287 128.842 54.4531 129.955 54.1292 131.561C54.0587 131.91 53.9021 132.301 53.6561 132.717L51.2871 128.831C51.6124 128.633 51.9354 128.43 52.2559 128.222Z'
      fill='url(#paint22_linear)'
    />
    <path
      d='M35.4963 55.5077L62.2734 107.539L95.0161 64.1142'
      stroke='#031E34'
      strokeWidth={0.548468}
      strokeLinecap='round'
      strokeLinejoin='round'
    />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M91.2514 68.6127C90.9021 68.4005 90.4913 68.3091 90.0865 68.365C87.9691 68.6576 86.4619 69.1125 85.5647 69.7297C84.0899 70.7442 87.5319 70.3517 89.1221 70.7442C90.7123 71.1368 89.4355 72.4573 90.0739 75.3757C90.4689 77.1811 91.1438 75.5574 92.0987 70.5048C92.2395 69.7601 91.8992 69.0061 91.2514 68.6127Z'
      fill='url(#paint23_linear)'
    />
    <path
      d='M35.2094 56.8595C35.4642 59.9075 35.9118 61.7952 36.5522 62.5226C37.5128 63.6137 38.0118 59.1189 38.0118 59.1189C38.0118 59.1189 41.3886 60.0565 42.1468 59.1189C42.6522 58.4939 40.9429 57.4589 37.0189 56.0141L35.2094 56.8595Z'
      fill='url(#paint24_linear)'
    />
    <path
      d='M81.0812 47.0853L62.2739 107.539L59.3104 39.5832'
      stroke='#031E34'
      strokeWidth={0.548468}
      strokeLinecap='round'
      strokeLinejoin='round'
    />
    <path
      d='M59.2202 45.3539C58.6604 45.4172 58.1298 45.6564 57.7478 46.0704C56.6226 47.2897 56.0601 48.3986 56.0601 49.3972C56.0601 49.8925 56.222 50.1131 56.5459 50.0589C58.1499 49.7907 59.7031 49.2555 61.3186 49.4418C61.6699 49.4823 62.0078 49.4674 62.3321 49.3972C63.2317 49.2023 62.9317 48.1515 61.432 46.2448C60.9078 45.5783 60.0627 45.2585 59.2202 45.3539Z'
      fill='url(#paint25_linear)'
    />
    <path
      fillRule='evenodd'
      clipRule='evenodd'
      d='M91.01 69.3853C89.3595 67.8397 85.593 59.8248 88.9656 47.8716C92.3382 35.9184 103.044 25.7644 113.682 26.2325C124.319 26.7005 129.716 34.8386 128.451 45.8403C127.186 56.842 115.098 66.0142 107.289 68.4382C99.4792 70.8623 92.6605 70.931 91.01 69.3853Z'
      fill='url(#paint26_linear)'
    />
    <path
      d='M116.828 53.9149C116.733 53.6496 116.63 53.3884 116.53 53.1239C116.448 52.9053 116.537 52.755 116.769 52.7311C117.023 52.7075 117.276 52.6838 117.529 52.6602C117.943 52.6218 118.053 52.4177 117.836 52.0687C117.699 51.8451 117.56 51.6308 117.423 51.4073C117.312 51.2255 117.377 51.0512 117.58 50.9889C117.859 50.9046 118.136 50.8297 118.408 50.7403C118.686 50.6502 118.752 50.4184 118.559 50.2051C118.362 49.9832 118.157 49.7714 117.957 49.5529C117.819 49.3988 117.849 49.2291 118.026 49.1308C118.274 48.9962 118.523 48.8676 118.771 48.7331C119.067 48.5713 119.077 48.3226 118.804 48.1226C118.575 47.9562 118.346 47.7957 118.117 47.6292C117.964 47.5163 117.961 47.3326 118.106 47.2144C118.335 47.028 118.565 46.8416 118.791 46.6526C119.006 46.471 118.979 46.2151 118.722 46.0974C118.456 45.9719 118.184 45.8532 117.918 45.7277C117.732 45.6431 117.692 45.4733 117.822 45.3118C118.002 45.0925 118.183 44.8792 118.363 44.6599C118.569 44.4072 118.493 44.1726 118.179 44.0956C117.905 44.0284 117.632 43.9671 117.358 43.8999C117.146 43.8488 117.075 43.6922 117.176 43.4981C117.304 43.2493 117.445 43.005 117.572 42.7504C117.722 42.4596 117.602 42.2549 117.271 42.2403C116.992 42.228 116.708 42.2224 116.429 42.2102C116.229 42.1998 116.122 42.0478 116.179 41.8565C116.259 41.5868 116.348 41.3189 116.425 41.0526C116.52 40.7357 116.364 40.5508 116.042 40.6014C115.764 40.6433 115.484 40.6945 115.209 40.739C114.996 40.7725 114.868 40.6472 114.888 40.4275C114.916 40.1495 114.952 39.8673 114.977 39.5867C115.003 39.2757 114.809 39.1258 114.515 39.2301C114.255 39.3239 114.003 39.4229 113.744 39.5226C113.511 39.6099 113.363 39.5174 113.341 39.2759C113.316 39.0048 113.292 38.7303 113.263 38.4566C113.231 38.1321 113.012 38.0276 112.73 38.1997C112.489 38.3454 112.255 38.4962 112.014 38.6419C111.844 38.7453 111.664 38.6811 111.606 38.4925C111.52 38.2171 111.445 37.9402 111.358 37.6649C111.267 37.3751 111.035 37.3085 110.81 37.5034C110.593 37.6943 110.386 37.8928 110.17 38.0896C110.008 38.2372 109.836 38.2111 109.733 38.0193C109.599 37.7713 109.47 37.5224 109.336 37.2744C109.182 36.9897 108.932 36.9736 108.737 37.24C108.571 37.4696 108.414 37.701 108.244 37.928C108.12 38.0947 107.943 38.0965 107.814 37.9382C107.632 37.7174 107.449 37.4907 107.267 37.2699C107.07 37.0329 106.819 37.0683 106.692 37.3501C106.571 37.6099 106.452 37.8757 106.331 38.1355C106.248 38.3121 106.079 38.3521 105.931 38.2325C105.709 38.056 105.498 37.872 105.279 37.6922C105.019 37.4754 104.779 37.5517 104.7 37.8815C104.634 38.1403 104.577 38.401 104.517 38.6592C104.458 38.908 104.317 38.9805 104.094 38.8675C103.845 38.7397 103.601 38.5993 103.349 38.469C103.069 38.3272 102.865 38.4531 102.851 38.7685C102.838 39.0416 102.834 39.3166 102.824 39.5923C102.816 39.8317 102.671 39.9287 102.436 39.8595C102.172 39.7789 101.915 39.6975 101.648 39.6203C101.348 39.5324 101.163 39.6949 101.209 40.0027C101.251 40.2808 101.302 40.5608 101.343 40.8389C101.378 41.0577 101.258 41.1847 101.039 41.1647C100.751 41.1354 100.463 41.1002 100.177 41.0769C99.8751 41.0524 99.7311 41.246 99.8311 41.5316C99.9262 41.8029 100.033 42.0725 100.134 42.343C100.204 42.536 100.112 42.6896 99.9099 42.7097C99.6362 42.739 99.3618 42.7624 99.0907 42.7883C98.7365 42.8249 98.6252 43.0383 98.8079 43.3345C98.9493 43.5665 99.0966 43.7979 99.2413 44.0325C99.3514 44.2083 99.2845 44.3919 99.0839 44.4509C98.8052 44.5351 98.5284 44.6101 98.253 44.6969C97.9777 44.7837 97.9083 45.0188 98.1016 45.2321C98.2989 45.454 98.5041 45.6658 98.7014 45.8876C98.8388 46.0418 98.8093 46.2115 98.6319 46.3098C98.3838 46.4443 98.135 46.5729 97.8869 46.7075C97.591 46.8693 97.5773 47.1154 97.8503 47.3154C98.0831 47.4844 98.3244 47.6493 98.5546 47.8217C98.6877 47.9191 98.6876 48.1061 98.5592 48.2101C98.3332 48.3991 98.1038 48.5856 97.8744 48.772C97.6373 48.9684 97.6633 49.2184 97.9423 49.3483C98.2021 49.4686 98.4677 49.5881 98.7274 49.7085C98.9132 49.7931 98.9564 49.9654 98.823 50.1244C98.6431 50.3436 98.459 50.5544 98.2824 50.7762C98.0741 51.0323 98.152 51.2635 98.4698 51.3432C98.7472 51.4129 99.0297 51.476 99.3096 51.5424C99.4968 51.5907 99.5655 51.7507 99.4786 51.9187C99.3403 52.1809 99.1954 52.4378 99.0638 52.7051C98.9297 52.9758 99.052 53.1771 99.3555 53.1923C99.6379 53.2071 99.9187 53.2101 100.2 53.219C100.428 53.2288 100.531 53.3783 100.463 53.5983C100.387 53.8494 100.306 54.092 100.23 54.3431C100.117 54.7105 100.273 54.8895 100.645 54.8294C100.914 54.7857 101.185 54.7386 101.458 54.6974C101.644 54.6704 101.775 54.7982 101.757 54.9875C101.728 55.2748 101.695 55.5595 101.669 55.8494C101.64 56.1638 101.837 56.3163 102.131 56.206C102.382 56.1164 102.632 56.0208 102.882 55.9252C103.152 55.8239 103.283 55.9035 103.309 56.2017C103.334 56.4669 103.357 56.7355 103.385 57.0033C103.417 57.3007 103.642 57.4045 103.899 57.2506C104.146 57.1042 104.391 56.9459 104.634 56.7969C104.805 56.6934 104.982 56.761 105.04 56.9496C105.126 57.225 105.201 57.5018 105.288 57.7772C105.379 58.067 105.611 58.1336 105.833 57.9361C106.039 57.7527 106.234 57.5616 106.437 57.3756C106.639 57.1897 106.805 57.2165 106.929 57.4568C107.053 57.6912 107.174 57.9289 107.304 58.1625C107.461 58.4498 107.707 58.4633 107.899 58.2003C108.066 57.9707 108.227 57.7419 108.393 57.5123C108.517 57.3456 108.688 57.3445 108.821 57.5054C109.003 57.7262 109.186 57.9529 109.368 58.1737C109.557 58.3997 109.806 58.3734 109.932 58.1069C110.055 57.8437 110.176 57.5839 110.293 57.3215C110.385 57.1256 110.549 57.0864 110.723 57.2207C110.834 57.306 110.947 57.3939 111.058 57.4791C111.055 57.4825 111.055 57.4825 111.053 57.4858C111.158 57.5778 111.267 57.6724 111.374 57.761C111.617 57.9589 111.852 57.8834 111.93 57.5807C111.996 57.3159 112.058 57.0485 112.12 56.7811C112.179 56.5323 112.324 56.4623 112.546 56.5754C112.791 56.7005 113.026 56.8391 113.272 56.9643C113.575 57.1182 113.776 56.9957 113.79 56.6532C113.8 56.3834 113.808 56.117 113.816 55.8505C113.824 55.6053 113.966 55.5116 114.204 55.5834C114.468 55.6639 114.725 55.7453 114.992 55.8225C115.296 55.913 115.477 55.7538 115.435 55.4427C115.398 55.185 115.35 54.9288 115.308 54.6718C115.256 54.3589 115.354 54.2527 115.66 54.2857C115.926 54.3147 116.192 54.3437 116.457 54.3668C116.778 54.3948 116.928 54.2005 116.828 53.9149ZM113.692 40.7387C113.97 40.9531 114.017 41.3422 113.805 41.6228C113.588 41.9041 113.224 41.9542 112.948 41.7363C112.671 41.5219 112.62 41.1302 112.835 40.8522C113.049 40.5683 113.411 40.5216 113.692 40.7387ZM103.282 40.7908C103.492 40.5195 103.895 40.4674 104.172 40.6701C104.455 40.8778 104.507 41.2872 104.29 41.5686C104.075 41.8466 103.693 41.899 103.413 41.6878C103.122 41.4689 103.064 41.0662 103.282 40.7908ZM101.24 44.8695C101.146 44.7971 101.123 44.7368 101.173 44.6308C101.547 43.7863 102.027 43.0186 102.658 42.3401C102.732 42.2582 102.797 42.2709 102.88 42.2873C103.288 42.3885 103.697 42.4896 104.107 42.5875C104.543 42.6941 104.808 42.5302 104.918 42.0908C104.966 41.9036 105.011 41.7138 105.063 41.5081C105.321 41.707 105.557 41.8998 105.802 42.0732C105.931 42.1621 105.912 42.2219 105.827 42.3325C104.962 43.4453 104.101 44.5607 103.24 45.6761C103.124 45.8268 103.021 46.0572 102.877 46.0908C102.727 46.1192 102.575 45.9006 102.425 45.7843C102.03 45.4793 101.64 45.1677 101.24 44.8695ZM100.211 50.5063C99.9272 50.2926 99.8788 49.8917 100.099 49.607C100.311 49.3382 100.711 49.2836 100.983 49.4929C101.263 49.704 101.313 50.1168 101.092 50.3956C100.877 50.6677 100.485 50.7182 100.211 50.5063ZM107.631 56.2715C107.356 56.0597 107.305 55.6621 107.511 55.3882C107.723 55.1076 108.138 55.054 108.413 55.2719C108.685 55.4871 108.735 55.8787 108.523 56.1534C108.307 56.4407 107.915 56.4912 107.631 56.2715ZM109.554 55.3991C109.463 55.4139 109.42 55.3863 109.36 55.3186C109.116 55.0183 108.859 54.7288 108.613 54.4318C108.335 54.0997 108.014 54.0657 107.679 54.3472C107.355 54.6152 107.031 54.8892 106.714 55.1684C106.616 55.2533 106.535 55.2759 106.413 55.2404C104.249 54.6449 102.617 53.3686 101.51 51.4184C101.452 51.3143 101.453 51.2297 101.503 51.1238C101.692 50.7405 101.874 50.3521 102.062 49.9628C102.245 49.5803 102.14 49.2802 101.755 49.0947C101.414 48.9276 101.073 48.7605 100.73 48.6027C100.662 48.5721 100.605 48.5494 100.6 48.4596C100.573 48.1554 100.554 47.8472 100.563 47.4961C100.651 47.5633 100.707 47.6073 100.768 47.6538C102.351 48.876 103.937 50.095 105.515 51.3239C105.659 51.435 105.737 51.4522 105.86 51.2855C106.247 50.756 106.655 50.2419 107.062 49.7279C107.161 49.6007 107.17 49.5331 107.03 49.4305C106.597 49.1124 106.183 48.7767 105.753 48.4552C105.653 48.3777 105.616 48.3281 105.71 48.2135C105.947 47.9265 106.174 47.6258 106.395 47.3259C106.464 47.2295 106.514 47.22 106.609 47.2983C107.108 47.6893 107.615 48.0702 108.112 48.4645C108.569 48.8278 108.694 49.4269 108.432 50.0157C108.224 50.4858 107.997 50.9465 107.775 51.4063C107.633 51.7081 107.586 52.0248 107.598 52.3491C107.612 52.7393 107.74 53.0576 108.079 53.3033C108.895 53.9008 109.688 54.5344 110.518 55.1753C110.176 55.2857 109.867 55.3466 109.554 55.3991ZM108.591 44.4881C108.663 44.3883 108.714 44.3848 108.805 44.4605C109.448 44.9626 110.103 45.4572 110.744 45.9626C110.962 46.1365 111.11 46.3738 111.17 46.6496C111.271 47.113 110.94 47.4664 110.471 47.3881C110.215 47.3457 109.99 47.236 109.786 47.0784C109.482 46.8492 109.184 46.6133 108.882 46.3807C108.558 46.13 108.239 45.8786 107.909 45.6347C107.803 45.5579 107.797 45.5104 107.879 45.4032C108.125 45.1062 108.363 44.798 108.591 44.4881ZM114.308 52.7712C114.232 52.8624 114.175 52.8879 114.069 52.7959C113.923 52.667 113.758 52.5556 113.603 52.4308C113.512 52.3551 113.442 52.3702 113.372 52.4606C113.243 52.6281 113.12 52.8008 112.964 52.9476C112.695 53.1994 112.389 53.3053 112.037 53.1727C111.654 53.0321 111.372 52.782 111.276 52.3661C111.256 52.2812 111.263 52.1959 111.308 52.1178C111.746 51.3554 111.885 50.5534 111.613 49.7019C111.612 49.6959 111.617 49.6892 111.621 49.6766C111.944 49.6954 112.266 49.7141 112.587 49.6787C113.277 49.6077 113.891 49.3868 114.302 48.7789C114.664 48.2406 114.754 47.6469 114.64 47.0192C114.485 46.1675 114.07 45.4672 113.383 44.9374C111.317 43.3371 109.246 41.7435 107.177 40.1465C107.117 40.1 107.057 40.0535 106.957 39.976C108.213 39.7536 109.406 39.8198 110.587 40.1591C110.997 40.2781 111.395 40.4409 111.786 40.6197C111.888 40.6667 111.932 40.7274 111.941 40.8409C111.974 41.2408 112.019 41.6391 112.064 42.0374C112.108 42.4509 112.357 42.6481 112.768 42.6071C113.196 42.5639 113.625 42.5207 114.05 42.4689C114.168 42.4536 114.245 42.4859 114.32 42.5758C115.751 44.3062 116.361 46.2844 116.147 48.5197C116.134 48.6752 116.077 48.77 115.935 48.8426C115.466 49.0841 115.007 49.3393 114.545 49.592C114.184 49.7893 114.091 50.0969 114.285 50.4609C114.497 50.8648 114.717 51.2647 114.935 51.6679C114.974 51.7353 115.014 51.7874 114.956 51.8763C114.755 52.1918 114.546 52.4902 114.308 52.7712ZM115.373 50.9478C115.099 50.7359 115.045 50.3146 115.263 50.0452C115.479 49.7731 115.871 49.7285 116.148 49.937C116.433 50.1567 116.483 50.5483 116.257 50.8338C116.039 51.1092 115.648 51.1597 115.373 50.9478Z'
      fill='white'
    />
    <path
      d='M36.8604 57.9847C33.8819 60.5222 22.053 64.0972 10.0943 54.6493C-1.86439 45.2014 -3.0089 29.276 5.65978 22.2867C14.3285 15.2975 28.3626 17.8735 36.2052 26.6017C44.0478 35.3299 43.2762 45.2014 42.2968 49.1672C41.3175 53.1329 39.839 55.4471 36.8604 57.9847Z'
      fill='url(#paint27_linear)'
    />
    <path
      d='M17.858 46.1622C18.333 46.579 18.5623 45.9137 18.6155 45.5797C18.6687 45.2458 18.8259 45.3186 18.587 45.0322C18.4302 44.8465 18.2622 44.6704 18.0842 44.5049C17.7609 44.7777 17.5448 45.1565 17.4746 45.5737C17.4452 45.7867 17.5085 46.2982 17.8437 46.153'
      fill='#F6D2A2'
    />
    <path
      d='M18.4145 46.2446C18.3718 46.2901 18.319 46.325 18.2604 46.3465C18.1891 46.3669 18.1136 46.3679 18.0418 46.3492C17.97 46.3305 17.9046 46.2928 17.8523 46.2402C17.8088 46.2556 17.7621 46.2598 17.7165 46.2523C17.671 46.2449 17.6281 46.226 17.5918 46.1975C17.5201 46.1117 17.4681 46.0113 17.4393 45.9033C17.4105 45.7952 17.4056 45.6822 17.4249 45.5721C17.4968 45.1406 17.7203 44.749 18.0552 44.4675L18.09 44.4315L18.126 44.4663C18.2679 44.5936 18.4013 44.7302 18.5253 44.875L18.6454 44.9911C18.8212 45.184 18.8152 45.2479 18.7464 45.3672C18.7128 45.4338 18.6894 45.5051 18.6769 45.5786C18.6502 45.82 18.5596 46.0499 18.4145 46.2446ZM18.0116 44.6762C17.7641 44.9247 17.6011 45.2449 17.5457 45.5913C17.531 45.6809 17.5346 45.7726 17.5564 45.8607C17.5783 45.9489 17.6179 46.0317 17.6728 46.104C17.6981 46.1227 17.7282 46.1339 17.7595 46.1363C17.7909 46.1387 17.8223 46.1321 17.8502 46.1174L17.8734 46.0934L17.8998 46.1189C17.9382 46.1627 17.9873 46.1956 18.0423 46.2146C18.0973 46.2335 18.1563 46.2377 18.2135 46.2268C18.3155 46.1494 18.3992 46.0506 18.4589 45.9374C18.5185 45.8241 18.5526 45.6991 18.5587 45.5712C18.5719 45.4872 18.5976 45.4055 18.6348 45.329C18.6735 45.2457 18.6826 45.2266 18.5429 45.0731L18.4228 44.9571C18.3139 44.8302 18.1982 44.7092 18.0763 44.5947L18.0044 44.6692L18.0116 44.6762Z'
      fill='#010101'
    />
    <path
      d='M17.858 46.1621C17.9092 46.0788 17.9346 45.9822 17.9311 45.8845L17.858 46.1621Z'
      fill='#C7B199'
    />
    <path
      d='M17.9012 46.2039C17.894 46.2185 17.8812 46.2295 17.8658 46.2347C17.8504 46.2398 17.8336 46.2386 17.8191 46.2314C17.8045 46.2241 17.7935 46.2114 17.7883 46.1959C17.7832 46.1805 17.7844 46.1637 17.7916 46.1492L17.8195 46.1203C17.8567 46.0582 17.8744 45.9863 17.8702 45.914C17.869 45.9061 17.8693 45.898 17.8712 45.8903C17.8731 45.8825 17.8765 45.8752 17.8812 45.8688C17.8859 45.8623 17.8919 45.8569 17.8987 45.8527C17.9055 45.8486 17.9131 45.8458 17.921 45.8446C17.9288 45.8434 17.9369 45.8437 17.9447 45.8456C17.9524 45.8475 17.9597 45.8509 17.9662 45.8556C17.9726 45.8603 17.9781 45.8662 17.9822 45.8731C17.9864 45.8799 17.9891 45.8874 17.9903 45.8953C17.9987 45.9911 17.9773 46.0872 17.929 46.1704L17.8988 46.2016L17.9012 46.2039Z'
      fill='#010101'
    />
    <path
      d='M13.4665 39.8969C11.3086 41.1699 10.3393 37.736 12.6046 37.2075L13.4665 39.8969Z'
      fill='#74CDDD'
    />
    <path
      d='M13.5378 39.924L13.5053 39.9577C12.888 40.318 12.3003 40.3401 11.853 40.0196C11.6203 39.8344 11.4439 39.5881 11.3435 39.3082C11.243 39.0283 11.2226 38.726 11.2844 38.4352C11.3501 38.1177 11.5096 37.8273 11.7424 37.6017C11.9752 37.3761 12.2704 37.2257 12.5898 37.17L12.6439 37.1572L13.5378 39.924ZM11.7565 37.7396C11.5664 37.937 11.4378 38.1854 11.3863 38.4546C11.3284 38.7231 11.3465 39.0025 11.4387 39.2613C11.5308 39.52 11.6933 39.748 11.9079 39.9194C12.3073 40.203 12.8314 40.1891 13.3881 39.877L12.5472 37.3006C12.2534 37.3738 11.9849 37.5254 11.7707 37.7393L11.7565 37.7396Z'
      fill='#010101'
    />
    <path
      d='M18.9627 30.2917C19.3288 27.9895 22.6905 28.8354 21.7074 30.9736L18.9627 30.2917Z'
      fill='#74CDDD'
    />
    <path
      d='M21.7417 31.0439L18.8951 30.3378L18.9036 30.2857C18.9325 29.9736 19.0537 29.6772 19.2518 29.4343C19.45 29.1915 19.716 29.0132 20.0159 28.9223C20.3042 28.8415 20.6092 28.8423 20.897 28.9244C21.1849 29.0065 21.4444 29.1668 21.6467 29.3875C21.8637 29.6435 22.1493 30.1699 21.7622 30.9987L21.7417 31.0439ZM19.0304 30.2456L21.6732 30.9034C21.7967 30.6789 21.8515 30.423 21.8307 30.1676C21.8098 29.9121 21.7143 29.6685 21.556 29.467C21.3691 29.2622 21.1289 29.1133 20.8623 29.0371C20.5957 28.9608 20.3132 28.9601 20.0462 29.0351C19.776 29.1135 19.5352 29.2704 19.3543 29.486C19.1734 29.7015 19.0607 29.9659 19.0304 30.2456Z'
      fill='#010101'
    />
    <path
      d='M32.1903 42.4942C32.7429 42.3547 34.0135 42.3467 33.8249 43.1766C33.8013 44.1242 32.5593 43.4727 32.0003 43.7872C31.9451 43.5698 31.9335 43.3436 31.9661 43.1217C31.9987 42.8998 32.0749 42.6865 32.1903 42.4942Z'
      fill='#F6D2A2'
    />
    <path
      d='M33.733 43.6034L33.7145 43.6226C33.5099 43.8104 33.1575 43.7859 32.8194 43.7658C32.5542 43.7214 32.282 43.7465 32.0294 43.8386L31.9569 43.88L31.9317 43.786C31.8192 43.332 31.8906 42.852 32.1304 42.4504L32.1605 42.4191C32.5156 42.3303 33.3647 42.2588 33.7276 42.6138C33.7984 42.6849 33.8487 42.7737 33.8733 42.871C33.8978 42.9682 33.8957 43.0703 33.8671 43.1664C33.8813 43.324 33.8332 43.4809 33.733 43.6034ZM32.0435 43.699C32.2967 43.6286 32.5618 43.6111 32.8221 43.6476C33.096 43.7092 33.383 43.6698 33.6303 43.5367C33.6723 43.4893 33.7045 43.434 33.7249 43.374C33.7454 43.314 33.7537 43.2506 33.7494 43.1874C33.7744 43.1103 33.7776 43.0277 33.7587 42.9489C33.7398 42.8701 33.6996 42.7979 33.6424 42.7405C33.3493 42.4574 32.6244 42.4725 32.2104 42.5694C32.0163 42.9113 31.9576 43.3135 32.0458 43.6966L32.0435 43.699Z'
      fill='#010101'
    />
    <path
      d='M33.8705 43.2207C33.8627 43.2286 33.8528 43.2343 33.842 43.237C33.8313 43.2397 33.8199 43.2393 33.8093 43.2359C33.7316 43.21 33.6554 43.1798 33.581 43.1454C33.444 43.0697 33.2912 43.027 33.1348 43.021C33.1269 43.0212 33.119 43.02 33.1116 43.0172C33.1041 43.0145 33.0973 43.0103 33.0915 43.0049C33.0858 42.9995 33.0811 42.993 33.0778 42.9859C33.0745 42.9787 33.0726 42.9709 33.0723 42.963C33.072 42.9551 33.0733 42.9472 33.0761 42.9398C33.0788 42.9324 33.083 42.9256 33.0884 42.9198C33.0938 42.914 33.1002 42.9093 33.1074 42.906C33.1146 42.9027 33.1224 42.9009 33.1303 42.9006C33.301 42.9051 33.4683 42.949 33.6191 43.029C33.6897 43.0608 33.7619 43.0887 33.8355 43.1126C33.8506 43.1175 33.8631 43.1281 33.8704 43.1421C33.8778 43.1561 33.8793 43.1724 33.8746 43.1875L33.8705 43.2207Z'
      fill='#010101'
    />
    <path
      d='M26.9027 49.4457C26.5685 49.9168 26.7157 50.5047 26.5737 51.0269C26.5722 51.0946 26.5541 51.1609 26.521 51.22C26.4879 51.279 26.4408 51.3291 26.3838 51.3658C26.3269 51.4024 26.2618 51.4246 26.1943 51.4302C26.1269 51.4359 26.059 51.425 25.9968 51.3983C25.9743 51.4227 25.9465 51.4416 25.9156 51.4536C25.8847 51.4656 25.8515 51.4704 25.8185 51.4676C25.0503 51.3015 25.3033 50.3712 25.3764 49.8243C25.7238 49.2915 26.3726 49.3841 26.9027 49.4457Z'
      fill='#F6D2A2'
    />
    <path
      d='M26.4802 51.3544C26.4589 51.3832 26.4339 51.4091 26.4059 51.4313C26.3478 51.4623 26.2841 51.4814 26.2184 51.4874C26.1528 51.4934 26.0867 51.4862 26.0239 51.4663C26.0013 51.4894 25.9735 51.5066 25.9429 51.5166C25.9122 51.5266 25.8796 51.529 25.8478 51.5237C25.1153 51.3735 25.245 50.5517 25.33 50.0069L25.3573 49.8151C25.7045 49.2729 26.3577 49.3465 26.8832 49.4082L27.0323 49.4269L26.9627 49.499C26.7942 49.7843 26.7114 50.1121 26.7241 50.4432C26.7189 50.6521 26.6925 50.8599 26.6451 51.0634C26.6157 51.1728 26.559 51.273 26.4802 51.3544ZM25.9231 51.3736C25.9355 51.3535 25.9521 51.3363 25.9718 51.3232L25.9834 51.3111L26.0404 51.329C26.0895 51.3462 26.1415 51.3534 26.1934 51.35C26.2453 51.3467 26.2959 51.3329 26.3424 51.3096C26.4367 51.2373 26.4993 51.1312 26.5167 51.0137C26.5626 50.8172 26.5884 50.6165 26.5937 50.4148C26.5882 50.0961 26.6588 49.7806 26.7996 49.4947C26.2979 49.4373 25.735 49.3952 25.4428 49.842L25.4153 50.0243C25.3354 50.5879 25.2222 51.2725 25.8338 51.4035C25.848 51.4069 25.8628 51.4071 25.8771 51.404C25.8913 51.4008 25.9047 51.3945 25.9162 51.3855L25.9231 51.3736Z'
      fill='#010101'
    />
    <path
      d='M26.0493 51.4352C26.0428 51.4427 26.0346 51.4485 26.0253 51.4521C26.0161 51.4557 26.0061 51.4569 25.9962 51.4557C25.9864 51.4544 25.977 51.4508 25.9689 51.445C25.9608 51.4393 25.9543 51.4316 25.9499 51.4228C25.8515 51.2936 25.7894 51.1406 25.7697 50.9795C25.7556 50.8987 25.7344 50.8192 25.7065 50.742C25.7006 50.7271 25.7009 50.7104 25.7073 50.6957C25.7136 50.681 25.7256 50.6694 25.7406 50.6635C25.7555 50.6576 25.7722 50.6579 25.7869 50.6643C25.8016 50.6706 25.8132 50.6826 25.8191 50.6976C25.8502 50.7815 25.8738 50.868 25.8897 50.9561C25.9101 51.0984 25.9679 51.2327 26.0571 51.3453C26.063 51.3515 26.0675 51.3588 26.0704 51.3669C26.0732 51.375 26.0743 51.3835 26.0735 51.392C26.0728 51.4005 26.0702 51.4088 26.066 51.4162C26.0619 51.4237 26.0561 51.4301 26.0493 51.4352ZM12.9258 39.2356C12.5737 39.3598 12.2571 39.3559 12.1274 38.9613C11.9977 38.5668 12.266 38.3802 12.6089 38.2656L12.9258 39.2356ZM20.7109 30.7123C20.8228 30.3561 20.8078 30.0398 20.409 29.924C20.0101 29.8081 19.833 30.0828 19.7304 30.4295L20.7109 30.7123Z'
      fill='#010101'
    />
    <path
      d='M28.4215 35.108C28.8547 35.5681 28.1977 35.8205 27.8658 35.8853C27.5339 35.9502 27.6122 36.1047 27.3177 35.876C27.1266 35.7257 26.9447 35.564 26.7731 35.3919C27.0345 35.0592 27.4054 34.8301 27.8199 34.7453C28.0319 34.7085 28.5452 34.7539 28.4118 35.094'
      fill='#F6D2A2'
    />
    <path
      d='M28.5136 35.652C28.3362 35.7998 28.1243 35.9002 27.8975 35.9438C27.8244 35.9588 27.754 35.9847 27.6887 36.0207C27.5622 36.0843 27.4986 36.0925 27.3092 35.9328L27.1891 35.8168C27.04 35.698 26.8989 35.5695 26.7667 35.4321L26.709 35.3764L26.7438 35.3404C27.0133 34.9959 27.397 34.7588 27.8257 34.672C27.9351 34.6488 28.0482 34.6497 28.1571 34.6747C28.2661 34.6997 28.3683 34.7482 28.4565 34.8168C28.4863 34.8521 28.5066 34.8944 28.5157 34.9396C28.5247 34.9849 28.5222 35.0317 28.5083 35.0757C28.5627 35.1262 28.6026 35.1903 28.6238 35.2614C28.645 35.3324 28.6467 35.4079 28.6287 35.4799C28.606 35.5463 28.5663 35.6056 28.5136 35.652ZM26.8487 35.3952C26.9674 35.513 27.0924 35.6244 27.223 35.7288L27.3431 35.8448C27.4896 35.9864 27.5153 35.9694 27.602 35.9277C27.6772 35.8879 27.7579 35.8594 27.8414 35.8432C27.9691 35.8329 28.0929 35.7946 28.204 35.731C28.3152 35.6674 28.411 35.5801 28.4846 35.4753C28.4935 35.4178 28.4872 35.359 28.4663 35.3047C28.4455 35.2504 28.4108 35.2024 28.3658 35.1656L28.337 35.1378L28.3602 35.1138C28.3739 35.0854 28.3793 35.0538 28.3758 35.0225C28.3724 34.9913 28.3601 34.9616 28.3405 34.937C28.2663 34.8846 28.1822 34.8479 28.0934 34.8292C28.0045 34.8104 27.9128 34.81 27.8237 34.8279C27.4437 34.9008 27.0998 35.1009 26.8487 35.3952Z'
      fill='#010101'
    />
    <path
      d='M28.4214 35.108C28.3427 35.1631 28.2497 35.1943 28.1537 35.1977L28.4214 35.108Z'
      fill='#C7B199'
    />
    <path
      d='M28.4647 35.1497L28.4206 35.1954C28.3342 35.242 28.2354 35.2602 28.1381 35.2475C28.1301 35.2466 28.1225 35.2441 28.1155 35.2402C28.1086 35.2363 28.1024 35.231 28.0975 35.2248C28.0926 35.2185 28.0889 35.2113 28.0868 35.2036C28.0846 35.1959 28.084 35.1879 28.0849 35.18C28.0859 35.1721 28.0884 35.1644 28.0923 35.1574C28.0962 35.1505 28.1014 35.1443 28.1077 35.1394C28.114 35.1345 28.1212 35.1308 28.1288 35.1287C28.1365 35.1265 28.1446 35.1259 28.1525 35.1268C28.2249 35.1285 28.2962 35.1083 28.357 35.0689L28.3848 35.0401C28.3993 35.0295 28.4175 35.0251 28.4353 35.0279C28.453 35.0307 28.469 35.0405 28.4795 35.055C28.4901 35.0695 28.4945 35.0877 28.4917 35.1054C28.4889 35.1232 28.4792 35.1391 28.4647 35.1497Z'
      fill='#010101'
    />
    <path
      d='M14.7251 32.8434C16.4048 31.104 18.2134 29.7119 20.721 30.4807C23.328 31.5264 25.077 33.7586 27.1772 35.5407C28.9732 37.08 31.1495 38.7545 31.9645 41.0644C32.8216 43.4847 31.2233 45.9619 29.5208 47.6143C28.1782 48.9085 26.182 50.1102 24.2212 49.6791C21.9213 49.176 20.1939 46.6953 18.6589 45.0877C16.84 43.1826 14.3689 41.9384 13.1151 39.5251C11.8172 37.0228 13.0621 34.8635 14.7227 32.8458'
      fill='#74CDDD'
    />
    <path
      d='M29.8614 47.3722L29.5738 47.6701C28.8621 48.3668 28.0375 48.9378 27.135 49.359C26.2305 49.8016 25.2068 49.9388 24.2177 49.75C22.3589 49.3478 20.8793 47.6683 19.5686 46.189C19.2408 45.8168 18.9276 45.4632 18.6221 45.145C17.9622 44.4831 17.2619 43.8627 16.5253 43.2873C15.2266 42.2282 13.8825 41.1344 13.0686 39.5685C12.7715 39.0299 12.5896 38.4354 12.5346 37.8228C12.4796 37.2101 12.5526 36.5927 12.749 36.0098C13.0583 35.0549 13.6413 34.0858 14.6753 32.8324C16.3198 31.1055 18.1933 29.6461 20.7365 30.4213C22.6442 31.1864 24.1214 32.599 25.553 33.9629C26.0863 34.4779 26.6365 35.0092 27.2118 35.4905C27.3751 35.6482 27.5595 35.7891 27.7368 35.9372C29.3935 37.342 31.2755 38.9365 32.0136 41.0376C32.9382 43.6669 31.0168 46.1758 29.8614 47.3722ZM14.7683 32.8851C13.1751 34.8427 11.8614 36.9819 13.1689 39.4982C13.9706 41.0431 15.3052 42.1276 16.5847 43.1729C17.3247 43.7511 18.0282 44.3746 18.6911 45.0399C18.999 45.3604 19.31 45.7164 19.6424 46.0885C20.9387 47.5539 22.4063 49.2218 24.2224 49.6153C24.9883 49.7838 27.029 49.9159 29.4608 47.5563C30.5177 46.5388 32.8591 43.8738 31.8796 41.0707C31.149 39.0001 29.2838 37.4171 27.6367 36.0216C27.4686 35.8592 27.2819 35.7207 27.1117 35.5749C26.5624 35.0956 25.9982 34.574 25.4649 34.0589C24.0522 32.6947 22.568 31.2893 20.689 30.5426C19.6144 30.1918 18.4449 30.2784 17.4337 30.7837C16.4318 31.3269 15.5303 32.0377 14.7683 32.8851Z'
      fill='#010101'
    />
    <path
      d='M17.3525 34.791C19.468 36.2303 21.8528 32.804 19.6115 31.4613C17.6017 30.2587 15.571 33.2703 17.3525 34.791Z'
      fill='white'
    />
    <path
      d='M19.8988 34.5245C19.7212 34.71 19.514 34.8644 19.2856 34.9817C18.9772 35.1435 18.6298 35.2159 18.2825 35.1906C17.9352 35.1654 17.6019 35.0435 17.3203 34.8388C17.1105 34.6674 16.9393 34.4537 16.8179 34.2116C16.6964 33.9695 16.6274 33.7045 16.6155 33.4339C16.6 32.9221 16.7577 32.42 17.063 32.0089C17.3333 31.623 17.7236 31.3372 18.1731 31.1959C18.4192 31.1267 18.6772 31.1101 18.9301 31.1472C19.1831 31.1843 19.4254 31.2742 19.6413 31.4112C19.9315 31.5665 20.1725 31.8 20.3369 32.0851C20.5014 32.3703 20.5827 32.6958 20.5717 33.0247C20.5364 33.5897 20.2973 34.1226 19.8988 34.5245ZM17.3895 34.7431C17.654 34.935 17.9669 35.0492 18.2928 35.0727C18.6187 35.0962 18.9448 35.0282 19.2341 34.8763C19.5798 34.6962 19.8736 34.4306 20.0875 34.1048C20.3014 33.7789 20.4282 33.4037 20.4558 33.015C20.4628 32.7087 20.3853 32.4064 20.232 32.1412C20.0786 31.876 19.8553 31.6581 19.5864 31.5114C19.1884 31.2696 18.7117 31.193 18.2581 31.2981C17.8044 31.4031 17.4098 31.6813 17.1586 32.0734C16.8432 32.4614 16.691 32.9568 16.7341 33.4549C16.7771 33.9531 17.0121 34.415 17.3895 34.7431Z'
      fill='#010101'
    />
    <path
      d='M14.2259 38.62C16.1941 39.7407 18.2287 36.8212 16.555 35.386C14.548 33.6661 11.9016 37.1229 14.2259 38.62Z'
      fill='white'
    />
    <path
      d='M16.5701 38.2744C16.3238 38.5333 16.0172 38.7269 15.6776 38.838C15.4325 38.9155 15.1737 38.9402 14.9184 38.9104C14.663 38.8807 14.4168 38.7972 14.196 38.6654C13.8898 38.4908 13.6402 38.2318 13.4768 37.9193C13.3135 37.6069 13.2434 37.2541 13.2748 36.9029C13.3232 36.4884 13.4801 36.0939 13.7297 35.7595C13.9794 35.425 14.3129 35.1623 14.6965 34.998C15.0123 34.8679 15.3589 34.8313 15.6949 34.8924C16.0309 34.9535 16.3424 35.1099 16.5921 35.3428C17.4817 36.1044 17.3268 37.2456 16.8202 37.9913C16.7443 38.092 16.6606 38.1867 16.5701 38.2744ZM14.2627 38.5627C14.677 38.802 15.1687 38.869 15.6319 38.7491C16.0951 38.6293 16.4926 38.3322 16.7387 37.9219C17.2273 37.2237 17.3762 36.1464 16.5393 35.4311C16.3054 35.2108 16.0128 35.0627 15.6967 35.0045C15.3806 34.9463 15.0545 34.9806 14.7574 35.1032C14.3929 35.2597 14.0761 35.5096 13.839 35.8277C13.602 36.1457 13.453 36.5207 13.4073 36.9148C13.3789 37.2423 13.4443 37.5712 13.5958 37.8629C13.7472 38.1547 13.9786 38.3974 14.2627 38.5627Z'
      fill='#010101'
    />
    <path
      d='M19.8775 36.5562C20.15 36.7746 20.4017 37.0177 20.6295 37.2824C20.6506 37.4387 20.6157 37.5974 20.531 37.7305C20.4545 37.7887 20.3646 37.8268 20.2695 37.8413C20.1744 37.8557 20.0772 37.8461 19.9869 37.8132C19.6884 37.5548 19.4109 37.2729 19.1573 36.9703L19.8775 36.5562Z'
      fill='white'
    />
    <path
      d='M20.5926 37.7389L20.581 37.7509C20.4953 37.8158 20.3946 37.8578 20.2882 37.8729C20.1818 37.888 20.0734 37.8756 19.9731 37.8371C19.7597 37.6696 19.5641 37.4807 19.3893 37.2733C19.3004 37.1875 19.2206 37.0826 19.1316 36.992L19.0596 36.9224L19.8854 36.4663L19.9262 36.5057C20.0031 36.58 20.0848 36.6589 20.1781 36.7257C20.3705 36.8697 20.544 37.0373 20.6946 37.2245L20.7066 37.2361C20.7234 37.301 20.727 37.3686 20.7172 37.4349C20.7074 37.5012 20.6844 37.5649 20.6496 37.6221L20.6065 37.7245L20.5926 37.7389ZM20.0207 37.7252C20.0988 37.7542 20.1828 37.7636 20.2653 37.7527C20.3479 37.7418 20.4265 37.7109 20.4944 37.6626L20.5329 37.5699C20.5854 37.4806 20.6013 37.3745 20.5774 37.2738C20.4362 37.1006 20.2749 36.9449 20.0969 36.8098C20.0224 36.7379 19.9503 36.6683 19.8666 36.6107L19.2561 36.9497C19.3306 37.0216 19.405 37.0935 19.4632 37.1775C19.6285 37.3783 19.8137 37.5618 20.016 37.7253L20.0207 37.7252Z'
      fill='#010101'
    />
    <path
      d='M15.103 38.1205C15.331 37.8843 15.3083 37.4924 15.0522 37.2451C14.7962 36.9978 14.4037 36.9888 14.1756 37.225C13.9475 37.4612 13.9702 37.8531 14.2263 38.1004C14.4824 38.3477 14.8749 38.3567 15.103 38.1205Z'
      fill='#010101'
    />
    <path
      d='M15.0507 37.6939C15.1045 37.6382 15.0954 37.5421 15.0304 37.4793C14.9654 37.4165 14.869 37.4108 14.8152 37.4665C14.7614 37.5223 14.7705 37.6183 14.8355 37.6811C14.9005 37.7439 14.9968 37.7496 15.0507 37.6939Z'
      fill='white'
    />
    <path
      d='M18.4445 34.4294C18.6687 34.1972 18.6429 33.8085 18.3868 33.5612C18.1308 33.314 17.7414 33.3017 17.5172 33.5339C17.2929 33.7661 17.3187 34.1548 17.5748 34.4021C17.8309 34.6494 18.2203 34.6616 18.4445 34.4294Z'
      fill='#010101'
    />
    <path
      d='M18.3875 34.0077C18.44 33.9533 18.4299 33.8583 18.3649 33.7955C18.2999 33.7327 18.2046 33.7259 18.1521 33.7803C18.0995 33.8347 18.1097 33.9297 18.1747 33.9925C18.2397 34.0553 18.335 34.0621 18.3875 34.0077Z'
      fill='white'
    />
    <path
      d='M18.6815 37.7226C18.9522 38.3462 20.1363 38.9278 19.9603 37.7782C19.6618 37.5198 19.3844 37.2379 19.1307 36.9353L18.6815 37.7226Z'
      fill='white'
    />
    <path
      d='M19.905 38.3981C19.863 38.4424 19.8096 38.4744 19.7507 38.4905C19.4358 38.581 18.8299 38.242 18.6087 37.7499L18.5895 37.7313L19.1029 36.8343L19.1606 36.8899C19.2543 36.9804 19.348 37.0709 19.4206 37.1736C19.5902 37.3752 19.7802 37.5586 19.9876 37.7211L20.0189 37.7513C20.0538 37.8602 20.0617 37.976 20.0419 38.0887C20.022 38.2014 19.975 38.3076 19.905 38.3981ZM18.7407 37.7334C18.922 38.1082 19.4406 38.451 19.7179 38.3706C19.9176 38.3128 19.9271 38.0434 19.8948 37.8172C19.6886 37.6534 19.4987 37.47 19.3278 37.2697C19.2582 37.2024 19.1837 37.1305 19.1255 37.0464L18.7407 37.7334Z'
      fill='#010101'
    />
    <path
      d='M17.8651 36.8275C17.7897 36.9221 17.7378 37.0333 17.7137 37.1518C17.6896 37.2704 17.6939 37.393 17.7264 37.5095C17.7589 37.6261 17.8185 37.7333 17.9005 37.8223C17.9824 37.9113 18.0843 37.9796 18.1978 38.0216C18.8622 38.199 18.9064 37.2109 19.265 36.9165C19.6339 36.5345 20.3414 36.6095 20.3068 35.9818C20.2663 35.2834 19.4446 35.4324 18.9051 35.6496L17.8651 36.8275Z'
      fill='#F6D2A2'
    />
    <path
      d='M20.2273 36.4297C20.0992 36.542 19.9508 36.6287 19.7901 36.6853C19.6167 36.7474 19.4565 36.8416 19.3178 36.9628C19.1849 37.1003 19.083 37.2648 19.0192 37.4451C18.853 37.8047 18.6641 38.2119 18.1871 38.0856C18.0685 38.054 17.9599 37.9927 17.8717 37.9074C17.7834 37.8222 17.7183 37.7158 17.6826 37.5984C17.6374 37.4645 17.626 37.3215 17.6495 37.1822C17.6731 37.0429 17.7308 36.9116 17.8175 36.8L18.8829 35.5957C19.2768 35.4282 19.8087 35.315 20.1167 35.5057C20.1869 35.5574 20.2458 35.6229 20.2898 35.6982C20.3337 35.7736 20.3617 35.8571 20.3721 35.9437C20.3824 36.0303 20.3749 36.1181 20.35 36.2017C20.3251 36.2853 20.2834 36.3629 20.2273 36.4297ZM19.2406 36.8697C19.3893 36.7388 19.5614 36.6372 19.7479 36.5703C20.048 36.4422 20.2824 36.3389 20.262 35.985C20.2639 35.9104 20.247 35.8366 20.2128 35.7704C20.1786 35.7041 20.1283 35.6475 20.0665 35.6058C19.799 35.4404 19.3026 35.5506 18.9556 35.6984L17.9224 36.8596C17.8499 36.9558 17.8019 37.0681 17.7826 37.187C17.7633 37.3058 17.7732 37.4276 17.8115 37.5418C17.8416 37.6395 17.8959 37.728 17.9694 37.799C18.0429 37.87 18.1333 37.9212 18.2319 37.9478C18.6044 38.0429 18.7618 37.7212 18.9258 37.3735C18.9939 37.1852 19.1012 37.0135 19.2406 36.8697Z'
      fill='#231F20'
    />
    <path
      d='M17.795 36.8665C17.1688 36.3129 18.2009 35.0903 18.8354 35.443C19.4698 35.7957 18.2952 37.2428 17.795 36.8665Z'
      fill='#010101'
    />
    <path
      d='M78.9452 52.5728C77.0556 53.8093 75.745 55.0215 75.0132 56.2095C73.9157 57.9915 76.287 57.3435 77.4313 56.7765C78.5756 56.2095 78.2627 57.4633 79.8078 58.7571C80.8378 59.6196 80.9152 57.8413 80.0399 53.4221L78.9452 52.5728Z'
      fill='url(#paint28_linear)'
    />
    <path
      d='M79.2697 54.415C75.9924 52.8073 71.4902 46.4696 73.2461 33.3532C75.002 20.2368 85.0804 10.0363 95.0168 11.7769C104.953 13.5174 111.297 21.9234 105.693 37.4811C100.089 53.0388 82.5469 56.0227 79.2697 54.415Z'
      fill='url(#paint29_linear)'
    />
    <path
      d='M96.1959 41.3125C96.4117 41.1614 96.5945 40.963 96.692 40.7539L100.078 33.4932C100.175 33.284 100.21 33.0166 100.187 32.7542L90.7796 33.5772L96.1959 41.3125Z'
      fill='#00599C'
    />
    <path
      d='M87.5206 42.2857L95.5014 41.5875C95.7313 41.5674 95.9801 41.4636 96.1959 41.3125L90.7796 33.5772L81.3725 34.4003C81.3954 34.6626 81.4759 34.9201 81.6082 35.109L86.2034 41.6715C86.468 42.0496 87.0608 42.326 87.5206 42.2857Z'
      fill='#004482'
    />
    <path
      d='M100.187 32.7541C100.164 32.4917 100.083 32.2343 99.9511 32.0453L95.356 25.4828C95.0913 25.1048 94.4985 24.8283 94.0387 24.8686L86.0579 25.5668C85.5981 25.607 85.0624 25.9822 84.8673 26.4004L81.4816 33.6611C81.3841 33.8703 81.3496 34.1378 81.3726 34.4002L90.7797 33.5772L100.187 32.7541Z'
      fill='#659AD2'
    />
    <path
      d='M88.4154 38.6473C85.6197 37.3437 84.4058 34.0086 85.7095 31.213C87.0131 28.4173 90.3482 27.2034 93.1439 28.5071C94.9478 29.3483 96.1776 31.1036 96.3532 33.088L93.5669 33.3345C93.479 32.3413 92.8639 31.4628 91.9617 31.0421C90.5639 30.3903 88.8964 30.9972 88.2446 32.3951C87.5927 33.7929 88.1996 35.4604 89.5975 36.1123C90.4998 36.533 91.5681 36.4396 92.3855 35.8683L93.9877 38.1611C92.3547 39.3023 90.2195 39.4886 88.4154 38.6473Z'
      fill='white'
    />
    <path
      d='M95.9811 35.6597L95.4177 35.397L95.6804 34.8337L95.1171 34.571L94.8544 35.1344L94.291 34.8717L94.0283 35.435L94.5917 35.6977L94.329 36.2611L94.8923 36.5237L95.155 35.9604L95.7184 36.2231L95.9811 35.6597Z'
      fill='white'
    />
    <path
      d='M98.0936 36.6448L97.5302 36.3821L97.7929 35.8188L97.2296 35.5561L96.967 36.1195L96.4036 35.8568L96.1409 36.4201L96.7043 36.6828L96.4416 37.2462L97.0048 37.5088L97.2676 36.9455L97.8309 37.2082L98.0936 36.6448Z'
      fill='white'
    />
    <path
      d='M56.5778 46.3232C50.6561 44.1444 45.1345 40.7203 40.0131 36.0508C31.1613 27.9803 30.8237 16.8532 36.1766 9.94861C40.6379 4.19402 50.3345 3.6373 55.9571 6.48556C57.6594 7.34786 59.8985 7.42196 61.3415 6.17345C67.1332 1.16253 73.3867 -1.41813 79.6927 0.801976C86.9456 3.3554 86.9456 19.9389 77.0954 31.5863C71.5794 38.1088 66.5139 42.8322 61.8988 45.7564C60.31 46.7631 58.343 46.9726 56.5778 46.3232Z'
      fill='url(#paint30_linear)'
    />
    <defs>
      <linearGradient
        id='paint0_linear'
        x1={10.9245}
        y1={144.563}
        x2={22.2312}
        y2={189.632}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset={1} stopColor='#128698' />
      </linearGradient>
      <linearGradient
        id='paint1_linear'
        x1={12.766}
        y1={163.982}
        x2={37.853}
        y2={195.075}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#33B7D5' />
        <stop offset={1} stopColor='#123635' />
      </linearGradient>
      <linearGradient
        id='paint2_linear'
        x1={42.2932}
        y1={107.882}
        x2={63.7416}
        y2={144.362}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset={1} stopColor='#128698' />
      </linearGradient>
      <linearGradient
        id='paint3_linear'
        x1={40.097}
        y1={106.108}
        x2={45.1117}
        y2={117.356}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#33B7D5' />
        <stop offset={1} stopColor='#123635' />
      </linearGradient>
      <linearGradient
        id='paint4_linear'
        x1={47.3796}
        y1={132.574}
        x2={38.641}
        y2={148.552}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset={1} stopColor='#06565B' />
      </linearGradient>
      <linearGradient
        id='paint5_linear'
        x1={3.54213}
        y1={137.475}
        x2={23.6253}
        y2={166.303}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset={1} stopColor='#128698' />
      </linearGradient>
      <linearGradient
        id='paint6_linear'
        x1={-4.15003}
        y1={163.866}
        x2={0.968762}
        y2={175.077}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#33B7D5' />
        <stop offset={1} stopColor='#123635' />
      </linearGradient>
      <linearGradient
        id='paint7_linear'
        x1={15.4085}
        y1={139.46}
        x2={8.39347}
        y2={154.331}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset={1} stopColor='#06565B' />
      </linearGradient>
      <linearGradient
        id='paint8_linear'
        x1={1.79298}
        y1={133.217}
        x2={12.289}
        y2={176.416}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset={1} stopColor='#128698' />
      </linearGradient>
      <linearGradient
        id='paint9_linear'
        x1={22.2815}
        y1={125.8}
        x2={38.1649}
        y2={159.963}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset={1} stopColor='#128698' />
      </linearGradient>
      <linearGradient
        id='paint10_linear'
        x1={25.5063}
        y1={143.916}
        x2={22.2296}
        y2={150.614}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#D8E7FF' />
        <stop offset={1} stopColor='#C6D6FF' />
      </linearGradient>
      <linearGradient
        id='paint11_linear'
        x1={54.5139}
        y1={138.233}
        x2={54.96}
        y2={138.944}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#BAFEFF' />
        <stop offset={1} stopColor='#A5FFFE' />
      </linearGradient>
      <linearGradient
        id='paint12_linear'
        x1={63.2805}
        y1={138.837}
        x2={63.9854}
        y2={139.406}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#BAFEFF' />
        <stop offset={1} stopColor='#A5FFFE' />
      </linearGradient>
      <linearGradient
        id='paint13_linear'
        x1={43.4273}
        y1={156.123}
        x2={40.6242}
        y2={169.725}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset={1} stopColor='#06565B' />
      </linearGradient>
      <linearGradient
        id='paint14_linear'
        x1={-5.09668}
        y1={97.8462}
        x2={8.44438}
        y2={148.189}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset={1} stopColor='#128698' />
      </linearGradient>
      <linearGradient
        id='paint15_linear'
        x1={5.62828}
        y1={101.449}
        x2={27.1354}
        y2={132.624}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset={1} stopColor='#128698' />
      </linearGradient>
      <linearGradient
        id='paint16_linear'
        x1={27.9647}
        y1={99.6903}
        x2={35.4059}
        y2={107.701}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset={1} stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint17_linear'
        x1={31.8468}
        y1={94.9472}
        x2={33.732}
        y2={97.0976}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset={1} stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint18_linear'
        x1={24.4267}
        y1={118.31}
        x2={19.057}
        y2={143.894}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset={1} stopColor='#06565B' />
      </linearGradient>
      <linearGradient
        id='paint19_linear'
        x1={11.272}
        y1={113.041}
        x2={14.2727}
        y2={115.396}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#042635' />
        <stop offset={1} stopColor='#001431' />
      </linearGradient>
      <linearGradient
        id='paint20_linear'
        x1={7.69229}
        y1={115.596}
        x2={12.2041}
        y2={122.877}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset={1} stopColor='#128698' />
      </linearGradient>
      <linearGradient
        id='paint21_linear'
        x1={-70.4667}
        y1={129.373}
        x2={-61.3207}
        y2={164.402}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#33B7D5' />
        <stop offset={1} stopColor='#123635' />
      </linearGradient>
      <linearGradient
        id='paint22_linear'
        x1={23.2919}
        y1={134.036}
        x2={-7.01102}
        y2={124.686}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#28674F' />
        <stop offset={1} stopColor='#123635' />
      </linearGradient>
      <linearGradient
        id='paint23_linear'
        x1={82.6094}
        y1={68.7498}
        x2={85.641}
        y2={78.1919}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset={1} stopColor='#128698' />
      </linearGradient>
      <linearGradient
        id='paint24_linear'
        x1={31.9739}
        y1={59.4402}
        x2={38.9423}
        y2={64.488}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#356FA8' />
        <stop offset={1} stopColor='#183C6F' />
      </linearGradient>
      <linearGradient
        id='paint25_linear'
        x1={53.5888}
        y1={45.4911}
        x2={54.8968}
        y2={51.7101}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset={1} stopColor='#128698' />
      </linearGradient>
      <linearGradient
        id='paint26_linear'
        x1={72.6492}
        y1={28.848}
        x2={89.5902}
        y2={82.5066}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset={1} stopColor='#128698' />
      </linearGradient>
      <linearGradient
        id='paint27_linear'
        x1={-19.7599}
        y1={40.0924}
        x2={24.0112}
        y2={70.4972}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#356FA8' />
        <stop offset={1} stopColor='#183C6F' />
      </linearGradient>
      <linearGradient
        id='paint28_linear'
        x1={72.0068}
        y1={55.8534}
        x2={78.3702}
        y2={59.9058}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#356FA8' />
        <stop offset={1} stopColor='#183C6F' />
      </linearGradient>
      <linearGradient
        id='paint29_linear'
        x1={56.7608}
        y1={33.752}
        x2={97.0999}
        y2={56.2134}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#356FA8' />
        <stop offset={1} stopColor='#183C6F' />
      </linearGradient>
      <linearGradient
        id='paint30_linear'
        x1={13.6227}
        y1={2.77893}
        x2={28.9098}
        y2={61.0984}
        gradientUnits='userSpaceOnUse'
      >
        <stop stopColor='#5DF1D7' />
        <stop offset={1} stopColor='#128698' />
      </linearGradient>
    </defs>
  </svg>
  /* eslint-enable max-len */
);
